

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/App_ExchangeEnvironmentType.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 2017  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- From sp11 Exchange virtual client creation will ask for Environment type. 

-- This script will compute environment type for Exchange virtual clients created before sp11

SET QUOTED_IDENTIFIER ON

DECLARE @onPremiseExchangeServer bit = 0

DECLARE @onPremiseServiceAcc bit = 0

DECLARE @onlineServiceAcc bit=0

DECLARE @localSystemServiceAcc bit = 0

DECLARE @azureAppDetails bit = 0

DECLARE @serviceAccount XML=''

DECLARE @auzreAppId nvarchar(max)

DECLARE @exchangeEnvironmentType INT = 0

DECLARE @tmpClientIDAProp TABLE (agentId int, clientId int, attrName nvarchar(256), attrVal nvarchar(256))

DECLARE @serviceTypeTable TABLE (accountType int)

DECLARE @createdTime INT = dbo.getUnixtime(GETUTCDATE())

DECLARE @agentId int = 0

DECLARE @clientId int = 0

DECLARE @exchangeServer nvarchar(256)

DECLARE @sqlScriptGUID varchar(48) = 'D75456BC-E0E6-427A-8E31-E337380D58BC'

DECLARE @thisScript INT = 0

SELECT @thisScript  = 1 FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = @sqlScriptGUID

IF  @thisScript  = 0

BEGIN
	INSERT INTO @tmpClientIDAProp 


	SELECT A.id, C.id, PR.attrName, PR.attrVal FROM App_Client C 

INNER JOIN APP_IDANAME (NOLOCK) A ON A.appTypeId =  137 AND C.id = A.clientId

LEFT JOIN APP_IDAProp (NOLOCK) PR ON PR.componentNameId = A.id AND PR.attrName= 'Exchange Environment Type' AND PR.attrVal != 0 and PR.modified = 0

	DELETE FROM @tmpClientIDAProp WHERE attrName IS NOT NULL

	WHILE EXISTS(SELECT * FROM @tmpClientIDAProp)

	BEGIN

		--Get client

		SELECT TOP 1 @agentId=agentid, @clientid=clientId FROM @tmpClientIDAProp	

		--Check onpremises exchange server

		SELECT @exchangeServer = REPLACE(attrVal,'`', '') FROM APP_IDAProp (NOLOCK) WHERE attrName = 'Exchange OnePass Servers' AND componentNameId = @agentId AND modified = 0

		IF  @exchangeServer != ''

		BEGIN

			SET @onPremiseExchangeServer = 1

		END

		--check if Azure App details are set

SELECT @auzreAppId = attrVal FROM APP_IDAProp (NOLOCK) WHERE attrName = 'Azure App Id' AND componentNameId = @agentId AND modified=0

		IF @auzreAppId != ''

		BEGIN 

			SET @azureAppDetails = 1

		END

		--check exchange service account type

		SELECT @serviceAccount = CAST(REPLACE(attrVal,'UTF-8','UTF-16') as XML) FROM APP_IDAProp WHERE attrName = 'Exchange OnePass Admin Accounts' AND componentNameId = @agentId AND modified = 0 
		INSERT INTO @serviceTypeTable 


		SELECT c.value('@serviceType','INT') FROM @serviceAccount.nodes('App_ExchangeAdminAccounts/adminAccounts') T(c)

		IF EXISTS(SELECT accountType FROM @serviceTypeTable WHERE accountType >= 12 AND accountType <= 16)

			SET @onPremiseServiceAcc = 1

		IF EXISTS(SELECT accountType FROM @serviceTypeTable WHERE accountType = 2)

			SET @onlineServiceAcc = 1

		IF EXISTS(SELECT accountType FROM @serviceTypeTable WHERE accountType=3)

			SET @localSystemServiceAcc = 1

		--Compute environment type for this exchange client

		IF @onPremiseServiceAcc = 1 AND @onPremiseExchangeServer = 1 AND @azureAppDetails = 0 AND @onlineServiceAcc = 0

			SET @exchangeEnvironmentType = 1  --on-premises exchange server

		ELSE IF (@onPremiseServiceAcc = 1 AND @onPremiseExchangeServer = 1 ) OR (@onlineServiceAcc = 1 AND @onPremiseExchangeServer = 1)

			SET @exchangeEnvironmentType = 2  --Hybrid with on-premises exchange server

		ELSE IF (@onlineServiceAcc = 1)  OR (@onlineServiceAcc = 1 AND @localSystemServiceAcc = 1 AND @azureAppDetails = 0)

			SET @exchangeEnvironmentType = 3  --Hybrid with no onpremises exchange server

		ELSE IF @onlineServiceAcc = 1 AND @azureAppDetails = 1

			SET @exchangeEnvironmentType = 4  --Exchange online only

		ELSE

			SET @exchangeEnvironmentType = 0	-- set to none

		-- Age existing type if present

UPDATE APP_IDAProp SET modified = @createdTime WHERE componentNameId = @agentId AND attrName = 'Exchange Environment Type' AND attrType = 7

		--Populate exchange environment type property
		INSERT INTO APP_IDAProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)


VALUES(@agentId, 'Exchange Environment Type', 7, @exchangeEnvironmentType, @createdTime, 0, 0)

		--Done with processing current entry

		DELETE FROM @tmpClientIDAProp where agentId = @agentId

		--reset all variabled

		DELETE FROM @serviceTypeTable

		SET @onPremiseExchangeServer = 0

		SET @onPremiseServiceAcc  = 0

		SET @onlineServiceAcc =0

		SET @localSystemServiceAcc  = 0

		SET @azureAppDetails  = 0

		SET @exchangeEnvironmentType = 0

		SET @agentId = 0 

		SET @clientId = 0

		SET @exchangeServer = ''

	END
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@sqlScriptGUID, 'UpdateExchangeEnvironmentType', 'Script to populate exchange environment type for existing exchange clients', @createdTime, 16, 0 , (16 + 1))

END

