

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/App_EmailTemplate.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

------------------------------------------------------------------------

-- rcsid[]='@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/App_EmailTemplate.script,v $ $Id: App_EmailTemplate.script,v 1.1.2.1 2020/05/05 17:33:11 nshah Exp $';

--TABLENAME APP_EMAILTEMPLATE

SET QUOTED_IDENTIFIER ON

GO

DECLARE @nowTime    int =  DATEDIFF(second, '01/01/1970', GETUTCDATE())

DECLARE @change2FactorEmailTemplateGuid    VARCHAR(40) = 'F3E358A1-67BF-4036-8CEE-66A053FB9C1B'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @change2FactorEmailTemplateGuid)

BEGIN	  

	--when createdOn and modifiedOn are different, the email template has been customized by the user. 

	--For system created email templates, email templates are updated by AppPopulateDefaultEmailTemplates.sp so no need to update it here

	UPDATE App_EmailTemplate

    SET emailBody= REPLACE(emailBody, '$USERNAME$','$USERNAME_LOGIN$'),

    modifiedOn = @nowTime

    WHERE type IN (12,13) AND (createdOn <> modifiedOn OR status & 1 = 0)

	-- Update script table , so that this code doesn't execute anymore'
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@change2FactorEmailTemplateGuid, 'Two Factor authenticatin email template changes', 'For Two Factor authenticatin email template change token $USERNAME$ to $USERNAME_LOGIN$', @nowTime, 16, 0 , (16 + 2))

END

