

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/App_CustomProperty.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]='@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/App_CustomProperty.script,v $ $Id: App_CustomProperty.script,v 1.2.12.6 2019/01/31 23:56:51 nramalingam Exp $';

-- PUT ANY #DEFINES HERE

-- ----------------------

DECLARE @nowTime INT = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()))

DECLARE @CustompropertyAddGUID VARCHAR(40) = '1D63475C-5DCF-4D91-AC70-211C685AA287'	

IF NOT EXISTS (SELECT * FROM App_CustomProperty WHERE propertyName = 'Tags' AND statusFlags = 26)											
	INSERT INTO App_CustomProperty (propertyName, indexingFieldName, dataType, defaultValue, description, ownerId, statusFlags, createdTime, configOptions)						
	VALUES ('Tags', 'CUSTOM_TAGS', 2, '', 'System created custom property for Tags.', 1, 26, @nowTime, NULL)									
 ELSE	
	UPDATE App_CustomProperty	
	SET indexingFieldName = 'CUSTOM_TAGS', dataType = 2, defaultValue = '', description = 'System created custom property for Tags.', ownerId = 1, configOptions = NULL 
	WHERE propertyName = 'Tags' AND statusFlags = 26

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @CustompropertyAddGUID)

BEGIN

	-- Add code to insert property->client mapping in App_ComponentProp table																								
	BEGIN TRAN																																								
	DECLARE @errorCode INT = 0


	DECLARE	@errorString NVARCHAR(MAX) = ''																																	
	IF OBJECT_ID('tempdb.dbo.#propertyInfo') IS NOT NULL																													
		DROP TABLE #propertyInfo																																			
	CREATE TABLE #propertyInfo																																				
	(																																										
		propertyId		INT,																																				
		ownerId			INT,																																				
		clientId		INT																																					
	)

INSERT INTO #propertyInfo																																				
	select CP.propertyId, CP.ownerId, A.clientId FROM App_CustomProperty CP																									
		JOIN APP_SubClientProp SC ON SC.attrname='Edge Drive User Id' AND SC.attrVal = CAST(CP.ownerId AS NVARCHAR(MAX))													
		JOIN APP_Application A On A.id = SC.componentNameId																													
		WHERE CP.propertyId NOT IN																																			
		(																																									
			SELECT componentId FROm APP_ComponentProp																														
			WHERE componentType = 18 AND propertyTypeId = 1008												
			AND dataType = 9																																				
		)


	IF @@ERROR <> 0																																							
	BEGIN																																									
		SET @errorCode = @@ERROR																																			
		GOTO ERROR_EXIT																																						
	END																																										



	MERGE App_ComponentProp AS TARGET

		USING (SELECT propertyId, ownerId, clientId FROM #propertyInfo) AS SOURCE (propertyId, ownerId, clientId)

ON (TARGET.componentId = SOURCE.propertyId AND TARGET.propertyTypeId = 1008 AND TARGET.longVal = SOURCE.clientId)

		WHEN NOT MATCHED BY TARGET THEN

			INSERT (componentType,componentId,propertyTypeId,dataType,longVal,longlongVal,created,modified)

VALUES(18, SOURCE.propertyId, 1008, 9, SOURCE.clientId, 0, @nowTime, 0);

	IF @@ERROR <> 0																																							
	BEGIN																																									
		SET @errorCode = @@ERROR																																			
		GOTO ERROR_EXIT																																						
	END	


	DECLARE @permissionsList NVARCHAR(MAX)

	DECLARE @propId INT

	DECLARE @ownerid INT

SET @permissionsList = CAST(31  AS NVARCHAR(10)) + ',' + CAST(209 AS NVARCHAR(10)) + ',' + CAST(210 AS NVARCHAR(10))

	DECLARE @propertyCursor CURSOR

	SET @propertyCursor = CURSOR FOR

		select propertyId, ownerId from #propertyInfo WHERE propertyId > 0

	OPEN @propertyCursor 

	FETCH NEXT FROM @propertyCursor INTO @propid, @ownerid

	WHILE @@FETCH_STATUS = 0

	BEGIN

EXEC sec_setCreatorForEntity @ownerid, 0, @permissionsList, @errorCode OUTPUT, @errorString OUTPUT, 166, @propid

		if (@errorCode<>0)

			GOTO ERROR_EXIT

		FETCH NEXT FROM @propertyCursor INTO @propid, @ownerid

	END

	CLOSE @propertyCursor;

	DEALLOCATE @propertyCursor;	

	-- Update script table , so that this code doesn't execute anymore'
INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)										
	VALUES(@CustompropertyAddGUID, 'Custom', 'Add system property and associate them to clients', @nowTime, 16, 0 , (16 + 2))


	ERROR_EXIT:																																								
		IF @errorCode <> 0																																					
			ROLLBACK TRAN																																					
		ELSE																																								
			COMMIT TRAN																																						
		IF OBJECT_ID('tempdb.dbo.#propertyInfo') IS NOT NULL																												
			DROP TABLE #propertyInfo																																		
END


GO

