

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/App_CreateOpWindowForServerPlan.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 2016  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/App_CreateOpWindowForServerPlan.script,v $ $Id: App_CreateOpWindowForServerPlan.script,v 1.1.4.4 2020/10/04 00:55:41 abilbrey Exp $";

GO

SET QUOTED_IDENTIFIER ON

GO

	DECLARE @errCode INTEGER

	DECLARE @errStr varchar(1024)

	DECLARE @pid INT = 0

	DECLARE @pType INT = 0

	DECLARE @atType INT = 0

	DECLARE @taskid INT = 0

	DECLARE @subTaskId INT = 0

    DECLARE @guidForOpWindowCreate uniqueidentifier = '4D071E15-10C6-467A-A684-AD03D2CAB51D'

    DECLARE @isOpWindowProcessingForServerPlan INT = 0 

	SELECT @isOpWindowProcessingForServerPlan = 1 FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = @guidForOpWindowCreate

DECLARE @constAttrName_Policy_Schedule      NVARCHAR(32)    = 'Schedule policy'

	DECLARE @schedulePolicyString NVarchar(MAX) 

	DECLARE @schedulePolicyId INT

	DECLARE @newRuleId INT = 0

	DECLARE @currentTime INTEGER

	SET @currentTime = DATEDIFF(second, '1970-01-01', GetUTCDate())

	IF (@isOpWindowProcessingForServerPlan = 0)        -- not done, update the plan details below

	BEGIN	

		-- Get all schedule policies associated to plan.

		BEGIN TRY

        BEGIN TRAN

			IF ( CURSOR_STATUS('global', 'details_cursor') >= 0   OR CURSOR_STATUS('local', 'details_cursor') >= 0 )  -- CLOSE CURSOR IF OPEN

				CLOSE details_cursor

			IF ( CURSOR_STATUS('global','details_cursor') = -1     OR CURSOR_STATUS('local','details_cursor') = -1 )

				DEALLOCATE details_cursor

			DECLARE details_cursor CURSOR FOR   

			SELECT PP.attrVal

				FROM App_PlanProp (NOLOCK) PP

				INNER JOIN App_Plan (NOLOCK) P ON P.id = PP.componentNameId

			WHERE PP.attrName = @constAttrName_Policy_Schedule AND P.ownerId IS NOT NULL

AND (P.flag & 0x40000000) = 0 AND ( (P.flag & 0x00004) = 0)

			AND p.subtype =33554437 --Server Plans PlanSubtype::Server

			OPEN details_cursor  

			FETCH NEXT FROM details_cursor  INTO @schedulePolicyString

			WHILE @@FETCH_STATUS = 0  

			BEGIN 

				IF ISNUMERIC(@schedulePolicyString)=0

				BEGIN 

					FETCH NEXT FROM details_cursor  INTO @schedulePolicyString

					continue

				END

				SET @schedulePolicyId = CAST(@schedulePolicyString AS INT)

				IF @schedulePolicyId<=0

				BEGIN 

					FETCH NEXT FROM details_cursor  INTO @schedulePolicyString

					continue

				END			

				DECLARE @opWindowOld INT = 0

				SELECT @opWindowOld = Id FROM APP_OpWindowRule (NOLOCK) WHERE SchedulePolicyId>0 AND SchedulePolicyId = @schedulePolicyId AND opType = 7

				-- If old op window isnt there or this schedule policy has full op window already then retain it. 

				IF @opWindowOld=0 OR EXISTS(SELECT 1 FROM APP_OpWindowRule (NOLOCK)  WHERE SchedulePolicyId>0 AND SchedulePolicyId = @schedulePolicyId AND opType = 1)

				BEGIN 

					FETCH NEXT FROM details_cursor  INTO @schedulePolicyString

					continue

				END

				SET @newRuleId = ISNULL((Select MAX(id) from APP_OpWindowRule),0)

				SET @newRuleId = @newRuleId + 1

				INSERT APP_OpWindowRule (id, clientId,appTypeId, opType, daysOfWeek, startTime, endTime, enable, description, utilization, clientGroupId, instanceId, backupsetId, subclientId, startDate, endDate,schedulePolicyId)

				SELECT @newRuleId, clientId,appTypeId, 1, daysOfWeek, startTime, endTime, enable, description, utilization, clientGroupId, instanceId, backupsetId, subclientId, startDate, endDate,schedulePolicyId -- 1 : Full OpType

				FROM APP_OpWindowRule (NOLOCK) 

				WHERE APP_OpWindowRule.Id = @opWindowOld

				-- Remove full operation window from existing op Window. 

				UPDATE APP_OpWindowRule

				SET OpType = OpType-1

				WHERE APP_OpWindowRule.Id = @opWindowOld

				FETCH NEXT FROM details_cursor  INTO @schedulePolicyString

			END

			CLOSE details_cursor;  

			DEALLOCATE details_cursor; 

			-- Get All user groups for which we don't have direct association present but there reference does exist in App_PlanProp Table.
			INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@guidForOpWindowCreate, 'ServerPlanSupportOpWindowFull', 'Create Full operation windows seperately for server Plan', @currentTime,  16, 0, (16 + 2))

		COMMIT TRAN

        END TRY

        BEGIN CATCH

			DECLARE @o_errorCode INT

            DECLARE @tmpErrorString NVARCHAR

            -- Call procedure to print error information.

            -- Call procedure to get error information.

            EXECUTE dbo.GetError @tmpErrorString OUTPUT , @o_errorCode OUTPUT

            PRINT 'Error: [ ' + @tmpErrorString + ' ]. Rolling back transaction'

            --Close cursor

            IF ( CURSOR_STATUS('global', 'updation_cursor') >= 0  /* cursor is open */ 

                OR CURSOR_STATUS('local', 'updation_cursor') >= 0 ) 

            CLOSE updation_cursor 

            IF ( CURSOR_STATUS('global','updation_cursor') = -1  /* cursor is closed */ 

                OR CURSOR_STATUS('local','updation_cursor') = -1 ) 

            DEALLOCATE updation_cursor 

            -- Rollback any active or uncommittable transactions before

            -- inserting information in the ErrorLog

            IF XACT_STATE() <> 0

            BEGIN

            PRINT 'Error: [ ' + @tmpErrorString + ' ]. Rolling back transaction'

                ROLLBACK TRANSACTION;

            END

        END CATCH;

    END

GO

SET QUOTED_IDENTIFIER ON

GO

