

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/App_ConvertCompanyFolderToManualAssoc.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/App_ConvertCompanyFolderToManualAssoc.script,v $ $Id: App_ConvertCompanyFolderToManualAssoc.script,v 1.1.2.1 2020/07/01 14:22:12 snandhini Exp $";

/**					 AppConvertCompanyFolderToManualAssoc.script

	One time script to convert company created automatic folders to manual folders

**/

SET NOCOUNT ON

SET QUOTED_IDENTIFIER ON

DECLARE @guid uniqueidentifier = '6D0BECF9-3B96-4AC0-B466-BDE786C1E0CB'

IF NOT EXISTS(SELECT 1 FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE  gp.SqlScriptGUID = @guid)

BEGIN

	BEGIN TRY

		BEGIN TRAN

		DECLARE @CompanyFolders TABLE(folderId INT, folderXml XML)
		INSERT INTO @CompanyFolders


		SELECT CAST(attrval AS INT) , ''

		FROM APP_CompanyProp 

WHERE attrName = 'Associated Folder' AND modified  =  0 AND ISNUMERIC(attrval) = 1

		UPDATE CF SET folderXml = rawXml

		FROM @CompanyFolders CF

		INNER JOIN APP_SmartFolder SF

		ON CF.folderId = SF.id

		UPDATE @CompanyFolders 

		SET folderXml.modify('replace value of (/App_SmartFolderEntityInfo/@isAutomatic)[1] with 0')

		UPDATE @CompanyFolders 

		SET folderXml.modify('delete /App_SmartFolderEntityInfo/folderRule')

		UPDATE SF SET flag = 0, ruleQuery = '', rawXml = folderXml

		FROM APP_SmartFolder SF

		INNER JOIN @CompanyFolders CF ON SF.id = CF.folderId
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@guid, 'AutomaticToManualFolder', 'Convert company folders from automatic to manual', dbo.GetUnixTime(GetUTCdate()), 16, 0 , (16 + 2))

		COMMIT TRAN

	END TRY

	BEGIN CATCH

		ROLLBACK TRAN

	END CATCH

END

SET NOCOUNT OFF

