

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/App_ComponentProp.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/App_ComponentProp.script,v $ $Id: App_ComponentProp.script,v 1.1.4.8 2020/12/15 17:43:10 mnalamothu Exp $";

SET NOCOUNT ON

DECLARE @commcellLevelSLA  int

DECLARE @commcellRPO int

DECLARE @nowTime    int =  DATEDIFF(second, '01/01/1970', GETUTCDATE())

SELECT  @commcellLevelSLA = longVal 

FROM    APP_ComponentProp WITH (NOLOCK)

WHERE   componentType = 1 AND componentId = 2 AND propertyTypeId = 3300

AND modified = 0

SELECT  @commcellRPO = longVal 

FROM    APP_ComponentProp WITH (NOLOCK)

WHERE   componentType = 1 AND componentId = 2 AND propertyTypeId = 3306

AND modified = 0

DECLARE @ClientGroupSLADays     TABLE (clientGroupId INT, days INT)
INSERT  INTO @ClientGroupSLADays


SELECT  componentId, longVal 

FROM    APP_ComponentProp WITH (NOLOCK)

WHERE   componentType = 8 AND propertyTypeId = 3300

AND modified = 0

DECLARE @ClientGroupRPODays     TABLE (clientGroupId INT, days INT)
INSERT  INTO @ClientGroupRPODays


SELECT  componentId, longVal 

FROM    APP_ComponentProp WITH (NOLOCK)

WHERE   componentType = 8 AND propertyTypeId = 3306

AND modified = 0

-- customer has modified the default SLA days and RPO is not set

IF ( @commcellLevelSLA is not null and  @commcellRPO is null )

BEGIN

	set @commcellRPO = @commcellLevelSLA* 1440
	INSERT INTO APP_ComponentProp ( componentType, componentId, propertyTypeId, dataType, longVal, longlongVal, stringVal, created, modified)


SELECT  1, 2, 3306, 8, @commcellRPO, 0, '',  datediff(second, '01/01/1970', GETUTCDATE()), 0

END

-- customer has modified the client group sla days and has not set RPO settings at client group level

if exists ( select top 1 clientGroupId from @ClientGroupSLADays )

and not exists ( select top 1 clientGroupid from @ClientGroupRPODays )

begin
	INSERT INTO APP_ComponentProp ( componentType, componentId, propertyTypeId, dataType, longVal, longlongVal, stringVal, created, modified)


SELECT  8, clientGroupId, 3306, 8, days*1440, 0, '',  datediff(second, '01/01/1970', GETUTCDATE()), 0

	FROM    @ClientGroupSLADays

end

DECLARE @removeDuplicateSamlSmtpsGUID    VARCHAR(40) = '868D3222-1395-4E97-A6CE-4D3A3BF9D917'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @removeDuplicateSamlSmtpsGUID)

BEGIN

	 DELETE ACP1

	 from APP_ComponentProp ACP1 with (nolock)

	 inner join APP_ComponentProp ACP2 with (nolock) on ACP1.longVal = ACP2.longVal 

	 inner join App_ThirdPartyApp ATPA with (nolock) on ACP1.longVal=ATPA.id 

	 inner join UMDSProviders UMDS with (nolock) on UMDS.id = ACP1.componentId 

where ACP1.componentType = 112 and ACP2.componentType = 112 and ACP1.id <> ACP2.id and UMDS.serviceType = 5 and ACP1.stringVal = ACP2.stringVal
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@removeDuplicateSamlSmtpsGUID, 'Remove duplicate redirection rule from SAML app ', 'Update script to remove duplicate company redirection rule from SAML app', @nowTime,  16, 0, (16 + 2))

END

-- DLP feature

-- a. If client has plan and plan has DLP feature enabled, then update Smart client group associated to plan with "CV_COMPONENT_SHOW_DLP"  property and set it to 1.

-- b. If "enableDLP" is set to 1 at dlpgroupprop, then set "allow owners to enable Data encrypt" to true in that clientgroup.

DECLARE @dlpSyncGuid    VARCHAR(40) = '44B7AE95-3BB9-49B8-BB8E-9EF1229EFE63'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @dlpSyncGuid)

BEGIN

	IF OBJECT_ID('tempdb.dbo.#DLPClientGroups') IS NOT NULL DROP TABLE #DLPClientGroups

	CREATE TABLE #DLPClientGroups(clientGroupId INT)
	INSERT INTO #DLPClientGroups


	SELECT CONVERT(INT,pp.attrVal) clientgroups from App_Plan p WITH(NOLOCK) INNER JOIN App_PlanProp pp WITH(NOLOCK) ON p.id = pp.componentNameId AND 

pp.attrName = 'Assigned client group' AND pp.modified = 0 AND pp.attrVal <> '0' AND pp.attrType = 7 AND

		EXISTS(SELECT 1 

				FROM UMPermissions permission INNER JOIN 

					 UMRolesPermissions roleToPermissionMap ON roleToPermissionMap.permissionId =  permission.id

WHERE       roleToPermissionMap.roleId = dbo.AppPlanGetEntityValue(p.id, 'Feature',  default)

						AND permission.permissionName = 'DLP')

	UNION

	SELECT groupId FROM DlpGroupProp WITH(NOLOCK) WHERE attrName = 'enableDLP' AND attrVal = '1' AND modified = 0

	INSERT APP_ComponentProp (componenttype, componentid, propertytypeid,datatype,longval,longlongval,stringval,created,modified)

SELECT 8, DLP.clientGroupId,  3623,8,1,0,N'', @nowTime, 0

		FROM #DLPClientGroups DLP

LEFT JOIN APP_ComponentProp CP ON DLP.clientGroupId = CP.componentId AND CP.propertytypeid = 3623

AND CP.componenttype = 8 AND CP.modified = 0

		WHERE CP.longVal IS NULL

	UPDATE CP

		SET CP.longVal = 1

		FROM APP_ComponentProp CP

		INNER JOIN #DLPClientGroups DLP ON DLP.clientGroupId = CP.componentId 

WHERE CP.propertytypeid = 3623 AND CP.modified = 0 AND CP.componenttype = 8

			AND CP.longVal <> 1

	IF OBJECT_ID('tempdb.dbo.#DLPClientGroups') IS NOT NULL DROP TABLE #DLPClientGroups
    INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@dlpSyncGuid, 'Sync enableDLP and plan DLP settings with clientgroup prop showDLP', 'Update script to sync enableDLP and plan DLP settings with clientgroup prop showDLP', @nowTime,  16, 0, (16 + 2))

END

--With form 91584 in SP20 we started saving global filters as empty content, this is causing scan phase to fail, this is a cleanup script to delete those entries.

DECLARE @removeEmptyGlobalFilters    VARCHAR(40) = '9F8878BF-61CE-4BDF-94FD-80EDADC83F6C'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @removeEmptyGlobalFilters)

BEGIN

	 DELETE FROM APP_ComponentProp

			WHERE stringVal = '' AND componentType = 8

AND propertyTypeId IN ( 3620, 3621 )
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@removeEmptyGlobalFilters, 'Fixing Global Empty filters', 'Update script to remove empty global filters', @nowTime,  16, 0, (16 + 2))

END

--Add System Default SLA entries if its not set 

IF OBJECT_ID('tempdb..#ClientGroupCommCellSLA') IS NOT NULL DROP TABLE #ClientGroupCommCellSLA

CREATE TABLE #ClientGroupCommCellSLA (clientGroupId INT, isSystemDefaultSLA INT)
INSERT INTO #ClientGroupCommCellSLA


SELECT componentId,0 

FROM app_componentProp WITH (NOLOCK)

WHERE propertyTypeId = 3300 AND modified = 0 AND componentType = 8
INSERT INTO #ClientGroupCommCellSLA


SELECT AG.Id,1

FROM APP_ClientGroup AG WITH (NOLOCK) 

LEFT OUTER JOIN #ClientGroupCommCellSLA C ON C.clientGroupId = AG.Id

WHERE C.clientGroupId IS NULL

IF EXISTS (SELECT 1 FROM #ClientGroupCommCellSLA where isSystemDefaultSLA = 1)

BEGIN
	INSERT INTO APP_ComponentProp ( componentType, componentId, propertyTypeId, dataType, longVal, longlongVal, stringVal, created, modified)


SELECT  8, C.clientGroupId,3327,8, C.isSystemDefaultSLA,0, '',  datediff(second, '01/01/1970', GETUTCDATE()), 0

	FROM #ClientGroupCommCellSLA C

	LEFT OUTER JOIN app_componentProp  AP WITH (NOLOCK)

	ON C.clientGroupId = Ap.componentId AND

AP.propertyTypeId = 3327 AND AP.modified = 0 AND AP.componentType = 8

	where AP.componentId IS NULL AND C.isSystemDefaultSLA = 1

END

IF OBJECT_ID('tempdb..#ClientGroupCommCellSLA') IS NOT NULL DROP TABLE #ClientGroupCommCellSLA

-- Set default commcell level sla days to 7 on fresh install setup

IF NOT EXISTS (SELECT 1 FROM APP_Client WHERE id = 2)

BEGIN

	IF NOT EXISTS (SELECT longVal

	    FROM    APP_ComponentProp WITH (NOLOCK)

WHERE   componentType = 1 AND componentId = 2 AND propertyTypeId = 3300 AND modified = 0)

	    BEGIN
        INSERT INTO APP_ComponentProp ( componentType, componentId, propertyTypeId, dataType, longVal, longlongVal, stringVal, created, modified)


SELECT  1, 2,3300,8,7,0, '', DATEDIFF(SS, '1970-01-01',  GETUTCDATE()), 0

	END

END

-- Client side download feature is supported from SP23. Reset the property for all client groups.

DECLARE @resetClientSideDownloadOptionGuid    VARCHAR(40) = 'BA054642-209B-42A3-914C-1830FEC7F4C2'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @resetClientSideDownloadOptionGuid)

BEGIN

UPDATE APP_ComponentProp SET longVal = 0 WHERE propertyTypeId = 3700
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@resetClientSideDownloadOptionGuid, 'Reset Client Side Download Option', 'Update script to remove client side download option for all client groups', @nowTime,  16, 0, (16 + 2))

END

SET NOCOUNT OFF
