

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/App_CompanyEntities.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/App_CompanyEntities.script,v $ $Id: App_CompanyEntities.script,v 1.1.2.13 2020/12/21 08:43:10 jswaminathan Exp $";
-- TABLENAME App_CompanyEntities

print '... inserting Table: App_CompanyEntities'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME App_CompanyEntities

-- This script is for populating entries for table App_CompanyEntities based on existing tables.

-- Table App_CompanyEntities is for tagging the entities with the company Id.

-- Until we have migrated all the code to correctly insert entries into this table App_CompanyEntities, 

-- we will have this query to keep inserting the missing entries. 

SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON

GO

	BEGIN TRY

		IF (SELECT count(0)

			FROM UMDSProviders WITH(NOLOCK)

			WHERE serviceType = 5) > 0    -- Execute script only if CS has companies created.

		BEGIN

			DECLARE @nowTime integer

			SET @nowTime =  dbo.GetUnixTime (GetUTCdate())

			-- One time script for bug fix. Company SF, Company SCG, default Company Tenant Admin, default Company UGs were not tagged correctly in SP21 version of this script. 

			-- Let us remove them once. The following code will set them right during this run.

			DECLARE @fixDefaultCompanyEntitiesTaggingGUID VARCHAR(40) = '34854597-5F9E-4580-A4B8-C1FF9F227467'

			IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @fixDefaultCompanyEntitiesTaggingGUID)

			BEGIN

				DELETE ACE

				FROM APP_CompanyEntities ACE

					INNER JOIN APP_CompanyProp ACP						

ON ACE.entityType = 127 AND ACE.entityId = ACP.attrValInt AND ACP.attrName = 'Associated Folder' AND ACP.modified = 0

				DELETE ACE

				FROM APP_CompanyEntities ACE

					INNER JOIN APP_CompanyProp ACP						

ON ACE.entityType = 28 AND ACE.entityId = ACP.attrValInt AND ACP.attrName = 'Associated Smart Client Group' AND ACP.modified = 0

				DELETE ACE

				FROM APP_CompanyEntities ACE

				WHERE

entityType IN (13, 15)		-- All company user, UGs are processed down under again.

				-- Update script table, so that this code doesn't execute anymore
				INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@fixDefaultCompanyEntitiesTaggingGUID, 'FixCompanyEntitiesTaggingGUID', 'Fix company entities tagging GUID', @nowTime, 16, 0 , (16 + 2))

			END

			-- Let us tag the Company Smart Folder, Company Smart Client Group, Company's users and UGs with the respective companies as first step. 

			-- Then let us start with the Creator entries in Security associations table. The reason to do like this is - during Create Company, the system created

			-- Company SCG, SF and default Tenant Admin user and UGs are tagged with the logged in user as Creator instead of the Company in Security table. 

			-- Cant use that logic for tagging table. 
			INSERT INTO App_CompanyEntities(entityType, entityId, companyId, created)


SELECT   127, attrValInt, componentNameId, @nowTime

			FROM APP_CompanyProp as CP WITH(NOLOCK)

			LEFT JOIN App_CompanyEntities as App WITH(NOLOCK) on

App.entityType = 127 AND

				App.entityId = attrValInt

WHERE attrName = 'Associated Folder'

		  		AND attrValInt <> 0

		   		AND CP.modified = 0

		   		AND App.entityId is NULL
			INSERT INTO App_CompanyEntities(entityType, entityId, companyId, created)


SELECT   28, attrValInt, componentNameId, @nowTime

			FROM APP_CompanyProp as CP WITH(NOLOCK)

			LEFT JOIN App_CompanyEntities as App WITH(NOLOCK) on

App.entityType = 28 AND

				App.entityId = attrValInt

WHERE attrName = 'Associated Smart Client Group'

		  		AND attrValInt <> 0

		   		AND CP.modified = 0

		   		AND App.entityId is NULL			

			IF OBJECT_ID('tempdb.dbo.#userCompanyMap') IS NOT NULL

        		DROP TABLE #userCompanyMap

    			CREATE TABLE #userCompanyMap

        		(

            			id INT NOT NULL,

				companyId INT

            			primary key (id)

        		)  
			INSERT INTO #userCompanyMap


			SELECT UM.id, (SELECT CASE UD.serviceType

									WHEN 5 /*UMDS_PROVIDER_ORGANIZATIONS*/ then UD.id

									WHEN 2 /*UMDS_PROVIDER_ACTIVE_DIR*/ then UD.ownerCompany

									WHEN 12 /*UMDS_PROVIDER_DUMMY*/ then UD.ownerCompany

									WHEN 1 /*UMDS_PROVIDER_NATIVE*/ then 0

									ELSE 0

									END

									FROM UMDSProviders UD WITH(NOLOCK)

									WHERE UD.id = UM.umdsProviderId)

			FROM UMUsers as UM WITH(NOLOCK)

        		LEFT JOIN App_CompanyEntities as App WITH(NOLOCK) on  

App.entityType = 13 AND

        		App.entityId = UM.id

        		WHERE  UM.umdsProviderId != 0 AND App.entityId is NULL
			INSERT INTO App_CompanyEntities(entityType, entityId, companyId, created)


SELECT 13, UC.id, UC.companyId, @nowTime

       			FROM #userCompanyMap as UC

        		WHERE UC.companyId != 0 

			IF OBJECT_ID('tempdb.dbo.#userGroupCompanyMap') IS NOT NULL

        		DROP TABLE #userGroupCompanyMap

    			CREATE TABLE #userGroupCompanyMap

        		(

            			id INT NOT NULL,

				companyId INT

            			primary key (id)

        		)  
			INSERT INTO #userGroupCompanyMap


			SELECT UG.id, (SELECT CASE UD.serviceType

									WHEN 5 /*UMDS_PROVIDER_ORGANIZATIONS*/ then UD.id

									WHEN 2 /*UMDS_PROVIDER_ACTIVE_DIR*/ then UD.ownerCompany

									WHEN 12 /*UMDS_PROVIDER_DUMMY*/ then UD.ownerCompany

									WHEN 1 /*UMDS_PROVIDER_NATIVE*/ then 0

									ELSE 0

									END

									FROM UMDSProviders UD WITH(NOLOCK)

									WHERE UD.id = UG.umdsProviderId)

        		FROM UMGroups as UG WITH(NOLOCK)

       			LEFT JOIN App_CompanyEntities as App WITH(NOLOCK) on  

App.entityType = 15 AND

        		App.entityId = UG.id

        		WHERE UG.umdsProviderId != 0 

                		AND UG.umdsProviderId IN (SELECT id from UMDSProviders WITH(NOLOCK))     /* umdsProviderId is not foreign key, hence need this check */

                		AND App.entityId is NULL
			INSERT INTO App_CompanyEntities(entityType, entityId, companyId, created)


SELECT 15, UG.id, UG.companyId, @nowTime

       			FROM #userGroupCompanyMap as UG

        		WHERE UG.companyId != 0
			INSERT INTO App_CompanyEntities(entityType, entityId, companyId, created)


			SELECT DISTINCT entityType1, entityId1, UM.companyId, @nowTime

			FROM UMSecurityAssociations as UM WITH(NOLOCK)

			LEFT JOIN App_CompanyEntities as App WITH(NOLOCK) on  

			App.entityType = UM.entityType1 AND 

			App.entityId = UM.entityId1

			WHERE UM.companyId != 0 

					AND UM.companyId IN (SELECT id from UMDSProviders WITH(NOLOCK))

					AND entityType2 = 0

					AND isCreator = 1 

					AND App.entityId is NULL
			INSERT INTO App_CompanyEntities(entityType, entityId, companyId, created)


			SELECT DISTINCT entityType3, entityId3, UM.companyId, @nowTime

			FROM UMSecurityAssociations as UM WITH(NOLOCK)

			LEFT JOIN App_CompanyEntities as App WITH(NOLOCK) on  

			App.entityType = UM.entityType3 AND 

			App.entityId = UM.entityId3

			WHERE UM.companyId != 0 

					AND UM.companyId IN (SELECT id from UMDSProviders WITH(NOLOCK))

					AND entityType3 != 0

					AND entityType4 = 0

					AND isCreator = 1 

					AND App.entityId is NULL
			INSERT INTO App_CompanyEntities(entityType, entityId, companyId, created)


			SELECT DISTINCT entityType4, entityId4, UM.companyId, @nowTime

			FROM UMSecurityAssociations as UM WITH(NOLOCK)

			LEFT JOIN App_CompanyEntities as App WITH(NOLOCK) on  

			App.entityType = UM.entityType4 AND 

			App.entityId = UM.entityId4

			WHERE UM.companyId != 0 

					AND UM.companyId IN (SELECT id from UMDSProviders WITH(NOLOCK))

					AND entityType4 != 0

					AND entityType5 = 0

					AND isCreator = 1 

					AND App.entityId is NULL
			INSERT INTO App_CompanyEntities(entityType, entityId, companyId, created)


			SELECT DISTINCT entityType5, entityId5, UM.companyId, @nowTime

			FROM UMSecurityAssociations as UM WITH(NOLOCK)

			LEFT JOIN App_CompanyEntities as App WITH(NOLOCK) on  

			App.entityType = UM.entityType5 AND 

			App.entityId = UM.entityId5

			WHERE UM.companyId != 0 

					AND UM.companyId IN (SELECT id from UMDSProviders WITH(NOLOCK))

					AND entityType5 != 0

					AND isCreator = 1 

					AND App.entityId is NULL
			INSERT INTO App_CompanyEntities(entityType, entityId, companyId, created)


			SELECT 3 /* client entity type */, componentNameId, CAST(attrVal AS INT), @nowTime  

			FROM APP_ClientProp as CP WITH(NOLOCK)

			LEFT JOIN App_CompanyEntities as App WITH(NOLOCK) on

				App.entityType = 3 AND 

				App.entityId = componentNameId

			WHERE attrName = 'Installation Company Id'

     				AND attrVal <> '0'

				AND attrVal IN (SELECT CAST(id AS NVARCHAR(12)) from UMDSProviders WITH(NOLOCK))

       				AND CP.modified = 0 

				AND App.entityId is NULL	

			/* Find the MA which are not already tagged in App_CompanyEntities but their corresponding client is tagged */
			INSERT INTO App_CompanyEntities(entityType, entityId, companyId, created)


			SELECT DISTINCT 11 /*media agent entity*/, M.clientId, CL.companyId, @nowTime

			FROM MMHost M WITH (NOLOCK)

			INNER JOIN App_CompanyEntities CL WITH (NOLOCK)

				ON CL.entityType = 3 /*CLIENT_ENTITY*/

					AND CL.entityId  = M.clientId

			LEFT JOIN App_CompanyEntities ACE WITH (NOLOCK)

				ON ACE.entityType = 11

					AND ACE.entityId = M.clientId

			WHERE ACE.entityId is NULL

			IF OBJECT_ID('tempdb.dbo.#CompanyIds') IS NOT NULL

    			DROP TABLE #CompanyIds

			CREATE TABLE #CompanyIds (

    				clientId        INT,

				companyId       INT,

    				PRIMARY KEY (clientId, companyId)

				)
			INSERT INTO #CompanyIds (clientId, companyId) /* To avoid multiple data pass over App_ClientProp table, save client company mapping */


    			SELECT DISTINCT

				cp.componentNameId,

				p.id

			FROM UMDSProviders p WITH(NOLOCK)

				INNER JOIN APP_ClientProp cp WITH(NOLOCK) ON

					cp.attrName = N'Installation Company Id'

					AND cp.modified = 0

					AND cp.attrVal <> N'0'

					AND cp.attrVal = CAST(p.id AS NVARCHAR(12))
			INSERT INTO App_CompanyEntities(entityType, entityId, companyId, created)


			SELECT 5 /* instance entity type */, AI.id, c.companyId, @nowTime

			FROM #CompanyIds c

				INNER JOIN App_application as Appl WITH(NOLOCK) ON

					c.clientId = Appl.clientId

				INNER JOIN APP_InstanceName as AI WITH(NOLOCK) ON

					AI.id = Appl.instance

				LEFT JOIN App_CompanyEntities as App WITH(NOLOCK) on

					App.entityType = 5 AND 

					App.entityId = AI.id

			WHERE 

				AI.id <> 1

				AND AI.id NOT IN (select componentNameId 

						   from APP_InstanceProp WITH(NOLOCK) INNER JOIN App_InstanceName WITH(NOLOCK) 

						   ON App_instancename.id=componentNameId and attrName = 'Discovered VM Instance' and APP_InstanceProp.modified=0 and status=0x200000 and attrVal = '1') /*default vm instance id*/

				AND App.entityId is NULL

			UNION

			SELECT 6 /* backupset entity type */, Bkp.id, c.companyId, @nowTime

			FROM #CompanyIds c

				INNER JOIN App_application as Appl WITH(NOLOCK) ON

					c.clientId = Appl.clientId

				INNER JOIN APP_BackupSetName as Bkp WITH(NOLOCK) ON

					Bkp.id = Appl.backupSet

				LEFT JOIN App_CompanyEntities as App WITH(NOLOCK) on

					App.entityType = 6 AND 

					App.entityId = Bkp.id

			WHERE

				App.entityId is NULL

			UNION

			SELECT 7 /* subclient entity type */, Appl.id, c.companyId, @nowTime

			FROM App_application as Appl WITH(NOLOCK)

				INNER JOIN #CompanyIds c ON

					c.clientId = Appl.clientId

				LEFT JOIN App_CompanyEntities as App WITH(NOLOCK) on

					App.entityType = 7 AND 

					App.entityId = Appl.id

			WHERE 

				App.entityId is NULL
			INSERT INTO App_CompanyEntities(entityType, entityId, companyId, created)


			SELECT DISTINCT 158 /*plan entity*/, P.id, USR.companyId, @nowTime

			FROM App_plan P WITH (NOLOCK)

			INNER JOIN App_CompanyEntities USR WITH (NOLOCK)

				ON USR.entityType = 13 /*USER_ENTITY*/

					AND USR.entityId  = P.ownerId

			LEFT JOIN App_CompanyEntities ACE WITH (NOLOCK)

				ON ACE.entityType = 158

					AND ACE.entityId = P.id

			WHERE ACE.entityId is NULL
			INSERT INTO App_CompanyEntities(entityType, entityId, companyId, created)


			SELECT DISTINCT 61 /* provider entity*/, P.id, ownerCompany, @nowTime

			FROM UMDSProviders P WITH (NOLOCK)

			LEFT JOIN App_CompanyEntities ACE WITH (NOLOCK)

				ON ACE.entityType = 61

					AND ACE.entityId = P.id

			WHERE ownerCompany <> 0

				AND ACE.entityId IS NULL

			/* Delete company tagging of default VM instance entity if it has been tagged */

			DELETE

			FROM App_CompanyEntities 

			WHERE entityType = 5 /*INSTANCE_ENTITY*/

				AND entityId IN (select componentNameId 

						   from APP_InstanceProp WITH(NOLOCK) INNER JOIN App_InstanceName WITH(NOLOCK) 

						   ON App_instancename.id=componentNameId and attrName = 'Discovered VM Instance' and APP_InstanceProp.modified=0 and status=0x200000 and attrVal = '1')

			/* subclient policies created along with plan before SP21 */
			INSERT INTO App_CompanyEntities(entityType, entityId, companyId, created)


			SELECT DISTINCT 6 /*backupset entity*/, BKP.id, ACE.companyId, @nowTime

			FROM APP_BackupSetName BKP WITH (NOLOCK)

			INNER JOIN App_PlanProp APP WITH (NOLOCK)

				ON cast (BKP.id as varchar(10)) = APP.attrVal

					AND APP.attrName in ('Subclient policy 2', 'Subclient policy 3', 'Subclient policy 4')

					AND APP.modified = 0

			INNER JOIN App_CompanyEntities ACE WITH (NOLOCK)

				ON ACE.entityType = 158 

					AND ACE.entityId = APP.componentNameId

			LEFT JOIN App_CompanyEntities ACE2 WITH (NOLOCK)

				ON ACE2.entityType = 6

					AND ACE2.entityId = BKP.id

			WHERE ACE2.entityId is NULL

			/* subclient policies created manually before SP21 */
			INSERT INTO App_CompanyEntities(entityType, entityId, companyId, created)


			SELECT DISTINCT 6 /*backupset entity*/, BKP.id, USR.companyId, @nowTime

			FROM APP_BackupSetName BKP WITH (NOLOCK)

			INNER JOIN APP_BackupSetProp P WITH (NOLOCK)

				ON P.componentNameId = BKP.id

					AND P.attrName = 'Subclient Policy Create UserId'

			INNER JOIN App_CompanyEntities USR WITH (NOLOCK)

				ON USR.entityType = 13 /*USER_ENTITY*/

					AND cast (USR.entityId as varchar(10)) = P.attrVal

			LEFT JOIN App_CompanyEntities ACE WITH (NOLOCK)

				ON ACE.entityType = 6

					AND ACE.entityId = BKP.id

			WHERE ACE.entityId is NULL

			/* VM allocation policy */
			INSERT INTO App_CompanyEntities(entityType, entityId, companyId, created)


			SELECT DISTINCT 93 /*VM_ALLOCATION_POLICY_ENTITY*/, P.id, ACE.companyId, @nowTime

			FROM App_VmAllocationPolicy P WITH(NOLOCK)

			INNER JOIN App_VmAllocationPolicyProp VPP WITH(NOLOCK)

				ON VPP.attrName = 'user' 

					AND VPP.componentNameId = P.id

					AND VPP.modified = 0

			INNER JOIN App_companyEntities ACE WITH(NOLOCK)

				ON ACE.entityType = 13

					AND CAST (ACE.entityId AS VARCHAR(10)) = VPP.attrVal

			LEFT JOIN App_companyEntities ACE2 WITH(NOLOCK)

				ON ACE2.entityType = 93

					AND ACE2.entityId = P.id

			WHERE ACE2.entityId is NULL

		END

	END TRY

	BEGIN CATCH

		PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

        	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

        	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

        	ERROR MESSAGE: ' + ERROR_MESSAGE() + '

        	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

        	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		;THROW;

	END CATCH

SET NOCOUNT OFF

GO
