

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/App_ClientMobileDeviceCleanUp.script] ---------- 


SET QUOTED_IDENTIFIER ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- Remove the absolute OEM Id from the tables

-- SCRIPTNAME App_ClientMobileDeviceCleanUp

SET  NOCOUNT ON

DECLARE  @errorCode         INT      = 0

DECLARE  @errorString       NVARCHAR(1024) = ''

DECLARE @isTranStarted int = 0

BEGIN TRY 

	--Get the list of mobile clients into a separate table

	IF object_id('tempdb.dbo.#MobileAppClients') is not null 

			DROP TABLE #MobileAppClients

	Create Table #MobileAppClients

	(

		clientId		int

	)

	BEGIN TRAN

		set @isTranStarted = 1

		--Get all mobile device client entries
		insert into #MobileAppClients(clientId)


		select distinct id from App_Client with(nolock) where simOperatingSystemId in (215, 216, 217);

		--Delete entries from UMOwners

		delete UMO

		from UMOwners UMO inner join #MobileAppClients MAC on UMO.entityId = MAC.clientId

		where UMO.entityType = 3

		--Delete entries from App_ClientProp

		delete ACP

		from App_ClientProp ACP inner join #MobileAppClients MAC on ACP.componentNameId = MAC.clientId

		--Delete App_Application Entries

		delete AA

		from APP_Application AA inner join #MobileAppClients MAC on AA.clientId = MAC.clientId

		--Delete ClientGroup Assoc

		delete ACGA

		from APP_ClientGroupAssoc ACGA inner join #MobileAppClients MAC on ACGA.clientId = MAC.clientId

		--Deleting all Clients with operating system Id set for mobile devices i.e. iOS, Android, Windows.

		--All mobile device entires will not be moved to MDM_Device & MDM_InstalledApp tables.

		delete AC

		from App_Client AC inner join #MobileAppClients MAC on AC.id = MAC.clientId

		--Delete all BadgeCount entries from MDM_InstalledAppProp tables

		delete from MDM_InstalledAppProp where attrName like 'BadgeCount'

END TRY

BEGIN CATCH

    SET @errorCode = ERROR_NUMBER()

    SET @errorString = 'Procedure [' + ISNULL(ERROR_PROCEDURE(), '') + '] Error Line [' + Convert(varchar(5), ISNULL(ERROR_LINE(), '')) + ']. ' + ISNULL(ERROR_MESSAGE(), '')

END CATCH

IF @errorCode = 0

BEGIN

    if @isTranStarted>0

    begin

        COMMIT TRAN

    end

END

ELSE

BEGIN

    IF LEN(@errorString) > 0

        Print @errorString

    ELSE

        Print 'SQL Error encountered while running the script hence rolling back Transaction'

    if @isTranStarted>0

    begin

        ROLLBACK TRAN

    end

END

-----------------------------------------------------

SET  NOCOUNT OFF

