

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/App_ClientGroup.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/App_ClientGroup.script,v $ $Id: App_ClientGroup.script,v 1.1.6.10 2020/08/19 05:57:13 alakra Exp $";
-- TABLENAME APP_ClientGroup

print '... inserting Table: APP_ClientGroup'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME APP_ClientGroup

SET NOCOUNT ON

SET QUOTED_IDENTIFIER ON

GO

DECLARE @nowTime    int =  DATEDIFF(second, '01/01/1970', GETUTCDATE())

DECLARE @CCGFlagGuid    VARCHAR(40) = '9C502B2D-6896-4B94-90B6-CF753CCEA18A'

DECLARE @UpgFromRel INT

DECLARE @UpgFromSP INT

SELECT @UpgFromRel = CAST(Status AS INTEGER) FROM DBUpgradeSteps WHERE Step = 'UpgradeFromRelease'

SELECT @UpgFromSP = CAST(Status AS INTEGER) FROM DBUpgradeSteps WHERE Step = 'UpgradeFromSPMajor'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @CCGFlagGuid)

BEGIN

	IF	(

@UpgFromRel < 16

OR  (@UpgFromRel = 16 AND @UpgFromSP < 8) --No need to execute from V11 SP8

		)

	BEGIN

		--Reset CommCell Group flag for all client groups with at least one associated client. Avoid resetting empty client groups with the flag already set. They are created from webconsole.

		UPDATE APP_ClientGroup SET flag = flag & (~262144) FROM APP_ClientGroup g INNER JOIN APP_ClientGroupAssoc a	ON g.id = a.clientGroupId 

		IF EXISTS (SELECT 1 FROM simInstalledPackages WHERE simPackageID = 727)

		BEGIN

			--Find all Client groups which are having ALL the associated clients as CommCell. This means that each and every associated client should also have entry in App_CommCell table. 

			IF object_id('tempdb.dbo.#TmpClientGroups') is not null DROP TABLE #TmpClientGroups 

			CREATE TABLE #TmpClientGroups(cgId INT, cId iNT, isExist INT)
			INSERT INTO #TmpClientGroups


			SELECT DISTINCT g.id AS CGId, a.clientId AS cId, 0 

			FROM APP_ClientGroup g INNER JOIN APP_ClientGroupAssoc a ON g.id = a.clientGroupId 

			ORDER BY g.id, a.clientId

			UPDATE #TmpClientGroups SET isExist = 1

			FROM #TmpClientGroups g

			INNER JOIN

			(

				SELECT DISTINCT g.id AS CGId, a.clientId AS cId 

				FROM APP_ClientGroup g INNER JOIN APP_ClientGroupAssoc a ON g.id = a.clientGroupId INNER JOIN APP_Client c ON a.clientId = c.id INNER JOIN APP_CommCell cc ON cc.clientId = c.id

			) sub

				ON g.cgId = sub.CGId AND g.cId = sub.cId

			--Exclude client groups having regular clients

			DELETE #TmpClientGroups FROM #TmpClientGroups g INNER JOIN (SELECT cgId, MIN(isExist) AS isExist FROM #TmpClientGroups GROUP BY cgId) sub ON g.cgId = sub.cgId AND sub.isExist = 0

			--Exclude client groups with only local CS to it

			DELETE #TmpClientGroups FROM #TmpClientGroups g WHERE g.cId = 2 AND NOT EXISTS (SELECT * FROM #TmpClientGroups WHERE cgId = g.cgId AND cId <> 2)

			--Set CommCell group flag for these client groups. Update flag for the client groups with all clients as registered CommCell

			UPDATE 

				APP_ClientGroup 

			SET flag = flag|0x40000 

			FROM #TmpClientGroups g 

				INNER JOIN APP_ClientGroup a

					ON g.cgId =  a.id

			IF object_id('tempdb.dbo.#TmpClientGroups') is not null DROP TABLE #TmpClientGroups

		END

	END
    INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@CCGFlagGuid, 'SetCommCellGroupFlagForClientGroup', 'Update script to set CommCell group flag for client groups created with associated CommCells', @nowTime,  16, 0, (16 + 2))

END

--As company is conflicting with EdgeClient group, updating edge drive SCG to a new flag

DECLARE @updateEdgeSCGFlagGuid    VARCHAR(40) = 'D5FD7637-3C59-4B3D-BCC4-109EE7E2AC17'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @updateEdgeSCGFlagGuid)

BEGIN

	--CV_FLAG_EDGEDRIVE_CLIENT_GROUP

	DECLARE @oldFlag INT = CAST(0x40000000 AS INT)

	DECLARE @newFlag INT = CAST(0x2000000 AS INT)

	--set new flag for edge client client group

	UPDATE CG SET flag = (flag & ~ @oldFlag) | @newFlag

	FROM 

	APP_ClientGroup CG

	INNER JOIN TM_AssocEntity TA(nolock) ON TA.clientGroupId = CG.Id

	INNER JOIN  TM_Task T(nolock) ON T.taskId = TA.taskId 	

	LEFT OUTER JOIN App_CompanyProp CMP(nolock) ON CMP.attrval = CAST(TA.clientGroupId AS NVARCHAR(MAX)) AND CMP.attrname='Associated Smart Client Group' 

												   AND CMP.modified=0 AND CMP.cs_attrName =CHECKSUM('Associated Smart Client Group')

	WHERE CG.flag & CAST(0x1000 AS INT)= CAST(0x1000 AS INT) -- CV_FLAG_SMART_CLIENT_GROUP

	AND CG.flag & @newFlag = 0

	AND T.flags & CAST(0x40 as INT) <> 0 AND CMP.ID IS NULL --TASK_FLAGS_EDGE_DRIVE
    INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@updateEdgeSCGFlagGuid, 'UpdateEdgeClientGroupNewFlag', 'Update script to update flag for edge drive client group to a new flag', @nowTime,  16, 0, (16 + 2))

END

DECLARE @updatescopeOfPlanSCGGuid    VARCHAR(40) = '6D1BBEAA-C0D0-48AA-8291-FF174861B0C8'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @updatescopeOfPlanSCGGuid)

BEGIN

	IF object_id('tempdb.dbo.#LaptopPlanSmartClientGroups') is not null DROP TABLE #LaptopPlanSmartClientGroups 

	DECLARE @refreshId integer = dbo.GetUnixTime(GetUTCdate())

	CREATE TABLE #LaptopPlanSmartClientGroups(cgId INT, planId INT, planName NVARCHAR(1024), ownerId iNT, companyId INT, companySCGId INT)
	INSERT INTO #LaptopPlanSmartClientGroups


	SELECT APP.attrVal, AP.id, AP.name, AP.ownerId, ACP.componentNameId, ACP.attrValInt  

		FROM App_PlanProp APP WITH (NOLOCK) 

	INNER JOIN APP_Plan AP WITH (NOLOCK) 

		ON AP.id=APP.componentNameId AND AP.subType=33554439	-- Only Laptop Plan

	LEFT OUTER JOIN App_CompanyProp ACP WITH(NOLOCK)

			ON ACP.componentNameId=dbo.AppGetCompanyForUserOrUserGroup(AP.ownerId, 1) AND ACP.attrName='Associated Smart Client Group'  AND ACP.modified=0

	WHERE APP.attrName='Assigned client group' AND APP.modified=0

	-- Delete all SCG which are related to commcell

	DELETE FROM #LaptopPlanSmartClientGroups WHERE companyId=0

	UPDATE APSCG

		SET APSCG.entityType = 61,	-- Provider entity

		APSCG.entityId = LPG.companyId    

	FROM APP_SCGScope APSCG

	INNER JOIN App_SCGRule ASCG WITH(NOLOCK)

		ON ASCG.id=APSCG.scgRuleId

	INNER JOIN #LaptopPlanSmartClientGroups LPG

		ON LPG.cgId=ASCG.scgId

	WHERE

		LPG.companyId<>0

	-- As per dicussion between Bhavyan and Arvind, we are only removing wrong client from Plan SCG and Company SCG to avoid regression chances

	-- Delete and keep only those rows where plan name was same and owned by different company

	DELETE LG 

		FROM #LaptopPlanSmartClientGroups LG

	LEFT OUTER JOIN #LaptopPlanSmartClientGroups LG2

		ON LG2.planName=LG.planName AND LG2.planId<>LG.planId

	WHERE LG2.cgId IS NULL

	-- Delete Association from Plan SCG

	DELETE ACGA

		FROM APP_ClientGroupAssoc ACGA

		INNER JOIN #LaptopPlanSmartClientGroups LPSCG

			ON LPSCG.cgId=ACGA.clientGroupId

		LEFT OUTER JOIN App_CompanyEntities ACE WITH(NOLOCK)

			ON ACE.entityType=3 AND ACE.companyId=LPSCG.companyId AND ACGA.clientId=ACE.entityId

		WHERE ACE.entityId IS NULL

	-- Delete Association from Company SCG 	

	DELETE ACGA

		FROM APP_ClientGroupAssoc ACGA

		INNER JOIN #LaptopPlanSmartClientGroups LPSCG

			ON LPSCG.companySCGId=ACGA.clientGroupId

		LEFT OUTER JOIN App_CompanyEntities ACE WITH(NOLOCK)

			ON ACE.entityType=3 AND ACE.companyId=LPSCG.companyId AND ACGA.clientId=ACE.entityId

		WHERE ACE.entityId IS NULL

	IF OBJECT_ID('tempdb.dbo.#AppSCGRefreshRecurExtTable') IS NOT NULL

            DROP TABLE #AppSCGRefreshRecurExtTable

        -- External Inputted Table does not exist

        CREATE TABLE #AppSCGRefreshRecurExtTable (

            scgId       INT PRIMARY KEY

        )

       -- Let make sure to insert only SCG
    INSERT INTO #AppSCGRefreshRecurExtTable 


    SELECT cgId FROM #LaptopPlanSmartClientGroups LPSCG

		INNER JOIN APP_ClientGroup ACG WITH(NOLOCK)

			ON ACG.id=LPSCG.cgId AND (ACG.flag & 0x1000  != 0) --CV_FLAG_SMART_CLIENT_GROUP

	UNION

	SELECT companySCGId FROM #LaptopPlanSmartClientGroups LPSCG

		INNER JOIN APP_ClientGroup ACG WITH(NOLOCK)

			ON ACG.id=LPSCG.companySCGId AND (ACG.flag & 0x1000  != 0) --CV_FLAG_SMART_CLIENT_GROUP

        EXEC APPSCGRefreshRecur 1, @refreshId, -1
    INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@updatescopeOfPlanSCGGuid, 'Update Scope of Laptop Plan SCG', 'Update Scope of Laptop Plan SCG is created by Tenant Admin', @nowTime,  16, 0, (16 + 2))

END

--Remove ownership from Plan Smart Client Group for Admin

DECLARE @scgOwnerRemovalGuid    VARCHAR(40) = 'bac4743d-2158-441d-9e15-9d809288808e'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @scgOwnerRemovalGuid)

BEGIN

DELETE FROM UMOwners WHERE entityType=28 AND entityId IN

(SELECT CAST(APP.attrVal AS INT) FROM App_PlanProp APP WHERE APP.attrName='Assigned client group')
    INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@scgOwnerRemovalGuid, 'Remove owner from plan smart client group', 'Update script to remove UMOwners association of Plan smart client Group', @nowTime,  16, 0, (16 + 2))

END

--Cloud mode enable.

DECLARE @cloudModeEnableGuid    VARCHAR(40) = 'CFE19D5C-97DA-49EC-885D-77D1F79BFA8B'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @cloudModeEnableGuid)

BEGIN

	DECLARE @cloudModeEnabled NVARCHAR(64) = N'Cloud Mode Enabled'

	DECLARE @enableCloudMode NVARCHAR(64) = N'EnableCloudLaptopMode'

	DECLARE @clientGroupEntity INT = 28

	DECLARE @DB_N_WIN_PACKAGE_MEDIAAGENT_CORE INT = 54

	DECLARE @DB_N_UNIX_PACKAGE_MEDIAAGENT_CORE INT = 1305

	IF OBJECT_ID('tempdb.dbo.#CloudLaptops') IS NOT NULL

		DROP TABLE #CloudLaptops

	CREATE TABLE #CloudLaptops ( clientId INT PRIMARY KEY)
	INSERT INTO #CloudLaptops(clientId)


	SELECT DISTINCT clientId FROM APP_ClientGroupAssoc P WITH (NOLOCK) 

	JOIN APP_AdvanceSettings S WITH (NOLOCK) ON S.entityId = P.clientGroupId AND S.keyName = @enableCloudMode AND S.entityType = @clientGroupEntity AND CAST(S.value AS VARCHAR(MAX)) = '1'

	IF OBJECT_ID('tempdb.dbo.#clientsWithMACore') IS NOT NULL

		DROP TABLE #clientsWithMACore

	CREATE TABLE #clientsWithMACore (clientId INT PRIMARY KEY)

	IF OBJECT_ID('tempdb.dbo.#pushWorkTokenToClient') IS NOT NULL

		DROP TABLE #pushWorkTokenToClient

	CREATE TABLE #pushWorkTokenToClient (subclientId INT, clientId INT)
	INSERT INTO #clientsWithMACore(clientId)


	SELECT DISTINCT T.clientId FROM #CloudLaptops T 

	INNER JOIN APP_CLIENT C ON C.id = T.clientId

	INNER JOIN simInstalledPackages pkg ON pkg.clientId = C.id

		WHERE pkg.simPackageID = @DB_N_WIN_PACKAGE_MEDIAAGENT_CORE

	--Set cloud mode enabled on default subclient of the client added to group.

	MERGE APP_SubClientProp T

	USING (SELECT subclient.id FROM App_Application subclient

			INNER JOIN #clientsWithMACore client ON client.clientId = subclient.clientid

			INNER JOIN App_BackupsetName backupSet ON backupSet.id = subclient.backupset

			INNER JOIN APP_AppTypeGroupAssoc appType ON appType.appTypeId = subclient.appTypeId AND appType.appGroupId IN(22,34) AND appType.typeOfGroup = 0 --22:WinFS and 34:UnixFS

			WHERE subclient.subclientStatus = 8

			AND backupSet.status = 8

			AND NOT EXISTS(SELECT 1 FROM App_Application sSubclient

								INNER JOIN APP_SubClientProp sProp ON sSubclient.id = sProp.componentnameId 

								WHERE sSubclient.clientid = client.clientId

								AND sProp.attrName = @cloudModeEnabled AND sProp.modified = 0 AND sProp.cs_attrName = CHECKSUM(@cloudModeEnabled))

			) S

	ON T.componentnameId = S.id AND T.attrName = @cloudModeEnabled AND T.modified = 0 AND T.cs_attrName = CHECKSUM(@cloudModeEnabled)

	WHEN NOT MATCHED THEN

		INSERT (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)

		VALUES(S.id, @cloudModeEnabled, 2, N'1', @nowTime, 0, 0)

		OUTPUT INSERTED.componentNameId

		INTO #pushWorkTokenToClient (subclientId);

	--push work token

	UPDATE T

		SET T.clientId = subclient.clientId

	FROM #pushWorkTokenToClient T

	INNER JOIN APP_Application subclient ON subclient.id = T.subclientId

	DECLARE @xmlForSyncRestoreWQ XML

	SET @xmlForSyncRestoreWQ = (SELECT 17 '@workToken',  -- WORK_TOKEN_SYNC_RESTORE_CONFIG

										'<TMMsg_SyncConfigWorkQueueReq/>' AS '@workTokenParams',

										(

											SELECT DISTINCT clientId '@clientId'

											FROM #pushWorkTokenToClient

												FOR XML PATH('entityList'),TYPE)

								FOR XML PATH('App_SubmitWorkQueueReq'))

	IF @xmlForSyncRestoreWQ IS NOT NULL

	BEGIN

		DECLARE @workQueueOutput XML

		EXEC AppWorkQueueSubmitRequestXMLOUTPUT @xmlForSyncRestoreWQ, @workQueueOutput output

	END
    INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@cloudModeEnableGuid, 'Cloud Mode Enable', 'Enable cloud mode on default subclient of default backupset.', @nowTime,  16, 0, (16 + 2))

END

SET NOCOUNT OFF

