

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/App_Client.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/App_Client.script,v $ $Id: App_Client.script,v 1.1.4.11 2020/12/12 03:35:51 anarde Exp $";
-- TABLENAME App_Client

print '... inserting Table: App_Client'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME App_Client

SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON

GO

DECLARE @nowTime    int =  DATEDIFF(second, '01/01/1970', GETUTCDATE())

DECLARE @DAGGuid    VARCHAR(40) = 'A626B229-8F69-488D-A477-C378E6658597'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @DAGGuid)

BEGIN

	UPDATE APP_Client 

	SET simOperatingSystemId = 210

	WHERE status&0x200000=0x200000          --CV_STATUS_DAG

	AND simOperatingSystemId = 0
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@DAGGuid, 'DAGClientSimOSId', 'Update script to set operating systemId for DAG pseudo clients', @nowTime,  16, 0, (16 + 2))

END

DECLARE @UpdateDisplayNameGuid    VARCHAR(40) = '1E6056FA-5E2F-4013-96F8-0E084715C95C'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @UpdateDisplayNameGuid)

BEGIN

	update app_client set displayName=ACP.attrVal

	from app_clientprop ACP where ACP.componentNameId=app_client.id and ACP.attrName='Virtual Machine Name' and ACP.modified=0 
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@UpdateDisplayNameGuid, 'UpdateDisplayNameWithVMName', 'Update script to set displayname with VM name for upgraded CS from below V11 SP4', @nowTime,  16, 0, (16 + 2))

END

DECLARE @packageAbsentFlag    VARCHAR(40) = '04A6DE9F-33D4-49DE-B055-B3DD32B37F96'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @UpdateDisplayNameGuid)

BEGIN

	-- create the client list temporary table

	IF object_id('tempdb.dbo.#ClientsWithPkg') IS NOT null 

		DROP TABLE #ClientsWithPkg

	CREATE TABLE #ClientsWithPkg	([r_id]	INT PRIMARY KEY)
	INSERT INTO #ClientsWithPkg


    SELECT DISTINCT 

		c.id 

    FROM App_client c WITH(NOLOCK) 

	INNER JOIN simInstalledPackages s WITH(NOLOCK) ON

		s.ClientId = C.id

    WHERE 

		c.id > 1

		AND C.releaseId >= 14

	-- Set the SAME_COMMCELL_GALAXY_PACKAGES_ABSENT property

	UPDATE T

		SET T.specialClientFlags = T.specialClientFlags | 0x2

	FROM APP_Client T

	LEFT OUTER JOIN #ClientsWithPkg S ON T.id = S.r_id

	WHERE 

		S.r_id IS NULL

		AND T.specialClientFlags <> (T.specialClientFlags | 0x2) 

		AND T.releaseId >= 14

		AND T.id > 1
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@UpdateDisplayNameGuid, 'PackAbsentFlag', 'Scrip to set package absent flag', @nowTime,  16, 0, (16 + 2))

END

DECLARE @setNetAPPType    VARCHAR(40) = '2B2F35AA-8DCB-492B-A351-5A3AB2DDF3BF'

DECLARE @setNasAPPType    VARCHAR(40) = 'EF891885-0B67-4CEF-9108-A66D71C4EDD0'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @setNetAPPType) OR NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @setNasAPPType) 

BEGIN

--1.	New scan feature should be enabled on subclients created post SP19-

--	As of now we don't want the feature to be enabled on existing subclients so we have decided to add a subclient property on all existing Isilon Network Share subclients(FS agents only) to indicating the feature is disabled.

--	You can use subclient property  'NAS streaming snap scan enabled' and set it to 'false'

--	Newly created subclients will not have this subclient property so we will assume that the feature is enabled

--	There are different NAS vendors which support Network Share FS agents. As of now, it is not guaranteed to uniquely identify Isilon Network Share FS agents so you can add above subclient property on all Network Share agents with below exception

--	i.	If additional setting bEnableNasNetworkShareStreamingBackup is false or bEnableNasNetworkShareStreamingBackup is not available

--		Then set this property if a client property 'Client App Type' is set to 3(ClientAppType_ISILON) or client whose apptype is not determined

--	ii.	Without checking additional setting bEnableNasNetworkShareStreamingBackup set subclient property 'NAS streaming snap scan enabled' to false 

--		if a client property 'Client App Type' is set to 5(ClientAppType_NETAPP) or client whose apptype is not determined

--2.	Populated 'Client App Type' for all Network Share clients-

--	Currently, 'Client App Type' is set only for Nutanix Network Share clients. We want to populate this property on rest of the Network Share clients. This info will be helpful to display appropriate client info in GUI-

--	Set 'Client App Type' property if it is not already set using below steps only if client apptype is 3(Isilon) or 5(NetApp):

--	i.	Using client property 'NAS OS Type' determine the client application type with this mapping - https:--cvs.commvault.com/source/xref/11.0-win/vaultcx/Source/CommServer/LibConfig/AppClientProp.cpp#10756

--	ii.	If above property is not present then use OSType filed from MMNDMPHostInfo table. Use above mapping.

--	iii.	If NDMP creds are not entered for the client then you will not find corresponding OSType. In this case, you can use 'SMControlHost' table and find engine type corresponding to the client. Use this engine ID to client app type mapping - https:--cvs.commvault.com/source/xref/11.0-win/vaultcx/Source/CommServer/LibConfig/AppClientProp.cpp#9795

--	iv.	If none of the above successful then set the client type as 0.

	IF OBJECT_ID('tempdb.dbo.#nasOSTypeToAppTypeMap') IS NOT NULL 

		DROP TABLE #nasOSTypeToAppTypeMap

    CREATE TABLE #nasOSTypeToAppTypeMap (osType NVARCHAR(8), appType INT)

	INSERT #nasOSTypeToAppTypeMap(osType, appType)

	VALUES

	(/*OS_TYPE_NUTANIX*/ N'34', /*ClientAppType_NUTANIX_AFS*/ 2),

	(/*OS_TYPE_ISILON*/ N'18', /*ClientAppType_ISILON*/ 3 ),

	(/*OS_TYPE_NETAPP*/ N'2', /*ClientAppType_NETAPP*/ 5 ),

	(/*OS_TYPE_DARTOS*/ N'1', /*ClientAppType_CELERRA_VNX*/ 6 ),

	(/*OS_TYPE_BLUEARC*/ N'9', /*ClientAppType_BLUEARC*/ 7 ),

	(/*OS_TYPE_UNITY*/ N'33', /*ClientAppType_UNITY*/ 8 ),

	(/*OS_TYPE_HUAWEI*/ N'32', /*ClientAppType_HUAWEI*/ 9 )

	IF OBJECT_ID('tempdb.dbo.#vendorNameToAppTypeMap') IS NOT NULL 

		DROP TABLE #vendorNameToAppTypeMap

    CREATE TABLE #vendorNameToAppTypeMap (vendorName NVARCHAR(256), appType INT)

	INSERT #vendorNameToAppTypeMap(vendorName, appType)

	VALUES

	(/*SM_SNAPSHOT_ENGINE_NUTANIX_VENDORNAME*/ N'Nutanix', /*ClientAppType_NUTANIX_AFS*/ 2),

	(/*SM_SNAPSHOT_ENGINE_ISILON_VENDORNAME*/ N'Dell EMC Isilon', /*ClientAppType_ISILON*/ 3 ),

	(/*SM_SNAPSHOT_ENGINE_NETAPP_VENDORNAME*/ N'NetApp', /*ClientAppType_NETAPP*/ 5 ),

	(/*SM_SNAPSHOT_ENGINE_CELERRA_VENDORNAME*/ N'Dell EMC VNX / Celerra', /*ClientAppType_CELERRA_VNX*/ 6 ),

	(/*SM_SNAPSHOT_ENGINE_HNAS_VENDORNAME*/ N'Hitachi NAS', /*ClientAppType_BLUEARC*/ 7 ),

	(/*SM_SNAPSHOT_ENGINE_UNITY_VENDORNAME*/ N'Dell EMC Unity', /*ClientAppType_UNITY*/ 8 ),

	(/*SM_SNAPSHOT_ENGINE_HUAWEI_VENDORNAME*/ N'Huawei', /*ClientAppType_HUAWEI*/ 9 )

	IF OBJECT_ID('tempdb.dbo.#networkShareClients') IS NOT NULL 

		DROP TABLE #networkShareClients

    CREATE TABLE #networkShareClients (clientId INT PRIMARY KEY,

										nasOSType INT DEFAULT 0,

										clientAppType INT DEFAULT 0)

	INSERT #networkShareClients(clientId)

	SELECT DISTINCT client.id

	FROM APP_Client client WITH(NOLOCK)

	LEFT JOIN APP_ClientProp prop WITH(NOLOCK) ON client.id = prop.componentnameid AND prop.attrName = N'Client App Type' AND prop.modified = 0

		WHERE prop.attrVal IS NULL 

		AND (client.status & 134217856) <> 0

		--0x8000080 = 134217856

		--CV_STATUS_NAS               0x0080 -- NAS CLIENTS

		--CV_STATUS_NON_NDMP          0x8000000 --Non NDMP

	UPDATE T

		SET T.nasOSType = CAST(attrVal AS INT)

	FROM #networkShareClients T

	INNER JOIN App_ClientProp S ON T.clientId = S.componentNameId

	WHERE S.attrName = N'NAS OS Type' AND S.modified = 0

	UPDATE T

		SET T.nasOSType = S.OSType

	FROM #networkShareClients T

	INNER JOIN MMNDMPHostInfo S WITH(NOLOCK) ON T.clientId = S.ClientId

	WHERE T.nasOSType = 0

	UPDATE T

		SET T.clientAppType = CAST(attrVal AS INT)

	FROM #networkShareClients T

	INNER JOIN App_ClientProp S WITH(NOLOCK) ON T.clientId = S.componentNameId

	WHERE S.attrName = N'Client App Type' AND S.modified = 0

	UPDATE T

		SET T.clientAppType = S.appType

	FROM #networkShareClients T

	INNER JOIN #nasOSTypeToAppTypeMap S ON S.osType = T.nasOSType

	WHERE T.clientAppType = 0

	UPDATE T

		SET T.clientAppType = S2.appType

	FROM #networkShareClients T

	INNER JOIN SMControlHost S1 WITH(NOLOCK) ON S1.ClientId = T.clientId

	INNER JOIN #vendorNameToAppTypeMap S2 ON S2.vendorName = S1.SnapVendorName

	WHERE T.clientAppType = 0

END --setNetAPPType OR setNasAPPType

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @setNetAPPType)

BEGIN

	--Set 'Client App Type' only if it is NetApp.

	INSERT APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)

	SELECT clientId, N'Client App Type', 7, CAST(clientAppType AS NVARCHAR(16)), @nowTime, 0, 0 

	FROM #networkShareClients

	WHERE clientAppType = 5 /*ClientAppType_NETAPP*/

	--START: Subclients of NetAppClient

	DECLARE @bEnableNetAppNetworkShareStreamingBackup INT

	SET @bEnableNetAppNetworkShareStreamingBackup = ISNULL((SELECT 1 FROM APP_AdvanceSettings WITH(NOLOCK) WHERE keyName = 'bEnableNetAppNetworkShareStreamingBackup' AND CAST(value AS NVARCHAR(MAX)) = N'true' AND enabled = 1 AND relativePath = N'CommServDB.Console' AND entityId = 2 AND entityType = 3), 0)

	IF OBJECT_ID('tempdb.dbo.#networkShareNetAppClients') IS NOT NULL 

    	DROP TABLE #networkShareNetAppClients

	CREATE TABLE #networkShareNetAppClients (clientId INT PRIMARY KEY, clientAppType INT)

	--If additional setting bEnableNetAppNetworkShareStreamingBackup is set to false or bEnableNetAppNetworkShareStreamingBackup is not available

	--Then set 'NAS streaming snap scan enabled' on (client having apptype 5(ClientAppType_NETAPP) OR client whose apptype is not determined) AND subclient is win or linux FS

	--Else set 'NAS streaming snap scan enabled' on client whose apptype is not determined AND subclient is win or linux FS

	INSERT #networkShareNetAppClients

	SELECT DISTINCT client.id, CAST(prop.attrVal AS INT)

	FROM APP_Client client WITH(NOLOCK)

	INNER JOIN APP_ClientProp prop WITH(NOLOCK) ON client.id = prop.componentnameid 

	WHERE prop.attrName = N'Client App Type' AND prop.attrVal = N'5' /*ClientAppType_NETAPP*/ AND prop.modified = 0

		AND (client.status & 134217856) <> 0

		--0x8000080 = 134217856

		--CV_STATUS_NAS               0x0080 -- NAS CLIENTS

		--CV_STATUS_NON_NDMP          0x8000000 --Non NDMP

	UNION

	SELECT clientId, 0

	FROM #networkShareClients

	WHERE clientAppType = 0

	IF @bEnableNetAppNetworkShareStreamingBackup = 0

	BEGIN

		INSERT APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)

		SELECT subclient.id, N'NAS streaming snap scan enabled', 2, N'0', @nowTime, 0, 0 FROM APP_Application subclient WITH(NOLOCK)

		INNER JOIN #networkShareNetAppClients nsClient ON nsClient.clientId = subclient.clientId

		WHERE subclient.appTypeId IN(33,29)/*33=WinFS, 29=LinuxFS*/

		AND NOT EXISTS(SELECT 1 FROM APP_SubClientProp WITH(NOLOCK) WHERE componentNameId = subclient.id AND attrName = N'NAS streaming snap scan enabled' AND modified = 0)

	END

	ELSE

	BEGIN

		INSERT APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)

		SELECT subclient.id, N'NAS streaming snap scan enabled', 2, N'0', @nowTime, 0, 0 FROM APP_Application subclient WITH(NOLOCK)

		INNER JOIN #networkShareNetAppClients nsClient ON nsClient.clientId = subclient.clientId

		WHERE subclient.appTypeId IN(33,29)/*33=WinFS, 29=LinuxFS*/	

		AND nsClient.clientAppType = 0

		AND NOT EXISTS(SELECT 1 FROM APP_SubClientProp WITH(NOLOCK) WHERE componentNameId = subclient.id AND attrName = N'NAS streaming snap scan enabled' AND modified = 0)

	END

	--END: Subclients of NetAppClient
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@setNetAPPType, 'SetNetAppType', 'Upgrade script to set NetApp Client App Type', @nowTime,  16, 0, (16 + 2))

END --setNetAPPType

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @setNasAPPType)

BEGIN

	--Set 'Client App Type' only if it is Isilon.

	INSERT APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)

	SELECT clientId, N'Client App Type', 7, CAST(clientAppType AS NVARCHAR(16)), @nowTime, 0, 0 

	FROM #networkShareClients

	WHERE clientAppType = 3 /*ClientAppType_ISILON*/ 

	DECLARE @bEnableNasNetworkShareStreamingBackup INT

	SET @bEnableNasNetworkShareStreamingBackup = ISNULL((SELECT 1 FROM APP_AdvanceSettings WITH(NOLOCK) WHERE keyName = 'bEnableNasNetworkShareStreamingBackup' AND CAST(value AS NVARCHAR(MAX)) = N'true' AND enabled = 1 AND relativePath = N'CommServDB.Console' AND entityId = 2 AND entityType = 3), 0)

	IF OBJECT_ID('tempdb.dbo.#networkShareClientsWithoutNutanix') IS NOT NULL 

    	DROP TABLE #networkShareClientsWithoutNutanix

	CREATE TABLE #networkShareClientsWithoutNutanix (clientId INT PRIMARY KEY, clientAppType INT)

	--If additional setting bEnableNasNetworkShareStreamingBackup is set to false or bEnableNasNetworkShareStreamingBackup is not available

	--Then set 'NAS streaming snap scan enabled' on client having apptype 3(ClientAppType_ISILON) or client whose apptype is not determined

	--Else set 'NAS streaming snap scan enabled' on client whose apptype is not determined

	INSERT #networkShareClientsWithoutNutanix

	SELECT DISTINCT client.id, CAST(prop.attrVal AS INT)

	FROM APP_Client client WITH(NOLOCK)

	INNER JOIN APP_ClientProp prop WITH(NOLOCK) ON client.id = prop.componentnameid 

	WHERE prop.attrName = N'Client App Type' AND prop.attrVal = N'3' /*ClientAppType_ISILON*/ AND prop.modified = 0

		AND (client.status & 134217856) <> 0

		--0x8000080 = 134217856

		--CV_STATUS_NAS               0x0080 -- NAS CLIENTS

		--CV_STATUS_NON_NDMP          0x8000000 --Non NDMP

	UNION

	SELECT clientId, 0

	FROM #networkShareClients

	WHERE clientAppType = 0

	IF @bEnableNasNetworkShareStreamingBackup = 0

	BEGIN		

		UPDATE T 

			SET modified = @nowTime

		FROM APP_SubClientProp T

		INNER JOIN APP_Application subclient WITH(NOLOCK) ON T.componentNameId = subclient.id

		INNER JOIN #networkShareClientsWithoutNutanix nsClient ON nsClient.clientId = subclient.clientId

		WHERE T.attrName = N'NAS streaming snap scan enabled'

		AND T.cs_attrName = CHECKSUM(N'NAS streaming snap scan enabled') AND T.modified = 0

		INSERT APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)

		SELECT subclient.id, N'NAS streaming snap scan enabled', 2, N'0', @nowTime, 0, 0 FROM APP_Application subclient WITH(NOLOCK)

		INNER JOIN #networkShareClientsWithoutNutanix nsClient ON nsClient.clientId = subclient.clientId

	END

	ELSE

	BEGIN

		UPDATE T 

			SET modified = @nowTime

		FROM APP_SubClientProp T

		INNER JOIN APP_Application subclient WITH(NOLOCK) ON T.componentNameId = subclient.id

		INNER JOIN #networkShareClientsWithoutNutanix nsClient ON nsClient.clientId = subclient.clientId

		WHERE 

			nsClient.clientAppType = 0

		AND T.attrName = N'NAS streaming snap scan enabled'

		AND T.cs_attrName = CHECKSUM(N'NAS streaming snap scan enabled') AND T.modified = 0

		INSERT APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)

		SELECT subclient.id, N'NAS streaming snap scan enabled', 2, N'0', @nowTime, 0, 0 

		FROM APP_Application subclient WITH(NOLOCK)

		INNER JOIN #networkShareClientsWithoutNutanix nsClient ON nsClient.clientId = subclient.clientId

		WHERE nsClient.clientAppType = 0

	END
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@setNasAPPType, 'SetNASAppType', 'Upgrade script to set NAS Client App Type and disable streaming snap scan on existing subclients', @nowTime,  16, 0, (16 + 2))

END

DECLARE @SetEpicClientAppTypeGUID VARCHAR(128) = '4E494E25-8CD1-4B95-A95D-C008A38AEA8A'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WITH(NOLOCK) WHERE SqlScriptGUID = @SetEpicClientAppTypeGUID)

BEGIN	

	DECLARE @currentTime INTEGER = (SELECT DATEDIFF(s, CONVERT(DATETIME, '1970-01-01'), GETUTCDATE()))

	DECLARE @newStateEpicServersList NVARCHAR(50) = 'epicServersList'   

	DECLARE @epicSupportedSlnValue INT= POWER(2,20) --enum SupportedSolutionsBitValue api.x

	IF OBJECT_ID('tempdb.dbo.#EpicClients') IS NOT NULL 

		DROP TABLE #EpicClients

	CREATE TABLE #EpicClients (clientId INT, companyId int)
	INSERT INTO #EpicClients


	SELECT distinct clientid, cast(ISNULL(cp2.attrval,0) as int)

	FROM App_client c

	JOIN App_application a ON a.clientId=C.id

	INNER JOIN APP_ScFilterFile f ON f.componentNameId=a.id AND (f.fileName LIKE '/Epic%' OR f.filename LIKE '%CACHEDB%') AND f.modified=0

	LEFT JOIN APP_ClientProp cp ON cp.componentNameId=A.clientId AND CP.attrName = 'client App type' AND cp.modified=0

	LEFT JOIN APP_ClientProp cp2 ON cp2.componentNameId=A.clientId AND CP2.attrName = 'Installation Company ID' AND cp2.modified=0 -- PROP_ASSOCIATED_COMPANY_ID

	WHERE CP.attrVal<>'11' OR CP.attrVal IS NULL
	INSERT INTO APP_ClientProp (componentNameId,attrName,attrType,attrVal,created,modified,ccpId)


	SELECT distinct clientid,'Client App Type',7,'11',@currentTime,0,0 ---enum ClientAppType Epic

	FROM #EpicClients

	EXEC AppAddDeniedNavsToPersona @newStateEpicServersList,@newStateEpicServersList,@newStateEpicServersList,@newStateEpicServersList,@newStateEpicServersList

	IF(@@ROWCOUNT > 0)

	BEGIN

		IF EXISTS(SELECT 1  FROM #EpicClients where companyId = 0 )

		BEGIN

			--Not having EPIC:true 

			UPDATE GXGlobalParam set value	 = REPLACE(value, '}', ',"EPIC":true}') WHERE name='completedSetups' and CHARINDEX('"EPIC":true',value)= 0 and modified=0  AND value <> ''

			UPDATE GXGlobalParam set value='{"EPIC":true}' WHERE name='completedSetups' and value='' and modified=0

			UPDATE GXGlobalParam set value = REPLACE( REPLACE( REPLACE(value, @newStateEpicServersList + ',', ''), ','+ @newStateEpicServersList ,''),@newStateEpicServersList,'') 	 

			WHERE name in ('Restricted Nav Items For MSP Admin', 'Restricted Nav Items For MSP User', 'Restricted Nav Items For Restricted Admin')

		END

		IF EXISTS(SELECT 1  FROM #EpicClients where companyId > 0 )

		BEGIN

			--Not having CORE_SETUP":true 

			--SELECT * FROM App_CompanyProp WHERE attrName='completedSetups' and CHARINDEX('"CORE_SETUP":true',attrval)= 0 and modified=0  AND attrval <> ''

			UPDATE C set attrVal = REPLACE(attrVal, '}', ',"EPIC":true}')

			FROM App_CompanyProp C

			INNER JOIN #EpicClients ec on ec.companyId= c.componentNameId AND ec.companyId > 0

			WHERE attrName='completedSetups' and CHARINDEX('"EPIC":true',attrval)= 0 and modified=0  AND attrval <> '' 

			--Empty string

			--SELECT * FROM App_CompanyProp WHERE attrName='completedSetups' and attrVal='' and modified=0

			UPDATE c  set attrVal='{"EPIC":true}'

			FROM  App_CompanyProp C

			INNER JOIN #EpicClients ec on ec.companyId= c.componentNameId AND ec.companyId > 0

			WHERE attrName='completedSetups' AND attrVal='' AND modified=0

			--No setups completed(null)
			INSERT INTO App_CompanyProp(componentNameId, attrName, attrType, attrVal, created, modified)


			SELECT U.companyId,'completedSetups', 1,'{"EPIC":true}',@currentTime,0  FROM #EpicClients u

			LEFT JOIN  App_CompanyProp cp on cp.componentNameId=u.companyId  and attrName='completedSetups' and cp.modified=0

			WHERE cp.id is null AND u.companyId > 0

			UPDATE c  set c.attrVal = CAST(c.attrVal as int) | @epicSupportedSlnValue

			FROM  App_CompanyProp C

			INNER JOIN #EpicClients ec on ec.companyId= c.componentNameId AND ec.companyId > 0

			WHERE attrName='supportedSolutions' AND modified=0

			IF(@@ROWCOUNT = 0)

			BEGIN
				INSERT INTO App_CompanyProp(componentNameId, attrName, attrType, attrVal, created, modified)


				SELECT U.companyId,'supportedSolutions', 1,@epicSupportedSlnValue ,@currentTime,0  

				FROM #EpicClients u WHERE u.companyId > 0

			END

			UPDATE GXGlobalParam set value = REPLACE( REPLACE( REPLACE(value, @newStateEpicServersList + ',', ''), ','+ @newStateEpicServersList ,''),@newStateEpicServersList,'') 	 

			WHERE name in ('Restricted Nav Items For Tenant Admin','Restricted Nav Items For Tenant User')

		END

	END
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@SetEpicClientAppTypeGUID, 'EpicClientAppTypeFix', 'Identify the Epic clients', datediff(second, '01/01/1970', GETDATE()), 16, 0 , (16 + 1))

END

