

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/AppRenameFailoverTopology.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/AppRenameFailoverTopology.script,v $ $Id: AppRenameFailoverTopology.script,v 1.1.2.2 2019/12/12 19:24:26 sjohnson Exp $";

GO

SET QUOTED_IDENTIFIER ON

GO

DECLARE @guid uniqueidentifier = 'BB1698A8-AA61-4DDC-AE0B-1A58A9438FF8'

DECLARE @curUtcDateTime BIGINT = datediff(second, '01/01/1970', GetUTCdate())

DECLARE @IsTranStarted INT = 0

DECLARE @globalParamTopologyUpdateExec INT = 0

SELECT @globalParamTopologyUpdateExec = 1

FROM

    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

    gp.SqlScriptGUID = @guid

IF (@globalParamTopologyUpdateExec = 0)        -- not done, create the activity monitoring dashboard

BEGIN

	BEGIN TRY

        IF @@TRANCOUNT=0

        BEGIN

            SET @IsTranStarted = 1

            BEGIN TRAN

        END

		UPDATE APP_FirewallTopology

		SET topologyName = 'Network Topology created for Commserv Failover',

		description = 'Network topology created by default for Commserv Failover'

		WHERE topologyName = 'Firewall Topology created for Commserv Failover'

		AND description = 'Firewall topology created by default for Commserv Failover' 

AND (flag & 2) > 0

		UPDATE APP_FirewallTopology

		SET topologyName = 'Network Topology created for failover clients',

		description = 'Network topology created by default for failover clients'

		WHERE topologyName = 'Firewall Topology created for failover clients'

		AND description = 'Firewall topology created by default for failover clients' 

AND (flag & 4)>0

		UPDATE APP_FirewallTopology

		SET topologyName = 'Test network topology created for Commserv Failover',

		description = 'Test network topology created by default for Commserv Failover'

		WHERE topologyName = 'Test firewall topology created for Commserv Failover'

		AND description = 'Test firewall topology created by default for Commserv Failover' 

AND (flag & 8 ) >0

		-- DATEADD(SECOND, @tzOffsetSecs,TM_Runtimeassoc.nextRunTime) converts CS time to time in UTC. Then we get its unix time by below

		-- DATEDIFF(second, '01/01/1970', DATEADD(SECOND, @tzOffsetSecs,TM_Runtimeassoc.nextRunTime) )
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@guid, 'RenameFailoverTopology', 'Rename system created topology created during failover configuration', @curUtcDateTime, 16, 0 , (16 + 2))

		IF (@IsTranStarted=1)

        BEGIN

            COMMIT TRAN

        END

	END TRY

	BEGIN CATCH 

		PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

		ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

		ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

		ERROR MESSAGE: ' + ERROR_MESSAGE() + '

		ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

		ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		PRINT 'Rolling back transaction'

		IF (@IsTranStarted=1)

		BEGIN

			ROLLBACK TRAN

		END

	END CATCH;	

END

GO

