

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/AppDisableTestFailover.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 2020  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

GO

SET QUOTED_IDENTIFIER ON

GO

DECLARE @guid uniqueidentifier = '8611C4DE-5BBB-430A-97FE-02C8D1D61BF3'

DECLARE @curUtcDateTime BIGINT = datediff(second, '01/01/1970', GetUTCdate())

DECLARE @IsTranStarted INT = 0

IF NOT EXISTS(SELECT 1

	FROM GXUniqueSQLScriptExecTracking(NOLOCK)

	WHERE SqlScriptGUID = @guid)

BEGIN

	BEGIN TRY

		IF @@TRANCOUNT=0

        BEGIN

            SET @IsTranStarted = 1

            BEGIN TRAN

        END

		DECLARE @testFwTopology INT = 0

		SELECT @testFwTopology = topologyId

		FROM APP_FirewallTopology(NOLOCK)

WHERE flag & 8 /*8*/ > 0

		DECLARE @testClientGroups TABLE(id INT)

		IF @testFwTopology > 0

		BEGIN
			INSERT INTO @testClientGroups


			SELECT groupId

			FROM APP_FirewallTopologyAssoc(NOLOCK)

			WHERE topologyId = @testFwTopology

		END

		IF EXISTS (SELECT 1 FROM @testClientGroups)

		BEGIN

			UPDATE CG

			SET flag = (flag & ~4096)

			FROM APP_ClientGroup CG

			JOIN @testClientGroups T ON T.id = CG.id

			DELETE CGA

			FROM APP_ClientGroupAssoc CGA

			JOIN @testClientGroups GC ON GC.id = CGA.clientGroupId

		END

		--Remove existing test failover associations

		DELETE FROM GxGlobalParam

		WHERE NAME IN ('CSTestFailoverClientGroup', 'CSTestFailoverProxyClientGroup')

		AND modified = 0
		INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@guid, 'DisableTestFailover', 'Disable Test Failover', @curUtcDateTime, 16, 0, (16 + 2))

		IF (@IsTranStarted=1)

		BEGIN

			COMMIT TRAN

		END

	END TRY

	BEGIN CATCH 

		PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

		ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

		ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

		ERROR MESSAGE: ' + ERROR_MESSAGE() + '

		ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

		ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		PRINT 'Rolling back transaction'

		IF (@IsTranStarted=1)

		BEGIN

			ROLLBACK TRAN

		END

		;THROW;

	END CATCH

END

GO

