

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/AppCleanUpServicePackInfoProperty.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/AppCleanUpServicePackInfoProperty.script,v $ $Id: AppCleanUpServicePackInfoProperty.script,v 1.1.2.2 2019/12/12 22:39:22 vdevassy Exp $";

GO

SET QUOTED_IDENTIFIER ON

GO

DECLARE @guid uniqueidentifier = 'D8800B9E-D01B-4EFA-AEA0-B3146F0C17E6'

DECLARE @curUtcDateTime BIGINT = datediff(second, '01/01/1970', GetUTCdate())

DECLARE @IsTranStarted INT = 0

DECLARE @globalParamTopologyUpdateExec INT = 0

SELECT @globalParamTopologyUpdateExec = 1

FROM

    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

    gp.SqlScriptGUID = @guid

IF (@globalParamTopologyUpdateExec = 0)        -- not done, create the activity monitoring dashboard

BEGIN

	BEGIN TRY

        IF @@TRANCOUNT=0

        BEGIN

            SET @IsTranStarted = 1

            BEGIN TRAN

        END

		-- Delete Service pack info and Service pack info time attributes based on backup cycles retained. 

		IF object_id('tempdb.dbo.#SPInfoListToRemove') IS NOT NULL

			DROP TABLE #SPInfoListToRemove

		CREATE TABLE #SPInfoListToRemove (

			clientId        INT,

			appTypeId		INT,			

			attrName		NVARCHAR(128),

			modified		INT

		)

		CREATE NONCLUSTERED INDEX SPInfoListToRemove_idx ON #SPInfoListToRemove (clientId, appTypeId, attrName, modified)
		INSERT INTO #SPInfoListToRemove


		SELECT DISTINCT App_Extendedproperties.clientId, App_Extendedproperties.appTypeId, App_Extendedproperties.attrName, App_Extendedproperties.modified		

		FROM App_Extendedproperties (NOLOCK)

		LEFT JOIN

		(

			   SELECT App_Extendedproperties.clientId, App_Extendedproperties.appTypeId, JMBKpstats.fullCycleNum, MIN(JMBKpstats.servStartDate) cycleStart, MAX(JMBKpstats.servEndDate) cycleEnd FROM app_extendedproperties

			   INNER JOIN App_application ON app_extendedproperties.clientId = APP_Application.clientId

			   AND APP_ExtendedProperties.appTypeId = APP_Application.appTypeId			   

			   AND APP_ExtendedProperties.attrName IN ('Service Pack Info', 'Service Pack Info Time')

			   INNER JOIN JMBkpStats ON  JMBkpStats.appId = App_application.Id and JMBkpStats.status in (1,3,14) --_JMSUCCESS,_PARTIALSUCCESS,_JMSUCCESSWITHWARNINGS

			   GROUP BY app_extendedproperties.clientId, app_extendedproperties.appTypeId, App_Extendedproperties.instance, JMBKpstats.fullCycleNum

		) SPInfo

		ON SPInfo.clientid = app_extendedproperties.clientId

		AND SPInfo.appTypeId = app_extendedproperties.appTypeId		

		AND (   

							 --cyclestart <= app_extendedproperties.created and cycleend >= app_extendedproperties.created 

							 ( cyclestart >= app_extendedproperties.created and (cyclestart<=app_extendedproperties.modified OR app_extendedproperties.modified=0)  ) OR

							 ( cycleend >= app_extendedproperties.created and (cycleend<=app_extendedproperties.modified OR app_extendedproperties.modified=0)  )

			   )

		WHERE attrName IN ('Service Pack Info', 'Service Pack Info Time')

		and SPInfo.clientId is null

		OPTION (MAXDOP 2)

		DECLARE @rcnt INT = 1

		WHILE (@rcnt > 0)

		BEGIN

			DELETE TOP (5000) EP FROM APP_ExtendedProperties EP WITH (NOLOCK) 			

			INNER JOIN #SPInfoListToRemove SPInfoListToRemove ON 

			EP.clientID = SPInfoListToRemove.clientID AND 

			EP.appTypeId = SPInfoListToRemove.appTypeId AND 			

			EP.attrName = SPInfoListToRemove.attrName AND 

			EP.modified = SPInfoListToRemove.modified

			SET @rcnt = @@ROWCOUNT

		END

		IF object_id('tempdb.dbo.#SPInfoListToRemove') IS NOT NULL

			DROP TABLE #SPInfoListToRemove
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@guid, 'CleanupServicePackInfoProperty', 'Clean up service pack info property from App_ExtendedProp tables', @curUtcDateTime, 16, 0 , (16 + 2))

		IF (@IsTranStarted=1)

        BEGIN

            COMMIT TRAN

        END

	END TRY

	BEGIN CATCH 

		PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

		ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

		ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

		ERROR MESSAGE: ' + ERROR_MESSAGE() + '

		ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

		ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		PRINT 'Rolling back transaction'

		IF (@IsTranStarted=1)

		BEGIN

			ROLLBACK TRAN

		END

	END CATCH;	

END

GO

