

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/AppCSFailoverDBFilePathInfo.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

GO

SET QUOTED_IDENTIFIER ON

GO

DECLARE @nowTime INT = DATEDIFF(second, '01/01/1970', GetUTCdate())

DECLARE @guid uniqueidentifier = 'BC8A06A0-5AFA-484A-AA9B-A838A3CB6994'

DECLARE @IsTranStarted INT = 0

IF EXISTS(SELECT 1 FROM dbo.simInstalledPackages WITH (NOLOCK) WHERE simPackageID = 24 )

BEGIN

	IF NOT EXISTS(SELECT * FROM   GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = @guid )

	BEGIN

		BEGIN TRY    

			IF @@TRANCOUNT=0

			BEGIN

				SET @IsTranStarted = 1

				BEGIN TRAN

			END	

			IF OBJECT_ID('tempdb.dbo.#DBFilePathInfoForFailver') IS NOT NULL DROP TABLE #DBFilePathInfoForFailver

			CREATE TABLE #DBFilePathInfoForFailver 

			(

				clientId NVARCHAR(20),

				xmlInfoForDBPaths XML

				PRIMARY KEY(clientID)

			)

			DECLARE @csSecondInstanceClientID INT = 0

			SELECT @csSecondInstanceClientID = CONVERT(INT, attrval) FROM App_clientprop

			WHERE componentnameID=2 AND attrname='Failover Instance ClientID' AND modified=0

			IF (@csSecondInstanceClientID>0)

			BEGIN

				-- Fill DB path for CS into CS second instance

				DECLARE @csDBFilePathXML XML

				SET @csDBFilePathXML = ( 

											SELECT name '@logicalFileName', physical_name '@fileName', size '@fileMaxSize',0 '@id',database_id 'sqlDBInfo/@databaseId',DB_NAME(database_id) 'sqlDBInfo/@databaseName' 

                                            FROM sys.master_files                                                 

                                            FOR XML PATH('sqlDbdeviceItem'),ROOT('Api_GetDBFilePathInfoResp'),TYPE

										)
				INSERT INTO #DBFilePathInfoForFailver 


				VALUES (CAST(@csSecondInstanceClientID AS  NVARCHAR(20)), @csDBFilePathXML)

			END

			-- Take DB File path info from XML options 
			INSERT INTO #DBFilePathInfoForFailver 


			SELECT CAST(TM_subtaskOptions.value AS  NVARCHAR(20)), 

				(

					SELECT 

						(SELECT TOP 1 DATA FROM dbo.SplitString(ref.value('@val','NVARCHAR(MAX)' ),char(9) ) ValComp WHERE ID = 6) '@logicalFileName', 

						(SELECT TOP 1 DATA FROM dbo.SplitString(ref.value('@val','NVARCHAR(MAX)' ),char(9) ) ValComp WHERE ID = 4) '@fileName', 

						(SELECT TOP 1 DATA FROM dbo.SplitString(ref.value('@val','NVARCHAR(MAX)' ),char(9) ) ValComp WHERE ID = 3) '@fileMaxSize',0 '@id',

						(SELECT TOP 1 DATA FROM dbo.SplitString(ref.value('@val','NVARCHAR(MAX)' ),char(9) ) ValComp WHERE ID = 1) 'sqlDBInfo/@databaseId',

						(SELECT TOP 1 DATA FROM dbo.SplitString(ref.value('@val','NVARCHAR(MAX)' ),char(9) ) ValComp WHERE ID = 2) 'sqlDBInfo/@databaseName' 

					FROM TM_SubtaskOptions (NOLOCK)

					CROSS APPLY (SELECT CAST(TM_SubtaskOptions.Value AS XML)) as T(X)

					CROSS APPLY T.X.nodes('deviceInfo') R(Ref)					

WHERE optionId = 28727135

					AND SubTaskID = FailoverSchedules.subTaskID 

					FOR XML PATH('sqlDbdeviceItem'),ROOT('Api_GetDBFilePathInfoResp'), TYPE

				)

			FROM TM_SubTaskOptions (NOLOCK)

			INNER JOIN 

			(

				SELECT DISTINCT TM_SubTask.subTaskID FROM TM_SubTask (NOLOCK) 

				INNER JOIN TM_Task (NOLOCK) ON TM_Task.taskId = TM_SubTask.TaskId

				AND TM_Task.deleted = 0

AND TM_SubTask.operationType = 1007

and (TM_Subtask.flags & 0x200000)>0

			) FailoverSchedules

			ON FailoverSchedules.subTaskID = TM_SubTaskOptions.subTaskID

AND TM_subtaskOptions.optionId = 293753447

			AND TM_subtaskOptions.value <> CONVERT(NVARCHAR(100),@csSecondInstanceClientID) -- CS client second instance is added above. 

			-- Insert into GxglobalParam where its not present before. 
			INSERT INTO GxglobalParam


SELECT 'DBFilePathInfo_'+clientId, CAST(xmlInfoForDBPaths AS NVARCHAR(MAX)), @nowTime,0

			FROM #DBFilePathInfoForFailver

LEFT JOIN GxGlobalParam ON GxGlobalParam.NAme = 'DBFilePathInfo_'+clientId AND GxGlobalParam.modified = 0

			WHERE GxGlobalParam.Name IS NULL 
			INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@guid, 'FillDBPathInfoForFailoverClients', 'Set DB File path Info in GxGlobalparam to use during live sync schedule creation', @nowTime, 16, 0, (16 + 2))

			IF (@IsTranStarted=1)

			BEGIN

				COMMIT TRAN

			END

		END TRY

		BEGIN CATCH 

			PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

			ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

			ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

			ERROR MESSAGE: ' + ERROR_MESSAGE() + '

			ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

			ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

			PRINT 'Rolling back transaction'

			IF (@IsTranStarted=1)

			BEGIN

				ROLLBACK TRAN

			END

		END CATCH;

		IF OBJECT_ID('tempdb.dbo.#DBFilePathInfoForFailver') IS NOT NULL DROP TABLE #DBFilePathInfoForFailver

	END

END

