

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/AddOutGoingRoutesToCGsInTopologies.script] ---------- 


SET QUOTED_IDENTIFIER ON

-----------------------------------------------------------------------------------------------------------------------------------------

-- 	Script 	: 	AddOutGoingRoutesToCGsInTopologies

--	Purpose :	This script adds OutGoing DIRECT routes between client groups part of One-way, Two-way and Via-Proxy network topologies. One route in case of One-way and two in case of Two-way and Via-Proxy.

-----------------------------------------------------------------------------------------------------------------------------------------

DECLARE @AddOutGoingRoutesToCGsInTopologies INT = 0

DECLARE @uniqueScriptID uniqueidentifier = 'C462DA01-C5D8-40F1-8FC5-9846E8A08892'

SELECT @AddOutGoingRoutesToCGsInTopologies = 1 FROM GXUniqueSQLScriptExecTracking WITH(NOLOCK) WHERE SqlScriptGUID = @uniqueScriptID

IF @AddOutGoingRoutesToCGsInTopologies = 0

BEGIN

	BEGIN TRY

		BEGIN TRANSACTION
		INSERT INTO APP_FWOutGoingRoutes


		SELECT 0 clientId

		, AFTA2.groupId clientGroupId

		, 0 forClientId

		, CASE topologyType WHEN 1 THEN AFTA3.groupId ELSE AFTA1.groupId END forClientGroupId --In case of Proxy topologies, creare direct route to proxy

		, CONVERT(XML,(SELECT ISNULL(ExtendedProps.props.value('@defaultOutgoingProtocol','int'),2 /* HTTPSA */) AS '@connectionProtocol',0 /* FALSE */ AS '@forceAllBackupRestoreDataTraffic','' AS '@gatewayHostname',	0 /* DIRECT */ AS '@routeType',	1 AS '@numberOfStreams'	FOR XML PATH('App_FireWallOutGoingRouteOptions'))) fwOutGoingRouteOptions

, CASE AFT.flag & 1 WHEN 1 THEN 4 ELSE 2 END

		FROM 

		APP_FirewallTopologyAssoc AFTA1 

		INNER JOIN APP_FirewallTopologyAssoc AFTA2 ON AFTA1.topologyId = AFTA2.topologyId AND AFTA1.fwGroupType = 1 AND AFTA2.fwGroupType = 2 

		LEFT JOIN APP_FirewallTopologyAssoc AFTA3 ON AFTA1.topologyId = AFTA3.topologyId AND AFTA3.fwGroupType = 3 

		INNER JOIN APP_FirewallTopology AFT ON AFTA1.topologyId = AFT.topologyId 

		INNER JOIN APP_FirewallOptions AFO ON AFTA2.groupId = AFO.clientGroupId

		CROSS APPLY AFO.extendedProperties.nodes('App_FirewallExtendedProperties') ExtendedProps(props)

		UNION ALL

		SELECT 0 clientId

		, AFTA1.groupId clientGroupId

		, 0 forClientId

		, CASE topologyType WHEN 1 THEN AFTA3.groupId ELSE AFTA2.groupId END forClientGroupId --In case of Proxy topologies, creare direct route to proxy

		, CONVERT(XML,(SELECT ISNULL(ExtendedProps.props.value('@defaultOutgoingProtocol','int'),2 /* HTTPSA */) AS '@connectionProtocol',0 /* FALSE */ AS '@forceAllBackupRestoreDataTraffic','' AS '@gatewayHostname',	0 /* DIRECT */ AS '@routeType',	1 AS '@numberOfStreams'	FOR XML PATH('App_FireWallOutGoingRouteOptions'))) fwOutGoingRouteOptions

, CASE AFT.flag & 1 WHEN 1 THEN 4 ELSE 2 END

		FROM 

		APP_FirewallTopologyAssoc AFTA1 

		INNER JOIN APP_FirewallTopologyAssoc AFTA2 ON AFTA1.topologyId = AFTA2.topologyId AND AFTA1.fwGroupType = 1 AND AFTA2.fwGroupType = 2 

		LEFT JOIN APP_FirewallTopologyAssoc AFTA3 ON AFTA1.topologyId = AFTA3.topologyId AND AFTA3.fwGroupType = 3 

		INNER JOIN APP_FirewallTopology AFT ON AFTA1.topologyId = AFT.topologyId 

		INNER JOIN APP_FirewallOptions AFO ON AFTA1.groupId = AFO.clientGroupId

		CROSS APPLY AFO.extendedProperties.nodes('App_FirewallExtendedProperties') ExtendedProps(props)

		WHERE topologyType IN (1,3)
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@uniqueScriptID, 'AddOutGoingRoutesToCGsInTopologiesExec', 'This script adds OutGoing DIRECT routes between client groups part of One-way, Two-way and Via-Proxy network topologies. One route in case of One-way and two in case of Two-way and Via-Proxy.', DATEDIFF(second,'01/01/1970',CURRENT_TIMESTAMP) , 16, 0, (16 + 1))

		COMMIT TRANSACTION

	END TRY

	BEGIN CATCH

		PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

		ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

		ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

		ERROR MESSAGE: ' + ERROR_MESSAGE() + '

		ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

		ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		PRINT 'Rolling back transaction'

		ROLLBACK TRANSACTION

	END CATCH

END
