

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/AddDIPSInformationInFirewallTable.script] ---------- 


SET QUOTED_IDENTIFIER ON

-----------------------------------------------------------------------------------------------------------------------------------------

--  Script  :   AddDIPSInformationInFirewallTable

--  Purpose :   This script inserts DIPS information into the table archPipelineFirewall table

-----------------------------------------------------------------------------------------------------------------------------------------

SET NOCOUNT ON

DECLARE @dipInfoExists INT = 0

DECLARE @uniqueScriptID uniqueidentifier = '4ADB0607-FFDB-49C6-A2C6-CFBD713D2EFB'

SELECT @dipInfoExists = 1 FROM GXUniqueSQLScriptExecTracking WITH(NOLOCK) WHERE SqlScriptGUID = @uniqueScriptID

IF @dipInfoExists = 0

BEGIN

    BEGIN TRY

        BEGIN TRANSACTION

		DECLARE @createdTime INTEGER = dbo.GetUnixTime(CURRENT_TIMESTAMP);

		-- Client to client DIPs
		INSERT INTO archPipelineFirewall


		SELECT srcClientId, srcInterface, destClientId, destInterface, @createdTime, 0, id

		FROM archPipeline

		WHERE srcGroupId=0 AND srcClientId<>0 AND destClientId<>0 AND isActive=1

		-- Client Group to client DIPs
		INSERT INTO archPipelineFirewall


		SELECT AC.Id, AC.net_hostname, APL.destClientId, APL.destInterface, @createdTime, 0, APL.id

		FROM archPipeline APL

		INNER JOIN APP_ClientGroupAssoc ACGA

		ON APL.srcGroupId=ACGA.clientGroupId

		INNER JOIN App_Client AC

		ON ACGA.clientId=AC.id

		WHERE APL.srcGroupId<>0 AND srcClientId=0 AND destClientId<>0 AND isActive=1
        INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


        VALUES (@uniqueScriptID

                , 'AddDIPSInformationInFirewallTableExec'

                , ' This script inserts DIPS information into the table archPipelineFirewall table'

                , DATEDIFF(second,'01/01/1970',CURRENT_TIMESTAMP) 

, 16

                , 0

, (16 + 1))

        COMMIT TRANSACTION

    END TRY

    BEGIN CATCH

        PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

        ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

        ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

        ERROR MESSAGE: ' + ERROR_MESSAGE() + '

        ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

        ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

        PRINT 'Rolling back transaction'

        ROLLBACK TRANSACTION

    END CATCH

END

SET NOCOUNT OFF

