

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/APP_WorkQueueRequest.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

------------------------------------------------------------------------

-- rcsid[]='@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/APP_WorkQueueRequest.script,v $ $Id: APP_WorkQueueRequest.script,v 1.2.12.9 2019/11/29 00:53:04 gstoops Exp $';

--TABLENAME APP_WorkQueueRequest

-- Delete CCS WorkQueueRequest that are not enabled for CCS Operations

DELETE wq

FROM APP_WorkQueueRequest wq		-- delete CCS workqueue rows for any of these clients that should not have CCS rows

	INNER JOIN (SELECT	-- get clients with CCS disabled

					c.id clientId

				FROM APP_Client c WITH(NOLOCK)

					INNER JOIN APP_ClientProp cp  WITH(NOLOCK) ON

						cp.componentNameId = c.id

						AND cp.attrName = N'CCS Enabled'

						AND cp.attrVal = N'0'

						AND cp.modified = 0

				UNION

				SELECT	-- get clients with CCS enabled and uninstalled / deleted

					c.id clientId

				FROM APP_Client c WITH(NOLOCK)

					INNER JOIN APP_ClientProp cp  WITH(NOLOCK) ON

						cp.componentNameId = c.id

						AND cp.attrName = N'CCS Enabled'

						AND cp.attrVal = N'1'

						AND cp.modified = 0

						AND (c.status & (2|4)) > 0		-- uninstalled / deleted

				UNION

				SELECT	-- get clients with CCS not set.  

						-- Note this works for pre SP12 Configured CCS Clients since it runs after APP_ClientProp.script

						-- that delete pre SP12 'CCS Enabled' property rows for clients configured.

					c.id clientId

				FROM

					APP_Client c WITH(NOLOCK)

					LEFT OUTER JOIN APP_ClientProp cp  WITH(NOLOCK) ON

						cp.componentNameId = c.id

						AND cp.attrName = N'CCS Enabled'

						AND cp.modified = 0

				WHERE 

					cp.id IS NULL		-- no row found

			) c ON

		c.clientId = wq.clientId

		AND wq.workToken IN (19, 49)		-- WORK_TOKEN_CCS_DB_UPDATE and WORK_TOKEN_CCS_DB_CHANGE_STATE CCS Tokens

-- Cleanup bGetClientPropOriginalMethod table and registry entires no longer needed

DECLARE @origEnabled	INT = NULL;

SELECT 

	@origEnabled = MAX(enabled)			-- ProdCS has 2 rows: one with INTEGER and the other with REG_DWORD data type so take the max setting of all rows

FROM APP_AdvanceSettings WITH(NOLOCK)

WHERE

	entityId = 2

	AND entityType = 3

	AND keyName = 'bGetClientPropOriginalMethod'

	AND relativePath = 'CommServe'

IF (@origEnabled IS NOT NULL)

BEGIN

	-- Table row exist, start cleanup operations

	IF (@origEnabled = 1)

	BEGIN

		DECLARE @nowTime2		INT =  DATEDIFF(second, '01/01/1970', GETUTCDATE())

		-- Disable in table and delete from registry when work query request executes

		UPDATE APP_AdvanceSettings

			SET enabled = 0

		WHERE

			entityId = 2

			AND entityType = 3

			AND keyName = 'bGetClientPropOriginalMethod'

			AND relativePath = 'CommServe'

			AND enabled = 1

		IF (@@ROWCOUNT > 0)

		BEGIN
			INSERT INTO APP_WorkQueueRequest([clientId],[remoteClient],[workToken],[workTokenParams],[createTime],[lastUpdateTime],[retryCount],[flag])


				VALUES (2, -1, 6, N'', @nowTime2, 0, 0, 0)

		END

	END

	ELSE	-- @origEnabled = 0

	BEGIN

		-- Delete row from table, no longer required

		DELETE FROM APP_AdvanceSettings

		WHERE

			entityId = 2

			AND entityType = 3

			AND keyName = 'bGetClientPropOriginalMethod'

			AND relativePath = 'CommServe'

			AND enabled = 0

	END

END

-- Cleanup WQs which are offline for 6 months or longer

BEGIN

	DECLARE @ageThreshold INT = dbo.getunixtime(DATEADD(MONTH, -6, GETUTCDATE()))--six months old

	DELETE FROM APP_WorkQueueRequest

    WHERE

		createTime > 0

		AND lastUpdateTime > 0

		AND createTime <= @ageThreshold

		AND lastUpdateTime <= @ageThreshold

END
