

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/APP_SMCreatePreCookedDashboards.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/APP_SMCreatePreCookedDashboards.script,v $ $Id: APP_SMCreatePreCookedDashboards.script,v 1.1.2.11.8.1 2021/02/09 07:19:04 mupadhyay Exp $";

GO

SET QUOTED_IDENTIFIER ON

GO

DECLARE @PreCookedDashboardsScriptExec INT = 0

SELECT

	@PreCookedDashboardsScriptExec = 1

FROM

	GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

	gp.SqlScriptGUID = 'E6412910-35D5-4D2C-BB50-D0D25F00DF05'

IF (@PreCookedDashboardsScriptExec = 0)		-- not done already, create the precooked dashboards for SM

BEGIN

	DECLARE @curUtcDateTime BIGINT

	DECLARE @dashboardId INT

	DECLARE @searchId INT

	DECLARE @DashBoardName NVARCHAR(30) = 'System Resources'

	DECLARE @browserURLField NVARCHAR(max)

	DECLARE @solrQueryField NVARCHAR(max)

	DECLARE @searchLabelField NVARCHAR(max)

	DECLARE @searchUrlXml xml

	SET @curUtcDateTime = datediff(second, '01/01/1970', GetUTCdate());

	DISABLE TRIGGER ALL on GXUniqueSQLScriptExecTracking

	DELETE FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = 'EAC1265B-F785-4FC1-97B5-0FFB35841D8F';

	ENABLE TRIGGER ALL on GXUniqueSQLScriptExecTracking

	DECLARE @dashBoardProp XML = CONVERT(XML, '<LogMonitoring_DashBoardProp isClientNavigation="1" clientNavigationApp="Resource Monitoring" />')

	--creating "system resources" dashboard 

	IF exists(SELECT 1 FROM LMDashBoard WITH (NOLOCK) WHERE dashBoardName = @DashBoardName AND monitoringAppType = 2 AND creatorUserId = 1)

		BEGIN

			SET @dashboardId = (SELECT TOP 1 dashBoardId FROM LMDashBoard WITH (NOLOCK) WHERE dashBoardName = @DashBoardName AND monitoringAppType = 2 AND creatorUserId = 1)

			UPDATE LMDashBoard set dashBoardProp = @dashBoardProp where dashBoardId = @dashboardId

			UPDATE LMDashBoard set status = 8 where dashBoardId = @dashboardId

		END

	ELSE

		BEGIN

			-- status = 8 indicates the pre created read only dashboard
			INSERT INTO LMDashBoard (dashBoardName,isPrivate,creatorUserId,status,created,modified,monitoringAppType,dashBoardProp)


				VALUES(@DashBoardName,1,1,8,@curUtcDateTime,0,2,@dashBoardProp)

			SET @dashboardId = @@IDENTITY

	END

	--creating searches

	SET @browserURLField = '?viewId=1&amp;TemplateName=%22Network%20Statistics%22&amp;fieldList=TemplateName&amp;keyWord=graphtype%20compare%20avg(bytesreceivedpersec)%2C%20avg(bytessentpersec)&amp;startTime=NOW-1DAYS&amp;endTime=NOW&amp;estimatedTimeDiff=86400000&amp;gap=1HOUR&amp;isAllTime=false&amp;dataView=tableView&amp;visibleCols=eventTime%2Ceventtime_sf%2Cinterfacename_lf%2Cbytesreceivedpersec_if%2Cbytessentpersec_if%2Cbandwidth_if%2Cpacketsreceivedpersec_if%2Cpacketssentpersec_if&amp;graphScale=spline'

	SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;fq=%28isLMDoc%3A2%29&amp;fq=%28TemplateName%3A%22Network+Statistics%22%29&amp;fq=%28eventTime:[NOW-1DAYS+TO+NOW}%29&amp;q=*%3A*&amp;sort=eventTime+desc'

	SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype compare avg(bytesreceivedpersec), avg(bytessentpersec)&lt;br&gt;&lt;b&gt;TemplateName:&lt;/b&gt;Network Statistics&lt;br&gt;&lt;b&gt;Start Time:&lt;/b&gt;NOW-1DAYS&lt;br&gt;&lt;b&gt;End Time:&lt;/b&gt;NOW&lt;br&gt;'

	SET @searchUrlXml = CONVERT(XML,'<LogMonitoring_SearchURLInfo orderId="3" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />')

	IF not exists (SELECT 1 FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Network Data Sent vs Received' AND monitoringAppType = 2 AND creatorUserId = 1)

		BEGIN
			INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified,monitoringAppType)


				VALUES('Network Data Sent vs Received',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime,2)

			SET @searchId = @@IDENTITY
			INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)


				VALUES(@dashboardId,@searchId)

		END

	ELSE

		BEGIN

			SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Network Data Sent vs Received' AND monitoringAppType = 2 AND creatorUserId = 1)

			UPDATE LMUserSearch set searchInfo = @searchUrlXml WHERE searchId = @searchId

			IF not exists(SELECT 1 FROM LMDashSearchAssoc WITH (NOLOCK) WHERE dashBoardId = @dashboardId AND searchId = @searchId)

				BEGIN
					INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)


						VALUES(@dashboardId,@searchId)

					update LMUserSearch

					set status =  status | 4

					where searchId = @searchId

				END

		END

	SET @browserURLField = '?viewId=1&amp;TemplateName=%22System%20Statistics%22&amp;fieldList=TemplateName&amp;keyWord=graphtype%20compare%20avg(cpuusage)%2C%20avg(freephysicalmemory)&amp;startTime=NOW-1DAYS&amp;endTime=NOW&amp;estimatedTimeDiff=86400000&amp;gap=1HOUR&amp;isAllTime=false&amp;dataView=tableView&amp;visibleCols=eventTime%2Ccpuusage_df%2Cphysicalmemorykb_if%2Cvirtualmemorykb_if%2Cevents_if%2Cmutexes_if%2Cserialno_sf%2Cregcode_sf%2Cfreephysicalmemory_if%2Cfreevirtualmemory_if&amp;graphScale=spline'

	SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;fq=%28isLMDoc%3A2%29&amp;fq=%28TemplateName%3A%22System+Statistics%22%29&amp;fq=%28eventTime:[NOW-1DAYS+TO+NOW}%29&amp;q=*%3A*&amp;sort=eventTime+desc'

	SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype compare avg(cpuusage), avg(freephysicalmemory)&lt;br&gt;&lt;b&gt;TemplateName:&lt;/b&gt;System Statistics&lt;br&gt;&lt;b&gt;Start Time:&lt;/b&gt;NOW-1DAYS&lt;br&gt;&lt;b&gt;End Time:&lt;/b&gt;NOW&lt;br&gt;'

	SET @searchUrlXml = CONVERT(XML,'<LogMonitoring_SearchURLInfo orderId="1" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />')

	IF not exists (SELECT 1 FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'CPU vs Memory' AND monitoringAppType = 2 AND creatorUserId = 1)

		BEGIN
			INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified,monitoringAppType)


				VALUES('CPU vs Memory',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime,2)

			SET @searchId = @@IDENTITY
			INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)


				VALUES(@dashboardId,@searchId)

		END

	ELSE

		BEGIN

			SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'CPU vs Memory' AND monitoringAppType = 2 AND creatorUserId = 1)

			UPDATE LMUserSearch set searchInfo = @searchUrlXml WHERE searchId = @searchId

			IF not exists(SELECT 1 FROM LMDashSearchAssoc WITH (NOLOCK) WHERE dashBoardId = @dashboardId AND searchId = @searchId)

				BEGIN
					INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)


						VALUES(@dashboardId,@searchId)

					update LMUserSearch

					set status =  status | 4

					where searchId = @searchId

				END

		END

	SET @browserURLField = '?viewId=1&amp;TemplateName=%22Disk%20IO%20Statistics%22&amp;fieldList=TemplateName&amp;keyWord=graphtype%20timechart%20avg(freebytespercent)%20by%20diskdevice&amp;startTime=NOW-1DAYS&amp;endTime=NOW&amp;estimatedTimeDiff=86400000&amp;gap=1HOUR&amp;isAllTime=false&amp;dataView=tableView&amp;visibleCols=eventTime%2Ctag_ss%2Cdiskdevice_lf%2Ceventtime_sf%2Cwritespersec_if%2Cwritebytespersec_if%2Creadspersec_if%2Creadbytespersec_if%2Cavgdiskwritequeuelength_if%2Cavgdiskreadqueuelength_if&amp;graphScale=spline'

	SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;fq=%28isLMDoc%3A2%29&amp;fq=%28TemplateName%3A%22Disk+IO+Statistics%22%29&amp;fq=%28eventTime:[NOW-1DAYS+TO+NOW}%29&amp;q=*%3A*&amp;sort=eventTime+desc'

	SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype timechart avg(freebytespercent) by diskdevice&lt;br&gt;&lt;b&gt;TemplateName:&lt;/b&gt;Disk IO Statistics&lt;br&gt;&lt;b&gt;Start Time:&lt;/b&gt;NOW-1DAYS&lt;br&gt;&lt;b&gt;End Time:&lt;/b&gt;NOW&lt;br&gt;'

	SET @searchUrlXml = CONVERT(XML,'<LogMonitoring_SearchURLInfo orderId="2" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />')

	IF not exists (SELECT 1 FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Disk Free Space' AND monitoringAppType = 2 AND creatorUserId = 1)

		BEGIN
			INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified,monitoringAppType)


				VALUES('Disk Free Space',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime,2)

			SET @searchId = @@IDENTITY
			INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)


				VALUES(@dashboardId,@searchId)

		END

	ELSE

		BEGIN

			SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Disk Free Space' AND monitoringAppType = 2 AND creatorUserId = 1)

			UPDATE LMUserSearch set searchInfo = @searchUrlXml WHERE searchId = @searchId

			IF not exists(SELECT 1 FROM LMDashSearchAssoc WITH (NOLOCK) WHERE dashBoardId = @dashboardId AND searchId = @searchId)

				BEGIN
					INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)


						VALUES(@dashboardId,@searchId)

					update LMUserSearch

					set status =  status | 4

					where searchId = @searchId

				END

		END

	SET @DashBoardName = 'Commvault Resource Usage'

	--creating "Commvault Resource Usage" dashboard 

	IF exists(SELECT 1 FROM LMDashBoard WITH (NOLOCK) WHERE dashBoardName = @DashBoardName AND monitoringAppType = 2 AND creatorUserId = 1)

		BEGIN

			SET @dashboardId = (SELECT TOP 1 dashBoardId FROM LMDashBoard WITH (NOLOCK) WHERE dashBoardName = @DashBoardName AND monitoringAppType = 2 AND creatorUserId = 1)

			UPDATE LMDashBoard set dashBoardProp = @dashBoardProp where dashBoardId = @dashboardId

			UPDATE LMDashBoard set status = 8 where dashBoardId = @dashboardId

		END

	ELSE

		BEGIN

			-- status = 8 indicates the read only dashboard
			INSERT INTO LMDashBoard (dashBoardName,isPrivate,creatorUserId,status,created,modified,monitoringAppType,dashBoardProp)


				VALUES(@DashBoardName,1,1,8,@curUtcDateTime,0,2,@dashBoardProp)

			SET @dashboardId = @@IDENTITY

	END		

	SET @browserURLField = '?viewId=1&amp;TemplateName=%22Processes%20Statistics%22&amp;processname_sf=%22QSDK.exe%22%2C%22EvMgrs.exe%22%2C%22cvd.exe%22%2C%22AppMgrSvc.exe%22%2C%22JobMgr.exe%22%2C%22MediaManager.exe%22%2C%22CVJavaService.exe%22%2C%22AuxCopyMgr.exe%22&amp;fieldList=TemplateName%2Cprocessname_sf&amp;keyWord=graphtype%20timechart%20avg(process_CPU)%20by%20processname&amp;startTime=NOW-1DAYS&amp;endTime=NOW&amp;estimatedTimeDiff=86400000&amp;gap=1HOUR&amp;isAllTime=false&amp;dataView=tableView&amp;visibleCols=eventTime%2Ceventtime_sf%2Ccpu_df%2Cprocessid_if%2Cthreads_if%2Chandles_if%2Cmemory_if%2Cwritecount_if%2Cwritesize_if%2Creadcount_if%2Creadsize_if%2Cprocessname_lf%2CMonitoringPolicyName&amp;graphScale=spline'

	SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;fq=%28isLMDoc%3A2%29&amp;fq=%28TemplateName%3A%22Processes+Statistics%22%29&amp;fq=%28processname_sf%3A%22QSDK.exe%22+OR+processname_sf%3A%22EvMgrs.exe%22+OR+processname_sf%3A%22cvd.exe%22+OR+processname_sf%3A%22AppMgrSvc.exe%22+OR+processname_sf%3A%22JobMgr.exe%22+OR+processname_sf%3A%22MediaManager.exe%22+OR+processname_sf%3A%22CVJavaService.exe%22+OR+processname_sf%3A%22AuxCopyMgr.exe%22%29&amp;fq=%28eventTime:[NOW-1DAYS+TO+NOW}%29&amp;q=*%3A*&amp;sort=eventTime+desc'

	SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype timechart avg(process_CPU) by processname&lt;br&gt;&lt;b&gt;TemplateName:&lt;/b&gt;Processes Statistics&lt;br&gt;&lt;b&gt;processname_sf:&lt;/b&gt;QSDK.exe,EvMgrs.exe,cvd.exe,AppMgrSvc.exe,JobMgr.exe,MediaManager.exe,CVJavaService.exe,AuxCopyMgr.exe&lt;br&gt;&lt;b&gt;Start Time:&lt;/b&gt;NOW-1DAYS&lt;br&gt;&lt;b&gt;End Time:&lt;/b&gt;NOW&lt;br&gt;'

	SET @searchUrlXml = CONVERT(XML,'<LogMonitoring_SearchURLInfo orderId="1" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />')

	IF not exists (SELECT 1 FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Commserve Process CPU Usage' AND monitoringAppType = 2 AND creatorUserId = 1)

		BEGIN
			INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified,monitoringAppType)


				VALUES('Commserve Process CPU Usage',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime,2)

			SET @searchId = @@IDENTITY
			INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)


				VALUES(@dashboardId,@searchId)

		END

	ELSE

		BEGIN

			SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Commserve Process CPU Usage' AND monitoringAppType = 2 AND creatorUserId = 1)

			UPDATE LMUserSearch set searchInfo = @searchUrlXml WHERE searchId = @searchId

			IF not exists(SELECT 1 FROM LMDashSearchAssoc WITH (NOLOCK) WHERE dashBoardId = @dashboardId AND searchId = @searchId)

				BEGIN
					INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)


						VALUES(@dashboardId,@searchId)

					update LMUserSearch

					set status =  status | 4

					where searchId = @searchId

				END

		END

	SET @browserURLField = '?viewId=1&amp;TemplateName=%22Processes%20Statistics%22&amp;processname_sf=%22QSDK.exe%22%2C%22EvMgrs.exe%22%2C%22cvd.exe%22%2C%22AppMgrSvc.exe%22%2C%22JobMgr.exe%22%2C%22MediaManager.exe%22%2C%22CVJavaService.exe%22%2C%22AuxCopyMgr.exe%22&amp;fieldList=TemplateName%2Cprocessname_sf&amp;keyWord=graphtype%20timechart%20avg(Memory)%20by%20processname&amp;startTime=NOW-1DAYS&amp;endTime=NOW&amp;estimatedTimeDiff=86400000&amp;gap=1HOUR&amp;isAllTime=false&amp;dataView=tableView&amp;visibleCols=eventTime%2CMonitoringPolicyName%2Ceventtime_sf%2Ccpu_df%2Cprocessid_if%2Cthreads_if%2Chandles_if%2Cmemory_if%2Cwritecount_if%2Cwritesize_if%2Creadcount_if%2Creadsize_if%2Cprocessname_lf&amp;graphScale=spline'

	SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;fq=%28isLMDoc%3A2%29&amp;fq=%28TemplateName%3A%22Processes+Statistics%22%29&amp;fq=%28processname_sf%3A%22QSDK.exe%22+OR+processname_sf%3A%22EvMgrs.exe%22+OR+processname_sf%3A%22cvd.exe%22+OR+processname_sf%3A%22AppMgrSvc.exe%22+OR+processname_sf%3A%22JobMgr.exe%22+OR+processname_sf%3A%22MediaManager.exe%22+OR+processname_sf%3A%22CVJavaService.exe%22+OR+processname_sf%3A%22AuxCopyMgr.exe%22%29&amp;fq=%28eventTime:[NOW-1DAYS+TO+NOW}%29&amp;q=*%3A*&amp;sort=eventTime+desc'

	SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype timechart avg(Memory) by processname&lt;br&gt;&lt;b&gt;TemplateName:&lt;/b&gt;Processes Statistics&lt;br&gt;&lt;b&gt;processname_sf:&lt;/b&gt;QSDK.exe,EvMgrs.exe,cvd.exe,AppMgrSvc.exe,JobMgr.exe,MediaManager.exe,CVJavaService.exe,AuxCopyMgr.exe&lt;br&gt;&lt;b&gt;Start Time:&lt;/b&gt;NOW-1DAYS&lt;br&gt;&lt;b&gt;End Time:&lt;/b&gt;NOW&lt;br&gt;'

	SET @searchUrlXml = CONVERT(XML,'<LogMonitoring_SearchURLInfo orderId="2" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />')

	IF not exists (SELECT 1 FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Commserve Process Memory Usage' AND monitoringAppType = 2 AND creatorUserId = 1)

		BEGIN
			INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified,monitoringAppType)


				VALUES('Commserve Process Memory Usage',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime,2)

			SET @searchId = @@IDENTITY
			INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)


				VALUES(@dashboardId,@searchId)

		END

	ELSE

		BEGIN

			SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Commserve Process Memory Usage' AND monitoringAppType = 2 AND creatorUserId = 1)

			UPDATE LMUserSearch set searchInfo = @searchUrlXml WHERE searchId = @searchId

			IF not exists(SELECT 1 FROM LMDashSearchAssoc WITH (NOLOCK) WHERE dashBoardId = @dashboardId AND searchId = @searchId)

				BEGIN
					INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)


						VALUES(@dashboardId,@searchId)

					update LMUserSearch

					set status =  status | 4

					where searchId = @searchId

				END

		END

	SET @browserURLField = '?viewId=1&amp;TemplateName=%22Processes%20Statistics%22&amp;processname_sf=%22cvd.exe%22%2C%22IndexingService.exe%22%2C%22CVMountd.exe%22%2C%22SIDB2.exe%22%2C%22CvMountd%22%2C%22AuxCopy.exe%22&amp;fieldList=TemplateName%2Cprocessname_sf&amp;keyWord=graphtype%20timechart%20avg(process_CPU)%20by%20processname&amp;startTime=NOW-1DAYS&amp;endTime=NOW&amp;estimatedTimeDiff=86400000&amp;gap=1HOUR&amp;isAllTime=false&amp;dataView=tableView&amp;visibleCols=eventTime%2Ctag_ss%2Ceventtime_sf%2Ccpu_df%2Cprocessid_if%2Cthreads_if%2Chandles_if%2Cmemory_if%2Cwritecount_if%2Cwritesize_if&amp;graphScale=spline'

	SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;fq=%28isLMDoc%3A2%29&amp;fq=%28TemplateName%3A%22Processes+Statistics%22%29&amp;fq=%28processname_sf%3A%22cvd.exe%22+OR+processname_sf%3A%22IndexingService.exe%22+OR+processname_sf%3A%22CVMountd.exe%22+OR+processname_sf%3A%22SIDB2.exe%22+OR+processname_sf%3A%22CvMountd%22+OR+processname_sf%3A%22AuxCopy.exe%22%29&amp;fq=%28eventTime:[NOW-1DAYS+TO+NOW}%29&amp;q=*%3A*&amp;sort=eventTime+desc'

	SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype timechart avg(process_CPU) by processname&lt;br&gt;&lt;b&gt;TemplateName:&lt;/b&gt;Processes Statistics&lt;br&gt;&lt;b&gt;processname_sf:&lt;/b&gt;cvd.exe,IndexingService.exe,CVMountd.exe,SIDB2.exe,CvMountd,AuxCopy.exe&lt;br&gt;&lt;b&gt;Start Time:&lt;/b&gt;NOW-1DAYS&lt;br&gt;&lt;b&gt;End Time:&lt;/b&gt;NOW&lt;br&gt;'

	SET @searchUrlXml = CONVERT(XML,'<LogMonitoring_SearchURLInfo orderId="3" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />')

	IF not exists (SELECT 1 FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Media Agent Process CPU Usage' AND monitoringAppType = 2 AND creatorUserId = 1)

		BEGIN
			INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified,monitoringAppType)


				VALUES('Media Agent Process CPU Usage',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime,2)

			SET @searchId = @@IDENTITY
			INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)


				VALUES(@dashboardId,@searchId)

		END

	ELSE

		BEGIN

			SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Media Agent Process CPU Usage' AND monitoringAppType = 2 AND creatorUserId = 1)

			UPDATE LMUserSearch set searchInfo = @searchUrlXml WHERE searchId = @searchId

			IF not exists(SELECT 1 FROM LMDashSearchAssoc WITH (NOLOCK) WHERE dashBoardId = @dashboardId AND searchId = @searchId)

				BEGIN
					INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)


						VALUES(@dashboardId,@searchId)

					update LMUserSearch

					set status =  status | 4

					where searchId = @searchId

				END

		END

	SET @browserURLField = '?viewId=1&amp;TemplateName=%22Processes%20Statistics%22&amp;processname_sf=%22cvd.exe%22%2C%22IndexingService.exe%22%2C%22CVMountd.exe%22%2C%22SIDB2.exe%22%2C%22CvMountd%22%2C%22AuxCopy.exe%22%2C%22cvd%22%2C%22Indexing%22&amp;fieldList=TemplateName%2Cprocessname_sf&amp;keyWord=graphtype%20timechart%20avg(Memory)%20by%20processname&amp;startTime=NOW-1DAYS&amp;endTime=NOW&amp;estimatedTimeDiff=86400000&amp;gap=1HOUR&amp;isAllTime=false&amp;dataView=tableView&amp;visibleCols=eventTime%2Ctag_ss%2Ceventtime_sf%2Ccpu_df%2Cprocessid_if%2Cthreads_if%2Chandles_if%2Cmemory_if%2Cwritecount_if%2Cwritesize_if&amp;graphScale=spline'

	SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;fq=%28isLMDoc%3A2%29&amp;fq=%28TemplateName%3A%22Processes+Statistics%22%29&amp;fq=%28processname_sf%3A%22cvd.exe%22+OR+processname_sf%3A%22IndexingService.exe%22+OR+processname_sf%3A%22CVMountd.exe%22+OR+processname_sf%3A%22SIDB2.exe%22+OR+processname_sf%3A%22CvMountd%22+OR+processname_sf%3A%22AuxCopy.exe%22+OR+processname_sf%3A%22cvd%22+OR+processname_sf%3A%22Indexing%22%29&amp;fq=%28eventTime:[NOW-1DAYS+TO+NOW}%29&amp;q=*%3A*&amp;sort=eventTime+desc'

	SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype timechart avg(Memory) by processname&lt;br&gt;&lt;b&gt;TemplateName:&lt;/b&gt;Processes Statistics&lt;br&gt;&lt;b&gt;processname_sf:&lt;/b&gt;cvd.exe,IndexingService.exe,CVMountd.exe,SIDB2.exe,CvMountd,AuxCopy.exe,cvd,Indexing&lt;br&gt;&lt;b&gt;Start Time:&lt;/b&gt;NOW-1DAYS&lt;br&gt;&lt;b&gt;End Time:&lt;/b&gt;NOW&lt;br&gt;'

	SET @searchUrlXml = CONVERT(XML,'<LogMonitoring_SearchURLInfo orderId="4" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />')

	IF not exists (SELECT 1 FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Media Agent Process Memory Usage' AND monitoringAppType = 2 AND creatorUserId = 1)

		BEGIN
			INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified,monitoringAppType)


				VALUES('Media Agent Process Memory Usage',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime,2)

			SET @searchId = @@IDENTITY
			INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)


				VALUES(@dashboardId,@searchId)

		END

	ELSE

		BEGIN

			SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Media Agent Process Memory Usage' AND monitoringAppType = 2 AND creatorUserId = 1)

			UPDATE LMUserSearch set searchInfo = @searchUrlXml WHERE searchId = @searchId

			IF not exists(SELECT 1 FROM LMDashSearchAssoc WITH (NOLOCK) WHERE dashBoardId = @dashboardId AND searchId = @searchId)

				BEGIN
					INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)


						VALUES(@dashboardId,@searchId)

					update LMUserSearch

					set status =  status | 4

					where searchId = @searchId

				END

		END

	SET @browserURLField = '?viewId=1&amp;TemplateName=%22Stream%20Statistics%22&amp;fieldList=TemplateName&amp;keyWord=graphtype%20compare%20avg(ida_read_throughput)%2C%20avg(ma_disk_write_throughput)&amp;startTime=NOW-1DAYS&amp;endTime=NOW&amp;estimatedTimeDiff=86400000&amp;gap=1HOUR&amp;isAllTime=false&amp;dataView=tableView&amp;visibleCols=eventTime%2Ctag_ss%2Ceventtime_sf%2Cjob_id_if%2Cpipeline_id_if%2Capp_type_if%2Cdata_type_if%2Cida_read_if%2Cida_read_size_if%2Cida_read_throughput_df&amp;graphScale=spline'

	SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;fq=%28isLMDoc%3A2%29&amp;fq=%28TemplateName%3A%22Stream+Statistics%22%29&amp;fq=%28eventTime:[NOW-1DAYS+TO+NOW}%29&amp;q=*%3A*&amp;sort=eventTime+desc'

	SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype compare avg(ida_read_throughput), avg(ma_disk_write_throughput)&lt;br&gt;&lt;b&gt;TemplateName:&lt;/b&gt;Stream Statistics&lt;br&gt;&lt;b&gt;Start Time:&lt;/b&gt;NOW-1DAYS&lt;br&gt;&lt;b&gt;End Time:&lt;/b&gt;NOW&lt;br&gt;'

	SET @searchUrlXml = CONVERT(XML,'<LogMonitoring_SearchURLInfo orderId="5" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />')

	IF not exists (SELECT 1 FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Agent DIsk Read vs Media Agent Disk Write' AND monitoringAppType = 2 AND creatorUserId = 1)

		BEGIN
			INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified,monitoringAppType)


				VALUES('Agent DIsk Read vs Media Agent Disk Write',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime,2)

			SET @searchId = @@IDENTITY
			INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)


				VALUES(@dashboardId,@searchId)

		END

	ELSE

		BEGIN

			SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Agent DIsk Read vs Media Agent Disk Write' AND monitoringAppType = 2 AND creatorUserId = 1)

			UPDATE LMUserSearch set searchInfo = @searchUrlXml WHERE searchId = @searchId

			IF not exists(SELECT 1 FROM LMDashSearchAssoc WITH (NOLOCK) WHERE dashBoardId = @dashboardId AND searchId = @searchId)

				BEGIN
					INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)


						VALUES(@dashboardId,@searchId)

					update LMUserSearch

					set status =  status | 4

					where searchId = @searchId

				END

		END

	SET @browserURLField = '?viewId=1&amp;TemplateName=%22Stream%20Writer%20Statistics%22%2C%22Stream%20Reader%20Statistics%22&amp;fieldList=TemplateName&amp;keyWord=select%20eventTime%2C%20totalbytesreceived%2C%20totalbytessent&amp;startTime=NOW-1DAYS&amp;endTime=NOW&amp;estimatedTimeDiff=86400000&amp;gap=1HOUR&amp;isAllTime=false&amp;dataView=tableView&amp;graphScale=linear'

	SET @solrQueryField = ''

	SET @searchLabelField = ''

	SET @searchUrlXml = CONVERT(XML,'<LogMonitoring_SearchURLInfo orderId="6" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />')

	IF not exists (SELECT 1 FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Media Agent Data Transferred' AND monitoringAppType = 2 AND creatorUserId = 1)

		BEGIN
			INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified,monitoringAppType)


				VALUES('Media Agent Data Transferred',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime,2)

			SET @searchId = @@IDENTITY
			INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)


				VALUES(@dashboardId,@searchId)

		END

	ELSE

		BEGIN 

			SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Media Agent Data Transferred' AND monitoringAppType = 2 AND creatorUserId = 1)

			UPDATE LMUserSearch set searchInfo = @searchUrlXml WHERE searchId = @searchId

			IF not exists(SELECT 1 FROM LMDashSearchAssoc WITH (NOLOCK) WHERE dashBoardId = @dashboardId AND searchId = @searchId)

				BEGIN
					INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)


						VALUES(@dashboardId,@searchId)

					update LMUserSearch

					set status =  status | 4

					where searchId = @searchId

				END

		END

	IF EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE Name = 'PreCookedDashboardsScriptExec')

	BEGIN

		UPDATE GXUniqueSQLScriptExecTracking SET SqlScriptGUID = 'EAC1265B-F785-4FC1-97B5-0FFB35841D8F' WHERE Name = 'PreCookedDashboardsScriptExec'

	END

	ELSE

	BEGIN
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('E6412910-35D5-4D2C-BB50-D0D25F00DF05', 'PreCookedDashboardsScriptExec', 'Create pre cooked dashboards and searches for SM', @curUtcDateTime, 16, 0 , (16 + 1))

	END

END

SET NOCOUNT OFF

GO

SET QUOTED_IDENTIFIER ON

GO

