

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/APP_SCGScope.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/APP_SCGScope.script,v $ $Id: APP_SCGScope.script,v 1.1.2.12 2019/11/12 19:32:12 abilbrey Exp $";
-- TABLENAME APP_SCGScope

print '... inserting Table: APP_SCGScope'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME APP_SCGScope

SET NOCOUNT ON

SET QUOTED_IDENTIFIER ON

GO

DECLARE @nowTime	INT =  DATEDIFF(second, '01/01/1970', GETUTCDATE())

DECLARE @newLine    NVARCHAR(3) = NCHAR(13) -- + CHAR(10)

-- Never change the below GUID!

DECLARE @CGScopeGuid    VARCHAR(40) = 'E11B34A7-9782-44DD-8515-4189A8CFFDB4'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @CGScopeGuid)

BEGIN

	-- Clear table

	TRUNCATE TABLE APP_SCGScope

	-- Set SCG Scope to current owner of client group as the initial setting during Database Upgrade

	-- No longer computing higher scope level base on owner rights.
	INSERT INTO APP_SCGScope (scgRuleId, entityType, entityId)


		SELECT

			r.id scgRuleId,

			13 entityType,		-- USER_ENTITY

			cg.userId

		FROM APP_ClientGroup cg WITH(NOLOCK)

			INNER JOIN APP_SCGRule r WITH(NOLOCK) ON

				r.scgId = cg.id
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@CGScopeGuid, 'SetSCGOwnerAsScopeLevel', 'Copying the client group owner to scope level as initial setting', @nowTime,  16, 0, (16 + 2))

END

-- Issue introduce, AppSCGRefreshRecur.sp, when a customer Db had a deleted user and still the owner of an SCG, older code over the years updated due to security changes

-- and the clients associated to the SCG were NOT removed as intended while the new functionality for scope unknowingly corrected the issue and removed

-- the clients for this SCG.  Amey want to maintain existing existing functionality of the customer SCG so code was added to check if the user

-- was deleted and NOT to remove the clients from the SCG.  User Group Hidden Users do not have the valid user flag ON so clients are not being deleted 

-- from SCGs now, making the new code uncompatible with the older code for using user security to make client associations.

-- The code below corrects the above run once code block to change User Group Hidden Users to their associated User Group for Scope Level.

DECLARE @SetGroupScopeGuid    VARCHAR(40) = '4EDBA110-14E9-4CBD-8C70-26C71331E0D5'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @SetGroupScopeGuid)

BEGIN

	IF OBJECT_ID('TempDb..#Scope') IS NOT NULL

		DROP TABLE #Scope

	CREATE TABLE #Scope (

		scopeId		INT,

		entityType	INT,		-- 13 USER_ENTITY -> change to 15 USERGROUP_ENTITY

		userId		INT,		-- dummy group user id with 2048 USERS_CREATE_AS_PER_USERGROUP flag set

		groupId		INT

	)

	-- Find Scope rows where User Entity is assigned but user is a dummy user group user assigned
	INSERT INTO #Scope (scopeId, entityType, userId, groupId)


		SELECT

			ss.scgRuleId,

			ss.entityType,

			ss.entityId,

			ug.groupId

		FROM APP_SCGScope ss WITH(NOLOCK)

			INNER JOIN UMUsers du WITH(NOLOCK) ON	-- find dummy / hidden user group users

				ss.entityType = 13					-- USER_ENTITY

				AND du.id = ss.entityId

				AND (du.flags & 2048) = 2048		-- USERS_CREATE_AS_PER_USERGROUP

			INNER JOIN (

						SELECT

							ug.userId,

							ug.groupId,

							CASE

								WHEN p.id IS NULL THEN g.name   

								ELSE p.domainName + '\' + g.name            -- in somecases need to prefix domain name

							END name                                        -- require name since error were hidden user can be mapped to multiple groups

						FROM UMUserGroup ug WITH(NOLOCK)

							INNER JOIN UMGroups g WITH(NOLOCK) ON

								g.id = ug.groupId

							LEFT OUTER JOIN UMDSProviders p WITH(NOLOCK) ON

								p.id = g.umdsProviderId

								AND g.umdsProviderId > 0

					) ug ON

						ug.userId = du.id

						AND ug.name = du.login      -- make sure user and group name match to eliminate multiple groups mapped.

	-- Change these Scope Rows to User Group Entities and the associated groupId

	UPDATE ss

		SET entityType = 15,		-- USERGROUP_ENTITY

			entityId = s.groupId

	FROM APP_SCGScope ss

		INNER JOIN #Scope s ON

			s.scopeId = ss.scgRuleId
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@SetGroupScopeGuid, 'SetSCGUserGroupScope', 'Changing SCG Scope level from User Group User to User Group', @nowTime,  16, 0, (16 + 2))

END

