

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/APP_ResourcePool.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 2016  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/APP_ResourcePool.script,v $ $Id: APP_ResourcePool.script,v 1.1.2.5 2020/10/04 00:56:47 abilbrey Exp $";

GO

SET QUOTED_IDENTIFIER ON

GO

DECLARE @MMInfraToAppResourcePoolMigrationGuidOld uniqueidentifier = '550BEB24-C199-4024-9A82-FFE2A83655D2'

DECLARE @MMInfraToAppResourcePoolMigrationGuidNew uniqueidentifier = 'A3F3B5F8-B86D-4E62-885C-FC6230ADBF9C'

DECLARE @MMInfraToAppResourcePoolMigrationGuidSP17 uniqueidentifier = '591EFEAE-34D0-428B-BD36-F6A9E7805967'

DECLARE @ExchangeAppType INT = 1

DECLARE @MigratedPoolTag NVARCHAR(MAX) = 'Migrated ResourcePool'

-- Handle previously migrated resource pools

-- IF EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @MMInfraToAppResourcePoolMigrationGuidOld)

-- BEGIN

-- -- No need to check new GUID here as with the new GUIDs there should be now entries with appType as zero

-- UPDATE APP_ResourcePool

-- SET appType = @ExchangeAppType , resourcePoolName = resourcePoolName + ' ' + @MigratedPoolTag

-- WHERE appType = 0

-- END

-- ELSE IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @MMInfraToAppResourcePoolMigrationGuidNew)

-- BEGIN

-- INSERT INTO APP_ResourcePool

-- SELECT 	AG.name  + ' ' + 	@MigratedPoolTag AS resourcePoolName,

		-- IP.infrastructurePoolId AS storagePoolId,

		-- IP.accessNodesGroupId AS accessNodesGroupId,

		-- IP.indexServerClientId AS indexServerClientId,

		-- IP.createdTime AS created,

		-- IP.modifiedTime AS modified,

		-- IP.flags AS flags,

		-- @ExchangeAppType AS appType,

		-- IP.extendedProp AS extendedProps

		-- FROM MMInfrastructurePool IP INNER JOIN archGroup AG ON IP.infrastructurePoolId = AG.id INNER JOIN APP_ClientGroup CG ON IP.accessNodesGroupId = CG.id

		-- WHERE NOT EXISTS (SELECT 1 from APP_ResourcePool WHERE appType = @ExchangeAppType AND storagePoolId = IP.infrastructurePoolId)

-- INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)

-- VALUES (@MMInfraToAppResourcePoolMigrationGuidNew, 'MigrateMMInfraToResourcePool', 'Update script to migrate MMIInfrastructurePool to APP_ResourcePool', DATEDIFF(second, '01/01/1970', GETUTCDATE()), 16, 0, (16 + 2))

-- END

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @MMInfraToAppResourcePoolMigrationGuidSP17)

BEGIN

-- First update any entries created in SP16 upgrade.

-- Since workflows in SP16 still use old table, its possible that post upgrade some entries were modified

-- Ensure we update the entries correctly.

UPDATE APP_ResourcePool 

SET accessNodesGroupId = IP.accessNodesGroupId,

	indexServerClientId = IP.indexServerClientId,

	created = IP.createdTime,

	modified = IP.modifiedTime,

	flags = IP.flags,

	extendedProps = IP.extendedProp 

	FROM 

	APP_ResourcePool RP INNER JOIN MMInfrastructurePool IP ON RP.storagePoolId = IP.infrastructurePoolId

	WHERE (IP.createdTime > RP.created) OR (IP.modifiedTime > RP.created) OR (IP.modifiedTime >  RP.modified)

	AND EXISTS (SELECT 1 FROM APP_Client WHERE id = IP.indexServerClientId)

-- Secondly migrate any new entries created that we did not already migrate
INSERT INTO APP_ResourcePool


SELECT 	AG.name  + ' ' + 	@MigratedPoolTag AS resourcePoolName,

		IP.infrastructurePoolId AS storagePoolId,

		IP.accessNodesGroupId AS accessNodesGroupId,

		IP.indexServerClientId AS indexServerClientId,

		IP.createdTime AS created,

		IP.modifiedTime AS modified,

		IP.flags AS flags,

		@ExchangeAppType AS appType,

		IP.extendedProp AS extendedProps

		FROM MMInfrastructurePool IP INNER JOIN archGroup AG ON IP.infrastructurePoolId = AG.id INNER JOIN APP_ClientGroup CG ON IP.accessNodesGroupId = CG.id

		WHERE NOT EXISTS (SELECT 1 from APP_ResourcePool WHERE appType = @ExchangeAppType AND storagePoolId = IP.infrastructurePoolId)

		AND EXISTS (SELECT 1 FROM APP_Client WHERE id = IP.indexServerClientId)
INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@MMInfraToAppResourcePoolMigrationGuidSP17, 'MigrateMMInfraToResourcePool', 'Update script to migrate SP17 MMIInfrastructurePool to APP_ResourcePool', DATEDIFF(second, '01/01/1970', GETUTCDATE()), 16, 0, (16 + 2))

END

GO

SET QUOTED_IDENTIFIER ON

GO
