

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/APP_ReportsMigrate.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/APP_ReportsMigrate.script,v $ $Id: APP_ReportsMigrate.script,v 1.5.2.13.14.2 2021/02/17 03:43:05 csunderland Exp $";

--TABLENAME APP_Reports

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @revision nvarchar(255)

SET @revision = '$Revision: 1.5.2.13.14.2 $'

DECLARE @migratedReports TABLE (reportId int)
INSERT INTO @migratedReports


SELECT MAX(ID)

FROM CustomReports

WHERE EntityLabel NOT IN (SELECT name FROM APP_Reports)

AND EntityLabel NOT IN (SELECT userReportId FROM APP_Reports)

AND ID NOT IN (SELECT referenceId FROM APP_Reports)

AND ID NOT IN (SELECT reportId FROM APP_Reports)

AND CAST(GUID AS nvarchar(256)) NOT IN (Select guid From APP_Reports)

AND EntityLabel IS NOT NULL

GROUP BY EntityLabel
SET IDENTITY_INSERT dbo.APP_Reports ON;

INSERT INTO APP_Reports(reportId, name, description, definition, version, deployedVersion, createTime, modifiedTime, userId, guid, revision, flags, engineVersion, referenceId, icon, source, userReportId) 


SELECT	ID,

		EntityLabel, 

		ISNULL(Options, ''), 

		'', 

		1, 

		1,

		@nowTime, 

		@nowTime, 

		1, 

		CASE WHEN GUID IS NULL THEN NEWID() ELSE GUID END, 

		CASE WHEN (Version IS NULL OR LEN(Version) = 0) THEN @revision ELSE Version END, 

		0,

		0, 

		ID,

		NULL,

		0,

		EntityLabel

FROM CustomReports

WHERE ID IN (SELECT reportId FROM @migratedReports)

UPDATE APP_Reports

SET revision = @revision

WHERE revision IS NULL OR revision = ''
SET IDENTITY_INSERT dbo.APP_Reports OFF;


Delete From APP_Reports Where guid in ('8E11B909-AC5C-4114-90B5-FC30C034188D', '7C658447-17A5-4475-A463-7D3B2AFEC89A') AND LEN(Cast(definition As nvarchar(max))) = 0
INSERT INTO APP_ReportsHistory (reportId, definition, version, deployed, createTime, userId, engineVersion)


SELECT reportId, definition, version, 1, @nowTime, 1, 0

FROM APP_Reports

WHERE reportId IN (Select reportId FROM APP_Reports WHERE referenceId IN (SELECT reportId FROM @migratedReports))

IF NOT EXISTS( SELECT 1 FROM App_Client WHERE id = 2)

BEGIN   

    DELETE FROM APP_Reports Where name = 'Backup Success Trending'

	DELETE FROM APP_Reports Where name = 'Last 24 Hours Backup Job Statistics'

	DELETE FROM APP_Reports Where name = 'Last 7 days backup job statistics'

	DELETE FROM APP_Reports Where name = 'Virtual Machine Protection in Last 30 Days'	

END

--remove all v10 report definitions so they do not come back in case customer deletes the v11 version of the report

Delete From CustomReports Where ID not in (Select referenceId From APP_Reports where LEN(Cast(definition As nvarchar(max))) = 0 AND referenceId > 0)

IF EXISTS (select * from APP_Reports where name = 'Last 24 hours backup job statistics') AND NOT EXISTS (select * from APP_Reports where name = 'Last 7 days backup job statistics')

BEGIN

	UPDATE APP_Reports

	Set name = 'Last 7 days backup job statistics',

		definition = REPLACE(cast(definition as nvarchar(max)), 'Last 24 hours backup job statistics', 'Last 7 days backup job statistics')

	Where name = 'Last 24 hours backup job statistics'

END

IF EXISTS (select * from APP_Reports where name = 'Dashboard' AND guid = 'd3c59c36-9d8b-4228-9a5d-311804a45ff1')

BEGIN

	delete from APP_Reports where name = 'Dashboard' AND guid = 'd3c59c36-9d8b-4228-9a5d-311804a45ff1'	

END

UPDATE APP_DataSet Set guid = '366be804-9682-4025-93ed-be4abf79d39d' WHERE name = 'Data Set Manager\Page0\DataSetManager' AND guid = 'e4e45625-80c0-4589-ba33-d1e4cba4af95'

IF EXISTS(SELECT 1 FROM APP_Reports WHERE tileType in (1, 2))

BEGIN

	DELETE FROM APP_DataSet WHERE reportId IN (SELECT reportId FROM APP_Reports WHERE tileType IN (1, 2))

	DELETE FROM APP_Reports WHERE tileType in (1, 2)

END

delete from App_reports where type = 2 and name = 'Custom Dashboard'  and version = 1 and deployedVersion = 1

Update APP_Reports Set deployedVersion = version Where [type] = 3

Update h 

Set h.deployed = 1 

From APP_ReportsHistory h

INNER JOIN APP_Reports r ON h.reportId = r.reportId AND h.version = r.version

Where r.[type] = 3

