

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/APP_QuickRunTools.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/APP_QuickRunTools.script,v $ $Id: APP_QuickRunTools.script,v 1.7.12.4 2020/10/04 00:58:25 abilbrey Exp $";

--TABLENAME APP_QuickRunTools

GO

SET QUOTED_IDENTIFIER ON

GO

SET NOCOUNT ON

DECLARE @toolId INTEGER = 0

--***************************************************

--For Remote Desktop Connection (Tool Added in 10.0)

--***************************************************

IF NOT EXISTS (SELECT * FROM APP_QuickRunTools WHERE aliasName LIKE N'Remote Desktop Connection' AND isPublic = 1)

BEGIN
	INSERT INTO APP_QuickRunTools VALUES (1,N'<App_ToolInfo aliasName="Remote Desktop Connection" alwaysAskForCredentials="0" description="" enabled="1" executablename="mstsc" osType="1" showOutputOnCommcellConsole="0" startupPath="" toolParameters="-v:$%CLIENT_NET_HOSTNAME%$" visibility="1" whereToRunTool="0">


         <associatedEntityTypes val="1" />

         <associatedEntityTypes val="3" />

        <associatedEntityTypes val="11" />

        <toolSecurity associatedUserGroupsOperationType="1">

          <associatedUserGroups userGroupId="1" userGroupName="master" />

          <associatedUserGroups userGroupId="3" userGroupName="View All" />

        </toolSecurity>

		 <securityAssociations associationsOperationType="1">

			<associations>

				<userOrGroup _type_="15" clientSidePackage="1" consumeLicense="1" srmReportSet="0" srmReportType="0" type="0" userGroupId="1" userGroupName="master" />

			</associations>

			<associations>

				<userOrGroup _type_="15" clientSidePackage="1" consumeLicense="1" srmReportSet="0" srmReportType="0" type="0" userGroupId="3" userGroupName="View All" />

			</associations>

		</securityAssociations>

        <userImpersonation />

      </App_ToolInfo>',N'Remote Desktop Connection',1)

	 SET @toolId = ISNULL((SELECT id FROM APP_QuickRunTools WHERE aliasName LIKE N'Remote Desktop Connection' AND isPublic = 1),0)

     IF @toolId <> 0

      BEGIN

      DELETE FROM APP_QuickRunToolAssoc WHERE toolId = @toolId
      INSERT INTO APP_QuickRunToolAssoc VALUES(@toolId,1,0)

      INSERT INTO APP_QuickRunToolAssoc VALUES(@toolId,3,0)


	  END

END

--*******************************************************

--For CreateProxy for Content Store (Tool Added in 11.0)

--*******************************************************

declare @s_aliasName nvarchar(512) = 'Create Proxy for Content Store'

declare @xml_commandInfo XML = '<App_ToolInfo aliasName="Create Proxy for Content Store" alwaysAskForCredentials="1" description="" 

                                    enabled="1" executablename="ConfigureProxyContentStore.exe" 

                                    executeImmediately="0" osType="1" showOutputOnCommcellConsole="1" startupPath="" 

                                    toolParameters="" toolType="0" visibility="0" whereToRunTool="2">

                                    <associatedEntityTypes val="1" />

                                    <associatedEntityTypes val="3" />

                                    <associatedEntityTypes val="11" />

                                    <userImpersonation />

                                 </App_ToolInfo>'

IF NOT EXISTS (SELECT * FROM APP_QuickRunTools WHERE aliasName LIKE @s_aliasName AND isPublic = 1)

BEGIN
     INSERT INTO APP_QuickRunTools(userId,commandInfo,aliasName,isPublic) 


           VALUES (1,@xml_commandInfo,@s_aliasName,1)

     SET @toolId  = ISNULL((SELECT id FROM APP_QuickRunTools WHERE aliasName LIKE @s_aliasName AND isPublic = 1),0)

     IF @toolId <> 0

      BEGIN

          DELETE FROM APP_QuickRunToolAssoc WHERE toolId = @toolId
          INSERT INTO APP_QuickRunToolAssoc VALUES(@toolId,1,0)

          INSERT INTO APP_QuickRunToolAssoc VALUES(@toolId,3,0)


      END

END

DECLARE @upgradeFromRelease INTEGER = 0

IF EXISTS (SELECT 1 FROM sysobjects WHERE id = OBJECT_ID(N'[dbo].[DBUpgradeSteps]') and OBJECTPROPERTY(id, N'IsTable') = 1)

BEGIN

    SELECT @upgradeFromRelease = CAST(Status AS INTEGER)

    FROM   DBUpgradeSteps

    WHERE  Step = 'UpgradeFromRelease'

END

IF ((@upgradeFromRelease < 16) AND (@upgradeFromRelease > 0) AND NOT Exists(SELECT 1 FROM GXGlobalParam WHERE name = 'APP_QuickRunToolsV11'))

BEGIN

	DECLARE @nowTime INT = DATEDIFF(second, '01/01/1970', GetUTCdate())

	IF EXISTS(SELECT 1 FROM APP_QuickRunTools WHERE isPublic = 1)

	BEGIN

		DECLARE @toolAssociations TABLE

		(

			toolId INTEGER,

			userGroupId INTEGER

		)

		DECLARE @toolAssociationsXml TABLE

		(

			toolId INTEGER,

			associations XML

		)
		INSERT INTO @toolAssociations


			SELECT ToolAssoc.toolId,

				   ToolAssoc.userGroupId

				FROM APP_QuickRunToolAssoc ToolAssoc INNER JOIN APP_QuickRunTools Tools

					ON ToolAssoc.toolId = Tools.id

				WHERE Tools.isPublic = 1
		INSERT INTO @toolAssociationsXml


			SELECT toolId, ISNULL((SELECT 15 AS 'userOrGroup/@_type_',

									1 AS 'userOrGroup/@clientSidePackage',

									1 AS 'userOrGroup/@consumeLicense',

									0 AS 'userOrGroup/@srmReportType',

									G.id as 'userOrGroup/@userGroupId',

									G.name as 'userOrGroup/@userGroupName'

										FROM @toolAssociations A INNER JOIN UMGroups G

											ON A.userGroupId = G.id

												WHERE A.toolId = B.toolId

										FOR XML PATH ('associations')),'')

				FROM @toolAssociations B Group By B.toolId

		UPDATE APP_QuickRunTools SET commandInfo.modify('

											insert <securityAssociations associationsOperationType="1">

													</securityAssociations>

													after (/App_ToolInfo/toolSecurity)[1]')

		UPDATE APP_QuickRunTools SET commandInfo.modify('

											insert sql:column("ToolAssoc.associations") 

												into (/App_ToolInfo/securityAssociations)[1]')

											FROM APP_QuickRunTools Tools inner join @toolAssociationsXml ToolAssoc on Tools.id = ToolAssoc.toolId

	END
	INSERT INTO GXGlobalParam VALUES ('APP_QuickRunToolsV11', 1, @nowTime, 0)


END

GO

SET NOCOUNT OFF

GO

SET QUOTED_IDENTIFIER ON

GO

