

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/APP_PlanBackupCopyUpgrade.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 2016  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

GO

SET QUOTED_IDENTIFIER ON

GO

	DECLARE @errCode INTEGER

	DECLARE @errStr varchar(1024)

	DECLARE @pid INT = 0

	DECLARE @pType INT = 0

	DECLARE @atType INT = 0

	DECLARE @taskid INT = 0

	DECLARE @subTaskId INT = 0

	DECLARE @currentTime INT = DATEDIFF(second, '01/01/1970', GETDATE())

    DECLARE @backupCopyPlanUpgrade uniqueidentifier = '4CD9CACA-06C1-4E3D-A1C8-A1B4123C632F'    

	IF NOT EXISTS(SELECT 1 FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = @backupCopyPlanUpgrade)

	BEGIN

		DECLARE @IsTranStarted INT = 0

		IF OBJECT_ID('tempdb.dbo.#Plan_Storage_Rule') IS NOT NULL

			DROP TABLE #Plan_Storage_Rule

		CREATE TABLE #Plan_Storage_Rule

		(

			planId INT,

			storagePolicyId INT , 

			ruleId INT, 

			rank INT

		)

		CREATE CLUSTERED INDEX #Plan_Storage_Rule_planId_storagePolicyId on #Plan_Storage_Rule (planId,storagePolicyId)

		IF OBJECT_ID('tempdb.dbo.#SPBackupCopyPattern') IS NOT NULL

				DROP TABLE #SPBackupCopyPattern

		CREATE TABLE #SPBackupCopyPattern

		(

			planId INT,

			storagePolicyId INT,

			rank INT,

			subTaskId INT,

			taskId INT,

			patternId INT,

			rpoMinutes INT,

		)

		CREATE CLUSTERED INDEX #SPBackupCopyPattern_planId_storagePolicyId_subTaskId on #SPBackupCopyPattern (planId,storagePolicyId,subTaskId)

		IF OBJECT_ID('tempdb.dbo.#planMaxRPOSched') IS NOT NULL

				DROP TABLE #planMaxRPOSched

		CREATE TABLE #planMaxRPOSched

		(

			planId INT PRIMARY KEY,

			taskId INT,

			rpoMinutes INT

		)

		IF OBJECT_ID('tempdb.dbo.#planMaxRPO') IS NOT NULL

				DROP TABLE #planMaxRPO

		CREATE TABLE #planMaxRPO

		(

			planId INT,

			maxRPO INT,

			pCnt INT

		)

		CREATE CLUSTERED INDEX #planMaxRPO_planId_maxRPO on #planMaxRPO (planId,maxRPO)

		/* Logic is as below:

			1. Get all Server plans which are to be upgraded (ones which don't have backup copy schedule policy yet)

			2. Get all storage policies of a plan and their associated backup copy schedules and patterns.

			3. From all the schedules find the MAX RPO for each plan.

			4. If all the storage policies in the plan have same RPO as MAX then disable all the schedules.

			5. Convert one RPO schedule from above to a schedule policy and associate the remaining storage policies to that policy.

			6. Add plan properties for front end usage.

		*/

	BEGIN TRY
		INSERT INTO #Plan_Storage_Rule


		(

			planId ,

			storagePolicyId, 

			rank 

		)

		SELECT DISTINCT P.id, CAST(PP.attrVal AS INT), 1

			FROM APP_Plan P

INNER JOIN APP_PlanProp PP WITH(NOLOCK) ON P.id = PP.componentNameId AND PP.attrName = 'Storage policy'

LEFT JOIN APP_PlanProp PP1 WITH(NOLOCK) ON P.id = PP1.componentNameId AND PP1.attrName = 'Backup copy schedule policy'

WHERE P.subType = 33554437

				AND PP1.attrVal IS NULL 

AND (P.flag & 0x00004) = 0

AND (P.flag & 0x40000000) = 0

				AND (P.flag != 2)

		UNION

		SELECT DISTINCT PO.planId, APR.storagePolicyId, PO.rank

		FROM

		(

		   SELECT  T.planId, ref.value('(rule/@ruleId)[1]', 'INT') as ruleId,ref.value('@rank', 'INT') as rank

		   FROM(

					SELECT P.id AS planId, CAST(PP.attrVal AS XML) AS xmlValue

					   FROM App_Plan P

INNER JOIN APP_PlanProp PP WITH(NOLOCK) ON PP.componentNameId = P.id AND PP.attrName = 'Storage Rules'

LEFT JOIN APP_PlanProp PP1 WITH(NOLOCK) ON P.id = PP1.componentNameId AND PP1.attrName = 'Backup copy schedule policy'

WHERE P.subType = 33554437

					   AND PP1.attrVal IS NULL 

AND (P.flag & 0x00004) = 0

AND (P.flag & 0x40000000) = 0

					   AND (P.flag != 2)

				) T

				CROSS APPLY T.xmlValue.nodes('Api_PlanRuleMaps/rules') r(ref)

		)PO

		INNER JOIN APP_PlanRule APR WITH(NOLOCK) ON APR.ruleId = PO.ruleId

		--Get Patterns of all the backup copy schedules on the storage policies
		INSERT INTO #SPBackupCopyPattern(planId,storagePolicyId,rank,subTaskId,taskId,patternId,rpoMinutes)


		SELECT PSR.planId,PSR.storagePolicyId,PSR.rank,ST.subtaskId,ST.taskId,P.patternId,

		CASE P.freq_type

			WHEN 4   THEN P.freq_interval * 24 * 60

			WHEN 8  THEN P.freq_recurrence_factor * 24 * 60 * 7

			WHEN 16  THEN P.freq_recurrence_factor * 24 * 60 * 30

			WHEN 32  THEN P.freq_recurrence_factor * 24 * 60 * 30

			WHEN 64 THEN P.freq_recurrence_factor * 24 * 60 * 365

			WHEN 128 THEN P.freq_recurrence_factor * 24 * 60 * 365

			WHEN 4096 THEN P.freq_interval

			ELSE 0 END

		FROM #Plan_Storage_Rule PSR

		INNER JOIN TM_AssocEntity AE WITH(NOLOCK) ON PSR.storagePolicyId = AE.policyId

INNER JOIN TM_Subtask ST WITH(NOLOCK) ON ST.taskId = AE.taskId AND ST.operationType = 4028

INNER JOIN TM_Task T WITH(NOLOCK) ON T.taskId = ST.taskId and t.taskType = 2

		INNER JOIN TM_PatternAssoc PA WITH(NOLOCK) ON PA.subtaskId = ST.subtaskId

		INNER JOIN TM_Pattern P WITH(NOLOCK) ON P.patternId = PA.patternId

		-- Get Max RPO per plan
		INSERT INTO #planMaxRPO(planId,maxRPO,pCnt)


		SELECT SP.planId, MAX(SP.rpoMinutes), COUNT(SP.planId)

			FROM #SPBackupCopyPattern SP

			GROUP BY SP.planId

		-- Get MAX RPO schedule for which to upgrade to policy, only one per plan
		INSERT INTO #planMaxRPOSched(planId,taskId,rpoMinutes)


		SELECT SPB.planId,MIN(SPB.taskId),SPB.rpoMinutes

		FROM #SPBackupCopyPattern SPB

		INNER JOIN #planMaxRPO PMR ON PMR.planId = SPB.planId AND PMR.maxRPO = SPB.rpoMinutes

		GROUP BY SPB.planId,SPB.rpoMinutes

		IF @@TRANCOUNT=0

		BEGIN

			SET @IsTranStarted = 1

			BEGIN TRAN

		END			

			--Disabling other schedules which have same RPO as MAX RPO

			UPDATE T

			SET T.description='Disabling due to Plan backup copy RPO upgrade',T.disabled = 1

			FROM TM_Task T

			INNER JOIN #SPBackupCopyPattern SPB ON SPB.taskId = T.taskId

			INNER JOIN #planMaxRPO MRPO ON MRPO.planId = SPB.planId AND MRPO.pCnt > 1

			WHERE NOT EXISTS

			(	

				SELECT 1 FROM #SPBackupCopyPattern SPB1

				WHERE SPB1.planId = MRPO.planId

				AND SPB1.rpoMinutes <> MRPO.maxRPO 

			)

			-- Convert the plan MAX(RPO) schedule to schedule policy and associate all the plan storage policies to it.

			UPDATE T

			SET T.description='Backup copy schedule policy created via upgrade for '+PL.name+' plan.',

				T.disabled = 0,

				T.taskType = 4,

				T.initiatedFrom = 5, --InitFromSchedule

				T.taskName = IIF(T.taskName = '' OR T.taskName IS NULL,PL.name +'backupcopy schedule policy',T.taskName)

			FROM TM_Task T

			INNER JOIN #planMaxRPOSched RPO ON RPO.taskId = T.taskId

			INNER JOIN App_Plan PL WITH(NOLOCK) ON PL.id = RPO.planId

			--Update the flags of the subtask associated to MAX RPO schedule with SUBTASK_FLAGS_PLAN_BACKUP_COPY

			UPDATE ST

SET ST.flags = (ST.flags | 0x2000000)

			FROM TM_SubTask ST

INNER JOIN #planMaxRPOSched RPO ON RPO.taskId = ST.taskId AND ST.operationType = 4028

			--Update Plan Properties
			INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)


SELECT P.planId,'Backup copy schedule policy',7,CAST(P.taskId AS NVARCHAR(10)),@currentTime,0

				FROM #planMaxRPOSched P

LEFT JOIN App_PlanProp PP WITH(NOLOCK) ON PP.componentNameId = P.planId AND PP.attrName = 'Backup copy schedule policy'

				WHERE PP.attrVal IS NULL

			UNION

SELECT P.planId,'Backup copy RPO In Minutes',7,CAST(P.rpoMinutes AS NVARCHAR(10)),@currentTime,0

				FROM #planMaxRPOSched P

LEFT JOIN App_PlanProp PP WITH(NOLOCK) ON PP.componentNameId = P.planId AND PP.attrName = 'Backup copy RPO In Minutes'

				WHERE PP.attrVal IS NULL

			--Add rest of the associations to the main schedule policy
            INSERT INTO TM_AssocEntity(


				assocType,

				taskId,

				flags,

				created,       

				exclude,

				clientGroupId,     

				clientId,       

				apptypeId,

				instanceId,     

				backupsetId,

				subclientId,       

				policyId,       

				copyId,     

				srmReportSet,   

				srmReportType,

				trackingPolicyId,  

				MediaAgentId,   

				agentlessPolicyId, 

				workflowId, 

				sidbStoreId,

				libraryId, 

				logMonitoringPolicyId

				)

SELECT 17,

				RPO.taskId, 

				0, 

				@currentTime, 

				0, 

				0, 

				0, 

				0, 

				0, 

				0, 

				0, 

				PSR.storagePolicyId, 

				0, 

				0, 

				0, 

				0, 

				0, 

				0, 

				0, 

				0, 

				0, 

				0  

            FROM #Plan_Storage_Rule PSR

			INNER JOIN #planMaxRPOSched RPO ON PSR.planId = RPO.planId

			LEFT JOIN TM_AssocEntity Existing WITH(NOLOCK) ON Existing.policyId = PSR.storagePolicyId AND Existing.taskId =  RPO.taskId  

			WHERE Existing.policyId IS NULL
			INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@backupCopyPlanUpgrade, 'Backup Copy Schedule policy on Plan ', 'Fix to upgrade existing plans to have backup copy schedule policy', @currentTime,  16, 0, (16 + 2))

		IF (@IsTranStarted=1)

		BEGIN

			COMMIT TRAN

			SET @IsTranStarted = 0

		END

	END TRY

	BEGIN CATCH

		IF (@IsTranStarted=1)

		BEGIN

			ROLLBACK TRAN

		END

		PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

        ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

        ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

        ERROR MESSAGE: ' + ERROR_MESSAGE() + '

        ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

        ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		;THROW;

	END CATCH

		IF OBJECT_ID('tempdb.dbo.#Plan_Storage_Rule') IS NOT NULL

			DROP TABLE #Plan_Storage_Rule

		IF OBJECT_ID('tempdb.dbo.#SPBackupCopyPattern') IS NOT NULL

			DROP TABLE #SPBackupCopyPattern

		IF OBJECT_ID('tempdb.dbo.#planMaxRPOSched') IS NOT NULL

			DROP TABLE #planMaxRPOSched

		IF OBJECT_ID('tempdb.dbo.#planMaxRPO') IS NOT NULL

				DROP TABLE #planMaxRPO

	END

GO

