

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/APP_MonitoringPolicyProp.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/APP_MonitoringPolicyProp.script,v $ $Id: APP_MonitoringPolicyProp.script,v 1.1.2.9 2020/01/23 11:29:21 logeshg Exp $";

--TABLENAME APP_MonitoringPolicyProp

DECLARE @policyId INT = NULL

SELECT @policyId = monitorPolicyId

FROM APP_MonitoringPolicy WITH (NOLOCK) 

WHERE MonitorPolicyName = N'System Created-Recall Logs' 

    AND description = N'System created policy for Recall monitoring' 

    AND status <> 3

IF (@policyId IS NOT NULL AND @policyId > 0)

BEGIN

	DECLARE @curUtcDateTime BIGINT = DATEDIFF(second, '01/01/1970', GetUTCdate())

	--We are updating/setting the index factor to weekly for System created recall policy 	

	UPDATE APP_MonitoringPolicyProp

	SET attrVal = N'2' , modified = @curUtcDateTime

	WHERE monitorPolicyId = @policyId 

		AND attrName = N'Factor'

	IF (@@ROWCOUNT = 0)

	BEGIN
		INSERT INTO APP_MonitoringPolicyProp 


		VALUES(@policyId,2,N'Factor',7,2,@curUtcDateTime,@curUtcDateTime)	

	END

	-- We are updating/setting the aging days to 180 for System created recall policy 	

	UPDATE APP_MonitoringPolicyProp

	SET attrVal = N'180' , modified = @curUtcDateTime

	WHERE monitorPolicyId = @policyId 

		AND attrName = N'age ci data after days'

	IF (@@ROWCOUNT = 0)

	BEGIN
		INSERT INTO APP_MonitoringPolicyProp 


		VALUES(@policyId,2,N'age ci data after days',7,N'180',@curUtcDateTime,@curUtcDateTime)	

	END

	UPDATE APP_MonitoringPolicyProp

	SET attrVal = N'%LOG_DIR%RecalledItems*%LOG_DIR%ArchiveJobStatistics*%LOG_DIR%FileScan*'  , modified = @curUtcDateTime

	WHERE monitorPolicyId = @policyId

		AND attrName = N'Content'

	--populate work queue request clients

	-- Process associatedClientGroups

	DECLARE @editSyncReq  NVARCHAR(MAX) = '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><TMMsg_MonitoringPolicyChangeReq monitoringPolicyId="' + CONVERT(NVARCHAR(MAX),@policyId) + '" operationType="1"/>'

	DECLARE @returnSyncCode TABLE (errorCode INT, errorMessage NVARCHAR(MAX)) 

	DECLARE clientGroupIdList CURSOR FOR SELECT clientGroupId FROM APP_MonitorAssocEntity WHERE monitorPolicyId = @policyId 

	OPEN clientGroupIdList

	DECLARE @cltgs INT

	FETCH NEXT FROM clientGroupIdList INTO @cltgs

	WHILE @@FETCH_STATUS = 0

	BEGIN   

		IF @cltgs > 0 

		BEGIN 

			INSERT @returnSyncCode

			EXEC AppWorkQueueSubmitRequest 8/*WORK_TOKEN_LOGMONITORING*/, 0, 0, 0, @cltgs, @editSyncReq  

		END

		FETCH NEXT FROM clientGroupIdList INTO @cltgs

	END

	CLOSE clientGroupIdList

	DEALLOCATE clientGroupIdList		

	-- Process associatedClients

	DECLARE clientIdList CURSOR FOR SELECT clientId FROM APP_MonitorAssocEntity WHERE monitorPolicyId = @policyId 

	OPEN clientIdList

	DECLARE @clts INT

	FETCH NEXT FROM clientIdList INTO @clts

	WHILE @@FETCH_STATUS = 0

	BEGIN   

		IF @clts > 0 

		BEGIN 

			INSERT @returnSyncCode

			EXEC AppWorkQueueSubmitRequest 8/*WORK_TOKEN_LOGMONITORING*/, 0, 0, @clts, 0, @editSyncReq  

		END

		FETCH NEXT FROM clientIdList INTO @clts

	END

	CLOSE clientIdList

	DEALLOCATE clientIdList		

END

SET @policyId = NULL

SELECT @policyId = monitorPolicyId

FROM APP_MonitoringPolicy WITH (NOLOCK) 

WHERE MonitorPolicyName = N'EdgeAudit'   

	AND description = N'System created policy for EdgeAudit'

    AND status <> 3

IF (@policyId IS NOT NULL AND @policyId > 0)

BEGIN 

	DECLARE @utcDateTime BIGINT = DATEDIFF(second, '01/01/1970', GetUTCdate())

	-- this is little weird

	-- In postupgrade default policy population script 

	-- string fields are getting set with 0 values so we have to update with empty string.

	UPDATE APP_MonitoringPolicyProp

	SET attrVal = N'' , modified = @utcDateTime

	WHERE monitorPolicyId = @policyId 

		AND attrName = N'extraction options'

	UPDATE APP_MonitoringPolicyProp

	SET attrVal = N'' , modified = @utcDateTime

	WHERE monitorPolicyId = @policyId 

		AND attrName = N'Global Monitoring User Name'

	UPDATE APP_MonitoringPolicyProp

	SET attrVal = N'' , modified = @utcDateTime

	WHERE monitorPolicyId = @policyId 

		AND attrName = N'Global Monitoring Web Service URL'

	UPDATE APP_MonitoringPolicyProp

	SET attrVal = N'' , modified = @utcDateTime

	WHERE monitorPolicyId = @policyId 

		AND attrName = N'Global Policy Name'

END 

IF EXISTS ( SELECT 1 

				FROM APP_MonitoringPolicy A WITH(NOLOCK) , APP_MonitoringPolicyProp B WITH(NOLOCK)

				WHERE A.monitorPolicyId = B.monitorPolicyId

				AND A.status <> 3 

				AND B.attrName = N'Monitoring SubType'

				AND B.attrVal = 1) -- Data Cube Alert type policy

BEGIN 	

	DECLARE @monPolicyId INT = (SELECT A.monitorPolicyId 

			FROM APP_MonitoringPolicy A WITH(NOLOCK) , APP_MonitoringPolicyProp B WITH(NOLOCK)

			WHERE A.monitorPolicyId = B.monitorPolicyId

			AND A.status <> 3 

			AND B.attrName = N'Monitoring SubType'

			AND B.attrVal = 1)	

	IF EXISTS ( SELECT 1 FROM APP_Criteria A WITH(NOLOCK) WHERE monitorPolicyId = @monPolicyId)

	BEGIN 

		UPDATE APP_Criteria 

		SET criteriaXML = '<?xml version=''1.0'' encoding=''UTF-8''?><LogMonitoring_ConditionsList criteriaName="(INFO  \(Thread-\d+\) \[   \] com\.commvault\.app\.business\.crawl\.CrawlStatus Job information with status matches any column)" opBetweenConditions="0"><conditionForMatchAnyColumn matchWholeWord="0" isCaseSensitive="0" value2="" value1="INFO  \(Thread-\d+\) \[   \] com\.commvault\.app\.business\.crawl\.CrawlStatus Job information with status" isInclusive="0" isregex="1"><column columnName="" /></conditionForMatchAnyColumn></LogMonitoring_ConditionsList>'

		WHERE monitorPolicyId = @monPolicyId

	END

END	

