

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/APP_LMCreateHyperVDashboard.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------

SET NOCOUNT ON

DECLARE @curUtcDateTime BIGINT

DECLARE @errorCode int = 0

DECLARE @errorString NVARCHAR(1024) = ''

DECLARE @HyperVDashboardScriptExec INT = 0

DECLARE @dashboardId INT

DECLARE @DashBoardName NVARCHAR(30) = 'HyperV'

DECLARE @searchUrl NVARCHAR(MAX)

DECLARE @searchUrlXml XML 

BEGIN TRY

	BEGIN TRANSACTION LMCreateHyperVDashboardTran

	SELECT

		@HyperVDashboardScriptExec = 1

	FROM

		GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

	WHERE

		gp.SqlScriptGUID = 'CC4720C5-88B7-445D-BF17-35865F406A08'

	IF (@HyperVDashboardScriptExec = 0)		-- not done, delete the old HyperV dashboard and create the HyperV search for CRE report dataset

	BEGIN

		SET @curUtcDateTime = datediff(second, '01/01/1970', GetUTCdate());

		DISABLE TRIGGER ALL on GXUniqueSQLScriptExecTracking

		--delete hyperV script entry

		DELETE FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = 'EB846BF6-7913-43E0-972E-8F52B9F79472';

		ENABLE TRIGGER ALL on GXUniqueSQLScriptExecTracking

		SET @dashboardId = (SELECT TOP 1 dashBoardId FROM LMDashBoard WITH (NOLOCK) WHERE dashBoardName = @DashBoardName AND monitoringAppType = 1 AND creatorUserId = 1 AND status = 8)

		IF (@dashboardId IS NOT NULL)

		BEGIN

			--delete searches in HyperV dashboard

			DELETE LMUS FROM LMUserSearch LMUS INNER JOIN LMDashSearchAssoc LMDSA ON LMUS.searchId = LMDSA.searchId WHERE LMDSA.dashBoardId = @dashboardId

			--delete search and dashboard associations, if any

			DELETE FROM LMDashSearchAssoc WHERE dashboardId = @dashboardId

			--delete HyperV dashboard

			DELETE FROM LMDashBoard WHERE dashboardId = @dashboardId

		END

		--creating searches

SET @searchUrl = '<LogMonitoring_SearchURLInfo orderId="1" searchType="0" isPrecookedSearch="true" browserURL="' + '?viewId=1&amp;TemplateName=%22HyperV%22&amp;fieldList=TemplateName&amp;startTime=NOW-1DAYS&amp;endTime=NOW&amp;estimatedTimeDiff=86400000&amp;gap=1HOUR&amp;isAllTime=false&amp;dataView=rawView&amp;graphScale=linear&amp;compareScale=1&amp;rows=100' + '" solrQuery="' + 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3Cmark%3E&amp;hl.simple.post=%3C%2Fmark%3E&amp;fq=%28isLMDoc%3A1%29&amp;fq=%28TemplateName%3A%22HyperV%22%29&amp;fq=%28eventTime:[NOW-1DAYS+TO+NOW}%29&amp;q=*%3A*&amp;sort=eventTime+desc' + '" searchLabel="' + 'Search Info&lt;br&gt;&lt;b&gt;TemplateName:&lt;/b&gt;HyperV&lt;br&gt;&lt;b&gt;Start Time:&lt;/b&gt;NOW-1DAYS&lt;br&gt;&lt;b&gt;End Time:&lt;/b&gt;NOW&lt;br&gt;' + '" isImplicitSearch="0" />' 
	SET @searchUrlXml = CONVERT(XML,@searchUrl) 
	IF NOT EXISTS (SELECT 1 FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'System Created HyperV Search' AND monitoringAppType = 1 AND creatorUserId = 1) 
	BEGIN 
		INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified,monitoringAppType) 
		VALUES('System Created HyperV Search',1,1,2,@searchUrlXml,@curUtcDateTime,@curUtcDateTime,1)	
	END
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('CC4720C5-88B7-445D-BF17-35865F406A08', 'HyperVDashboardScriptExec', 'Delete old HyperV dashboard and create search for CRE dataset', @curUtcDateTime, 16, 0 , (16 + 1))

	END

	COMMIT TRANSACTION LMCreateHyperVDashboardTran

END TRY

BEGIN CATCH

	SELECT @errorCode = ERROR_NUMBER(), @errorString = ERROR_MESSAGE()

	PRINT N'Error occured. ErrorNo(' + CAST(@errorCode AS NVARCHAR) + N') ErrorMsg(' + @errorString + N').'

	PRINT N'So Rolling back Transactions.'

	ROLLBACK TRANSACTION LMCreateHyperVDashboardTran

END CATCH

