

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/APP_LMCreateActivityMonDashboard.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/APP_LMCreateActivityMonDashboard.script,v $ $Id: APP_LMCreateActivityMonDashboard.script,v 1.1.2.12 2020/10/04 00:54:22 abilbrey Exp $";

GO

SET QUOTED_IDENTIFIER ON

GO

DECLARE @ActivityMonDashboardScriptExec INT = 0

SELECT

	@ActivityMonDashboardScriptExec = 1

FROM

	GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

	gp.SqlScriptGUID = '3DDFF721-CEFE-4591-AB43-7F1EAEACC519'

IF (@ActivityMonDashboardScriptExec = 0)		-- not done, create the activity monitoring dashboard

BEGIN

	DECLARE @curUtcDateTime BIGINT

	DECLARE @dashboardId INT

	DECLARE @searchId INT

	DECLARE @DashBoardName NVARCHAR(50) = 'System Created Activity Monitoring' --activity monitoring default dashboard

	DECLARE @browserURLField NVARCHAR(max)

	DECLARE @solrQueryField NVARCHAR(max)

	DECLARE @searchLabelField NVARCHAR(max)

	DECLARE @searchUrlXml xml

	SET @curUtcDateTime = datediff(second, '01/01/1970', GetUTCdate())

		--clear previous script entry

	DELETE FROM LMDashBoard WHERE dashBoardName = 'Activity Monitoring' AND monitoringAppType = 2 AND status = 4

	--creating dashboard 

	DECLARE @dashBoardProp XML = CONVERT(XML, '<LogMonitoring_DashBoardProp isClientNavigation="0" clientNavigationApp="Activity Monitoring" />')

	IF exists(SELECT 1 FROM LMDashBoard WITH (NOLOCK) WHERE dashBoardName = @DashBoardName AND monitoringAppType = 2 AND creatorUserId = 1)

		BEGIN

			SET @dashboardId = (SELECT TOP 1 dashBoardId FROM LMDashBoard WITH (NOLOCK) WHERE dashBoardName = @DashBoardName AND monitoringAppType = 2 AND creatorUserId = 1)

			UPDATE LMDashBoard set dashBoardProp = @dashBoardProp where dashBoardId = @dashboardId

		END

	ELSE

		BEGIN

			-- status = 8 indicates pre-created dashboard which is available for all users
			INSERT INTO LMDashBoard (dashBoardName,isPrivate,creatorUserId,status,created,modified,monitoringAppType,dashBoardProp)


				VALUES(@DashBoardName,1,1,8,@curUtcDateTime,0,2,@dashBoardProp)

			SET @dashboardId = @@IDENTITY

	END

	--creating searches

	SET @browserURLField = '?viewId=1&amp;TemplateName=%22Activity%20Monitoring%22&amp;useroperation_ss=%22WRITE%22%2C%22CREATE%22%2C%22DELETE%22%2C%22MOVE%22&amp;fieldList=TemplateName%2Cuseroperation_ss&amp;keyWord=graphtype%20pie%20hostname&amp;startTime=&amp;endTime=&amp;estimatedTimeDiff&amp;gap&amp;isAllTime=true&amp;dataView=rawView&amp;graphScale=linear'

	SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;q=*%3A*+AND+%28isLMDoc%3A2%29+AND+%28TemplateName%3A%22Activity+Monitoring%22%29+AND+%28useroperation_ss%3A%22WRITE%22+OR+useroperation_ss%3A%22CREATE%22+OR+useroperation_ss%3A%22DELETE%22+OR+useroperation_ss%3A%22MOVE%22%29&amp;sort=eventTime+desc'

	SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype pie hostname&lt;br&gt;&lt;b&gt;TemplateName:&lt;/b&gt;Activity Monitoring&lt;br&gt;&lt;b&gt;useroperation_ss:&lt;/b&gt;WRITE,CREATE,DELETE,MOVE&lt;br&gt; &lt;b&gt;Time Range:&lt;/b&gt;All Time&lt;br&gt;'

	SET @searchUrlXml = CONVERT(XML,'<LogMonitoring_SearchURLInfo orderId="1" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />')

	IF not exists (SELECT 1 FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Clients with Most Edited Content' AND monitoringAppType = 2 AND creatorUserId = 1)

		BEGIN
			INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified,monitoringAppType)


				VALUES('Clients with Most Edited Content',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime,2)

			SET @searchId = @@IDENTITY
			INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)


				VALUES(@dashboardId,@searchId)

		END

	ELSE

		BEGIN

			SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Clients with Most Edited Content' AND monitoringAppType = 2 AND creatorUserId = 1)

			IF not exists(SELECT 1 FROM LMDashSearchAssoc WITH (NOLOCK) WHERE dashBoardId = @dashboardId AND searchId = @searchId)

				BEGIN

					--delete other dashboard associations of this search 

					DELETE FROM LMDashSearchAssoc where searchId = @searchId
					INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)


						VALUES(@dashboardId,@searchId)

					update LMUserSearch

					set status =  status | 4

					where searchId = @searchId

				END

		END

	SET @browserURLField = '?viewId=1&amp;TemplateName=%22Activity%20Monitoring%22&amp;useroperation_ss=%22WRITE%22%2C%22CREATE%22%2C%22DELETE%22%2C%22MOVE%22&amp;fieldList=TemplateName%2Cuseroperation_ss&amp;keyWord=graphtype%20donut%20user%2Chostname&amp;startTime=&amp;endTime=&amp;estimatedTimeDiff&amp;gap&amp;isAllTime=true&amp;dataView=rawView&amp;graphScale=linear'

	SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;q=*%3A*+AND+%28isLMDoc%3A2%29+AND+%28TemplateName%3A%22Activity+Monitoring%22%29+AND+%28useroperation_ss%3A%22WRITE%22+OR+useroperation_ss%3A%22CREATE%22+OR+useroperation_ss%3A%22DELETE%22+OR+useroperation_ss%3A%22MOVE%22%29&amp;sort=eventTime+desc'

	SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype donut user,hostname&lt;br&gt;&lt;b&gt;TemplateName:&lt;/b&gt;Activity Monitoring&lt;br&gt;&lt;b&gt;useroperation_ss:&lt;/b&gt;WRITE,CREATE,DELETE,MOVE&lt;br&gt; &lt;b&gt;Time Range:&lt;/b&gt;All Time&lt;br&gt;'

	SET @searchUrlXml = CONVERT(XML,'<LogMonitoring_SearchURLInfo orderId="2" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />')

	IF not exists (SELECT 1 FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Top Users Editing Content' AND monitoringAppType = 2 AND creatorUserId = 1)

		BEGIN
			INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified,monitoringAppType)


				VALUES('Top Users Editing Content',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime,2)

			SET @searchId = @@IDENTITY
			INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)


				VALUES(@dashboardId,@searchId)

		END

	ELSE

		BEGIN

			SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Top Users Editing Content' AND monitoringAppType = 2 AND creatorUserId = 1)

			IF not exists(SELECT 1 FROM LMDashSearchAssoc WITH (NOLOCK) WHERE dashBoardId = @dashboardId AND searchId = @searchId)

				BEGIN

					--delete other dashboard associations of this search 

					DELETE FROM LMDashSearchAssoc where searchId = @searchId
					INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)


						VALUES(@dashboardId,@searchId)

					update LMUserSearch

					set status =  status | 4

					where searchId = @searchId

				END

		END

	SET @browserURLField = '?viewId=1&amp;TemplateName=%22Activity%20Monitoring%22&amp;useroperation_ss=%22WRITE%22%2C%22CREATE%22%2C%22DELETE%22%2C%22MOVE%22&amp;fieldList=TemplateName%2Cuseroperation_ss&amp;keyWord=graphtype%20pie%20sourcefilename&amp;startTime=&amp;endTime=&amp;estimatedTimeDiff&amp;gap&amp;isAllTime=true&amp;dataView=rawView&amp;graphScale=linear'

	SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;fq=%28isLMDoc%3A2%29&amp;fq=%28TemplateName%3A%22Activity+Monitoring%22%29&amp;fq=%28useroperation_ss%3A%22WRITE%22+OR+useroperation_ss%3A%22CREATE%22+OR+useroperation_ss%3A%22DELETE%22+OR+useroperation_ss%3A%22MOVE%22%29&amp;q=*%3A*&amp;sort=eventTime+desc'

	SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype pie sourcefilename&lt;br&gt;&lt;b&gt;TemplateName:&lt;/b&gt;Activity Monitoring&lt;br&gt;&lt;b&gt;useroperation_ss:&lt;/b&gt;WRITE,CREATE,DELETE,MOVE&lt;br&gt; &lt;b&gt;Time Range:&lt;/b&gt;All Time&lt;br&gt;'

	SET @searchUrlXml = CONVERT(XML,'<LogMonitoring_SearchURLInfo orderId="3" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />')

	IF not exists (SELECT 1 FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Most Edited Files' AND monitoringAppType = 2 AND creatorUserId = 1)

		BEGIN
			INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified,monitoringAppType)


				VALUES('Most Edited Files',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime,2)

			SET @searchId = @@IDENTITY
			INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)


				VALUES(@dashboardId,@searchId)

		END

	ELSE

		BEGIN

			SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Most Edited Files' AND monitoringAppType = 2 AND creatorUserId = 1)

			IF not exists(SELECT 1 FROM LMDashSearchAssoc WITH (NOLOCK) WHERE dashBoardId = @dashboardId AND searchId = @searchId)

				BEGIN

					--delete other dashboard associations of this search 

					DELETE FROM LMDashSearchAssoc where searchId = @searchId
					INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)


						VALUES(@dashboardId,@searchId)

					update LMUserSearch

					set status =  status | 4

					where searchId = @searchId

				END

		END

	SET @browserURLField = '?viewId=1&amp;TemplateName=%22Activity%20Monitoring%22&amp;fieldList=TemplateName&amp;keyWord=graphtype%20donut%20user%2Cuseroperation&amp;startTime=&amp;endTime=&amp;estimatedTimeDiff&amp;gap&amp;isAllTime=true&amp;dataView=rawView&amp;graphScale=linear'

	SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;q=*%3A*+AND+%28isLMDoc%3A2%29+AND+%28TemplateName%3A%22Activity+Monitoring%22%29&amp;sort=eventTime+desc'

	SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype donut user,useroperation&lt;br&gt;&lt;b&gt;TemplateName:&lt;/b&gt;Activity Monitoring&lt;br&gt; &lt;b&gt;Time Range:&lt;/b&gt;All Time&lt;br&gt;'

	SET @searchUrlXml = CONVERT(XML,'<LogMonitoring_SearchURLInfo orderId="4" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />')

	IF not exists (SELECT 1 FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Most Active Users' AND monitoringAppType = 2 AND creatorUserId = 1)

		BEGIN
			INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified,monitoringAppType)


				VALUES('Most Active Users',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime,2)

			SET @searchId = @@IDENTITY
			INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)


				VALUES(@dashboardId,@searchId)

		END

	ELSE

		BEGIN

			SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Most Active Users' AND monitoringAppType = 2 AND creatorUserId = 1)

			IF not exists(SELECT 1 FROM LMDashSearchAssoc WITH (NOLOCK) WHERE dashBoardId = @dashboardId AND searchId = @searchId)

				BEGIN

					--delete other dashboard associations of this search 

					DELETE FROM LMDashSearchAssoc where searchId = @searchId
					INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)


						VALUES(@dashboardId,@searchId)

					update LMUserSearch

					set status =  status | 4

					where searchId = @searchId

				END

		END

	SET @browserURLField = '?viewId=1&amp;TemplateName=%22Activity%20Monitoring%22&amp;result_sf=%22FAILED%22&amp;fieldList=TemplateName%2Cresult_sf&amp;keyWord=graphtype%20donut%20user%2Cuseroperation&amp;startTime=&amp;endTime=&amp;estimatedTimeDiff&amp;gap&amp;isAllTime=true&amp;dataView=rawView&amp;graphScale=linear'

	SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;q=*%3A*+AND+%28isLMDoc%3A2%29+AND+%28TemplateName%3A%22Activity+Monitoring%22%29+AND+%28result_sf%3A%22FAILED%22%29&amp;sort=eventTime+desc'

	SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype donut user,useroperation&lt;br&gt;&lt;b&gt;TemplateName:&lt;/b&gt;Activity Monitoring&lt;br&gt;&lt;b&gt;result_sf:&lt;/b&gt;FAILED&lt;br&gt; &lt;b&gt;Time Range:&lt;/b&gt;All Time&lt;br&gt;'

	SET @searchUrlXml = CONVERT(XML,'<LogMonitoring_SearchURLInfo orderId="5" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />')

	IF not exists (SELECT 1 FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Most Failed Activity' AND monitoringAppType = 2 AND creatorUserId = 1)

		BEGIN
			INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified,monitoringAppType)


				VALUES('Most Failed Activity',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime,2)

			SET @searchId = @@IDENTITY
			INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)


				VALUES(@dashboardId,@searchId)

		END

	ELSE

		BEGIN

			SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Most Failed Activity' AND monitoringAppType = 2 AND creatorUserId = 1)

			IF not exists(SELECT 1 FROM LMDashSearchAssoc WITH (NOLOCK) WHERE dashBoardId = @dashboardId AND searchId = @searchId)

				BEGIN

					--delete other dashboard associations of this search 

					DELETE FROM LMDashSearchAssoc where searchId = @searchId
					INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)


						VALUES(@dashboardId,@searchId)

					update LMUserSearch

					set status =  status | 4

					where searchId = @searchId

				END

		END

	SET @browserURLField = '?viewId=1&amp;TemplateName=%22Activity%20Monitoring%22&amp;useroperation_ss=%22LOGIN%22&amp;result_sf=%22FAILED%22&amp;fieldList=TemplateName%2Cuseroperation_ss%2Cresult_sf&amp;keyWord=graphtype%20donut%20user%2Chostname&amp;startTime=&amp;endTime=&amp;estimatedTimeDiff&amp;gap&amp;isAllTime=true&amp;dataView=rawView&amp;graphScale=linear'

	SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;q=*%3A*+AND+%28isLMDoc%3A2%29+AND+%28TemplateName%3A%22Activity+Monitoring%22%29+AND+%28useroperation_ss%3A%22LOGIN%22%29+AND+%28result_sf%3A%22FAILED%22%29&amp;sort=eventTime+desc'

	SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype donut user,hostname&lt;br&gt;&lt;b&gt;TemplateName:&lt;/b&gt;Activity Monitoring&lt;br&gt;&lt;b&gt;useroperation_ss:&lt;/b&gt;LOGIN&lt;br&gt;&lt;b&gt;result_sf:&lt;/b&gt;FAILED&lt;br&gt; &lt;b&gt;Time Range:&lt;/b&gt;All Time&lt;br&gt;'

	SET @searchUrlXml = CONVERT(XML,'<LogMonitoring_SearchURLInfo orderId="6" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />')

	IF not exists (SELECT 1 FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Most Failed Logins' AND monitoringAppType = 2 AND creatorUserId = 1)

		BEGIN
			INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified,monitoringAppType)


				VALUES('Most Failed Logins',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime,2)

			SET @searchId = @@IDENTITY
			INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)


				VALUES(@dashboardId,@searchId)

		END

	ELSE

		BEGIN

			SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Most Failed Logins' AND monitoringAppType = 2 AND creatorUserId = 1)

			IF not exists(SELECT 1 FROM LMDashSearchAssoc WITH (NOLOCK) WHERE dashBoardId = @dashboardId AND searchId = @searchId)

				BEGIN

					--delete other dashboard associations of this search 

					DELETE FROM LMDashSearchAssoc where searchId = @searchId
					INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)


						VALUES(@dashboardId,@searchId)

					update LMUserSearch

					set status =  status | 4

					where searchId = @searchId

				END

		END

	SET @browserURLField = '?viewId=1&amp;TemplateName=%22Activity%20Monitoring%22&amp;useroperation_ss=%22LOGIN%22&amp;fieldList=TemplateName&amp;excludeFieldList=useroperation_ss&amp;keyWord=graphtype%20donut%20processname%2C%20hostname&amp;startTime=&amp;endTime=&amp;estimatedTimeDiff&amp;gap&amp;isAllTime=true&amp;dataView=rawView&amp;graphScale=linear&amp;compareScale=1&amp;rows=100'

	SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3Cmark%3E&amp;hl.simple.post=%3C%2Fmark%3E&amp;fq=%28isLMDoc%3A2%29&amp;fq=%28TemplateName%3A%22Activity+Monitoring%22%29&amp;fq=+-%28useroperation_ss%3A%22LOGIN%22%29&amp;q=*%3A*&amp;sort=eventTime+desc'

	SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype donut processname, hostname&lt;br&gt;&lt;b&gt;TemplateName:&lt;/b&gt;Activity Monitoring&lt;br&gt;useroperation_ss: - LOGIN  &lt;b&gt;Time Range:&lt;/b&gt;All Time&lt;br&gt;'

	SET @searchUrlXml = CONVERT(XML,'<LogMonitoring_SearchURLInfo orderId="7" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />')

	IF not exists (SELECT 1 FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Most Used Applications' AND monitoringAppType = 2 AND creatorUserId = 1)

		BEGIN
			INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified,monitoringAppType)


				VALUES('Most Used Applications',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime,2)

			SET @searchId = @@IDENTITY
			INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)


				VALUES(@dashboardId,@searchId)

		END

	ELSE

		BEGIN

			SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Most Used Applications' AND monitoringAppType = 2 AND creatorUserId = 1)

			UPDATE LMUserSearch set searchInfo = @searchUrlXml WHERE searchId = @searchId

			IF not exists(SELECT 1 FROM LMDashSearchAssoc WITH (NOLOCK) WHERE dashBoardId = @dashboardId AND searchId = @searchId)

				BEGIN

					--delete other dashboard associations of this search 

					DELETE FROM LMDashSearchAssoc where searchId = @searchId
					INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)


						VALUES(@dashboardId,@searchId)

					update LMUserSearch

					set status =  status | 4

					where searchId = @searchId

				END

		END

	IF EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE Name = 'ActivityMonDashboardScriptExec')

	BEGIN

		UPDATE GXUniqueSQLScriptExecTracking SET SqlScriptGUID = '3DDFF721-CEFE-4591-AB43-7F1EAEACC519' WHERE Name = 'ActivityMonDashboardScriptExec'

	END

	ELSE

	BEGIN
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


			VALUES('3DDFF721-CEFE-4591-AB43-7F1EAEACC519', 'ActivityMonDashboardScriptExec', 'Create Activity monitoring dashboard and searches', @curUtcDateTime, 16, 0 , (16 + 1))

	END

END

SET NOCOUNT OFF

GO

SET QUOTED_IDENTIFIER ON

GO

