

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/APP_InstanceProp.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

------------------------------------------------------------------------

-- rcsid[]='@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/APP_InstanceProp.script,v $ $Id: APP_InstanceProp.script,v 1.2.12.9 2020/06/11 20:07:41 shussain Exp $';

--TABLENAME APP_InstanceProp

-- MR133918 - Exchange Derived Instance Property used attrType of 1 when it should have used 111 to indicate it was derived

-- Change needed for CCS Subsystem, so that the row can be encoded properly into XML and avoid the performance hit

-- of encoding generic string property types.

UPDATE ip

	SET attrType = 111

FROM

	APP_Client c WITH(NOLOCK)

	INNER JOIN APP_Application a WITH(NOLOCK) ON

		a.clientId = c.id

		AND c.releaseId = 16	-- 11.0 SP to SP upgrade

	INNER JOIN APP_InstanceProp ip ON

		a.instance = ip.componentNameId

		AND ip.attrName LIKE 'Target Mailboxes%'

		AND ip.attrType = 1

DECLARE @curTime INT 

SET @curTime  = datediff(second, '01/01/1970', GETDATE())

DECLARE @discoveredVMInstanceId INT=0

SET @discoveredVMInstanceId=ISNULL((SELECT id from APP_InstanceName WHERE name='VMInstance' and status=0x200000),0)

IF @discoveredVMInstanceId <> 0 AND NOT EXISTS(SELECT componentNameId from APP_InstanceProp WHERE componentNameId = @discoveredVMInstanceId  AND modified = 0 AND attrName='Discovered VM Instance' )

BEGIN
	insert into APP_InstanceProp(componentNameId,attrName,attrType,attrVal,created,modified,ccpId)


values( @discoveredVMInstanceId,'Discovered VM Instance',1,'1',@curTime,0,0)

END

--Update the Virtual Server Host property for Amazon psuedoclients

DECLARE @guid VARCHAR(40) = '94E1F46D-045B-41DE-A194-80A7477ED2C8'

IF NOT EXISTS (SELECT * FROM GXUniqueSQLScriptExecTracking gp WHERE gp.SqlScriptGUID = @guid)

BEGIN

    UPDATE APP_InstanceProp

	SET attrVal = 'default'

	WHERE componentNameId in (SELECT componentNameId FROM APP_InstanceProp

								WHERE attrName = 'Virtual Server Instance Type' AND attrVal = '301')

	AND attrName = 'Virtual Server Host'
    INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@guid, 'VirtualServerHostUpdate', 'Update script to set Virtual Server Host value as default for Amazon pseudoclients.', @curTime,  16, 0, (16 + 2))

END

--Update the FileIndexing Engine Type

DECLARE @fiGuid VARCHAR(40) = '5236f768-33e7-4a0a-9760-f2126e6f0ed3'

IF NOT EXISTS (SELECT TOP 1 1 FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = @fiGuid)

BEGIN
    INSERT INTO APP_InstanceProp


	SELECT DISTINCT AAP.instance, 'File Indexing Engine Type', 7, '0', @curTime, 0, 0 FROM APP_SubClientProp ASCP WITH(NOLOCK)

	INNER JOIN APP_Application AAP WITH(NOLOCK)

		ON AAP.id=ASCP.componentNameId AND ASCP.attrName='Associated index server id' AND ASCP.attrVal<>'0' and ASCP.modified=0 AND ASCP.cs_attrName=CHECKSUM(N'Associated index server id')

	LEFT OUTER JOIN APP_InstanceProp AIP WITH(NOLOCK)

		ON AIP.componentNameId=AAP.instance AND AIP.attrName='File Indexing Engine Type' AND AIP.modified=0

	WHERE AIP.id IS NULL
    INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@fiGuid, 'FileIndexingEngineUpdate', 'Update script to set File Indexing Engine Type for Virtual Server Instance.', @curTime,  16, 0, (16 + 2))

END

--DELETE THE VCLOUD HOST PROPERTY FOR ALL HYPERV

SET @guid  = '0AE9BE58-BD16-4604-9ABD-B6319517FDA3'

IF NOT EXISTS (SELECT * FROM GXUNIQUESQLSCRIPTEXECTRACKING GP WHERE GP.SQLSCRIPTGUID = @guid)

BEGIN

    DELETE FROM P1 

	FROM APP_INSTANCEPROP  P1

	 JOIN APP_INSTANCEPROP  P2

	ON  P2.COMPONENTNAMEID = P1.COMPONENTNAMEID 

	WHERE

	 P1.ATTRNAME = N'Virtual Server vCloud Host'  

	AND P2.ATTRNAME = N'Virtual Server Instance Type'  

	AND P2.ATTRVAL = N'102' --HyperV
    INSERT INTO GXUNIQUESQLSCRIPTEXECTRACKING(SQLSCRIPTGUID, NAME, DESCRIPTION, CREATEDTIME, CREATEDRELID, EXPIRETIME, EXPIRERELID)


        VALUES (@guid, 'Remove vCloud Host on HyperV', 'Update script to delete vCloud Host property on all hHperV clients.', 

@curTime,  16, 0, (16 + 2))

END

-- Insert the property for those instances without 'Instance Status' property.

SET @guid = '70118667-A30F-44FA-A07C-AB6380744A10'

IF NOT EXISTS (SELECT * FROM GXUniqueSQLScriptExecTracking gp WHERE gp.SqlScriptGUID = @guid)

BEGIN
	INSERT INTO APP_InstanceProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)


		SELECT NP.instance, N'Instance Status', 1, 0, @curTime, 0, 0

			FROM (SELECT DISTINCT AP.instance 

					FROM APP_Application AP WITH(NOLOCK)

						LEFT JOIN APP_InstanceProp IP WITH(NOLOCK)

							ON AP.instance = IP.componentNameId

								AND IP.attrName = 'Instance Status' 

								AND IP.modified = 0 

					WHERE AP.appTypeId = 81 

						AND IP.attrName IS NULL) NP
    INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@guid, 'InstanceStatusInsertUpdate', 'Update the instance status properties.', @curTime,  16, 0, (16 + 2))

END

