

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/APP_InstanceName.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

------------------------------------------------------------------------

-- rcsid[]='@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/APP_InstanceName.script,v $ $Id: APP_InstanceName.script,v 1.1.2.6 2018/10/26 21:03:51 pankajkumar Exp $';

--TABLENAME APP_InstanceName

IF NOT EXISTS(SELECT id from APP_InstanceName WHERE name='VMInstance' and status=0x200000) AND NOT EXISTS(SELECT componentNameId from APP_InstanceProp WHERE attrName='Discovered VM Instance' and attrVal= '1' AND modified = 0)

BEGIN
	insert into app_instancename(name,refTime,modified,status)


values('VMInstance',0,0,0x200000)

END

--update instance name for solr & ctree index server

DECLARE @isIndexServerInstanceNameUpdated INT = 0

DECLARE @indexServerIntanceNameVersion varchar(36) = '93A87563-1EE6-4EFD-AF23-6EBC95C56BD9'

SELECT @isIndexServerInstanceNameUpdated = 1

FROM GXUniqueSQLScriptExecTracking GS WITH(NOLOCK)

WHERE GS.SqlScriptGUID = @indexServerIntanceNameVersion

IF (@isIndexServerInstanceNameUpdated = 0)            -- not done, do the db upgrade

BEGIN   

	BEGIN TRY

	BEGIN TRAN

	UPDATE APP_InstanceName

SET name = (CASE WHEN IP.attrVal = 6 THEN 'dynamicIndexInstance' ELSE 'classicIndexInstance' END)

	FROM APP_InstanceProp IP (NOLOCK) 

WHERE IP.componentNameId = APP_InstanceName.id AND IP.attrName = 'Distributed Cluster Type' AND  IP.attrVal IN (6, 7)
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@indexServerIntanceNameVersion, 'indexServerIntanceNameVersion', 'update index server instance name', datediff(second, '01/01/1970', GETDATE()), 16, 0 , (16 + 1))

	COMMIT TRAN

	END TRY

	BEGIN CATCH

		ROLLBACK TRAN

		SELECT @@ERROR, ERROR_MESSAGE()

	END CATCH	

END

