

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/APP_IDAType.script] ---------- 


SET QUOTED_IDENTIFIER ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/APP_IDAType.script,v $ $Id: APP_IDAType.script,v 1.119.2.34 2020/10/04 01:00:15 abilbrey Exp $";

-- For 9.0, we are adding a column 'isCWEjobValid' and on update, preserving some of the existing settings where before all were being overwritten  -SKatz

-- Preserve:  priority, updateRecoSec, chunksizeMB, updateIntervalSec

--

--

-- Moved scripting to simAppTypeLicTypeMap.script file

--

--#define  DELETE_ROW(key)    
--	IF EXISTS (Select 1 FROM simAppTypeLicTypeMap WHERE name = key)  
--		DELETE FROM simAppTypeLicTypeMap WHERE name = key  
--	DELETE FROM APP_idaType WHERE name = key  
--


GO

DECLARE @gpBackslashString        NVARCHAR(2)

DECLARE @empty			         NVARCHAR(2)

DECLARE @exMbPubFolderDefContent	NVARCHAR(10)

DECLARE @tblRetCode integer

set @gpBackslashString	= '\'

set @empty = ''

set @exMbPubFolderDefContent = '\\MB'

SET NOCOUNT ON

IF EXISTS (Select * from APP_iDAType where type = 0)												 
     UPDATE APP_idaType SET name = 'Default Application Type Name', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Default Application Type Name',												 
							indexSpaceSaver = 1											
                            WHERE type =0															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (0, 'Default Application Type Name', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Default Application Type Name', 1)

/* PROTOTYPE

Most defs in appMgrDbDefines.h, some in EvSecurityConst.h. '|' below indicates logical "OR" (Choose 1), not bitwise "OR".

type					CV_APPTYPE_??,

name					CV_APPTYPE_??_NAME, 

treeType				[1 | 2 | 3],

AppGroup1				100001,

priority				['6' | '0'],

caseSensitivity			['0' | '1'],

dirOrder				['0' | '1' | '2'],

dirDelim				@gpBackslashString | @exMbPubFolderDefContent | '/' ,

updateRecoSec			['300'|'300'|'300']

chunkSizeMB				['8192' | '16384' ],

updateIntervalSec		['300' | '300' | '300']

*/

IF EXISTS (Select * from APP_iDAType where type = 1)												 
     UPDATE APP_idaType SET name = 'Windows NT File System', treeType = 1, appGroup1 = 100001,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '1', dirdelim = @gpBackslashString,								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = 'File System',												 
							indexSpaceSaver = 1											
                            WHERE type =1															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1, 'Windows NT File System', 1, 100001, '6', '0', '1',				 
	           @gpBackslashString, '300', '8192', '300', 33, 1,'File System', 1)

IF EXISTS (Select * from APP_iDAType where type = 3)												 
     UPDATE APP_idaType SET name = 'Informix Database', treeType = 3, appGroup1 = 100003,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Informix',												 
							indexSpaceSaver = 1											
                            WHERE type =3															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (3, 'Informix Database', 3, 100003, '6', '0', @empty,				 
	           @empty, '300', '16384', '300', 0, 0,'Informix', 1)

IF EXISTS (Select * from APP_iDAType where type = 4)												 
     UPDATE APP_idaType SET name = 'SQL Server', treeType = 2, appGroup1 = 100004,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 81,														 
							isCWEjobValid = 0,											 
							displayName = 'SQL Server',												 
							indexSpaceSaver = 1											
                            WHERE type =4															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (4, 'SQL Server', 2, 100004, '6', '0', @empty,				 
	           @empty, '300', '16384', '300', 81, 0,'SQL Server', 1)

IF EXISTS (Select * from APP_iDAType where type = 5)												 
     UPDATE APP_idaType SET name = 'Sybase Database', treeType = 3, appGroup1 = 100005,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Sybase',												 
							indexSpaceSaver = 1											
                            WHERE type =5															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (5, 'Sybase Database', 3, 100005, '0', '0', @empty,				 
	           @empty, '300', '16384', '300', 0, 0,'Sybase', 1)

IF EXISTS (Select * from APP_iDAType where type = 6)												 
     UPDATE APP_idaType SET name = 'Unix Notes Database', treeType = 3, appGroup1 = 100006,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 59,														 
							isCWEjobValid = 1,											 
							displayName = 'Notes Database',												 
							indexSpaceSaver = 1											
                            WHERE type =6															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (6, 'Unix Notes Database', 3, 100006, '6', '0', @empty,				 
	           @empty, '300', '16384', '300', 59, 1,'Notes Database', 1)

IF EXISTS (Select * from APP_iDAType where type = 7)												 
     UPDATE APP_idaType SET name = 'Notes Document', treeType = 3, appGroup1 = 100007,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 60,														 
							isCWEjobValid = 1,											 
							displayName = 'Notes Document',												 
							indexSpaceSaver = 1											
                            WHERE type =7															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (7, 'Notes Document', 3, 100007, '6', '0', @empty,				 
	           @empty, '300', '8192', '300', 60, 1,'Notes Document', 1)

IF EXISTS (Select * from APP_iDAType where type = 8)												 
     UPDATE APP_idaType SET name = 'Exchange 5.5 Mailbox', treeType = 1, appGroup1 = 100008,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 54,														 
							isCWEjobValid = 1,											 
							displayName = 'Exchange Mailbox (Classic)',												 
							indexSpaceSaver = 1											
                            WHERE type =8															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (8, 'Exchange 5.5 Mailbox', 1, 100008, '6', '0', @empty,				 
	           @empty, '300', '8192', '300', 54, 1,'Exchange Mailbox (Classic)', 1)

IF EXISTS (Select * from APP_iDAType where type = 9)												 
     UPDATE APP_idaType SET name = 'Exchange 5.5 Database', treeType = 3, appGroup1 = 100009,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 53,														 
							isCWEjobValid = 0,											 
							displayName = 'Exchange Database',												 
							indexSpaceSaver = 1											
                            WHERE type =9															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (9, 'Exchange 5.5 Database', 3, 100009, '6', '0', @empty,				 
	           @empty, '300', '16384', '300', 53, 0,'Exchange Database', 1)

IF EXISTS (Select * from APP_iDAType where type = 13)												 
     UPDATE APP_idaType SET name = 'NDMP', treeType = 1, appGroup1 = 100013,				 
                            casesensitivity = '1',		    			 						
                            dirorder = '1', dirdelim = '/',								
							ccpType = 0,														 
							isCWEjobValid = 1,											 
							displayName = 'NDMP',												 
							indexSpaceSaver = 1											
                            WHERE type =13															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (13, 'NDMP', 1, 100013, '6', '1', '1',				 
	           '/', '300', '16384', '300', 0, 1,'NDMP', 1)

IF EXISTS (Select * from APP_iDAType where type = 14)												 
     UPDATE APP_idaType SET name = 'Exchange 2000 Mailbox', treeType = 1, appGroup1 = 100014,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 54,														 
							isCWEjobValid = 1,											 
							displayName = 'Exchange Mailbox (Classic)',												 
							indexSpaceSaver = 1											
                            WHERE type =14															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (14, 'Exchange 2000 Mailbox', 1, 100014, '6', '0', @empty,				 
	           @empty, '300', '8192', '300', 54, 1,'Exchange Mailbox (Classic)', 1)

IF EXISTS (Select * from APP_iDAType where type = 15)												 
     UPDATE APP_idaType SET name = 'Exchange 2000 Database', treeType = 3, appGroup1 = 100015,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 53,														 
							isCWEjobValid = 0,											 
							displayName = 'Exchange Database',												 
							indexSpaceSaver = 1											
                            WHERE type =15															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (15, 'Exchange 2000 Database', 3, 100015, '6', '0', @empty,				 
	           @empty, '300', '16384', '300', 53, 0,'Exchange Database', 1)

IF EXISTS (Select * from APP_iDAType where type = 1000)												 
     UPDATE APP_idaType SET name = 'CommServe Management', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'CommServe StorageManager',												 
							indexSpaceSaver = 1											
                            WHERE type =1000															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1000, 'CommServe Management', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'CommServe StorageManager', 1)

IF EXISTS (Select * from APP_iDAType where type = 1001)												 
     UPDATE APP_idaType SET name = 'CommClient Management', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'iDataAgent Base',												 
							indexSpaceSaver = 1											
                            WHERE type =1001															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1001, 'CommClient Management', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'iDataAgent Base', 1)

IF EXISTS (Select * from APP_iDAType where type = 1002)												 
     UPDATE APP_idaType SET name = 'MediaAgent Management', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'MediaAgent',												 
							indexSpaceSaver = 1											
                            WHERE type =1002															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1002, 'MediaAgent Management', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'MediaAgent', 1)

IF EXISTS (Select * from APP_iDAType where type = 11)												 
     UPDATE APP_idaType SET name = 'Windows 2000 File System', treeType = 1, appGroup1 = 100011,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '1', dirdelim = @gpBackslashString,								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = 'File System',												 
							indexSpaceSaver = 1											
                            WHERE type =11															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (11, 'Windows 2000 File System', 1, 100011, '6', '0', '1',				 
	           @gpBackslashString, '300', '8192', '300', 33, 1,'File System', 1)

IF EXISTS (Select * from APP_iDAType where type = 10)												 
     UPDATE APP_idaType SET name = 'Novell Directory Services', treeType = 1, appGroup1 = 100010,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '2', dirdelim = '.',								
							ccpType = 0,														 
							isCWEjobValid = 1,											 
							displayName = 'Novell Directory Services',												 
							indexSpaceSaver = 1											
                            WHERE type =10															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (10, 'Novell Directory Services', 1, 100010, '6', '0', '2',				 
	           '.', '300', '8192', '300', 0, 1,'Novell Directory Services', 1)

IF EXISTS (Select * from APP_iDAType where type = 12)												 
     UPDATE APP_idaType SET name = 'NetWare File System', treeType = 1, appGroup1 = 100012,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '1', dirdelim = @gpBackslashString,								
							ccpType = 12,														 
							isCWEjobValid = 1,											 
							displayName = 'File System',												 
							indexSpaceSaver = 1											
                            WHERE type =12															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (12, 'NetWare File System', 1, 100012, '6', '0', '1',				 
	           @gpBackslashString, '300', '8192', '300', 12, 1,'File System', 1)

IF EXISTS (Select * from APP_iDAType where type = 16)												 
     UPDATE APP_idaType SET name = 'SQL Server', treeType = 2, appGroup1 = 100004,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 81,														 
							isCWEjobValid = 0,											 
							displayName = 'SQL Server',												 
							indexSpaceSaver = 1											
                            WHERE type =16															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (16, 'SQL Server', 2, 100004, '6', '0', @empty,				 
	           @empty, '300', '16384', '300', 81, 0,'SQL Server', 1)

IF EXISTS (Select * from APP_iDAType where type = 17)												 
     UPDATE APP_idaType SET name = 'HP-UX File System', treeType = 1, appGroup1 = 100017,				 
                            casesensitivity = '1',		    			 						
                            dirorder = '1', dirdelim = '/',								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = 'File System',												 
							indexSpaceSaver = 1											
                            WHERE type =17															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (17, 'HP-UX File System', 1, 100017, '6', '1', '1',				 
	           '/', '300', '8192', '300', 33, 1,'File System', 1)

IF EXISTS (Select * from APP_iDAType where type = 18)												 
     UPDATE APP_idaType SET name = 'HP-UX 64bit File System', treeType = 1, appGroup1 = 100018,				 
                            casesensitivity = '1',		    			 						
                            dirorder = '1', dirdelim = '/',								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = 'File System',												 
							indexSpaceSaver = 1											
                            WHERE type =18															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (18, 'HP-UX 64bit File System', 1, 100018, '6', '1', '1',				 
	           '/', '300', '8192', '300', 33, 1,'File System', 1)

IF EXISTS (Select * from APP_iDAType where type = 19)												 
     UPDATE APP_idaType SET name = 'Solaris File System', treeType = 1, appGroup1 = 100019,				 
                            casesensitivity = '1',		    			 						
                            dirorder = '1', dirdelim = '/',								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = 'File System',												 
							indexSpaceSaver = 1											
                            WHERE type =19															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (19, 'Solaris File System', 1, 100019, '6', '1', '1',				 
	           '/', '300', '8192', '300', 33, 1,'File System', 1)

IF EXISTS (Select * from APP_iDAType where type = 20)												 
     UPDATE APP_idaType SET name = 'Solaris 64bit File System', treeType = 1, appGroup1 = 100020,				 
                            casesensitivity = '1',		    			 						
                            dirorder = '1', dirdelim = '/',								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = 'File System',												 
							indexSpaceSaver = 1											
                            WHERE type =20															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (20, 'Solaris 64bit File System', 1, 100020, '6', '1', '1',				 
	           '/', '300', '8192', '300', 33, 1,'File System', 1)

IF EXISTS (Select * from APP_iDAType where type = 21)												 
     UPDATE APP_idaType SET name = 'AIX File System', treeType = 1, appGroup1 = 100021,				 
                            casesensitivity = '1',		    			 						
                            dirorder = '1', dirdelim = '/',								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = 'File System',												 
							indexSpaceSaver = 1											
                            WHERE type =21															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (21, 'AIX File System', 1, 100021, '6', '1', '1',				 
	           '/', '300', '8192', '300', 33, 1,'File System', 1)

IF EXISTS (Select * from APP_iDAType where type = 22)												 
     UPDATE APP_idaType SET name = 'Oracle Database', treeType = 3, appGroup1 = 100022,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 22,														 
							isCWEjobValid = 0,											 
							displayName = 'Oracle',												 
							indexSpaceSaver = 1											
                            WHERE type =22															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (22, 'Oracle Database', 3, 100022, '6', '0', @empty,				 
	           @empty, '300', '16384', '300', 22, 0,'Oracle', 1)

IF EXISTS (Select * from APP_iDAType where type = 23)												 
     UPDATE APP_idaType SET name = 'Oracle8 Serverless Database', treeType = 3, appGroup1 = 100023,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 22,														 
							isCWEjobValid = 0,											 
							displayName = 'Oracle8 Serverless Database',												 
							indexSpaceSaver = 1											
                            WHERE type =23															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (23, 'Oracle8 Serverless Database', 3, 100023, '6', '0', @empty,				 
	           @empty, '300', '16384', '300', 22, 0,'Oracle8 Serverless Database', 1)

IF EXISTS (Select * from APP_iDAType where type = 2)												 
     UPDATE APP_idaType SET name = 'Oracle Database', treeType = 3, appGroup1 = 100002,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 22,														 
							isCWEjobValid = 0,											 
							displayName = 'Oracle Database',												 
							indexSpaceSaver = 1											
                            WHERE type =2															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (2, 'Oracle Database', 3, 100002, '6', '0', @empty,				 
	           @empty, '300', '16384', '300', 22, 0,'Oracle Database', 1)

IF EXISTS (Select * from APP_iDAType where type = 1003)												 
     UPDATE APP_idaType SET name = 'NAS MediaAgent Client', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'NAS MediaAgent Client',												 
							indexSpaceSaver = 1											
                            WHERE type =1003															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1003, 'NAS MediaAgent Client', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'NAS MediaAgent Client', 1)

IF EXISTS (Select * from APP_iDAType where type = 24)												 
     UPDATE APP_idaType SET name = 'Serverless Data Manager', treeType = 3, appGroup1 = 100024,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '1', dirdelim = @gpBackslashString,								
							ccpType = 0,														 
							isCWEjobValid = 1,											 
							displayName = 'Serverless Data Manager',												 
							indexSpaceSaver = 1											
                            WHERE type =24															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (24, 'Serverless Data Manager', 3, 100024, '6', '0', '1',				 
	           @gpBackslashString, '300', '8192', '300', 0, 1,'Serverless Data Manager', 1)

IF EXISTS (Select * from APP_iDAType where type = 25)												 
     UPDATE APP_idaType SET name = 'ProxyHost', treeType = 1, appGroup1 = 100025,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '1', dirdelim = @gpBackslashString,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'ProxyHost',												 
							indexSpaceSaver = 1											
                            WHERE type =25															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (25, 'ProxyHost', 1, 100025, '6', '0', '1',				 
	           @gpBackslashString, '300', '8192', '300', 0, 0,'ProxyHost', 1)

IF EXISTS (Select * from APP_iDAType where type = 26)												 
     UPDATE APP_idaType SET name = 'FasTrax Exchange Mailbox', treeType = 1, appGroup1 = 100026,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '1', dirdelim = @gpBackslashString,								
							ccpType = 54,														 
							isCWEjobValid = 0,											 
							displayName = 'FasTrax Exchange Mailbox',												 
							indexSpaceSaver = 1											
                            WHERE type =26															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (26, 'FasTrax Exchange Mailbox', 1, 100026, '6', '0', '1',				 
	           @gpBackslashString, '300', '8192', '300', 54, 0,'FasTrax Exchange Mailbox', 1)

IF EXISTS (Select * from APP_iDAType where type = 27)												 
     UPDATE APP_idaType SET name = 'FasTrax Exchange Database', treeType = 3, appGroup1 = 100027,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '1', dirdelim = @gpBackslashString,								
							ccpType = 53,														 
							isCWEjobValid = 0,											 
							displayName = 'FasTrax Exchange Database',												 
							indexSpaceSaver = 1											
                            WHERE type =27															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (27, 'FasTrax Exchange Database', 3, 100027, '6', '0', '1',				 
	           @gpBackslashString, '300', '16384', '300', 53, 0,'FasTrax Exchange Database', 1)

IF EXISTS (Select * from APP_iDAType where type = 28)												 
     UPDATE APP_idaType SET name = 'FasTrax File System', treeType = 1, appGroup1 = 100028,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '1', dirdelim = @gpBackslashString,								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = 'FasTrax File System',												 
							indexSpaceSaver = 1											
                            WHERE type =28															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (28, 'FasTrax File System', 1, 100028, '6', '0', '1',				 
	           @gpBackslashString, '300', '8192', '300', 33, 1,'FasTrax File System', 1)

IF EXISTS (Select * from APP_iDAType where type = 29)												 
     UPDATE APP_idaType SET name = 'Linux File System', treeType = 1, appGroup1 = 100029,				 
                            casesensitivity = '1',		    			 						
                            dirorder = '1', dirdelim = '/',								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = 'File System',												 
							indexSpaceSaver = 1											
                            WHERE type =29															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (29, 'Linux File System', 1, 100029, '6', '1', '1',				 
	           '/', '300', '8192', '300', 33, 1,'File System', 1)

IF EXISTS (Select * from APP_iDAType where type = 30)												 
     UPDATE APP_idaType SET name = 'FasTrax Exchange 2000 Mailbox', treeType = 1, appGroup1 = 100030,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '1', dirdelim = @gpBackslashString,								
							ccpType = 54,														 
							isCWEjobValid = 0,											 
							displayName = 'FasTrax Exchange 2000 Mailbox',												 
							indexSpaceSaver = 1											
                            WHERE type =30															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (30, 'FasTrax Exchange 2000 Mailbox', 1, 100030, '6', '0', '1',				 
	           @gpBackslashString, '300', '8192', '300', 54, 0,'FasTrax Exchange 2000 Mailbox', 1)

IF EXISTS (Select * from APP_iDAType where type = 31)												 
     UPDATE APP_idaType SET name = 'FasTrax Exchange 2000 Database', treeType = 3, appGroup1 = 100031,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '1', dirdelim = @gpBackslashString,								
							ccpType = 53,														 
							isCWEjobValid = 0,											 
							displayName = 'FasTrax Exchange 2000 Database',												 
							indexSpaceSaver = 1											
                            WHERE type =31															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (31, 'FasTrax Exchange 2000 Database', 3, 100031, '6', '0', '1',				 
	           @gpBackslashString, '300', '16384', '300', 53, 0,'FasTrax Exchange 2000 Database', 1)

IF EXISTS (Select * from APP_iDAType where type = 32)												 
     UPDATE APP_idaType SET name = 'SharePoint Database', treeType = 3, appGroup1 = 100032,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'SharePoint Database',												 
							indexSpaceSaver = 1											
                            WHERE type =32															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (32, 'SharePoint Database', 3, 100032, '6', '0', @empty,				 
	           @empty, '300', '16384', '300', 0, 0,'SharePoint Database', 1)

IF EXISTS (Select * from APP_iDAType where type = 33)												 
     UPDATE APP_idaType SET name = 'Windows File System', treeType = 1, appGroup1 = 100033,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '1', dirdelim = @gpBackslashString,								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = 'File System',												 
							indexSpaceSaver = 1											
                            WHERE type =33															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (33, 'Windows File System', 1, 100033, '6', '0', '1',				 
	           @gpBackslashString, '300', '8192', '300', 33, 1,'File System', 1)

IF EXISTS (Select * from APP_iDAType where type = 34)												 
     UPDATE APP_idaType SET name = 'Windows XP 64-bit File System', treeType = 1, appGroup1 = 100034,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '1', dirdelim = @gpBackslashString,								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = 'File System',												 
							indexSpaceSaver = 1											
                            WHERE type =34															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (34, 'Windows XP 64-bit File System', 1, 100034, '6', '0', '1',				 
	           @gpBackslashString, '300', '8192', '300', 33, 1,'File System', 1)

IF EXISTS (Select * from APP_iDAType where type = 35)												 
     UPDATE APP_idaType SET name = 'Exchange Public Folder', treeType = 1, appGroup1 = 100035,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @exMbPubFolderDefContent,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Exchange Public Folder',												 
							indexSpaceSaver = 1											
                            WHERE type =35															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (35, 'Exchange Public Folder', 1, 100035, '6', '0', @empty,				 
	           @exMbPubFolderDefContent, '300', '8192', '300', 0, 0,'Exchange Public Folder', 1)

IF EXISTS (Select * from APP_iDAType where type = 36)												 
     UPDATE APP_idaType SET name = 'Unix Tru64 64-bit File System', treeType = 1, appGroup1 = 100036,				 
                            casesensitivity = '1',		    			 						
                            dirorder = '1', dirdelim = '/',								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = 'File System',												 
							indexSpaceSaver = 1											
                            WHERE type =36															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (36, 'Unix Tru64 64-bit File System', 1, 100036, '6', '1', '1',				 
	           '/', '300', '8192', '300', 33, 1,'File System', 1)

IF EXISTS (Select * from APP_iDAType where type = 38)												 
     UPDATE APP_idaType SET name = 'Proxy Client File System', treeType = 1, appGroup1 = 100038,				 
                            casesensitivity = '1',		    			 						
                            dirorder = '1', dirdelim = '/',								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = 'File System',												 
							indexSpaceSaver = 1											
                            WHERE type =38															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (38, 'Proxy Client File System', 1, 100038, '6', '1', '1',				 
	           '/', '300', '8192', '300', 33, 1,'File System', 1)

IF EXISTS (Select * from APP_iDAType where type = 39)												 
     UPDATE APP_idaType SET name = 'Software Data Mover', treeType = 1, appGroup1 = 100039,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 1,											 
							displayName = 'Software Data Mover',												 
							indexSpaceSaver = 1											
                            WHERE type =39															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (39, 'Software Data Mover', 1, 100039, '6', '0', @empty,				 
	           @empty, '300', '8192', '300', 0, 1,'Software Data Mover', 1)

IF EXISTS (Select * from APP_iDAType where type = 1004)												 
     UPDATE APP_idaType SET name = 'NDMP MediaAgent Client', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'NDMP Remote Tape Server',												 
							indexSpaceSaver = 1											
                            WHERE type =1004															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1004, 'NDMP MediaAgent Client', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'NDMP Remote Tape Server', 1)

IF EXISTS (Select * from APP_iDAType where type = 40)												 
     UPDATE APP_idaType SET name = 'ProxyHost on Unix', treeType = 1, appGroup1 = 100040,				 
                            casesensitivity = '1',		    			 						
                            dirorder = '1', dirdelim = '/',								
							ccpType = 0,														 
							isCWEjobValid = 1,											 
							displayName = 'ProxyHost',												 
							indexSpaceSaver = 1											
                            WHERE type =40															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (40, 'ProxyHost on Unix', 1, 100040, '6', '1', '1',				 
	           '/', '300', '8192', '300', 0, 1,'ProxyHost', 1)

IF EXISTS (Select * from APP_iDAType where type = 41)												 
     UPDATE APP_idaType SET name = 'Active Directory', treeType = 1, appGroup1 = 100041,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '2', dirdelim = ',',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Active Directory',												 
							indexSpaceSaver = 1											
                            WHERE type =41															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (41, 'Active Directory', 1, 100041, '6', '0', '2',				 
	           ',', '300', '8192', '300', 0, 0,'Active Directory', 1)

IF EXISTS (Select * from APP_iDAType where type = 1005)												 
     UPDATE APP_idaType SET name = 'Copy Manager', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Copy Manager',												 
							indexSpaceSaver = 1											
                            WHERE type =1005															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1005, 'Copy Manager', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Copy Manager', 1)

IF EXISTS (Select * from APP_iDAType where type = 1006)												 
     UPDATE APP_idaType SET name = 'EZ Browse Media Agent', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'EZ Browse Media Agent',												 
							indexSpaceSaver = 1											
                            WHERE type =1006															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1006, 'EZ Browse Media Agent', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'EZ Browse Media Agent', 1)

IF EXISTS (Select * from APP_iDAType where type = 42)												 
     UPDATE APP_idaType SET name = 'Windows 2003 32-bit File System', treeType = 1, appGroup1 = 100042,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '1', dirdelim = @gpBackslashString,								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = 'File System',												 
							indexSpaceSaver = 1											
                            WHERE type =42															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (42, 'Windows 2003 32-bit File System', 1, 100042, '6', '0', '1',				 
	           @gpBackslashString, '300', '8192', '300', 33, 1,'File System', 1)

IF EXISTS (Select * from APP_iDAType where type = 43)												 
     UPDATE APP_idaType SET name = 'Windows 2003 64-bit File System', treeType = 1, appGroup1 = 100043,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '1', dirdelim = @gpBackslashString,								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = 'File System',												 
							indexSpaceSaver = 1											
                            WHERE type =43															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (43, 'Windows 2003 64-bit File System', 1, 100043, '6', '0', '1',				 
	           @gpBackslashString, '300', '8192', '300', 33, 1,'File System', 1)

IF EXISTS (Select * from APP_iDAType where type = 44)												 
     UPDATE APP_idaType SET name = 'Exchange 2000 Web Folder', treeType = 1, appGroup1 = 100044,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @exMbPubFolderDefContent,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Exchange Web Folder',												 
							indexSpaceSaver = 1											
                            WHERE type =44															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (44, 'Exchange 2000 Web Folder', 1, 100044, '6', '0', @empty,				 
	           @exMbPubFolderDefContent, '300', '8192', '300', 0, 0,'Exchange Web Folder', 1)

IF EXISTS (Select * from APP_iDAType where type = 45)												 
     UPDATE APP_idaType SET name = 'Exchange 2000 Mailbox Archiver', treeType = 1, appGroup1 = 100045,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 53,														 
							isCWEjobValid = 1,											 
							displayName = 'Exchange Mailbox Archiver',												 
							indexSpaceSaver = 1											
                            WHERE type =45															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (45, 'Exchange 2000 Mailbox Archiver', 1, 100045, '6', '0', @empty,				 
	           @empty, '300', '8192', '300', 53, 1,'Exchange Mailbox Archiver', 1)

IF EXISTS (Select * from APP_iDAType where type = 46)												 
     UPDATE APP_idaType SET name = 'SharePoint Document', treeType = 1, appGroup1 = 100046,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @exMbPubFolderDefContent,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'SharePoint Document',												 
							indexSpaceSaver = 1											
                            WHERE type =46															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (46, 'SharePoint Document', 1, 100046, '6', '0', @empty,				 
	           @exMbPubFolderDefContent, '300', '8192', '300', 0, 0,'SharePoint Document', 1)

IF EXISTS (Select * from APP_iDAType where type = 47)												 
     UPDATE APP_idaType SET name = 'OSSV Plug-in on Windows', treeType = 1, appGroup1 = 100047,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '1', dirdelim = @gpBackslashString,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'OSSV Plug-in',												 
							indexSpaceSaver = 1											
                            WHERE type =47															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (47, 'OSSV Plug-in on Windows', 1, 100047, '6', '0', '1',				 
	           @gpBackslashString, '300', '8192', '300', 0, 0,'OSSV Plug-in', 1)

IF EXISTS (Select * from APP_iDAType where type = 48)												 
     UPDATE APP_idaType SET name = 'Serverless Data Manager on Unix', treeType = 1, appGroup1 = 100048,				 
                            casesensitivity = '1',		    			 						
                            dirorder = '1', dirdelim = '/',								
							ccpType = 0,														 
							isCWEjobValid = 1,											 
							displayName = 'Serverless Data Manager on Unix',												 
							indexSpaceSaver = 1											
                            WHERE type =48															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (48, 'Serverless Data Manager on Unix', 1, 100048, '6', '1', '1',				 
	           '/', '300', '8192', '300', 0, 1,'Serverless Data Manager on Unix', 1)

IF EXISTS (Select * from APP_iDAType where type = 1007)												 
     UPDATE APP_idaType SET name = 'CommVault Software Snapshot', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'QSnap',												 
							indexSpaceSaver = 1											
                            WHERE type =1007															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1007, 'CommVault Software Snapshot', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'QSnap', 1)

IF EXISTS (Select * from APP_iDAType where type = 49)												 
     UPDATE APP_idaType SET name = 'Unigraphics', treeType = 1, appGroup1 = 100049,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Unigraphics',												 
							indexSpaceSaver = 1											
                            WHERE type =49															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (49, 'Unigraphics', 1, 100049, '6', '0', @empty,				 
	           @empty, '300', '8192', '300', 0, 0,'Unigraphics', 1)

IF EXISTS (Select * from APP_iDAType where type = 50)												 
     UPDATE APP_idaType SET name = 'OSSV Plug-in on Unix', treeType = 1, appGroup1 = 100050,				 
                            casesensitivity = '1',		    			 						
                            dirorder = '1', dirdelim = '/',								
							ccpType = 0,														 
							isCWEjobValid = 1,											 
							displayName = 'OSSV Plug-in',												 
							indexSpaceSaver = 1											
                            WHERE type =50															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (50, 'OSSV Plug-in on Unix', 1, 100050, '6', '1', '1',				 
	           '/', '300', '8192', '300', 0, 1,'OSSV Plug-in', 1)

IF EXISTS (Select * from APP_iDAType where type = 51)												 
     UPDATE APP_idaType SET name = 'Notes Database', treeType = 3, appGroup1 = 100006,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 59,														 
							isCWEjobValid = 1,											 
							displayName = 'Notes Database',												 
							indexSpaceSaver = 1											
                            WHERE type =51															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (51, 'Notes Database', 3, 100006, '6', '0', @empty,				 
	           @empty, '300', '16384', '300', 59, 1,'Notes Database', 1)

IF EXISTS (Select * from APP_iDAType where type = 52)												 
     UPDATE APP_idaType SET name = 'Unix Notes Document', treeType = 3, appGroup1 = 100007,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 60,														 
							isCWEjobValid = 1,											 
							displayName = 'Notes Document',												 
							indexSpaceSaver = 1											
                            WHERE type =52															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (52, 'Unix Notes Document', 3, 100007, '6', '0', @empty,				 
	           @empty, '300', '8192', '300', 60, 1,'Notes Document', 1)

IF EXISTS (Select * from APP_iDAType where type = 37)												 
     UPDATE APP_idaType SET name = 'DB2', treeType = 3, appGroup1 = 100037,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'DB2',												 
							indexSpaceSaver = 1											
                            WHERE type =37															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (37, 'DB2', 3, 100037, '6', '0', @empty,				 
	           @empty, '300', '16384', '300', 0, 0,'DB2', 1)

IF EXISTS (Select * from APP_iDAType where type = 53)												 
     UPDATE APP_idaType SET name = 'Exchange Database', treeType = 3, appGroup1 = 100053,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 53,														 
							isCWEjobValid = 1,											 
							displayName = 'Exchange Database',												 
							indexSpaceSaver = 1											
                            WHERE type =53															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (53, 'Exchange Database', 3, 100053, '6', '0', @empty,				 
	           @empty, '300', '16384', '300', 53, 1,'Exchange Database', 1)

IF EXISTS (Select * from APP_iDAType where type = 54)												 
     UPDATE APP_idaType SET name = 'Exchange Mailbox (Classic)', treeType = 1, appGroup1 = 100054,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 54,														 
							isCWEjobValid = 1,											 
							displayName = 'Exchange Mailbox (Classic)',												 
							indexSpaceSaver = 1											
                            WHERE type =54															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (54, 'Exchange Mailbox (Classic)', 1, 100054, '6', '0', @empty,				 
	           @empty, '300', '8192', '300', 54, 1,'Exchange Mailbox (Classic)', 1)

IF EXISTS (Select * from APP_iDAType where type = 55)												 
     UPDATE APP_idaType SET name = 'Exchange Web Folder', treeType = 1, appGroup1 = 100055,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @exMbPubFolderDefContent,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Exchange Web Folder',												 
							indexSpaceSaver = 1											
                            WHERE type =55															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (55, 'Exchange Web Folder', 1, 100055, '6', '0', @empty,				 
	           @exMbPubFolderDefContent, '300', '8192', '300', 0, 0,'Exchange Web Folder', 1)

IF EXISTS (Select * from APP_iDAType where type = 56)												 
     UPDATE APP_idaType SET name = 'Exchange Mailbox Archiver', treeType = 1, appGroup1 = 100056,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 1,											 
							displayName = 'Exchange Mailbox Archiver',												 
							indexSpaceSaver = 1											
                            WHERE type =56															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (56, 'Exchange Mailbox Archiver', 1, 100056, '6', '0', @empty,				 
	           @empty, '300', '8192', '300', 0, 1,'Exchange Mailbox Archiver', 1)

IF EXISTS (Select * from APP_iDAType where type = 57)												 
     UPDATE APP_idaType SET name = 'Exchange 5.5 Mailbox Archiver', treeType = 1, appGroup1 = 100057,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 1,											 
							displayName = 'Exchange Mailbox Archiver',												 
							indexSpaceSaver = 1											
                            WHERE type =57															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (57, 'Exchange 5.5 Mailbox Archiver', 1, 100057, '6', '0', @empty,				 
	           @empty, '300', '8192', '300', 0, 1,'Exchange Mailbox Archiver', 1)

IF EXISTS (Select * from APP_iDAType where type = 58)												 
     UPDATE APP_idaType SET name = 'Windows File Archiver', treeType = 1, appGroup1 = 100058,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '1', dirdelim = @gpBackslashString,								
							ccpType = 58,														 
							isCWEjobValid = 1,											 
							displayName = 'File Archiver',												 
							indexSpaceSaver = 1											
                            WHERE type =58															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (58, 'Windows File Archiver', 1, 100058, '6', '0', '1',				 
	           @gpBackslashString, '300', '8192', '300', 58, 1,'File Archiver', 1)

IF EXISTS (Select * from APP_iDAType where type = 59)												 
     UPDATE APP_idaType SET name = 'Notes Database', treeType = 3, appGroup1 = 100006,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 59,														 
							isCWEjobValid = 1,											 
							displayName = 'Notes Database',												 
							indexSpaceSaver = 1											
                            WHERE type =59															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (59, 'Notes Database', 3, 100006, '6', '0', @empty,				 
	           @empty, '300', '16384', '300', 59, 1,'Notes Database', 1)

IF EXISTS (Select * from APP_iDAType where type = 60)												 
     UPDATE APP_idaType SET name = 'Notes Document', treeType = 3, appGroup1 = 100007,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 60,														 
							isCWEjobValid = 1,											 
							displayName = 'Notes Document',												 
							indexSpaceSaver = 1											
                            WHERE type =60															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (60, 'Notes Document', 3, 100007, '6', '0', @empty,				 
	           @empty, '300', '8192', '300', 60, 1,'Notes Document', 1)

IF EXISTS (Select * from APP_iDAType where type = 61)												 
     UPDATE APP_idaType SET name = 'SAP for Oracle', treeType = 3, appGroup1 = 100061,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'SAP for Oracle',												 
							indexSpaceSaver = 1											
                            WHERE type =61															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (61, 'SAP for Oracle', 3, 100061, '6', '0', @empty,				 
	           @empty, '300', '16384', '300', 0, 0,'SAP for Oracle', 1)

IF EXISTS (Select * from APP_iDAType where type = 62)												 
     UPDATE APP_idaType SET name = 'DB2 on Unix', treeType = 3, appGroup1 = 100062,				 
                            casesensitivity = '1',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'DB2',												 
							indexSpaceSaver = 1											
                            WHERE type =62															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (62, 'DB2 on Unix', 3, 100062, '6', '1', @empty,				 
	           @empty, '300', '16384', '300', 0, 0,'DB2', 1)

IF EXISTS (Select * from APP_iDAType where type = 1008)												 
     UPDATE APP_idaType SET name = 'OSSV Enabler', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'QREnabler',												 
							indexSpaceSaver = 1											
                            WHERE type =1008															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1008, 'OSSV Enabler', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'QREnabler', 1)

IF EXISTS (Select * from APP_iDAType where type = 1009)												 
     UPDATE APP_idaType SET name = 'NDMP Restore Enabler', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'NDMP Restore Enabler',												 
							indexSpaceSaver = 1											
                            WHERE type =1009															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1009, 'NDMP Restore Enabler', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'NDMP Restore Enabler', 1)

IF EXISTS (Select * from APP_iDAType where type = 1010)												 
     UPDATE APP_idaType SET name = 'Centerra', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 33,														 
							isCWEjobValid = 0,											 
							displayName = 'Centera',												 
							indexSpaceSaver = 1											
                            WHERE type =1010															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1010, 'Centerra', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 33, 0,'Centera', 1)

IF EXISTS (Select * from APP_iDAType where type = 1011)												 
     UPDATE APP_idaType SET name = 'CommCell Explorer', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'CommCell Explorer',												 
							indexSpaceSaver = 1											
                            WHERE type =1011															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1011, 'CommCell Explorer', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'CommCell Explorer', 1)

IF EXISTS (Select * from APP_iDAType where type = 1012)												 
     UPDATE APP_idaType SET name = 'SNMP Enabler', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'SNMP Enabler',												 
							indexSpaceSaver = 1											
                            WHERE type =1012															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1012, 'SNMP Enabler', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'SNMP Enabler', 1)

IF EXISTS (Select * from APP_iDAType where type = 1013)												 
     UPDATE APP_idaType SET name = 'OSSV Enabler Snap View', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'QREnabler',												 
							indexSpaceSaver = 1											
                            WHERE type =1013															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1013, 'OSSV Enabler Snap View', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'QREnabler', 1)

IF EXISTS (Select * from APP_iDAType where type = 1014)												 
     UPDATE APP_idaType SET name = 'Java Gui', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Java Gui',												 
							indexSpaceSaver = 1											
                            WHERE type =1014															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1014, 'Java Gui', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Java Gui', 1)

IF EXISTS (Select * from APP_iDAType where type = 1015)												 
     UPDATE APP_idaType SET name = 'MMC Gui', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'MMC Gui',												 
							indexSpaceSaver = 1											
                            WHERE type =1015															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1015, 'MMC Gui', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'MMC Gui', 1)

IF EXISTS (Select * from APP_iDAType where type = 64)												 
     UPDATE APP_idaType SET name = 'SGI FileSystem', treeType = 1, appGroup1 = 100064,				 
                            casesensitivity = '1',		    			 						
                            dirorder = '1', dirdelim = '/',								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = 'File System',												 
							indexSpaceSaver = 1											
                            WHERE type =64															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (64, 'SGI FileSystem', 1, 100064, '6', '1', '1',				 
	           '/', '300', '8192', '300', 33, 1,'File System', 1)

IF EXISTS (Select * from APP_iDAType where type = 65)												 
     UPDATE APP_idaType SET name = 'Image Level', treeType = 1, appGroup1 = 100065,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '1', dirdelim = @gpBackslashString,								
							ccpType = 0,														 
							isCWEjobValid = 1,											 
							displayName = 'Image Level',												 
							indexSpaceSaver = 1											
                            WHERE type =65															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (65, 'Image Level', 1, 100065, '6', '0', '1',				 
	           @gpBackslashString, '300', '8192', '300', 0, 1,'Image Level', 1)

IF EXISTS (Select * from APP_iDAType where type = 63)												 
     UPDATE APP_idaType SET name = 'MAC FileSystem', treeType = 1, appGroup1 = 100063,				 
                            casesensitivity = '1',		    			 						
                            dirorder = '1', dirdelim = '/',								
							ccpType = 0,														 
							isCWEjobValid = 1,											 
							displayName = 'File System',												 
							indexSpaceSaver = 1											
                            WHERE type =63															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (63, 'MAC FileSystem', 1, 100063, '6', '1', '1',				 
	           '/', '300', '8192', '300', 0, 1,'File System', 1)

IF EXISTS (Select * from APP_iDAType where type = 1016)												 
     UPDATE APP_idaType SET name = 'Content Indexing Engine', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Content Indexing',												 
							indexSpaceSaver = 1											
                            WHERE type =1016															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1016, 'Content Indexing Engine', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Content Indexing', 1)

IF EXISTS (Select * from APP_iDAType where type = 1017)												 
     UPDATE APP_idaType SET name = 'Echo View Enabler', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Echo View Enabler',												 
							indexSpaceSaver = 1											
                            WHERE type =1017															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1017, 'Echo View Enabler', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Echo View Enabler', 1)

IF EXISTS (Select * from APP_iDAType where type = 1018)												 
     UPDATE APP_idaType SET name = 'QNet Agent', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'QNet Agent',												 
							indexSpaceSaver = 1											
                            WHERE type =1018															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1018, 'QNet Agent', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'QNet Agent', 1)

IF EXISTS (Select * from APP_iDAType where type = 66)												 
     UPDATE APP_idaType SET name = 'Unix File Archiver', treeType = 1, appGroup1 = 100066,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '1', dirdelim = @gpBackslashString,								
							ccpType = 58,														 
							isCWEjobValid = 1,											 
							displayName = 'File Archiver',												 
							indexSpaceSaver = 1											
                            WHERE type =66															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (66, 'Unix File Archiver', 1, 100066, '6', '0', '1',				 
	           @gpBackslashString, '300', '8192', '300', 58, 1,'File Archiver', 1)

IF EXISTS (Select * from APP_iDAType where type = 1019)												 
     UPDATE APP_idaType SET name = 'Vault Tracker Enterprise', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Vault Tracker Enterprise',												 
							indexSpaceSaver = 1											
                            WHERE type =1019															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1019, 'Vault Tracker Enterprise', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Vault Tracker Enterprise', 1)

IF EXISTS (Select * from APP_iDAType where type = 1020)												 
     UPDATE APP_idaType SET name = 'Magnetic Library', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Disk Library Connector (DDO)',												 
							indexSpaceSaver = 1											
                            WHERE type =1020															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1020, 'Magnetic Library', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Disk Library Connector (DDO)', 1)

IF EXISTS (Select * from APP_iDAType where type = 1021)												 
     UPDATE APP_idaType SET name = 'Data Encryption', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Data Encryption',												 
							indexSpaceSaver = 1											
                            WHERE type =1021															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1021, 'Data Encryption', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Data Encryption', 1)

IF EXISTS (Select * from APP_iDAType where type = 1022)												 
     UPDATE APP_idaType SET name = 'Data Verification', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Data Verification',												 
							indexSpaceSaver = 1											
                            WHERE type =1022															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1022, 'Data Verification', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Data Verification', 1)

IF EXISTS (Select * from APP_iDAType where type = 1023)												 
     UPDATE APP_idaType SET name = 'Data Multiplexing', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Data Multiplexing',												 
							indexSpaceSaver = 1											
                            WHERE type =1023															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1023, 'Data Multiplexing', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Data Multiplexing', 1)

IF EXISTS (Select * from APP_iDAType where type = 1024)												 
     UPDATE APP_idaType SET name = 'Commcell Migration', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'CommCell Migration',												 
							indexSpaceSaver = 1											
                            WHERE type =1024															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1024, 'Commcell Migration', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'CommCell Migration', 1)

IF EXISTS (Select * from APP_iDAType where type = 67)												 
     UPDATE APP_idaType SET name = 'Exchange Compliance Archiver', treeType = 1, appGroup1 = 100067,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 1,											 
							displayName = 'Exchange Compliance Archiver',												 
							indexSpaceSaver = 1											
                            WHERE type =67															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (67, 'Exchange Compliance Archiver', 1, 100067, '6', '0', @empty,				 
	           @empty, '300', '8192', '300', 0, 1,'Exchange Compliance Archiver', 1)

IF EXISTS (Select * from APP_iDAType where type = 68)												 
     UPDATE APP_idaType SET name = 'Exchange 5.5 Compliance Archiver', treeType = 1, appGroup1 = 100068,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 1,											 
							displayName = 'Exchange Compliance Archiver',												 
							indexSpaceSaver = 1											
                            WHERE type =68															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (68, 'Exchange 5.5 Compliance Archiver', 1, 100068, '6', '0', @empty,				 
	           @empty, '300', '8192', '300', 0, 1,'Exchange Compliance Archiver', 1)

IF EXISTS (Select * from APP_iDAType where type = 1025)												 
     UPDATE APP_idaType SET name = 'Galaxy Compliance', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'WORM Support',												 
							indexSpaceSaver = 1											
                            WHERE type =1025															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1025, 'Galaxy Compliance', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'WORM Support', 1)

IF EXISTS (Select * from APP_iDAType where type = 1026)												 
     UPDATE APP_idaType SET name = 'Grid Store', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Grid Store',												 
							indexSpaceSaver = 1											
                            WHERE type =1026															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1026, 'Grid Store', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Grid Store', 1)

IF EXISTS (Select * from APP_iDAType where type = 1027)												 
     UPDATE APP_idaType SET name = 'Optical Enabler', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Optical Enabler',												 
							indexSpaceSaver = 1											
                            WHERE type =1027															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1027, 'Optical Enabler', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Optical Enabler', 1)

IF EXISTS (Select * from APP_iDAType where type = 69)												 
     UPDATE APP_idaType SET name = 'SharePoint Server Database', treeType = 3, appGroup1 = 100069,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'SharePoint Server Database',												 
							indexSpaceSaver = 1											
                            WHERE type =69															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (69, 'SharePoint Server Database', 3, 100069, '6', '0', @empty,				 
	           @empty, '300', '16384', '300', 0, 0,'SharePoint Server Database', 1)

IF EXISTS (Select * from APP_iDAType where type = 70)												 
     UPDATE APP_idaType SET name = 'SQL Server', treeType = 2, appGroup1 = 100004,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 81,														 
							isCWEjobValid = 0,											 
							displayName = 'SQL Server',												 
							indexSpaceSaver = 1											
                            WHERE type =70															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (70, 'SQL Server', 2, 100004, '6', '0', @empty,				 
	           @empty, '300', '16384', '300', 81, 0,'SQL Server', 1)

IF EXISTS (Select * from APP_iDAType where type = 71)												 
     UPDATE APP_idaType SET name = 'GroupWise DB', treeType = 3, appGroup1 = 100071,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'GroupWise DB',												 
							indexSpaceSaver = 1											
                            WHERE type =71															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (71, 'GroupWise DB', 3, 100071, '6', '0', @empty,				 
	           @empty, '300', '16384', '300', 0, 0,'GroupWise DB', 1)

IF EXISTS (Select * from APP_iDAType where type = 72)												 
     UPDATE APP_idaType SET name = 'Recovery Director', treeType = 1, appGroup1 = 100072,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Recovery Director',												 
							indexSpaceSaver = 1											
                            WHERE type =72															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (72, 'Recovery Director', 1, 100072, '6', '0', @empty,				 
	           @empty, '300', '8192', '300', 0, 0,'Recovery Director', 1)

IF EXISTS (Select * from APP_iDAType where type = 73)												 
     UPDATE APP_idaType SET name = 'File Share Archiver', treeType = 1, appGroup1 = 100073,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '1', dirdelim = @gpBackslashString,								
							ccpType = 58,														 
							isCWEjobValid = 1,											 
							displayName = 'File Share Archiver',												 
							indexSpaceSaver = 1											
                            WHERE type =73															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (73, 'File Share Archiver', 1, 100073, '6', '0', '1',				 
	           @gpBackslashString, '300', '8192', '300', 58, 1,'File Share Archiver', 1)

IF EXISTS (Select * from APP_iDAType where type = 1029)												 
     UPDATE APP_idaType SET name = 'Open Systems SnapVault (OSSV)', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Open Systems SnapVault (OSSV)',												 
							indexSpaceSaver = 1											
                            WHERE type =1029															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1029, 'Open Systems SnapVault (OSSV)', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Open Systems SnapVault (OSSV)', 1)

IF EXISTS (Select * from APP_iDAType where type = 74)												 
     UPDATE APP_idaType SET name = 'FreeBSD', treeType = 1, appGroup1 = 100074,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '1', dirdelim = '/',								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = 'File System',												 
							indexSpaceSaver = 1											
                            WHERE type =74															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (74, 'FreeBSD', 1, 100074, '6', '0', '1',				 
	           '/', '300', '8192', '300', 33, 1,'File System', 1)

IF EXISTS (Select * from APP_iDAType where type = 75)												 
     UPDATE APP_idaType SET name = 'Image Level On Unix', treeType = 1, appGroup1 = 100075,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '1', dirdelim = '/',								
							ccpType = 0,														 
							isCWEjobValid = 1,											 
							displayName = 'Image Level on Unix',												 
							indexSpaceSaver = 1											
                            WHERE type =75															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (75, 'Image Level On Unix', 1, 100075, '6', '0', '1',				 
	           '/', '300', '8192', '300', 0, 1,'Image Level on Unix', 1)

IF EXISTS (Select * from APP_iDAType where type = 76)												 
     UPDATE APP_idaType SET name = 'Image Level ProxyHost', treeType = 1, appGroup1 = 100076,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '1', dirdelim = @gpBackslashString,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Image Level ProxyHost',												 
							indexSpaceSaver = 1											
                            WHERE type =76															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (76, 'Image Level ProxyHost', 1, 100076, '6', '0', '1',				 
	           @gpBackslashString, '300', '8192', '300', 0, 0,'Image Level ProxyHost', 1)

IF EXISTS (Select * from APP_iDAType where type = 1031)												 
     UPDATE APP_idaType SET name = 'ONTAP support for SnapVault', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'ONTAP support for SnapVault',												 
							indexSpaceSaver = 1											
                            WHERE type =1031															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1031, 'ONTAP support for SnapVault', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'ONTAP support for SnapVault', 1)

IF EXISTS (Select * from APP_iDAType where type = 77)												 
     UPDATE APP_idaType SET name = 'Unix Notes Database', treeType = 3, appGroup1 = 100006,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 59,														 
							isCWEjobValid = 1,											 
							displayName = 'Notes Database',												 
							indexSpaceSaver = 1											
                            WHERE type =77															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (77, 'Unix Notes Database', 3, 100006, '6', '0', @empty,				 
	           @empty, '300', '16384', '300', 59, 1,'Notes Database', 1)

IF EXISTS (Select * from APP_iDAType where type = 78)												 
     UPDATE APP_idaType SET name = 'SharePoint Server', treeType = 1, appGroup1 = 100078,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @exMbPubFolderDefContent,								
							ccpType = 78,														 
							isCWEjobValid = 1,											 
							displayName = 'Sharepoint Server',												 
							indexSpaceSaver = 1											
                            WHERE type =78															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (78, 'SharePoint Server', 1, 100078, '6', '0', @empty,				 
	           @exMbPubFolderDefContent, '300', '8192', '300', 78, 1,'Sharepoint Server', 1)

IF EXISTS (Select * from APP_iDAType where type = 1032)												 
     UPDATE APP_idaType SET name = '1-Touch Server for Unix', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = '1-Touch Server for Unix',												 
							indexSpaceSaver = 1											
                            WHERE type =1032															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1032, '1-Touch Server for Unix', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'1-Touch Server for Unix', 1)

IF EXISTS (Select * from APP_iDAType where type = 1030)												 
     UPDATE APP_idaType SET name = 'Subclient Policy', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Subclient Policy',												 
							indexSpaceSaver = 1											
                            WHERE type =1030															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1030, 'Subclient Policy', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Subclient Policy', 1)

IF EXISTS (Select * from APP_iDAType where type = 79)												 
     UPDATE APP_idaType SET name = 'SAP for MAX DB', treeType = 3, appGroup1 = 100079,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'SAP for MAX DB',												 
							indexSpaceSaver = 1											
                            WHERE type =79															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (79, 'SAP for MAX DB', 3, 100079, '6', '0', @empty,				 
	           @empty, '300', '16384', '300', 0, 0,'SAP for MAX DB', 1)

IF EXISTS (Select * from APP_iDAType where type = 1035)												 
     UPDATE APP_idaType SET name = 'Content Addressed Storage', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Content Addressed Storage',												 
							indexSpaceSaver = 1											
                            WHERE type =1035															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1035, 'Content Addressed Storage', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Content Addressed Storage', 1)

IF EXISTS (Select * from APP_iDAType where type = 1036)												 
     UPDATE APP_idaType SET name = 'DVD Support', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'DVD Support',												 
							indexSpaceSaver = 1											
                            WHERE type =1036															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1036, 'DVD Support', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'DVD Support', 1)

IF EXISTS (Select * from APP_iDAType where type = 1037)												 
     UPDATE APP_idaType SET name = 'UDO Support', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'UDO Support',												 
							indexSpaceSaver = 1											
                            WHERE type =1037															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1037, 'UDO Support', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'UDO Support', 1)

IF EXISTS (Select * from APP_iDAType where type = 1038)												 
     UPDATE APP_idaType SET name = 'CommCell Readiness Check', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'CommCell Readiness Check',												 
							indexSpaceSaver = 1											
                            WHERE type =1038															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1038, 'CommCell Readiness Check', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'CommCell Readiness Check', 1)

IF EXISTS (Select * from APP_iDAType where type = 1039)												 
     UPDATE APP_idaType SET name = 'Advanced FileSystem iDA Options', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Advanced FileSystem iDA Options',												 
							indexSpaceSaver = 1											
                            WHERE type =1039															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1039, 'Advanced FileSystem iDA Options', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Advanced FileSystem iDA Options', 1)

IF EXISTS (Select * from APP_iDAType where type = 1040)												 
     UPDATE APP_idaType SET name = '1-Touch Server for Windows', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = '1-Touch Server for Windows',												 
							indexSpaceSaver = 1											
                            WHERE type =1040															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1040, '1-Touch Server for Windows', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'1-Touch Server for Windows', 1)

IF EXISTS (Select * from APP_iDAType where type = 1041)												 
     UPDATE APP_idaType SET name = 'Erase Data', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Erase Data',												 
							indexSpaceSaver = 1											
                            WHERE type =1041															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1041, 'Erase Data', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Erase Data', 1)

IF EXISTS (Select * from APP_iDAType where type = 1042)												 
     UPDATE APP_idaType SET name = 'Client Groups', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Client Groups',												 
							indexSpaceSaver = 1											
                            WHERE type =1042															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1042, 'Client Groups', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Client Groups', 1)

IF EXISTS (Select * from APP_iDAType where type = 1043)												 
     UPDATE APP_idaType SET name = 'FileSystem Accelerator', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'FileSystem Accelerator',												 
							indexSpaceSaver = 1											
                            WHERE type =1043															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1043, 'FileSystem Accelerator', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'FileSystem Accelerator', 1)

IF EXISTS (Select * from APP_iDAType where type = 1044)												 
     UPDATE APP_idaType SET name = 'Dynamic Mount Path Sharing', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Dynamic Mount Path Sharing',												 
							indexSpaceSaver = 1											
                            WHERE type =1044															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1044, 'Dynamic Mount Path Sharing', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Dynamic Mount Path Sharing', 1)

IF EXISTS (Select * from APP_iDAType where type = 1045)												 
     UPDATE APP_idaType SET name = 'Unix Base Package', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Unix Base Package',												 
							indexSpaceSaver = 1											
                            WHERE type =1045															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1045, 'Unix Base Package', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Unix Base Package', 1)

IF EXISTS (Select * from APP_iDAType where type = 1046)												 
     UPDATE APP_idaType SET name = 'Unix Copy Manager', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Unix Copy Manager',												 
							indexSpaceSaver = 1											
                            WHERE type =1046															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1046, 'Unix Copy Manager', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Unix Copy Manager', 1)

IF EXISTS (Select * from APP_iDAType where type = 1047)												 
     UPDATE APP_idaType SET name = 'Unix Block Filter', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Unix Block Filter',												 
							indexSpaceSaver = 1											
                            WHERE type =1047															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1047, 'Unix Block Filter', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Unix Block Filter', 1)

IF EXISTS (Select * from APP_iDAType where type = 1048)												 
     UPDATE APP_idaType SET name = 'Unix NAS iDataAgent', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Unix NAS iDataAgent',												 
							indexSpaceSaver = 1											
                            WHERE type =1048															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1048, 'Unix NAS iDataAgent', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Unix NAS iDataAgent', 1)

IF EXISTS (Select * from APP_iDAType where type = 1049)												 
     UPDATE APP_idaType SET name = 'Galaxy SCSI Driver', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Galaxy SCSI Driver',												 
							indexSpaceSaver = 1											
                            WHERE type =1049															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1049, 'Galaxy SCSI Driver', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Galaxy SCSI Driver', 1)

IF EXISTS (Select * from APP_iDAType where type = 1050)												 
     UPDATE APP_idaType SET name = 'Unused Apple MAC', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Unused Apple MAC',												 
							indexSpaceSaver = 1											
                            WHERE type =1050															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1050, 'Unused Apple MAC', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Unused Apple MAC', 1)

IF EXISTS (Select * from APP_iDAType where type = 1051)												 
     UPDATE APP_idaType SET name = 'Unused for Apple MAC', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Unused for Apple MAC',												 
							indexSpaceSaver = 1											
                            WHERE type =1051															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1051, 'Unused for Apple MAC', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Unused for Apple MAC', 1)

IF EXISTS (Select * from APP_iDAType where type = 1033)												 
     UPDATE APP_idaType SET name = '1-Touch Server for Unix', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = '1-Touch Server for Unix',												 
							indexSpaceSaver = 1											
                            WHERE type =1033															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1033, '1-Touch Server for Unix', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'1-Touch Server for Unix', 1)

IF EXISTS (Select * from APP_iDAType where type = 1052)												 
     UPDATE APP_idaType SET name = 'Advanced Copy Features', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Advanced Copy Features',												 
							indexSpaceSaver = 1											
                            WHERE type =1052															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1052, 'Advanced Copy Features', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Advanced Copy Features', 1)

IF EXISTS (Select * from APP_iDAType where type = 1053)												 
     UPDATE APP_idaType SET name = 'Advanced Media Management Features', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Advanced Media Management Features',												 
							indexSpaceSaver = 1											
                            WHERE type =1053															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1053, 'Advanced Media Management Features', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Advanced Media Management Features', 1)

IF EXISTS (Select * from APP_iDAType where type = 80)												 
     UPDATE APP_idaType SET name = 'Oracle RAC', treeType = 1, appGroup1 = 100080,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Oracle RAC',												 
							indexSpaceSaver = 1											
                            WHERE type =80															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (80, 'Oracle RAC', 1, 100080, '6', '0', @empty,				 
	           @empty, '300', '16384', '300', 0, 0,'Oracle RAC', 1)

IF EXISTS (Select * from APP_iDAType where type = 81)												 
     UPDATE APP_idaType SET name = 'SQL Server', treeType = 1, appGroup1 = 100004,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 81,														 
							isCWEjobValid = 0,											 
							displayName = 'SQL Server',												 
							indexSpaceSaver = 1											
                            WHERE type =81															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (81, 'SQL Server', 1, 100004, '6', '0', @empty,				 
	           @empty, '300', '16384', '300', 81, 0,'SQL Server', 1)

IF EXISTS (Select * from APP_iDAType where type = 82)												 
     UPDATE APP_idaType SET name = 'Exchange PF Archiver', treeType = 1, appGroup1 = 100082,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @exMbPubFolderDefContent,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Exchange PF Archiver',												 
							indexSpaceSaver = 1											
                            WHERE type =82															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (82, 'Exchange PF Archiver', 1, 100082, '6', '0', @empty,				 
	           @exMbPubFolderDefContent, '300', '8192', '300', 0, 0,'Exchange PF Archiver', 1)

IF EXISTS (Select * from APP_iDAType where type = 83)												 
     UPDATE APP_idaType SET name = 'NetWare File Archiver', treeType = 1, appGroup1 = 100083,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '1', dirdelim = @gpBackslashString,								
							ccpType = 12,														 
							isCWEjobValid = 1,											 
							displayName = 'File Archiver',												 
							indexSpaceSaver = 1											
                            WHERE type =83															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (83, 'NetWare File Archiver', 1, 100083, '6', '0', '1',				 
	           @gpBackslashString, '300', '8192', '300', 12, 1,'File Archiver', 1)

IF EXISTS (Select * from APP_iDAType where type = 84)												 
     UPDATE APP_idaType SET name = 'Continuous Data Replicator', treeType = 1, appGroup1 = 100084,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Continuous Data Replicator',												 
							indexSpaceSaver = 1											
                            WHERE type =84															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (84, 'Continuous Data Replicator', 1, 100084, '6', '0', @empty,				 
	           @empty, '300', '8192', '300', 0, 0,'Continuous Data Replicator', 1)

IF EXISTS (Select * from APP_iDAType where type = 85)												 
     UPDATE APP_idaType SET name = 'Data Classification', treeType = 1, appGroup1 = 100085,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '1', dirdelim = '/',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Data Classification Enabler',												 
							indexSpaceSaver = 1											
                            WHERE type =85															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (85, 'Data Classification', 1, 100085, '6', '0', '1',				 
	           '/', '300', '8192', '300', 0, 0,'Data Classification Enabler', 1)

IF EXISTS (Select * from APP_iDAType where type = 86)												 
     UPDATE APP_idaType SET name = 'OES File System on Linux', treeType = 1, appGroup1 = 100086,				 
                            casesensitivity = '1',		    			 						
                            dirorder = '1', dirdelim = @gpBackslashString,								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = 'OES File System',												 
							indexSpaceSaver = 1											
                            WHERE type =86															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (86, 'OES File System on Linux', 1, 100086, '6', '1', '1',				 
	           @gpBackslashString, '300', '8192', '300', 33, 1,'OES File System', 1)

IF EXISTS (Select * from APP_iDAType where type = 87)												 
     UPDATE APP_idaType SET name = 'Image Level ProxyHost on Unix', treeType = 1, appGroup1 = 100087,				 
                            casesensitivity = '1',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Image Level ProxyHost on Unix',												 
							indexSpaceSaver = 1											
                            WHERE type =87															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (87, 'Image Level ProxyHost on Unix', 1, 100087, '6', '1', @empty,				 
	           @empty, '300', '8192', '300', 0, 0,'Image Level ProxyHost on Unix', 1)

IF EXISTS (Select * from APP_iDAType where type = 88)												 
     UPDATE APP_idaType SET name = 'Centera', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 33,														 
							isCWEjobValid = 0,											 
							displayName = 'Centera',												 
							indexSpaceSaver = 1											
                            WHERE type =88															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (88, 'Centera', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 33, 0,'Centera', 1)

IF EXISTS (Select * from APP_iDAType where type = 1055)												 
     UPDATE APP_idaType SET name = 'NDMP Tape Server', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'NDMP Tape Server',												 
							indexSpaceSaver = 1											
                            WHERE type =1055															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1055, 'NDMP Tape Server', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'NDMP Tape Server', 1)

IF EXISTS (Select * from APP_iDAType where type = 1056)												 
     UPDATE APP_idaType SET name = 'Vault Tracker', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Vault Tracker',												 
							indexSpaceSaver = 1											
                            WHERE type =1056															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1056, 'Vault Tracker', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Vault Tracker', 1)

IF EXISTS (Select * from APP_iDAType where type = 1059)												 
     UPDATE APP_idaType SET name = 'Recovery Points', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Recovery Points',												 
							indexSpaceSaver = 1											
                            WHERE type =1059															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1059, 'Recovery Points', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Recovery Points', 1)

IF EXISTS (Select * from APP_iDAType where type = 1061)												 
     UPDATE APP_idaType SET name = 'Open File Handler', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'QSnap',												 
							indexSpaceSaver = 1											
                            WHERE type =1061															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1061, 'Open File Handler', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'QSnap', 1)

IF EXISTS (Select * from APP_iDAType where type = 1062)												 
     UPDATE APP_idaType SET name = 'CommServe Database', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'CommServe Database',												 
							indexSpaceSaver = 1											
                            WHERE type =1062															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1062, 'CommServe Database', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'CommServe Database', 1)

IF EXISTS (Select * from APP_iDAType where type = 1060)												 
     UPDATE APP_idaType SET name = 'QNET Agent DB on CommServer', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'QNET Agent DB on CommServer',												 
							indexSpaceSaver = 1											
                            WHERE type =1060															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1060, 'QNET Agent DB on CommServer', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'QNET Agent DB on CommServer', 1)

IF EXISTS (Select * from APP_iDAType where type = 89)												 
     UPDATE APP_idaType SET name = 'MS SharePoint Archiver', treeType = 3, appGroup1 = 100089,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 89,														 
							isCWEjobValid = 0,											 
							displayName = 'MS Sharepoint Archiver',												 
							indexSpaceSaver = 1											
                            WHERE type =89															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (89, 'MS SharePoint Archiver', 3, 100089, '6', '0', @empty,				 
	           @empty, '300', '16384', '300', 89, 0,'MS Sharepoint Archiver', 1)

IF EXISTS (Select * from APP_iDAType where type = 90)												 
     UPDATE APP_idaType SET name = 'Domino Mailbox Archiver', treeType = 3, appGroup1 = 100090,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 1,											 
							displayName = 'Domino Mailbox Archiver',												 
							indexSpaceSaver = 1											
                            WHERE type =90															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (90, 'Domino Mailbox Archiver', 3, 100090, '6', '0', @empty,				 
	           @empty, '300', '16384', '300', 0, 1,'Domino Mailbox Archiver', 1)

IF EXISTS (Select * from APP_iDAType where type = 91)												 
     UPDATE APP_idaType SET name = 'DPM', treeType = 1, appGroup1 = 100091,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '1', dirdelim = @gpBackslashString,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'DPM',												 
							indexSpaceSaver = 1											
                            WHERE type =91															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (91, 'DPM', 1, 100091, '6', '0', '1',				 
	           @gpBackslashString, '300', '8192', '300', 0, 0,'DPM', 1)

IF EXISTS (Select * from APP_iDAType where type = 1064)												 
     UPDATE APP_idaType SET name = 'Content Index Server', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Content Indexing Engine',												 
							indexSpaceSaver = 1											
                            WHERE type =1064															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1064, 'Content Index Server', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Content Indexing Engine', 1)

IF EXISTS (Select * from APP_iDAType where type = 1065)												 
     UPDATE APP_idaType SET name = 'Online Content Indexing', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Online Content Indexing',												 
							indexSpaceSaver = 1											
                            WHERE type =1065															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1065, 'Online Content Indexing', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Online Content Indexing', 1)

IF EXISTS (Select * from APP_iDAType where type = 1066)												 
     UPDATE APP_idaType SET name = 'Filer Snapshot', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Network Appliance Snapshot Enabler',												 
							indexSpaceSaver = 1											
                            WHERE type =1066															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1066, 'Filer Snapshot', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Network Appliance Snapshot Enabler', 1)

IF EXISTS (Select * from APP_iDAType where type = 93)												 
     UPDATE APP_idaType SET name = 'Content Indexing Agent', treeType = 1, appGroup1 = 100093,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '1', dirdelim = @gpBackslashString,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Online Content Indexing',												 
							indexSpaceSaver = 1											
                            WHERE type =93															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (93, 'Content Indexing Agent', 1, 100093, '6', '0', '1',				 
	           @gpBackslashString, '300', '8192', '300', 0, 0,'Online Content Indexing', 1)

	---------------	

IF EXISTS (Select * from APP_iDAType where type = 1067)												 
     UPDATE APP_idaType SET name = 'File Replication Driver', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'File Replication Driver',												 
							indexSpaceSaver = 1											
                            WHERE type =1067															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1067, 'File Replication Driver', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'File Replication Driver', 1)

IF EXISTS (Select * from APP_iDAType where type = 1068)												 
     UPDATE APP_idaType SET name = 'FSDM Driver', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'FSDM Driver',												 
							indexSpaceSaver = 1											
                            WHERE type =1068															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1068, 'FSDM Driver', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'FSDM Driver', 1)

IF EXISTS (Select * from APP_iDAType where type = 1069)												 
     UPDATE APP_idaType SET name = 'OSSV VSS Provider', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'OSSV VSS Provider',												 
							indexSpaceSaver = 1											
                            WHERE type =1069															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1069, 'OSSV VSS Provider', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'OSSV VSS Provider', 1)

IF EXISTS (Select * from APP_iDAType where type = 1070)												 
     UPDATE APP_idaType SET name = 'Desktop Search Server', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Desktop Search Server',												 
							indexSpaceSaver = 1											
                            WHERE type =1070															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1070, 'Desktop Search Server', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Desktop Search Server', 1)

IF EXISTS (Select * from APP_iDAType where type = 1071)												 
     UPDATE APP_idaType SET name = 'CDR VSS Provider', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'CDR VSS Provider',												 
							indexSpaceSaver = 1											
                            WHERE type =1071															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1071, 'CDR VSS Provider', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'CDR VSS Provider', 1)

IF EXISTS (Select * from APP_iDAType where type = 1072)												 
     UPDATE APP_idaType SET name = 'Shared Dynamic Disk', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Shared Dynamic Disk',												 
							indexSpaceSaver = 1											
                            WHERE type =1072															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1072, 'Shared Dynamic Disk', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Shared Dynamic Disk', 1)

IF EXISTS (Select * from APP_iDAType where type = 1073)												 
     UPDATE APP_idaType SET name = 'Active Directory Signon', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Active Directory Signon',												 
							indexSpaceSaver = 1											
                            WHERE type =1073															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1073, 'Active Directory Signon', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Active Directory Signon', 1)

IF EXISTS (Select * from APP_iDAType where type = 1074)												 
     UPDATE APP_idaType SET name = 'Desktop Search Server Database', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Desktop Search Server Database',												 
							indexSpaceSaver = 1											
                            WHERE type =1074															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1074, 'Desktop Search Server Database', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Desktop Search Server Database', 1)

		/*

IF EXISTS (Select * from APP_iDAType where type = {0})												 
     UPDATE APP_idaType SET name = {1}, treeType = {2}, appGroup1 = {3},				 
                            casesensitivity = {5},		    			 						
                            dirorder = {6}, dirdelim = {7},								
							ccpType = {11},														 
							isCWEjobValid = {12},											 
							displayName = {13},												 
							indexSpaceSaver = {14}											
                            WHERE type ={0}															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES ({0}, {1}, {2}, {3}, {4}, {5}, {6},				 
	           {7}, {8}, {9}, {10}, {11}, {12},{13}, {14})

		*/

IF EXISTS (Select * from APP_iDAType where type = 1075)												 
     UPDATE APP_idaType SET name = 'Compliance Search', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Compliance Search',												 
							indexSpaceSaver = 1											
                            WHERE type =1075															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1075, 'Compliance Search', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Compliance Search', 1)

IF EXISTS (Select * from APP_iDAType where type = 1076)												 
     UPDATE APP_idaType SET name = 'Single Instance Store', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Data De-Duplication Enabler',												 
							indexSpaceSaver = 1											
                            WHERE type =1076															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1076, 'Single Instance Store', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Data De-Duplication Enabler', 1)

IF EXISTS (Select * from APP_iDAType where type = 1077)												 
     UPDATE APP_idaType SET name = 'Auxiliary Copy Encryption', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Auxiliary Copy Encryption',												 
							indexSpaceSaver = 1											
                            WHERE type =1077															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1077, 'Auxiliary Copy Encryption', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Auxiliary Copy Encryption', 1)

IF EXISTS (Select * from APP_iDAType where type = 120)												 
     UPDATE APP_idaType SET name = 'SharePoint Search Connector', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'SharePoint Search Connector',												 
							indexSpaceSaver = 1											
                            WHERE type =120															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (120, 'SharePoint Search Connector', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'SharePoint Search Connector', 1)

IF EXISTS (Select * from APP_iDAType where type = 1078)												 
     UPDATE APP_idaType SET name = 'OWA Proxy Enabler', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'MS Outlook Web Access Proxy',												 
							indexSpaceSaver = 1											
                            WHERE type =1078															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1078, 'OWA Proxy Enabler', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'MS Outlook Web Access Proxy', 1)

IF EXISTS (Select * from APP_iDAType where type = 1082)												 
     UPDATE APP_idaType SET name = 'SRM Services', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'SRM Services',												 
							indexSpaceSaver = 1											
                            WHERE type =1082															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1082, 'SRM Services', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'SRM Services', 1)

IF EXISTS (Select * from APP_iDAType where type = 1080)												 
     UPDATE APP_idaType SET name = 'SRM Services DB', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'SRM Services DB',												 
							indexSpaceSaver = 1											
                            WHERE type =1080															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1080, 'SRM Services DB', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'SRM Services DB', 1)

IF EXISTS (Select * from APP_iDAType where type = 600)												 
     UPDATE APP_idaType SET name = 'SRM Agent For Windows File Systems', treeType = 3, appGroup1 = 100600,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '1', dirdelim = @gpBackslashString,								
							ccpType = 0,														 
							isCWEjobValid = 1,											 
							displayName = 'SRM for Windows File Systems',												 
							indexSpaceSaver = 1											
                            WHERE type =600															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (600, 'SRM Agent For Windows File Systems', 3, 100600, '6', '0', '1',				 
	           @gpBackslashString, '300', '8192', '300', 0, 1,'SRM for Windows File Systems', 1)

IF EXISTS (Select * from APP_iDAType where type = 601)												 
     UPDATE APP_idaType SET name = 'SRM Agent For Oracle', treeType = 3, appGroup1 = 100601,				 
                            casesensitivity = '1',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'SRM for Oracle',												 
							indexSpaceSaver = 1											
                            WHERE type =601															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (601, 'SRM Agent For Oracle', 3, 100601, '6', '1', @empty,				 
	           @empty, '300', '8192', '300', 0, 0,'SRM for Oracle', 1)

IF EXISTS (Select * from APP_iDAType where type = 602)												 
     UPDATE APP_idaType SET name = 'SRM Agent For SQL Server', treeType = 3, appGroup1 = 100602,				 
                            casesensitivity = '1',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'SRM for SQL Server',												 
							indexSpaceSaver = 1											
                            WHERE type =602															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (602, 'SRM Agent For SQL Server', 3, 100602, '6', '1', @empty,				 
	           @empty, '300', '8192', '300', 0, 0,'SRM for SQL Server', 1)

IF EXISTS (Select * from APP_iDAType where type = 603)												 
     UPDATE APP_idaType SET name = 'SRM Agent For Network Attached Storage', treeType = 3, appGroup1 = 100603,				 
                            casesensitivity = '1',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 1,											 
							displayName = 'SRM for Network Attached Storage',												 
							indexSpaceSaver = 1											
                            WHERE type =603															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (603, 'SRM Agent For Network Attached Storage', 3, 100603, '6', '1', @empty,				 
	           @empty, '300', '8192', '300', 0, 1,'SRM for Network Attached Storage', 1)

IF EXISTS (Select * from APP_iDAType where type = 604)												 
     UPDATE APP_idaType SET name = 'SRM Agent For NetWare', treeType = 3, appGroup1 = 100604,				 
                            casesensitivity = '1',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 1,											 
							displayName = 'SRM for Netware',												 
							indexSpaceSaver = 1											
                            WHERE type =604															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (604, 'SRM Agent For NetWare', 3, 100604, '6', '1', @empty,				 
	           @empty, '300', '8192', '300', 0, 1,'SRM for Netware', 1)

IF EXISTS (Select * from APP_iDAType where type = 605)												 
     UPDATE APP_idaType SET name = 'SRM Agent For UNIX File Systems', treeType = 3, appGroup1 = 100605,				 
                            casesensitivity = '1',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 1,											 
							displayName = 'SRM for UNIX File Systems',												 
							indexSpaceSaver = 1											
                            WHERE type =605															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (605, 'SRM Agent For UNIX File Systems', 3, 100605, '6', '1', @empty,				 
	           @empty, '300', '8192', '300', 0, 1,'SRM for UNIX File Systems', 1)

IF EXISTS (Select * from APP_iDAType where type = 606)												 
     UPDATE APP_idaType SET name = 'SRM Agent For Exchange', treeType = 3, appGroup1 = 100606,				 
                            casesensitivity = '1',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'SRM for Exchange',												 
							indexSpaceSaver = 1											
                            WHERE type =606															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (606, 'SRM Agent For Exchange', 3, 100606, '6', '1', @empty,				 
	           @empty, '300', '8192', '300', 0, 0,'SRM for Exchange', 1)

IF EXISTS (Select * from APP_iDAType where type = 607)												 
     UPDATE APP_idaType SET name = 'SRM Agent For SharePoint', treeType = 3, appGroup1 = 100607,				 
                            casesensitivity = '1',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'SRM for Sharepoint',												 
							indexSpaceSaver = 1											
                            WHERE type =607															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (607, 'SRM Agent For SharePoint', 3, 100607, '6', '1', @empty,				 
	           @empty, '300', '8192', '300', 0, 0,'SRM for Sharepoint', 1)

IF EXISTS (Select * from APP_iDAType where type = 1081)												 
     UPDATE APP_idaType SET name = 'Proxy File Share Archiver', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Proxy File Share Archiver',												 
							indexSpaceSaver = 1											
                            WHERE type =1081															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1081, 'Proxy File Share Archiver', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Proxy File Share Archiver', 1)

IF EXISTS (Select * from APP_iDAType where type = 1083)												 
     UPDATE APP_idaType SET name = 'Media Explorer', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Media Explorer',												 
							indexSpaceSaver = 1											
                            WHERE type =1083															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1083, 'Media Explorer', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Media Explorer', 1)

IF EXISTS (Select * from APP_iDAType where type = 1079)												 
     UPDATE APP_idaType SET name = 'Legal Hold', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Legal Hold',												 
							indexSpaceSaver = 1											
                            WHERE type =1079															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1079, 'Legal Hold', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Legal Hold', 1)

IF EXISTS (Select * from APP_iDAType where type = 103)												 
     UPDATE APP_idaType SET name = 'DB2 MultiNode', treeType = 3, appGroup1 = 100103,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'DB2 MultiNode',												 
							indexSpaceSaver = 1											
                            WHERE type =103															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (103, 'DB2 MultiNode', 3, 100103, '6', '0', @empty,				 
	           @empty, '300', '16384', '300', 0, 0,'DB2 MultiNode', 1)

IF EXISTS (Select * from APP_iDAType where type = 104)												 
     UPDATE APP_idaType SET name = 'MySQL', treeType = 3, appGroup1 = 100104,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '1', dirdelim = '/',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'MySQL',												 
							indexSpaceSaver = 1											
                            WHERE type =104															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (104, 'MySQL', 3, 100104, '0', '0', '1',				 
	           '/', '300', '16384', '300', 0, 0,'MySQL', 1)

IF EXISTS (Select * from APP_iDAType where type = 106)												 
     UPDATE APP_idaType SET name = 'Virtual Server', treeType = 1, appGroup1 = 100106,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '1', dirdelim = @gpBackslashString,								
							ccpType = 0,														 
							isCWEjobValid = 1,											 
							displayName = 'Virtual Server',												 
							indexSpaceSaver = 1											
                            WHERE type =106															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (106, 'Virtual Server', 1, 100106, '6', '0', '1',				 
	           @gpBackslashString, '300', '8192', '300', 0, 1,'Virtual Server', 1)

IF EXISTS (Select * from APP_iDAType where type = 105)												 
     UPDATE APP_idaType SET name = 'CI For Exchange Mailbox', treeType = 1, appGroup1 = 100105,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'CI for Exchange',												 
							indexSpaceSaver = 1											
                            WHERE type =105															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (105, 'CI For Exchange Mailbox', 1, 100105, '6', '0', @empty,				 
	           @empty, '300', '8192', '300', 0, 0,'CI for Exchange', 1)

IF EXISTS (Select * from APP_iDAType where type = 107)												 
     UPDATE APP_idaType SET name = 'Workstation Backup', treeType = 1, appGroup1 = 100107,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Workstation Backup',												 
							indexSpaceSaver = 1											
                            WHERE type =107															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (107, 'Workstation Backup', 1, 100107, '6', '0', @empty,				 
	           @empty, '300', '8192', '300', 0, 0,'Workstation Backup', 1)

IF EXISTS (Select * from APP_iDAType where type = 1090)												 
     UPDATE APP_idaType SET name = 'Workstation Backup Policy', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Workstation Backup Policy',												 
							indexSpaceSaver = 1											
                            WHERE type =1090															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1090, 'Workstation Backup Policy', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Workstation Backup Policy', 1)

IF EXISTS (Select * from APP_iDAType where type = 1084)												 
     UPDATE APP_idaType SET name = 'Unix Base Zero Package', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Unix Base Zero Package',												 
							indexSpaceSaver = 1											
                            WHERE type =1084															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1084, 'Unix Base Zero Package', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Unix Base Zero Package', 1)

IF EXISTS (Select * from APP_iDAType where type = 1085)												 
     UPDATE APP_idaType SET name = 'Unix File Replication Driver', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Unix File Replication Driver',												 
							indexSpaceSaver = 1											
                            WHERE type =1085															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1085, 'Unix File Replication Driver', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Unix File Replication Driver', 1)

IF EXISTS (Select * from APP_iDAType where type = 1089)												 
     UPDATE APP_idaType SET name = 'Offline Mining Sharepoint Tool', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Offline Mining Enabler for SharePoint',												 
							indexSpaceSaver = 1											
                            WHERE type =1089															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1089, 'Offline Mining Sharepoint Tool', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Offline Mining Enabler for SharePoint', 1)

IF EXISTS (Select * from APP_iDAType where type = 1086)												 
     UPDATE APP_idaType SET name = 'Offline Mining Exhange Admin Tool', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Offline Mining Exhange Admin Tool',												 
							indexSpaceSaver = 1											
                            WHERE type =1086															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1086, 'Offline Mining Exhange Admin Tool', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Offline Mining Exhange Admin Tool', 1)

IF EXISTS (Select * from APP_iDAType where type = 1087)												 
     UPDATE APP_idaType SET name = 'Offline Mining Exhange User Tool', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Offline Mining Enabler for Exchange',												 
							indexSpaceSaver = 1											
                            WHERE type =1087															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1087, 'Offline Mining Exhange User Tool', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Offline Mining Enabler for Exchange', 1)

IF EXISTS (Select * from APP_iDAType where type = 1091)												 
     UPDATE APP_idaType SET name = 'Office Communication Server', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Office Communications Server',												 
							indexSpaceSaver = 1											
                            WHERE type =1091															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1091, 'Office Communication Server', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Office Communications Server', 1)

IF EXISTS (Select * from APP_iDAType where type = 1092)												 
     UPDATE APP_idaType SET name = 'Snap Backup', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Hardware Snapshot Enabler',												 
							indexSpaceSaver = 1											
                            WHERE type =1092															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1092, 'Snap Backup', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Hardware Snapshot Enabler', 1)

IF EXISTS (Select * from APP_iDAType where type = 650)												 
     UPDATE APP_idaType SET name = 'SRM Proxy Agent for Oracle', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'SRM Proxy Agent for Oracle',												 
							indexSpaceSaver = 1											
                            WHERE type =650															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (650, 'SRM Proxy Agent for Oracle', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'SRM Proxy Agent for Oracle', 1)

IF EXISTS (Select * from APP_iDAType where type = 651)												 
     UPDATE APP_idaType SET name = 'SRM Proxy Agent for NAS', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'SRM Proxy Agent for NAS',												 
							indexSpaceSaver = 1											
                            WHERE type =651															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (651, 'SRM Proxy Agent for NAS', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'SRM Proxy Agent for NAS', 1)

IF EXISTS (Select * from APP_iDAType where type = 652)												 
     UPDATE APP_idaType SET name = 'SRM Proxy Agent for Netware', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'SRM Proxy Agent for Netware',												 
							indexSpaceSaver = 1											
                            WHERE type =652															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (652, 'SRM Proxy Agent for Netware', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'SRM Proxy Agent for Netware', 1)

IF EXISTS (Select * from APP_iDAType where type = 1098)												 
     UPDATE APP_idaType SET name = 'Microsoft Office Sharepoint Server', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'ERM Connector',												 
							indexSpaceSaver = 1											
                            WHERE type =1098															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1098, 'Microsoft Office Sharepoint Server', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'ERM Connector', 1)

--'CV_APPTYPE_EXCHANGE_DM_WEB_PROXY' is an older pseudo appType, but for some reason never added to this table.

IF EXISTS (Select * from APP_iDAType where type = 1063)												 
     UPDATE APP_idaType SET name = 'DM Web Proxy', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'DM Web Proxy',												 
							indexSpaceSaver = 1											
                            WHERE type =1063															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1063, 'DM Web Proxy', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'DM Web Proxy', 1)

IF EXISTS (Select * from APP_iDAType where type = 1099)												 
     UPDATE APP_idaType SET name = 'AD offline Enabler', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Offline Mining Enabler for Active Directory',												 
							indexSpaceSaver = 1											
                            WHERE type =1099															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1099, 'AD offline Enabler', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Offline Mining Enabler for Active Directory', 1)

IF EXISTS (Select * from APP_iDAType where type = 1100)												 
     UPDATE APP_idaType SET name = 'Block Level De-Duplication', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Block Level De-Duplication',												 
							indexSpaceSaver = 1											
                            WHERE type =1100															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1100, 'Block Level De-Duplication', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Block Level De-Duplication', 1)

IF EXISTS (Select * from APP_iDAType where type = 1101)												 
     UPDATE APP_idaType SET name = 'Tape De-Duplication', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Tape De-Duplication',												 
							indexSpaceSaver = 1											
                            WHERE type =1101															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1101, 'Tape De-Duplication', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Tape De-Duplication', 1)

--9.0 AppTypes

IF EXISTS (Select * from APP_iDAType where type = 121)												 
     UPDATE APP_idaType SET name = 'Metrics Reporting Server', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Metrics Reporting Server',												 
							indexSpaceSaver = 1											
                            WHERE type =121															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (121, 'Metrics Reporting Server', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Metrics Reporting Server', 1)

IF EXISTS (Select * from APP_iDAType where type = 122)												 
     UPDATE APP_idaType SET name = 'Monitored Ops Clients', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Monitored Ops Client',												 
							indexSpaceSaver = 1											
                            WHERE type =122															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (122, 'Monitored Ops Clients', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Monitored Ops Client', 1)

IF EXISTS (Select * from APP_iDAType where type = 1107)												 
     UPDATE APP_idaType SET name = 'CommNet Explorer', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'CommNet Explorer',												 
							indexSpaceSaver = 1											
                            WHERE type =1107															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1107, 'CommNet Explorer', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'CommNet Explorer', 1)

IF EXISTS (Select * from APP_iDAType where type = 1102)												 
     UPDATE APP_idaType SET name = 'CommNet SNMP Enabler', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'CommNet SNMP Enabler',												 
							indexSpaceSaver = 1											
                            WHERE type =1102															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1102, 'CommNet SNMP Enabler', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'CommNet SNMP Enabler', 1)

IF EXISTS (Select * from APP_iDAType where type = 1103)												 
     UPDATE APP_idaType SET name = 'Developer License', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Developer License',												 
							indexSpaceSaver = 1											
                            WHERE type =1103															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1103, 'Developer License', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Developer License', 1)

IF EXISTS (Select * from APP_iDAType where type = 1104)												 
     UPDATE APP_idaType SET name = 'CommNet Browser', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'CommNet Browser',												 
							indexSpaceSaver = 1											
                            WHERE type =1104															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1104, 'CommNet Browser', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'CommNet Browser', 1)

IF EXISTS (Select * from APP_iDAType where type = 1105)												 
     UPDATE APP_idaType SET name = 'Catalog Server', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Catalog Server',												 
							indexSpaceSaver = 1											
                            WHERE type =1105															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1105, 'Catalog Server', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Catalog Server', 1)

IF EXISTS (Select * from APP_iDAType where type = 125)												 
     UPDATE APP_idaType SET name = 'PostgreSQL', treeType = 3, appGroup1 = 100125,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '1', dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'PostgreSQL',												 
							indexSpaceSaver = 1											
                            WHERE type =125															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (125, 'PostgreSQL', 3, 100125, '0', '0', '1',				 
	           @empty, '300', '16384', '300', 0, 0,'PostgreSQL', 1)

IF EXISTS (Select * from APP_iDAType where type = 124)												 
     UPDATE APP_idaType SET name = 'Object Link', treeType = 1, appGroup1 = 100124,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '1', dirdelim = @gpBackslashString,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Object Link',												 
							indexSpaceSaver = 1											
                            WHERE type =124															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (124, 'Object Link', 1, 100124, '6', '0', '1',				 
	           @gpBackslashString, '300', '8192', '300', 0, 0,'Object Link', 1)

IF EXISTS (Select * from APP_iDAType where type = 126)												 
     UPDATE APP_idaType SET name = 'Sybase IQ', treeType = 3, appGroup1 = 100126,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Sybase IQ',												 
							indexSpaceSaver = 1											
                            WHERE type =126															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (126, 'Sybase IQ', 3, 100126, '0', '0', @empty,				 
	           @empty, '300', '16384', '300', 0, 0,'Sybase IQ', 1)

IF EXISTS (Select * from APP_iDAType where type = 127)												 
     UPDATE APP_idaType SET name = 'External Data Connector', treeType = 1, appGroup1 = 100127,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '1', dirdelim = @gpBackslashString,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'External Data Connector',												 
							indexSpaceSaver = 1											
                            WHERE type =127															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (127, 'External Data Connector', 1, 100127, '6', '0', '1',				 
	           @gpBackslashString, '300', '8192', '300', 0, 0,'External Data Connector', 1)

IF EXISTS (Select * from APP_iDAType where type = 1106)												 
     UPDATE APP_idaType SET name = 'CommNet Server DB', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'CommNet Server DB',												 
							indexSpaceSaver = 1											
                            WHERE type =1106															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1106, 'CommNet Server DB', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'CommNet Server DB', 1)

IF EXISTS (Select * from APP_iDAType where type = 128)												 
     UPDATE APP_idaType SET name = 'Documentum', treeType = 1, appGroup1 = 100128,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Documentum',												 
							indexSpaceSaver = 1											
                            WHERE type =128															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (128, 'Documentum', 1, 100128, '6', '0', @empty,				 
	           @empty, '300', '16384', '300', 0, 0,'Documentum', 1)

IF EXISTS (Select * from APP_iDAType where type = 1117)												 
     UPDATE APP_idaType SET name = 'SRM for Virtual Server', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'SRM for Virtual Server',												 
							indexSpaceSaver = 1											
                            WHERE type =1117															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1117, 'SRM for Virtual Server', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'SRM for Virtual Server', 1)

IF EXISTS (Select * from APP_iDAType where type = 654)												 
     UPDATE APP_idaType SET name = 'SRM for Lotus Notes', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'SRM for Lotus Notes',												 
							indexSpaceSaver = 1											
                            WHERE type =654															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (654, 'SRM for Lotus Notes', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'SRM for Lotus Notes', 1)

IF EXISTS (Select * from APP_iDAType where type = 1108)												 
     UPDATE APP_idaType SET name = 'File Level Enabler for SRM', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'File Level Enabler for SRM',												 
							indexSpaceSaver = 1											
                            WHERE type =1108															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1108, 'File Level Enabler for SRM', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'File Level Enabler for SRM', 1)

IF EXISTS (Select * from APP_iDAType where type = 1111)												 
     UPDATE APP_idaType SET name = 'Library Sharing Across CommCells', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Library Sharing Across CommCells',												 
							indexSpaceSaver = 1											
                            WHERE type =1111															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1111, 'Library Sharing Across CommCells', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Library Sharing Across CommCells', 1)

IF EXISTS (Select * from APP_iDAType where type = 1112)												 
     UPDATE APP_idaType SET name = 'Client Side DeDuplication', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Client Side DeDuplication',												 
							indexSpaceSaver = 1											
                            WHERE type =1112															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1112, 'Client Side DeDuplication', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Client Side DeDuplication', 1)

IF EXISTS (Select * from APP_iDAType where type = 1113)												 
     UPDATE APP_idaType SET name = 'Cloud Storage', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Cloud Storage',												 
							indexSpaceSaver = 1											
                            WHERE type =1113															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1113, 'Cloud Storage', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Cloud Storage', 1)

IF EXISTS (Select * from APP_iDAType where type = 1114)												 
     UPDATE APP_idaType SET name = 'SAP ArchiveLink', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'SAP ArchiveLink',												 
							indexSpaceSaver = 1											
                            WHERE type =1114															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1114, 'SAP ArchiveLink', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'SAP ArchiveLink', 1)

IF EXISTS (Select * from APP_iDAType where type = 1115)												 
     UPDATE APP_idaType SET name = 'Agentless Data collection for SRM', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Agentless Data collection for SRM',												 
							indexSpaceSaver = 1											
                            WHERE type =1115															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1115, 'Agentless Data collection for SRM', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Agentless Data collection for SRM', 1)

IF EXISTS (Select * from APP_iDAType where type = 130)												 
     UPDATE APP_idaType SET name = 'Other External Agent', treeType = 1, appGroup1 = 100130,				 
                            casesensitivity = '1',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Other External Agent',												 
							indexSpaceSaver = 1											
                            WHERE type =130															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (130, 'Other External Agent', 1, 100130, '6', '1', @empty,				 
	           @empty, '300', '8192', '300', 0, 0,'Other External Agent', 1)

IF EXISTS (Select * from APP_iDAType where type = 131)												 
     UPDATE APP_idaType SET name = 'Object Store', treeType = 1, appGroup1 = 100124,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '1', dirdelim = @gpBackslashString,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Object Store',												 
							indexSpaceSaver = 1											
                            WHERE type =131															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (131, 'Object Store', 1, 100124, '6', '0', '1',				 
	           @gpBackslashString, '300', '8192', '300', 0, 0,'Object Store', 1)

IF EXISTS (Select * from APP_iDAType where type = 1119)												 
     UPDATE APP_idaType SET name = 'Data Protection Enterprise infrastructure', treeType = 0, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Data Protection Enterprise infrastructure',												 
							indexSpaceSaver = 1											
                            WHERE type =1119															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1119, 'Data Protection Enterprise infrastructure', 0, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Data Protection Enterprise infrastructure', 1)

IF EXISTS (Select * from APP_iDAType where type = 1121)												 
     UPDATE APP_idaType SET name = 'Data Archive Enterprise infrastructure', treeType = 0, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Data Archive Enterprise infrastructure',												 
							indexSpaceSaver = 1											
                            WHERE type =1121															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1121, 'Data Archive Enterprise infrastructure', 0, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Data Archive Enterprise infrastructure', 1)

IF EXISTS (Select * from APP_iDAType where type = 1125)												 
     UPDATE APP_idaType SET name = 'Search Engine', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'CTE Search Server',												 
							indexSpaceSaver = 1											
                            WHERE type =1125															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1125, 'Search Engine', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'CTE Search Server', 1)

IF EXISTS (Select * from APP_iDAType where type = 1122)												 
     UPDATE APP_idaType SET name = 'NetApp Cloud', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'NetApp Cloud',												 
							indexSpaceSaver = 1											
                            WHERE type =1122															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1122, 'NetApp Cloud', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'NetApp Cloud', 1)

IF EXISTS (Select * from APP_iDAType where type = 1123)												 
     UPDATE APP_idaType SET name = 'NetApp Snap Management', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'NetApp Snap Management',												 
							indexSpaceSaver = 1											
                            WHERE type =1123															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1123, 'NetApp Snap Management', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'NetApp Snap Management', 1)

IF EXISTS (Select * from APP_iDAType where type = 1126)												 
     UPDATE APP_idaType SET name = 'Workflow DB', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Workflow DB',												 
							indexSpaceSaver = 1											
                            WHERE type =1126															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1126, 'Workflow DB', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Workflow DB', 1)

IF EXISTS (Select * from APP_iDAType where type = 1127)												 
     UPDATE APP_idaType SET name = 'Workflow Engine', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Workflow Engine',												 
							indexSpaceSaver = 1											
                            WHERE type =1127															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1127, 'Workflow Engine', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Workflow Engine', 1)

IF EXISTS (Select * from APP_iDAType where type = 1140)												 
     UPDATE APP_idaType SET name = 'Advanced document', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Advanced document',												 
							indexSpaceSaver = 1											
                            WHERE type =1140															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1140, 'Advanced document', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Advanced document', 1)

IF EXISTS (Select * from APP_iDAType where type = 1128)												 
     UPDATE APP_idaType SET name = 'Dell Snap Management', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Dell Snap Management',												 
							indexSpaceSaver = 1											
                            WHERE type =1128															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1128, 'Dell Snap Management', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Dell Snap Management', 1)

IF EXISTS (Select * from APP_iDAType where type = 1129)												 
     UPDATE APP_idaType SET name = 'Virtual Machines', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Virtual Machines',												 
							indexSpaceSaver = 1											
                            WHERE type =1129															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1129, 'Virtual Machines', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Virtual Machines', 1)

IF EXISTS (Select * from APP_iDAType where type = 1130)												 
     UPDATE APP_idaType SET name = 'Protected Mailboxes', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Protected Mailboxes',												 
							indexSpaceSaver = 1											
                            WHERE type =1130															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1130, 'Protected Mailboxes', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Protected Mailboxes', 1)

IF EXISTS (Select * from APP_iDAType where type = 1131)												 
     UPDATE APP_idaType SET name = 'Archived Mailboxes', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Archived Mailboxes',												 
							indexSpaceSaver = 1											
                            WHERE type =1131															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1131, 'Archived Mailboxes', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Archived Mailboxes', 1)

IF EXISTS (Select * from APP_iDAType where type = 1132)												 
     UPDATE APP_idaType SET name = 'Content indexed Mailboxes', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Content indexed Mailboxes',												 
							indexSpaceSaver = 1											
                            WHERE type =1132															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1132, 'Content indexed Mailboxes', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Content indexed Mailboxes', 1)

IF EXISTS (Select * from APP_iDAType where type = 1133)												 
     UPDATE APP_idaType SET name = 'Disk Library Space (TB)', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Disk Library Space (TB)',												 
							indexSpaceSaver = 1											
                            WHERE type =1133															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1133, 'Disk Library Space (TB)', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Disk Library Space (TB)', 1)

IF EXISTS (Select * from APP_iDAType where type = 1134)												 
     UPDATE APP_idaType SET name = 'Dedupe Store Space (TB)', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Dedupe Store Space (TB)',												 
							indexSpaceSaver = 1											
                            WHERE type =1134															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1134, 'Dedupe Store Space (TB)', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Dedupe Store Space (TB)', 1)

IF EXISTS (Select * from APP_iDAType where type = 1135)												 
     UPDATE APP_idaType SET name = 'Content Indexing Advanced Linguistic Support', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Content Indexing Advanced Linguistic Support',												 
							indexSpaceSaver = 1											
                            WHERE type =1135															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1135, 'Content Indexing Advanced Linguistic Support', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Content Indexing Advanced Linguistic Support', 1)

-- THIS IS A "PSEUDO TYPE", USED FOR CCP ONLY (modeled afer winFS)

IF EXISTS (Select * from APP_iDAType where type = 1137)												 
     UPDATE APP_idaType SET name = 'All Agents', treeType = 1, appGroup1 = 100033,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '1', dirdelim = @gpBackslashString,								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = 'All Agents',												 
							indexSpaceSaver = 1											
                            WHERE type =1137															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1137, 'All Agents', 1, 100033, '6', '0', '1',				 
	           @gpBackslashString, '300', '8192', '300', 33, 1,'All Agents', 1)

-- Content Indexed Object

IF EXISTS (Select * from APP_iDAType where type = 1138)												 
     UPDATE APP_idaType SET name = 'Content Indexed Object', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '1', dirdelim = @gpBackslashString,								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = 'Content Indexed Object',												 
							indexSpaceSaver = 1											
                            WHERE type =1138															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1138, 'Content Indexed Object', 1, 0, '6', '0', '1',				 
	           @gpBackslashString, '300', '8192', '300', 33, 1,'Content Indexed Object', 1)

IF EXISTS (Select * from APP_iDAType where type = 134)												 
     UPDATE APP_idaType SET name = 'Cloud Apps', treeType = 1, appGroup1 = 100134,				 
                            casesensitivity = '1',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = 'Cloud Apps',												 
							indexSpaceSaver = 1											
                            WHERE type =134															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (134, 'Cloud Apps', 1, 100134, '6', '1', @empty,				 
	           @empty, '300', '8192', '300', 33, 1,'Cloud Apps', 1)

IF EXISTS (Select * from APP_iDAType where type = 1139)												 
     UPDATE APP_idaType SET name = 'Extended Indexing Engine', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Extended Indexing Engine',												 
							indexSpaceSaver = 1											
                            WHERE type =1139															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1139, 'Extended Indexing Engine', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Extended Indexing Engine', 1)

IF EXISTS (Select * from APP_iDAType where type = 135)												 
     UPDATE APP_idaType SET name = 'SAP HANA', treeType = 3, appGroup1 = 100079,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'SAP HANA',												 
							indexSpaceSaver = 1											
                            WHERE type =135															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (135, 'SAP HANA', 3, 100079, '6', '0', @empty,				 
	           @empty, '300', '16384', '300', 0, 0,'SAP HANA', 1)

IF EXISTS (Select * from APP_iDAType where type = 1143)												 
     UPDATE APP_idaType SET name = 'Data Protection Snapshot', treeType = 0, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Data Protection Snapshot',												 
							indexSpaceSaver = 1											
                            WHERE type =1143															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1143, 'Data Protection Snapshot', 0, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Data Protection Snapshot', 1)

IF EXISTS (Select * from APP_iDAType where type = 1144)												 
     UPDATE APP_idaType SET name = 'Data Protection Replication', treeType = 0, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Data Protection Replication',												 
							indexSpaceSaver = 1											
                            WHERE type =1144															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1144, 'Data Protection Replication', 0, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Data Protection Replication', 1)

IF EXISTS (Select * from APP_iDAType where type = 136)												 
     UPDATE APP_idaType SET name = 'SAP HANA', treeType = 3, appGroup1 = 100079,				 
                            casesensitivity = '0',		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'SAP HANA',												 
							indexSpaceSaver = 1											
                            WHERE type =136															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (136, 'SAP HANA', 3, 100079, '6', '0', @empty,				 
	           @empty, '300', '16384', '300', 0, 0,'SAP HANA', 1)

-- usage based Licenses

IF EXISTS (Select * from APP_iDAType where type = 1146)												 
     UPDATE APP_idaType SET name = 'VM Sockets', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '1', dirdelim = @gpBackslashString,								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = 'VM Sockets',												 
							indexSpaceSaver = 1											
                            WHERE type =1146															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1146, 'VM Sockets', 1, 0, '6', '0', '1',				 
	           @gpBackslashString, '300', '8192', '300', 33, 1,'VM Sockets', 1)

IF EXISTS (Select * from APP_iDAType where type = 1147)												 
     UPDATE APP_idaType SET name = 'Protected Virtual Machines', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '1', dirdelim = @gpBackslashString,								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = 'Protected Virtual Machines',												 
							indexSpaceSaver = 1											
                            WHERE type =1147															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1147, 'Protected Virtual Machines', 1, 0, '6', '0', '1',				 
	           @gpBackslashString, '300', '8192', '300', 33, 1,'Protected Virtual Machines', 1)

IF EXISTS (Select * from APP_iDAType where type = 1148)												 
     UPDATE APP_idaType SET name = 'Virtual Machine Provisioning', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '1', dirdelim = @gpBackslashString,								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = 'Virtual Machine Provisioning',												 
							indexSpaceSaver = 1											
                            WHERE type =1148															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1148, 'Virtual Machine Provisioning', 1, 0, '6', '0', '1',				 
	           @gpBackslashString, '300', '8192', '300', 33, 1,'Virtual Machine Provisioning', 1)

IF EXISTS (Select * from APP_iDAType where type = 1149)												 
     UPDATE APP_idaType SET name = 'Virtual Machine Archiving', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '1', dirdelim = @gpBackslashString,								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = 'Virtual Machine Archiving',												 
							indexSpaceSaver = 1											
                            WHERE type =1149															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1149, 'Virtual Machine Archiving', 1, 0, '6', '0', '1',				 
	           @gpBackslashString, '300', '8192', '300', 33, 1,'Virtual Machine Archiving', 1)

IF EXISTS (Select * from APP_iDAType where type = 1150)												 
     UPDATE APP_idaType SET name = 'Virtual Machine Snapshot', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '1', dirdelim = @gpBackslashString,								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = 'Virtual Machine Snapshot',												 
							indexSpaceSaver = 1											
                            WHERE type =1150															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1150, 'Virtual Machine Snapshot', 1, 0, '6', '0', '1',				 
	           @gpBackslashString, '300', '8192', '300', 33, 1,'Virtual Machine Snapshot', 1)

IF EXISTS (Select * from APP_iDAType where type = 1151)												 
     UPDATE APP_idaType SET name = 'CPU Socket Based Virtual Machine Snapshot', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '1', dirdelim = @gpBackslashString,								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = 'CPU Socket Based Virtual Machine Snapshot',												 
							indexSpaceSaver = 1											
                            WHERE type =1151															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1151, 'CPU Socket Based Virtual Machine Snapshot', 1, 0, '6', '0', '1',				 
	           @gpBackslashString, '300', '8192', '300', 33, 1,'CPU Socket Based Virtual Machine Snapshot', 1)

IF EXISTS (Select * from APP_iDAType where type = 1152)												 
     UPDATE APP_idaType SET name = 'End point users', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '1', dirdelim = @gpBackslashString,								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = 'End point users',												 
							indexSpaceSaver = 1											
                            WHERE type =1152															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1152, 'End point users', 1, 0, '6', '0', '1',				 
	           @gpBackslashString, '300', '8192', '300', 33, 1,'End point users', 1)

IF EXISTS (Select * from APP_iDAType where type = 1153)												 
     UPDATE APP_idaType SET name = 'End point sharing users', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '1', dirdelim = @gpBackslashString,								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = 'End point sharing users',												 
							indexSpaceSaver = 1											
                            WHERE type =1153															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1153, 'End point sharing users', 1, 0, '6', '0', '1',				 
	           @gpBackslashString, '300', '8192', '300', 33, 1,'End point sharing users', 1)

IF EXISTS (Select * from APP_iDAType where type = 1154)												 
     UPDATE APP_idaType SET name = 'End point E-discovery users', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '1', dirdelim = @gpBackslashString,								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = 'End point E-discovery users',												 
							indexSpaceSaver = 1											
                            WHERE type =1154															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1154, 'End point E-discovery users', 1, 0, '6', '0', '1',				 
	           @gpBackslashString, '300', '8192', '300', 33, 1,'End point E-discovery users', 1)

IF EXISTS (Select * from APP_iDAType where type = 1161)												 
     UPDATE APP_idaType SET name = 'Application Class Virtual', treeType = 0, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Application Class Virtual',												 
							indexSpaceSaver = 1											
                            WHERE type =1161															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1161, 'Application Class Virtual', 0, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Application Class Virtual', 1)

IF EXISTS (Select * from APP_iDAType where type = 64)												 
     UPDATE APP_idaType SET name = 'Big Data Apps', treeType = 1, appGroup1 = 100064,				 
                            casesensitivity = '1',		    			 						
                            dirorder = '1', dirdelim = '/',								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = 'Big Data Apps',												 
							indexSpaceSaver = 1											
                            WHERE type =64															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (64, 'Big Data Apps', 1, 100064, '6', '1', '1',				 
	           '/', '300', '8192', '300', 33, 1,'Big Data Apps', 1)

IF EXISTS (Select * from APP_iDAType where type = 137)												 
     UPDATE APP_idaType SET name = 'Exchange Mailbox', treeType = 1, appGroup1 = 100137,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '1', dirdelim = @gpBackslashString,								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = 'Exchange Mailbox',												 
							indexSpaceSaver = 1											
                            WHERE type =137															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (137, 'Exchange Mailbox', 1, 100137, '6', '0', '1',				 
	           @gpBackslashString, '300', '8192', '300', 33, 1,'Exchange Mailbox', 1)

IF EXISTS (Select * from APP_iDAType where type = 1163)												 
     UPDATE APP_idaType SET name = 'Mailbox archive solution', treeType = 0, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Mailbox archive solution',												 
							indexSpaceSaver = 1											
                            WHERE type =1163															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1163, 'Mailbox archive solution', 0, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Mailbox archive solution', 1)

IF EXISTS (Select * from APP_iDAType where type = 1165)												 
     UPDATE APP_idaType SET name = 'Appliance store capacity (TB)', treeType = 0, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Appliance store capacity (TB)',												 
							indexSpaceSaver = 1											
                            WHERE type =1165															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1165, 'Appliance store capacity (TB)', 0, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Appliance store capacity (TB)', 1)

IF EXISTS (Select * from APP_iDAType where type = 1167)												 
     UPDATE APP_idaType SET name = 'CIFN Enabler', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'CIFN Enabler',												 
							indexSpaceSaver = 1											
                            WHERE type =1167															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1167, 'CIFN Enabler', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'CIFN Enabler', 1)

IF EXISTS (Select * from APP_iDAType where type = 1169)												 
     UPDATE APP_idaType SET name = 'Commvault Complete Enabler', treeType = 1, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Commvault Complete Enabler',												 
							indexSpaceSaver = 1											
                            WHERE type =1169															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1169, 'Commvault Complete Enabler', 1, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Commvault Complete Enabler', 1)

IF EXISTS (Select * from APP_iDAType where type = 1170)												 
     UPDATE APP_idaType SET name = 'Operating Instances', treeType = 0, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Operating Instances',												 
							indexSpaceSaver = 1											
                            WHERE type =1170															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1170, 'Operating Instances', 0, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Operating Instances', 1)

IF EXISTS (Select * from APP_iDAType where type = 1171)												 
     UPDATE APP_idaType SET name = 'Virtual Operating Instances', treeType = 0, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Virtual Operating Instances',												 
							indexSpaceSaver = 1											
                            WHERE type =1171															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1171, 'Virtual Operating Instances', 0, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Virtual Operating Instances', 1)

IF EXISTS (Select * from APP_iDAType where type = 1172)												 
     UPDATE APP_idaType SET name = 'Activate E-Discovery For Files (TB)', treeType = 0, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Activate E-Discovery For Files (TB)',												 
							indexSpaceSaver = 1											
                            WHERE type =1172															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1172, 'Activate E-Discovery For Files (TB)', 0, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Activate E-Discovery For Files (TB)', 1)

IF EXISTS (Select * from APP_iDAType where type = 1173)												 
     UPDATE APP_idaType SET name = 'Activate E-Discovery For Email/Cloud Apps', treeType = 0, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Activate E-Discovery For Email/Cloud Apps',												 
							indexSpaceSaver = 1											
                            WHERE type =1173															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1173, 'Activate E-Discovery For Email/Cloud Apps', 0, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Activate E-Discovery For Email/Cloud Apps', 1)

IF EXISTS (Select * from APP_iDAType where type = 1174)												 
     UPDATE APP_idaType SET name = 'Activate Sensitive Data For Files (TB)', treeType = 0, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Activate Sensitive Data For Files (TB)',												 
							indexSpaceSaver = 1											
                            WHERE type =1174															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1174, 'Activate Sensitive Data For Files (TB)', 0, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Activate Sensitive Data For Files (TB)', 1)

IF EXISTS (Select * from APP_iDAType where type = 1175)												 
     UPDATE APP_idaType SET name = 'Activate Sensitive Data For Email/Cloud Apps', treeType = 0, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Activate Sensitive Data For Email/Cloud Apps',												 
							indexSpaceSaver = 1											
                            WHERE type =1175															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1175, 'Activate Sensitive Data For Email/Cloud Apps', 0, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Activate Sensitive Data For Email/Cloud Apps', 1)

IF EXISTS (Select * from APP_iDAType where type = 1176)												 
     UPDATE APP_idaType SET name = 'File Storage Optimization (TB)', treeType = 0, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'File Storage Optimization (TB)',												 
							indexSpaceSaver = 1											
                            WHERE type =1176															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1176, 'File Storage Optimization (TB)', 0, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'File Storage Optimization (TB)', 1)

IF EXISTS (Select * from APP_iDAType where type = 1177)												 
     UPDATE APP_idaType SET name = 'Activate Suite', treeType = 0, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Activate Suite',												 
							indexSpaceSaver = 1											
                            WHERE type =1177															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1177, 'Activate Suite', 0, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Activate Suite', 1)

IF EXISTS (Select * from APP_iDAType where type = 1178)												 
     UPDATE APP_idaType SET name = 'DR VM', treeType = 0, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'DR VM',												 
							indexSpaceSaver = 1											
                            WHERE type =1178															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1178, 'DR VM', 0, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'DR VM', 1)

IF EXISTS (Select * from APP_iDAType where type = 1179)												 
     UPDATE APP_idaType SET name = 'Metallic Cloud Storage Service (TB)', treeType = 0, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Metallic Cloud Storage Service (TB)',												 
							indexSpaceSaver = 1											
                            WHERE type =1179															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1179, 'Metallic Cloud Storage Service (TB)', 0, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Metallic Cloud Storage Service (TB)', 1)

IF EXISTS (Select * from APP_iDAType where type = 1180)												 
     UPDATE APP_idaType SET name = 'Metallic Cloud Storage Service T2 (TB)', treeType = 0, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Metallic Cloud Storage Service T2 (TB)',												 
							indexSpaceSaver = 1											
                            WHERE type =1180															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1180, 'Metallic Cloud Storage Service T2 (TB)', 0, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Metallic Cloud Storage Service T2 (TB)', 1)

IF EXISTS (Select * from APP_iDAType where type = 1181)												 
     UPDATE APP_idaType SET name = 'Metallic Cloud Storage Service T3 (TB)', treeType = 0, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Metallic Cloud Storage Service T3 (TB)',												 
							indexSpaceSaver = 1											
                            WHERE type =1181															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1181, 'Metallic Cloud Storage Service T3 (TB)', 0, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Metallic Cloud Storage Service T3 (TB)', 1)

IF EXISTS (Select * from APP_iDAType where type = 1182)												 
     UPDATE APP_idaType SET name = 'Metallic Cloud Storage Service T4 (TB)', treeType = 0, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Metallic Cloud Storage Service T4 (TB)',												 
							indexSpaceSaver = 1											
                            WHERE type =1182															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1182, 'Metallic Cloud Storage Service T4 (TB)', 0, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Metallic Cloud Storage Service T4 (TB)', 1)

IF EXISTS (Select * from APP_iDAType where type = 1183)												 
     UPDATE APP_idaType SET name = 'Metallic Cloud Storage Service T5 (TB)', treeType = 0, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Metallic Cloud Storage Service T5 (TB)',												 
							indexSpaceSaver = 1											
                            WHERE type =1183															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1183, 'Metallic Cloud Storage Service T5 (TB)', 0, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Metallic Cloud Storage Service T5 (TB)', 1)

IF EXISTS (Select * from APP_iDAType where type = 1184)												 
     UPDATE APP_idaType SET name = 'Metallic Cloud Storage Service T6 (TB)', treeType = 0, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Metallic Cloud Storage Service T6 (TB)',												 
							indexSpaceSaver = 1											
                            WHERE type =1184															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1184, 'Metallic Cloud Storage Service T6 (TB)', 0, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Metallic Cloud Storage Service T6 (TB)', 1)

IF EXISTS (Select * from APP_iDAType where type = 1185)												 
     UPDATE APP_idaType SET name = 'Metallic Cloud Storage Service T7 (TB)', treeType = 0, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Metallic Cloud Storage Service T7 (TB)',												 
							indexSpaceSaver = 1											
                            WHERE type =1185															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1185, 'Metallic Cloud Storage Service T7 (TB)', 0, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Metallic Cloud Storage Service T7 (TB)', 1)

IF EXISTS (Select * from APP_iDAType where type = 1186)												 
     UPDATE APP_idaType SET name = 'Metallic Cloud Storage Service T8 (TB)', treeType = 0, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Metallic Cloud Storage Service T8 (TB)',												 
							indexSpaceSaver = 1											
                            WHERE type =1186															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1186, 'Metallic Cloud Storage Service T8 (TB)', 0, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Metallic Cloud Storage Service T8 (TB)', 1)

IF EXISTS (Select * from APP_iDAType where type = 1187)												 
     UPDATE APP_idaType SET name = 'Metallic Cloud Storage Service T9 (TB)', treeType = 0, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Metallic Cloud Storage Service T9 (TB)',												 
							indexSpaceSaver = 1											
                            WHERE type =1187															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1187, 'Metallic Cloud Storage Service T9 (TB)', 0, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Metallic Cloud Storage Service T9 (TB)', 1)

IF EXISTS (Select * from APP_iDAType where type = 1188)												 
     UPDATE APP_idaType SET name = 'Metallic Cloud Storage Service T10 (TB)', treeType = 0, appGroup1 = 0,				 
                            casesensitivity = 'Invalid Property',		    			 						
                            dirorder = 'Invalid Property', dirdelim = 'Invalid Property',								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = 'Metallic Cloud Storage Service T10 (TB)',												 
							indexSpaceSaver = 1											
                            WHERE type =1188															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1188, 'Metallic Cloud Storage Service T10 (TB)', 0, 0, 'Invalid Property', 'Invalid Property', 'Invalid Property',				 
	           'Invalid Property', 'Invalid Property', 'Invalid Property', 'Invalid Property', 0, 0,'Metallic Cloud Storage Service T10 (TB)', 1)

-- Move APP_IDAType.script

-- (DELETE_ROW('Office 365 Sharepoint'))

 UPDATE APP_iDAType

set AppGroup1 = 100081

where AppGroup1 = 100004

 UPDATE APP_iDAType

set AppGroup1 = 100135

where type = 135

 UPDATE APP_iDAType

set AppGroup1 = 100131

where type = 131

 UPDATE APP_iDAType

set isCWEjobValid = 1

where type IN (6, 7, 51, 52, 59, 60, 77)

IF NOT EXISTS(SELECT 1 FROM	GXUniqueSQLScriptExecTracking WITH(NOLOCK) WHERE SqlScriptGUID = '2B70DC31-BD11-44D6-B625-92ACAAF0E3B9')

BEGIN

	DECLARE @nowTime	INT

	SET     @nowTime =  DATEDIFF(SECOND, '01/01/1970', GetUTCdate())

	UPDATE App_IdaType

SET ChunkSizeMB = '8192'

	WHERE type IN 

	(1,7,8,10,11,12,14,17,18,19,20,21,24,25,26,28,29,30,33,34,35,36,38,39,40,41,42,43,44,45,46,47,48,49,50,52,54,55,56,57,58,60,63,64,65,66,67,68,72,73,74,

	75,76,78,82,83,84,85,86,87,91,93,105,106,107,124,127,130,131,134,137,600,601,602,603,604,605,606,607,1137,1138,1146,1147,1148,1149,1150,1151,1152,1153,1154)

	AND ChunkSizeMB = '4096'
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('2B70DC31-BD11-44D6-B625-92ACAAF0E3B9', 'Update default apptype chunksizeMB', 'Update default chunksizeMB for apPTypes', @nowTime, 16, 0, (16 + 2))

END

IF EXISTS (Select * from APP_iDAType where type = 139)												 
     UPDATE APP_idaType SET name = 'Azure AD', treeType = 1, appGroup1 = 100139,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '2', dirdelim = ',',								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = 'Azure AD',												 
							indexSpaceSaver = 1											
                            WHERE type =139															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (139, 'Azure AD', 1, 100139, '6', '0', '2',				 
	           ',', '300', '8192', '300', 33, 1,'Azure AD', 1)

IF EXISTS (Select * from APP_iDAType where type = 301)												 
     UPDATE APP_idaType SET name = 'Azure Web App', treeType = 1, appGroup1 = 100301,				 
                            casesensitivity = '0',		    			 						
                            dirorder = '2', dirdelim = ',',								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = 'Azure Web App',												 
							indexSpaceSaver = 1											
                            WHERE type =301															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (301, 'Azure Web App', 1, 100301, '6', '0', '2',				 
	           ',', '300', '8192', '300', 33, 1,'Azure Web App', 1)

SET NOCOUNT OFF

