

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/APP_GenerateCustomGuidForAllPublicFolders.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- This is one time upgrade script to populate custom user GUIDS for Public Folder db records. 

-- This Script gives the next custom GUID in sequence.

-- Custom GUIDs are generated starting with below sequences to ensure these guids go into index core 3.

-- '00000000X0000X0000X0000X00000000000C', '00000000X0000X0000X0000X0000000000C0', '00000000X0000X0000X0000X000000000C00'... so on

-- '00000000X0000X0000X0000X000000000030', '00000000X0000X0000X0000X000000000300', '00000000X0000X0000X0000X000000003000'... so on

SET NOCOUNT ON

SET QUOTED_IDENTIFIER ON

DECLARE @sqlScriptGUID varchar(48) = '341B810E-F3F7-447A-BD23-9899B5E6BEE6'

DECLARE @createdTime INT = dbo.getUnixtime(GETUTCDATE())

IF EXISTS(SELECT 1 FROM GXUniqueSQLScriptExecTracking (NOLOCK) WHERE SqlScriptGUID = @sqlScriptGUID)

GOTO ERROR_EXIST

IF OBJECT_ID('tempdb.dbo.#tempPFsubclientGuids') IS NOT NULL       DROP TABLE #tempPFsubclientGuids

IF OBJECT_ID('tempdb.dbo.#tempSubclientIds') IS NOT NULL       DROP TABLE #tempSubclientIds

CREATE TABLE #tempPFsubclientGuids  (subclientId INT, newGuid varchar(40))

CREATE TABLE #tempSubclientIds (subclientId INT)

DECLARE @subclientId INT

DECLARE @guid varchar(40), @userGuid varchar(40), @newSequence varchar(40), @cSequenceEnd varchar(40), @guidEnd varchar(40)

SET @guid =				'00000000X0000X0000X0000X00000000000C'

SET @cSequenceEnd =		'C0000000X0000X0000X0000X000000000000'

SET @newSequence =		'00000000X0000X0000X0000X000000000003' 

SET @guidEnd	=		'30000000X0000X0000X0000X000000000000'

-- get unique subclients for all public folder entries from DB into a temp table
INSERT INTO #tempSubclientIds


SELECT Distinct AE.subClientId

FROM APP_EmailConfigPolicyAssoc (NOLOCK) AS AE

INNER JOIN APP_Application (NOLOCK) AA ON AA.id = AE.subClientId AND AA.subclientName = 'usermailbox' AND AA.appTypeId = 137

WHERE AE.discoverByType  = 12  AND AE.modified = 0 

--For each subclient entry in #tempSubclientIds table, generate a custom GUID             	

WHILE EXISTS(SELECT 1 FROM #tempSubclientIds)

BEGIN

	SELECT @subclientId =  MAX(subclientid) from #tempSubclientIds
	INSERT INTO #tempPFsubclientGuids	  values( @subclientId , @guid )


	  -- Running out of total custom guids (63): usecase is practically not possible for Public Folders. Break out, Just in case if it hits. 

	  IF @guid = @guidEnd BREAK

	  -- change to @newSequence '3' at then end of guid sequence 'C'

	  IF @guid = @cSequenceEnd	SET @guid = @newSequence  -- this particular guid @newSequence (003) is skipped intentionally.

		DECLARE @position int,  @asci int 		

		BEGIN

			SET @position = 1  

			WHILE @position <= DATALENGTH(@guid)  

			BEGIN  

				SET @asci = ASCII(SUBSTRING(@guid, @position, 1))         

				IF @asci in ( ASCII('C'), ASCII('3'))

					BREAK		

				SET @position = @position + 1    

			END

		   IF @position IN (10, 15, 20, 25) -- ignore X's to generate next guid in sequence 

		   BEGIN

				SET @guid =  STUFF(@guid, @position-2, 1, CHAR(@asci))    

		   END

		   ELSE IF @position > 1 AND @position <= 36 -- generate next guid in sequence

		   BEGIN

				SET @guid =  STUFF(@guid, @position-1, 1, CHAR(@asci))   

		   END

		   SET @guid =  STUFF(@guid, @position, 1, '0') 

		END

		--delete processed subclient from temp table

		DELETE FROM #tempSubclientIds WHERE subclientId = @subclientId            

END   

 -- update guid for current subclient in APP_EmailConfigPolicyAssoc table.

	  UPDATE A       

	  SET A.userGuid = T.newGuid, A.coreId = 3

	  FROM APP_EmailConfigPolicyAssoc A

	  INNER JOIN #tempPFsubclientGuids T ON A.subclientId = T.subclientId 

	  WHERE A.discoverByType  = 12  AND A.modified = 0 	

	  IF OBJECT_ID('tempdb.dbo.#tempSubclientIds') IS NOT NULL       DROP TABLE #tempSubclientIds

	IF OBJECT_ID('tempdb.dbo.#tempPFsubclientGuids') IS NOT NULL       DROP TABLE #tempPFsubclientGuids
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@sqlScriptGUID, 'APP_AllPublicFolders_Push_CustomGUID', 'Added Custom GUID to ALL Public Folders', @createdTime, 16, 0 , (16 + 1))

ERROR_EXIST:

