

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/APP_FirewallTPPM.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/APP_FirewallTPPM.script,v $ $Id: APP_FirewallTPPM.script,v 1.1.2.3 2020/08/06 14:44:07 pankajkumar Exp $";

SET NOCOUNT ON

SET QUOTED_IDENTIFIER ON

GO

DECLARE @DYNAMIC_TPPM INT = 8 --TPPMType::DYNAMIC_TPPM=8 

DECLARE @WebServerTPPMUpgrade INT = 0

DECLARE @WebServerTPPMUpgradeVersion varchar(36) = '6DA37434-FD9C-4BC3-8FE2-41D6C50CFC0F'

SELECT @WebServerTPPMUpgrade = 1

FROM GXUniqueSQLScriptExecTracking GS WITH(NOLOCK)

WHERE GS.SqlScriptGUID = @WebServerTPPMUpgradeVersion

IF (@WebServerTPPMUpgrade = 0)            -- not done, do the db upgrade. This makes sure this script is run only one time

BEGIN

	IF OBJECT_ID('tempdb.dbo.#WebServerTPPM') IS NOT NULL

		DROP TABLE #WebServerTPPM

	CREATE TABLE #WebServerTPPM 

	(

		ClientId INT, 

		Port INT

	)
	INSERT INTO #WebServerTPPM (ClientId, Port)


	SELECT 	DISTINCT 	ClientId, 

						CAST(attrVal AS INT) AS Port

	FROM simInstalledPackages A WITH(NOLOCK)

		JOIN APP_ClientProp B WITH(NOLOCK) 

		ON A.ClientId = B.componentNameId 

			AND B.modified = 0 

			AND B.attrName = 'DM2WebService Web Site Port' 

WHERE A.simPackageID = 803

			AND NOT EXISTS (SELECT 1 FROM APP_FirewallTPPM WITH(NOLOCK) WHERE fromEntityId = ClientId AND toEntityId = ClientId AND CONVERT(NVARCHAR(10), toPortNumber) = attrVal AND tppmType = @DYNAMIC_TPPM)

	IF (EXISTS(SELECT TOP 1 1 FROM #WebServerTPPM))

	BEGIN		

		-- insert into APP_FirewallTPPM
		INSERT INTO  APP_FirewallTPPM (tppmType, 


		fromEntityType, 

		fromEntityId, 

		fromPortNumber, 

		toEntityType, 

		toEntityId, 

		toPortNumber, 

		status, 

		tppmParams)

		SELECT 	@DYNAMIC_TPPM,  --TPPMType::DYNAMIC_TPPM=8 

3,

				ClientId, 

				0, 

3,

				ClientId, 

				Port, 

				1, 

				''

		FROM #WebServerTPPM

		-- insert into APP_WorkQueueRequest so that Push Network Configuration to happen when all services are up

		DECLARE @createdTime INTEGER = dbo.GetUnixTime(GETUTCDATE())
		INSERT INTO APP_WorkQueueRequest (clientId, 


		remoteClient, 

		workToken, 

		workTokenParams, 

		createTime, 

		lastUpdateTime, 

		retryCount, 

		flag)

		SELECT ClientId, 

				-1,

5,

				'', 

				@createdTime, 

				0, 

				0, 

				0

		FROM #WebServerTPPM	

	END

	IF OBJECT_ID('tempdb.dbo.#WebServerTPPM') IS NOT NULL

		DROP TABLE #WebServerTPPM
	INSERT INTO GXUniqueSQLScriptExecTracking (


	SqlScriptGUID, 

	Name, 

	Description, 

	CreatedTime, 

	CreatedRelId, 

	ExpireTime, 

	ExpireRelId)

	VALUES(

	@WebServerTPPMUpgradeVersion, 

	'SCPWebServerTPPMUpgrade', 

	'Upgrade WebServer TPPM', 

	datediff(second, '01/01/1970', GETDATE()), 

16,

	0 , 

(16 + 1))

END

SET NOCOUNT OFF

GO

