

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/APP_EmailConfigPolicyAssoc_AllPublicFolders.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 2017  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- From sp15 Exchange virtual client creation will create ALL Public Folders. Default auto discovered association

-- Insert ALL Public Folders default auto discovered association for Exchange virtual clients 

DECLARE @discoverByType INT = 12

DECLARE @displayName varchar(50) = 'All Public Folders'

DECLARE @isAutoDiscovered INT = 1

DECLARE @ownerId INT = 1

DECLARE @createdTime INT = dbo.getUnixtime(GETUTCDATE())

DECLARE @sqlScriptGUID varchar(48) = '1523C181-80F6-42E1-9E3A-79A1C17CAD65'

DECLARE @allUserUpgrade INT = 0

SELECT @allUserUpgrade = 1 FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = @sqlScriptGUID

IF  @allUserUpgrade = 0

BEGIN

	MERGE APP_EmailConfigPolicyAssoc AS AEC 

	USING 

	(

		SELECT A.id AS subclientId, A.clientId, A.backupSet AS backupSetId FROM App_Application A

		INNER JOIN APP_BackupSetProp APB WITH (NOLOCK) ON APB.attrName='Exchange OnePass BackupSet Type' AND APB.attrVal = 1 AND APB.modified = 0 AND A.backupSet = APB.componentNameId  --only match for usermailbox backupsets

INNER JOIN APP_IDAName AIN WITH (NOLOCK) ON AIN.clientId = A.clientId AND AIN.appTypeId = 137

INNER JOIN APP_IDAProp AIP WITH (NOLOCK) ON AIP.componentNameId = AIN.id AND AIP.attrName = 'Exchange Environment Type' AND AIP.modified = 0 AND AIP.attrVal IN (1,2,3,4)

WHERE A.appTypeId = 137 AND A.subclientStatus & 0x00008 =  0x00008

	) AS APP

	ON AEC.discoverbyType = @discoverByType AND AEC.subclientId = APP.subclientId

	WHEN NOT MATCHED THEN 

	INSERT (userGuid,displayName,aliasName,smtpAdrress,databaseName,exchangeServer,discoverByType,isAutoDiscovered,mailBoxType,clientId,backupsetId,subClientId,adGroupName,autoDiscover,ownerId,created,modified,flags,status,deleted,coreId,password,mailBoxSize,description,planId)

	VALUES('', @displayName, NULL, NULL, NULL, NULL, @discoverByType,  @isAutoDiscovered, NULL, APP.clientId, APP.backupSetId, APP.subclientId, NULL,  @isAutoDiscovered,  @ownerId,  @createdTime , '0', '0', '2', '0', '0', NULL, NULL, NULL, 0);
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@sqlScriptGUID, 'APP_EmailConfigPolicyAssoc_AllPublicFolders', 'Added ALL Public Folders auto discovered association', @createdTime, 16, 0 , (16 + 1))

END
