

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/APP_EmailConfigPolicyAssoc.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 2017  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- From sp11 Exchange virtual client creation will create All Users. Default auto discovered association

-- Insert ALL Users default auto discovered association for Exchange virtual clients created before sp11

DECLARE @discoverByType INT = 8

DECLARE @displayName varchar(20) = 'All Users'

DECLARE @isAutoDiscovered INT = 1

DECLARE @ownerId INT = 1

DECLARE @createdTime INT = dbo.getUnixtime(GETUTCDATE())

DECLARE @sqlScriptGUID varchar(48) = 'B1A75A85-5479-4C02-A5D4-ABAF9AAB40AA'

DECLARE @allUserUpgrade INT = 0

SELECT @allUserUpgrade = 1 FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = @sqlScriptGUID

IF  @allUserUpgrade = 0

BEGIN

	MERGE APP_EmailConfigPolicyAssoc AS AEC 

	USING 

	(

		SELECT A.id AS subclientId, A.clientId, A.backupSet AS backupSetId FROM App_Application A

		INNER JOIN APP_BackupSetProp APB ON APB.attrName='Exchange OnePass BackupSet Type' AND APB.attrVal = 1 AND APB.modified = 0 AND A.backupSet = APB.componentNameId  --only match for usermailbox backupsets

WHERE A.appTypeId = 137 AND A.subclientStatus & 0x00008 =  0x00008

	) AS APP

	ON AEC.discoverbyType = @discoverByType AND AEC.subclientId = APP.subclientId

	WHEN NOT MATCHED THEN 

	INSERT (userGuid,displayName,aliasName,smtpAdrress,databaseName,exchangeServer,discoverByType,isAutoDiscovered,mailBoxType,clientId,backupsetId,subClientId,adGroupName,autoDiscover,ownerId,created,modified,flags,status,deleted,coreId,password,mailBoxSize,description,planId)

	VALUES('', @displayName, NULL, NULL, NULL, NULL, @discoverByType,  @isAutoDiscovered, NULL, APP.clientId, APP.backupSetId, APP.subclientId, NULL,  @isAutoDiscovered,  @ownerId,  @createdTime , '0', '0', '2', '0', '0', NULL, NULL, NULL, 0);
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@sqlScriptGUID, 'EmailConfigPolicyAssoc', 'Added All Users auto discovered association', @createdTime, 16, 0 , (16 + 1))

END

--Script to convert undetected (customer upgrading from older SP) mailbox types to usermailbox type(1)

DECLARE @sqlDefaultUserMailboxTypeGUID varchar(48) = '6363B7C8-5BBB-463F-9818-516CD58A8613'

IF NOT EXISTS (SELECT TOP 1 SqlScriptGUID FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = @sqlDefaultUserMailboxTypeGUID)

BEGIN

	UPDATE APP_EmailConfigPolicyAssoc

	SET msExchRecipientTypeDetails = 1

	WHERE mailBoxType = 1 AND modified = 0 AND (msExchRecipientTypeDetails IS NULL or msExchRecipientTypeDetails = 0 )
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@sqlDefaultUserMailboxTypeGUID, 'Default to usermailbox', 'Defaulted undetected mailbox types to user-mailbox ', @createdTime, 16, 0 , (16 + 1))

END

