

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/APP_ConfigurationPolicyDetails.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 2016  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/APP_ConfigurationPolicyDetails.script,v $";

GO

SET QUOTED_IDENTIFIER ON

GO

-- start renameDCPolicyWithEEPolicy if not done already

IF NOT EXISTS(SELECT * FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = 'EBC89520-27F5-4960-84F5-DDB1443AB725')

BEGIN

	-- get current epoch second

	DECLARE @currentEpoch INT

	SET @currentEpoch = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()))

	-- check if dc policies are present with tag '<dcpolicy></dcpolicy>'

	IF EXISTS (SELECT 1 FROM APP_ConfigurationPolicyDetails WITH(NOLOCK) CROSS APPLY policyDetails.nodes('/dcPolicy') AS dcPolicy(d) WHERE detailType=6 and modified=0) 

	BEGIN

		-- temp table used for processing

		IF OBJECT_ID('tempdb.dbo.#dcPolicyRulesSP11') IS NOT NULL

			DROP TABLE #dcPolicyRulesSP11

		CREATE TABLE #dcPolicyRulesSP11 (

				id              INT NOT NULL,

				componentNameId INT,

				detailType      INT,

				dcPolicyDetails XML,

				created         INT,

				PRIMARY KEY (id)

		)

		-- grab all latest dc policies having tag dcpolicy and dump them in temp table
		INSERT INTO #dcPolicyRulesSP11 (id, componentNameId, detailType, dcPolicyDetails, created) 


			   SELECT id, componentNameId, detailType, policyDetails, created FROM APP_ConfigurationPolicyDetails WITH(NOLOCK)

			   CROSS APPLY policyDetails.nodes('/dcPolicy') AS dcPolicy(d)          

			   WHERE detailType=6 AND modified=0 -- existing dc policies

		-- replace dcPolicy keyword with eePolicy

		UPDATE #dcPolicyRulesSP11 SET dcPolicyDetails = REPLACE(REPLACE(CAST(dcPolicyDetails AS NVARCHAR(MAX)), '</dcPolicy>', '</eePolicy>'), '<dcPolicy ', '<eePolicy ')

		-- update latest dc policy modifiedtime from 0 to current time

		UPDATE APP_ConfigurationPolicyDetails SET modified = @currentEpoch 

			FROM APP_ConfigurationPolicyDetails config

				INNER JOIN #dcPolicyRulesSP11 temp

				ON config.id = temp.id

		-- insert the new XML with modified time as 0
		INSERT INTO APP_ConfigurationPolicyDetails (componentNameId, detailType,policyDetails,created,modified) 


				SELECT componentNameId, detailType,dcPolicyDetails,created,0 FROM #dcPolicyRulesSP11

		-- drop the temp table

		DROP TABLE #dcPolicyRulesSP11

	END

	-- insert unique guid
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('EBC89520-27F5-4960-84F5-DDB1443AB725', 'renameDCPolicyWithEEPolicy', 'Rename of DC policy with EE policy', @currentEpoch, 16, 0, (16 + 2))

END -- end of renameDCPolicyWithEEPolicy

GO

SET QUOTED_IDENTIFIER ON

GO

