

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/APP_CompanyPropAttrValInt.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

------------------------------------------------------------------------

-- rcsid[]='@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/APP_CompanyPropAttrValInt.script,v $ $Id: APP_CompanyPropAttrValInt.script,v 1.1.2.1 2019/12/12 19:22:05 abilbrey Exp $';

--TABLENAME APP_CompanyProp

SET QUOTED_IDENTIFIER ON

GO

SET NOCOUNT ON

DECLARE @AttrValIntGuid	VARCHAR(40) = '1898275B-AC59-44A0-BACE-BDA28569A88B'

DECLARE @nowTime INT = DATEDIFF(SECOND, '01/01/1970', GETUTCDATE())

IF NOT EXISTS(SELECT TOP 1 * FROM	GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE	gp.SqlScriptGUID = @AttrValIntGuid)	

BEGIN

	PRINT 'APP_CompanyPropAttrValInt: conversion starting'

	-- Convert existing rows were attrVal is integer data to the 

	UPDATE cp

		SET attrValInt = CAST(attrVal AS INTEGER)

	FROM APP_CompanyProp cp

	WHERE

		attrType in (

			5,	--PROPERTY_SHORT

			6,	--PROPERTY_USHORT

			7,	--PROPERTY_INTEGER

			8,	--PROPERTY_UINTEGER

			9,	--PROPERTY_LONG

			10	--PROPERTY_ULONG

		)

		AND LEN(attrVal) <= 10		-- largest integer string possible

		AND ISNUMERIC(attrVal) = 1
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@AttrValIntGuid, 'AttrValIntAdded', 'Populate attrValInt Column from existing attrVal for Integer data', @nowTime, 16, 0 , (16 + 2))

	PRINT 'APP_CompanyPropAttrValInt: conversion completed'

END

