

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/APP_CompanyProp.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

------------------------------------------------------------------------

-- rcsid[]='@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/APP_CompanyProp.script,v $ $Id: APP_CompanyProp.script,v 1.1.2.37 2020/06/10 14:31:57 sthakkar Exp $';

--TABLENAME APP_CompanyProp

SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON

GO

DECLARE @CompanySettingsMigrateGUID	VARCHAR(40) = '4E1D4F8A-83EC-4301-A029-9642164323E3'

-- Tbl script file should not have any function calls because they may not exist during upgrade

DECLARE @nowTimeUTC int = datediff(second, '01/01/1970', getUTCDate())

IF NOT EXISTS(SELECT TOP 1 * FROM	GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE	gp.SqlScriptGUID = @CompanySettingsMigrateGUID)	

BEGIN

	DECLARE @nowTime	int =  DATEDIFF(second, '01/01/1970', GETUTCDATE())

	DECLARE @creationTimeSettingID INT = 2415

	DECLARE @SCGSettingID INT = 2416

	-- For all current settings, get the owner company,settings and insert them into table.

	DECLARE @tblProviders TABLE (providerId INT, OwnerId INT, SettingId INT, SettingValue NVARCHAR(MAX))

	DECLARE @tblSettings TABLE (providerId INT, OwnerId INT, SettingId INT, SettingValue NVARCHAR(MAX))
	INSERT INTO @tblProviders (providerId, OwnerId, SettingId, SettingValue)


		SELECT DISTINCT ACP.componentId, CASE UD.serviceType 

WHEN 5 THEN UD.ID

WHEN 2 THEN UD.ownerCompany

WHEN 1 THEN 0

                                  ELSE 0

                                  END, ACP.propertyTypeId,ACP.stringVal

				FROM App_ComponentProp ACP

			INNER JOIN UMDSProviders UD

ON UD.ID=ACP.componentId AND ACP.componentType=10 AND ACP.modified=0

	-- Insert setting for Company creation time.

	-- It is one time hack to get the creation time from umuser prop of the primary contact
	INSERT INTO @tblProviders


	SELECT UD.id, UD.id, @creationTimeSettingID, UUP.created FROM UMDSProviders UD 

		INNER JOIN UMUsers UU

			ON UU.umDSproviderId=UD.id

		INNER JOIN UMUsersProp UUP 

			ON UU.id=UUP.componentNameId AND UUP.attrName = 'Primary Contact' AND UUP.attrVal=N'1'

WHERE UD.serviceType= 5

	-- In case we have some entry where we have child AD entry AS WELL as Owner company ID, then simply honour parent company ID

	-- Remove any child provider settings

    DELETE FROM @tblProviders WHERE (OwnerId IN (SELECT DISTINCT providerId FROM @tblProviders)  AND OwnerId <> providerId) OR (OwnerId NOT IN (SELECT id from UMDSProviders))

	-- Add smart client group details
	INSERT INTO @tblProviders 


		SELECT UD.id, UD.id, @SCGSettingID,AC.id from APP_ClientGroup AC

			INNER JOIN UMDSProviders UD

ON AC.name= UD.domainName AND ((AC.flag & 0x1000) <> 0) AND ((UD.flags & 0x0002) = 0)

	-- For handling Of sub-domains, we havbe to use another table to get data right., i.e. in cae of multiple values, make it comma seprated
	INSERT INTO @tblSettings 


		SELECT providerId, OwnerId, SettingId, STUFF((SELECT ',' + SettingValue

         FROM @tblProviders 

         WHERE SettingId = t.SettingId and providerId=T.providerId

         FOR XML PATH(''))

		 ,1,1,'') FROM @tblProviders t

WHERE SettingId=2412

		group BY providerId, SettingId, OwnerId

	-- Insert company creation time. to avoid multiple primary contact scenario, we handle them seprately.
	INSERT INTO @tblSettings


	select providerId,OwnerId,SettingId, min(SettingValue) FROM @tblProviders where SettingId=@creationTimeSettingID group by providerId,OwnerId,SettingId

	-- Insert all other settings in final table
	INSERT INTO @tblSettings 


SELECT providerId, OwnerId, SettingId, SettingValue FROM @tblProviders WHERE SettingId NOT IN (2412, @creationTimeSettingID)

	-- Now migrate these settings

	-- Attrtype is not right.. we will correct at bottom

	MERGE APP_CompanyProp TGT

	USING @tblSettings SRC

	ON TGT.componentNameId = SRC.OwnerId

	WHEN NOT MATCHED THEN

		INSERT (componentNameId, attrName, attrType, attrVal, created, modified)

		VALUES (SRC.OwnerId,CASE SRC.SettingId

WHEN 2400				THEN		'Customization'

WHEN 2401						THEN		'Primary Domain'

WHEN 2410		THEN		'Default Laptop Plan'

WHEN 2411		THEN		'Default Server Plan'

WHEN 2413 		THEN		'Default Snap Plan'

WHEN 2412					THEN		'Sub Domain'

WHEN 2405				THEN		'Notification Email'

WHEN 2409			THEN		'Notification Sender Name'

WHEN @creationTimeSettingID                         THEN		'Creation Time'				-- this is a new property. 2415 is not actual property id in codebase. Will only be used by script

WHEN @SCGSettingID                                  THEN        'Associated Smart Client Group'

							ELSE 'NOT SUPPORTED'

END , 1, SRC.SettingValue, @nowTime, 0);

	-- Delete any entry which is not supposed to be there

	DELETE FROM APP_CompanyProp WHERE attrName='NOT SUPPORTED'

	-- Update script table , so that this code doesn't execute anymore'
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@CompanySettingsMigrateGUID, 'CompanySettingsMigrate', 'Migrate Settings from ComponentProp to CompanyProp', @nowTime, 16, 0 , (16 + 2))

END

DECLARE @CompanySCGSecurityCorrectionsGUID	VARCHAR(40) = '299a3944-cff4-47d9-a4d1-832a2d71165a'

IF NOT EXISTS(SELECT TOP 1 * FROM	GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE	gp.SqlScriptGUID = @CompanySCGSecurityCorrectionsGUID)	

BEGIN

	IF OBJECT_ID('tempdb.dbo.#providerDetails') IS NOT NULL

			DROP TABLE #providerDetails

	CREATE TABLE #providerDetails (providerID INT PRIMARY KEY, tenantAdminGroupId INT, groupName NVARCHAR(1024), providerName NVARCHAR(1024), scgID INT)
	INSERT INTO #providerDetails


	SELECT UD.id, UG.id, UG.name, UD.domainName, CAST(ACP.attrVal AS INT) FROM UMDSProviders UD

	INNER JOIN UMGroups UG

ON UG.umdsProviderId=UD.id AND UG.groupFlags&0x10000=0x10000

	INNER JOIN App_CompanyProp ACP

ON ACP.componentNameId=UD.id AND ACP.attrName='Associated Smart Client Group' AND ISNUMERIC(ACP.attrVal) = 1

	INNER JOIN APP_ClientGroup ACG

ON ACG.id=CAST(ACP.attrVal AS INT) AND ACG.flag&0x1000=0x1000

WHERE UD.serviceType=5 AND UD.flags&0x0002=0 AND UD.enabled=1

DECLARE @tenantAdminRoleId INT= (SELECT id FROM UMRoles WHERE flags & 256 <> 0)

DECLARE @adminUserId INT = (SELECT TOP 1 id FROM UMUsers WHERE flags & 0x040 <> 0)

DECLARE @masterRoleId INT= ISNULL((SELECT id FROM UMRoles WHERE name = 'Master' AND flags & 1 | 2 <> 0), 1)

	UPDATE Sec 

	SET roleId = @tenantAdminRoleId

	FROM UMSecurityAssociations Sec 

		 INNER JOIN #providerDetails Temp

			ON Sec.isUser = 0 AND Sec.userOrGroupId = Temp.tenantAdminGroupId 

		    AND Sec.entityType1 = 28 /*CLIENT_GROUP_ENTITY*/ AND Sec.entityId1 = Temp.scgId 

			AND Sec.roleId=@masterRoleId	

	IF OBJECT_ID('tempdb.dbo.#providerDetails') IS NOT NULL

			DROP TABLE #providerDetails

	-- Update script table , so that this code doesn't execute anymore'

	-- Tbl script file should not have any function calls because they may not exist during upgrade
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@CompanySCGSecurityCorrectionsGUID, 'CompanySCSecurityCorrection', 'Script to update security rights for Tenant Admin On Company SCG', @nowTimeUTC, 16, 0 , (16 + 2))

END

--Hide the Web Console advance settings in GUI

DECLARE @UpdateCustomizationSettingsFlag	VARCHAR(40) = 'C62ECDE0-813E-4855-8EC0-940DA6A83910'

IF NOT EXISTS(SELECT TOP 1 * FROM	GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE	gp.SqlScriptGUID = @UpdateCustomizationSettingsFlag)	

BEGIN
	INSERT INTO app_advancesettingsEx(keyId  , details, hidden)


	SELECT id, '', 1 from APP_AdvanceSettings 

	WHERE relativePath= 'WebConsole\Customization' AND ID NOT IN (SELECT keyid FROM app_advancesettingsex)

	-- Update script table , so that this code doesn't execute anymore

	-- Tbl script file should not have any function calls because they may not exist during upgrade
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@UpdateCustomizationSettingsFlag, 'UpdateCustomizationSettingsFlag', 'Script to add hidden flag to Additional settings for customization', @nowTimeUTC, 16, 0 , (16 + 2))

END

DECLARE @CompanySCGFlagUpdate	VARCHAR(40) = '24061618-95F2-4DC3-A9E7-58451A23DEAF'

IF NOT EXISTS(SELECT TOP 1 * FROM	GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE	gp.SqlScriptGUID = @CompanySCGFlagUpdate)	

BEGIN	

UPDATE APP_ClientGroup          SET flag =       (flag       | 1073741824) WHERE id in(

SELECT CAST(attrVal AS INT)  FROM App_CompanyProp WHERE attrName='Associated Smart Client Group' AND cs_attrName = checksum('Associated Smart Client Group') and modified=0)

	-- Update script table , so that this code doesn't execute anymore

	-- Tbl script file should not have any function calls because they may not exist during upgrade
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@CompanySCGFlagUpdate, 'CompanySCGFlagUpdate', 'Script to set flag On Company SCG that gorup is associated to a company', @nowTimeUTC, 16, 0 , (16 + 2))

END

-- Migrate Settings from App_AdvanceSettings to App_companyProp if some user want to enable Company as User Centric Prefered

DECLARE @MigrateSettingsforSharedLaptopUsage	VARCHAR(40) = '007b8213-7d70-47a7-a9c0-bf9d4f1e1a45'

IF NOT EXISTS(SELECT TOP 1 * FROM	GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE	gp.SqlScriptGUID = @MigrateSettingsforSharedLaptopUsage)	

BEGIN

	-- Only migrate setting from app_advancesetting if there is no current setting for shared laptop usage
	INSERT INTO App_CompanyProp(componentNameId, attrName, attrType, attrVal, created, modified)


SELECT UD.id, 'Prefer Machine Centric Client',7,0,dbo.GetUnixTime (GetUTCdate()),0  FROM APP_AdvanceSettings AAD  WITH(NOLOCK)

	INNER JOIN UMDSProviders UD WITH(NOLOCK)

ON UD.id=AAD.entityid AND UD.serviceType=5 AND AAD.entitytype=61 AND AAD.keyname='Enable Shared Laptop Usage' AND AAD.relativePath='CommServDB.Console' AND CAST(AAD.value AS NVARCHAR(256))=N'1' AND AAD.enabled=1

	LEFT OUTER JOIN App_CompanyProp ACP WITH(NOLOCK)

ON ACP.componentNameId=UD.id AND ACP.attrName='Prefer Machine Centric Client' AND ACP.modified=0

	WHERE ACP.id IS NULL

	-- Remove key values from App_AdvanceSettings

DELETE FROM APP_AdvanceSettings WHERE keyname='Enable Shared Laptop Usage'
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@MigrateSettingsforSharedLaptopUsage, 'MigrateSettingsforSharedLaptopUsage', 'Script to migarte shared laptop usage setting from App_AdvanceSetting to App_CompanyProp', @nowTimeUTC, 16, 0 , (16 + 2))

END

IF NOT EXISTS(SELECT TOP 1 * FROM	GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE	gp.SqlScriptGUID = '8FCA91EA-FB76-4FEE-B43E-96A3709BB20A')	

BEGIN

IF EXISTS (select value from GxGlobalParam WITH (NOLOCK) where Name = 'EnableTwoFactorAuthentication'

				and value = '1')

	BEGIN

		-- If CC has TFA enabled, enable it for all companies, else the default is disabled.
		INSERT INTO App_CompanyProp(componentNameId, attrName, attrType, attrVal, created, modified)


SELECT UD.id, 'EnableTwoFactorAuthentication',7,1,@nowTimeUTC,0

		FROM UMDSProviders UD WITH(NOLOCK)

where UD.serviceType=5

	END
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


	VALUES('8FCA91EA-FB76-4FEE-B43E-96A3709BB20A', 'EnableTwoFactorAuthentication', 

			'Script to Enable Two Factor Authentication for Companies if enabled at Commcell Level ', 

@nowTimeUTC, 16, 0 , (16 + 2))

END

--Set the supported solutions bitmask value for existing tenants.

IF NOT EXISTS(SELECT TOP 1 * FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = 'ADEE5538-473C-447E-9A24-68D4C7DDCB7B') 

BEGIN

	-- If value is found from previous upgrade script then update it

UPDATE App_CompanyProp SET attrVal = '0' WHERE attrName = 'supportedSolutions' and attrVal = 4127
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


	VALUES('ADEE5538-473C-447E-9A24-68D4C7DDCB7B', 'supportedSolutions',

		'Script to show the supported solutions for existing tenants.',

@nowTimeUTC, 16, 0 , (16 + 2))

END

--Set Auto retire devices properties for existing tenants

IF NOT EXISTS(SELECT TOP 1 * FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = 'A397B224-A223-46D4-9ADD-FAB4D13660D3') 

BEGIN 
	INSERT INTO App_CompanyProp (componentNameId, attrName, attrVal, attrType, modified,created)  


SELECT UD.id,'Force delete devices after days',-1, 7,0,@nowTimeUTC

	FROM UMDSProviders UD WITH(NOLOCK) 

where UD.serviceType=5

	UNION ALL

SELECT UD.id,'Retire devices after days', 183, 7,0,@nowTimeUTC

	FROM UMDSProviders UD WITH(NOLOCK)

where UD.serviceType=5
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


	VALUES('A397B224-A223-46D4-9ADD-FAB4D13660D3', 'autoRetireDevices',

		'Script to add properties for auto retire devices for existing tenants',

@nowTimeUTC, 16, 0 , (16 + 2))

END

--Cleanup of Encryption Settings incorrectly set on company and commcell level

DECLARE @EncryptionSettingsCleanUp	VARCHAR(40) = '52022DA0-5788-4337-83B4-4C73C652AB1F'

IF NOT EXISTS(SELECT TOP 1 * FROM	GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE	gp.SqlScriptGUID = @EncryptionSettingsCleanUp)	

BEGIN

DELETE FROM App_CompanyProp WHERE attrName IN ('Encryption Settings' ,'Encrypt: Type', 'Encrypt: Key Length', 'Encrypt: drToolAccess')

DELETE FROM APP_ClientProp WHERE attrName = 'Override Global Encryption Settings'

	-- Update script table , so that this code doesn't execute anymore'

	-- Tbl script file should not have any function calls because they may not exist during upgrade
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@EncryptionSettingsCleanUp, 'CompanyEncryptionSettingsCleanup', 'Script to clean up properties of encryption feature on company level which is not yet available', @nowTimeUTC, 16, 0 , (16 + 2))

END

IF NOT EXISTS(SELECT TOP 1 * FROM	GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE	gp.SqlScriptGUID = 'E4CB3D40-5CA6-492A-8BB7-FB7B37F51A91')	

BEGIN

	Declare @initial_val nvarchar(max)

select @initial_val = value from GXGlobalParam where Name = 'completedSetups'

	IF @initial_val IS NOT NULL

	BEGIN

		--if value is found from previous upgrade script then update it, else insert into App_CompanyProp

		MERGE App_CompanyProp AC

USING (select id from UMDSProviders WITH(NOLOCK) where serviceType=5) as Providers

ON componentNameId=Providers.id and attrName='completedSetups'

		WHEN MATCHED THEN

			UPDATE SET attrVal = @initial_val 

		WHEN NOT MATCHED THEN

			INSERT (componentNameId, attrName, attrType, attrVal, created, modified) 

VALUES(Providers.id, 'completedSetups', 1,@initial_val,@nowTimeUTC,0);

	END
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


	VALUES('E4CB3D40-5CA6-492A-8BB7-FB7B37F51A91', 'completedSetups', 

			'Script to inherit Completed setups from the MSP.', 

@nowTimeUTC, 16, 0 , (16 + 2))

END

IF NOT EXISTS(SELECT TOP 1 * FROM	GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE	gp.SqlScriptGUID = '0229B669-70D5-477C-8405-728E97961CAA')	

BEGIN

	--delete the empty keys that got created

	SET @nowTime	=  DATEDIFF(second, '01/01/1970', GETUTCDATE())

	IF OBJECT_ID('tempdb.dbo.#clients') IS NOT NULL

			DROP TABLE #clients

	CREATE TABLE #clients (clientId INT)
	INSERT INTO #clients


	SELECT entityId FROM app_advancesettings WHERE relativePath = 'WebConsole\Customization' AND entityType=3 AND keyName=''

	UNION

	SELECT  A.entityId

	FROM app_advancesettings  A

	LEFT JOIN UMDSProviders P ON CONVERT(INT,CONVERT(VARCHAR(20),A.value)) = p.id

	WHERE relativePath = 'WebConsole\Customization'

	AND keyName<>'' AND ISNUMERIC(CONVERT(VARCHAR(20),value))=1 and p.id is null

	UPDATE app_advancesettings SET deleted=1

	WHERE relativePath = 'WebConsole\Customization' AND entityType=3 AND keyName=''

	--delete the keys for deleted companies

	UPDATE  A SET A.deleted=1

	FROM app_advancesettings  A

	LEFT JOIN UMDSProviders P ON CONVERT(INT,CONVERT(VARCHAR(20),A.value)) = p.id

	WHERE relativePath = 'WebConsole\Customization'

	AND keyName<>'' AND ISNUMERIC(CONVERT(VARCHAR(20),value))=1 and p.id is null

	AND entityType=3 
	INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)


	SELECT C.clientId, 6 /*WORK_TOKEN_REGISTRY*/, '', @nowTime, 0, 0, 0, -1

	FROM #clients C

	INNER JOIN APP_Client AC WITH(NOLOCK)

	ON AC.id=C.clientId

	IF OBJECT_ID('tempdb.dbo.#clients') IS NOT NULL

			DROP TABLE #clients
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


	VALUES('0229B669-70D5-477C-8405-728E97961CAA', 'cleanupCustomizationSettings', 

			'Script to clean up unwanted customization keys for admin console.', 

@nowTimeUTC, 16, 0 , (16 + 2))

END

IF NOT EXISTS(SELECT TOP 1 * FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = '28F7E516-7D93-4903-AD07-142928ABE01A')	

BEGIN

	-- Duplicate entries in GxGlobalParam for 'Use UPN For Email' will have to be removed manually.

	-- Handle fix due to issue caused by form 74655 (SP17). 

	-- Introducing new variable to prevent issues caused by reusing old variable when upgrading from Sp14 or older to Sp17

	DECLARE @curr_val nvarchar(max) = NULL	

select @curr_val = attrVal from App_CompanyProp where attrName = 'Use UPN For Email' AND componentNameId = 0

AND modified = 0 AND cs_attrName = checksum('Use UPN For Email')

	IF @curr_val IS NOT NULL

	BEGIN

		--if value is found from previous upgrade script then update it, else insert into GXGlobalParam

UPDATE GXGlobalParam SET value = @curr_val WHERE name = 'Use UPN For Email'

		IF @@ROWCOUNT = 0
INSERT INTO GXGlobalParam values('Use UPN For Email',@curr_val,@nowTime,0)


DELETE FROM App_CompanyProp WHERE attrName = 'Use UPN For Email' AND componentNameId = 0

	END
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('28F7E516-7D93-4903-AD07-142928ABE01A', 'Use UPN For Email',

			'Script to ensure consistency for UPN property', 

@nowTimeUTC, 16, 0 , (16 + 2))

END

IF NOT EXISTS(SELECT TOP 1 * FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = '9CC25F09-ECA6-4FB2-8EE3-CEBC6B5AEBAE')

BEGIN

	-- Upon upgrading to SP17 from SP14 or older, the gxglobalParam 'Use UPN For Email' can get unexpected values due to reuse of variable set in

	-- 'completedSetups' without proper flushing. Below sql statement deletes those invalid entries.

DELETE FROM GXGlobalParam WHERE name = 'Use UPN For Email' AND value NOT IN ('0','1')
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('9CC25F09-ECA6-4FB2-8EE3-CEBC6B5AEBAE', 'Use UPN For Email',

		'Script to remove unexpected values for UPN property', 

@nowTimeUTC, 16, 0 , (16 + 2))

END

IF NOT EXISTS(SELECT TOP 1 * FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = '913166D7-26B3-4147-9059-D7141DDB0EF7')

BEGIN

	-- Whenever company is deactivated/activated, the deactivation and activation time needs to be updated in DB.

	-- For existing companies, based on current state, we are setting the activation or deactivation time. 

	-- 1) If company is currently deactivated, set deactivation time as time when this script was run.

	-- 2) If company is currently activated, no need to set anything since activation time is considered to be same as company creation time. 
	INSERT INTO App_CompanyProp(componentNameId, attrName, attrType, attrVal, created, modified)


SELECT UD.id, 'Deactivation time',7,@nowTimeUTC,@nowTimeUTC,0 FROM UMDSProviders UD WITH(NOLOCK)

WHERE UD.serviceType=5 AND (UD.flags & 0x0010 = 0x0010)
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('913166D7-26B3-4147-9059-D7141DDB0EF7', 'Deactivation time',

		'Script to add deactivation time for deactivated companies', 

@nowTimeUTC, 16, 0 , (16 + 2))

END

IF NOT EXISTS(SELECT TOP 1 * FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = '9047DC19-7D82-4809-A75D-2B01E2AEFFD3')	

BEGIN

	DECLARE @now integer

	SET @now = dbo.getUnixtime(GetUTCDate())

	DECLARE @isGlobalLevelNavItemsSet INT = 0

IF EXISTS(SELECT 1 FROM GXGlobalParam WHERE NAME IN ('Restricted Nav Items For MSP Admin' ,'Restricted Nav Items For MSP User','Restricted Nav Items For Restricted Admin') and modified=0)

	BEGIN

		SET @isGlobalLevelNavItemsSet = 1

	END

	--This is a look up table

	DECLARE @CompletedSetupsToState table(setup nvarchar(50), state nvarchar(50), PRIMARY KEY (setup, state))
	INSERT INTO @CompletedSetupsToState VALUES


	('CASSANDRA','bigDataApps'),

	('EXCHANGE_DAG','exchange'),

	('EXCHANGE_MAILBOX','exchange'),

	('SHAREPOINT', 'sharepoint'),

	('ACTIVE_DIRECTORY', 'activeDirectory'),

	('EXCHANGE_ONLINE', 'office365Exchange'),

	('ONEDRIVE_FOR_BUSINESS', 'office365OneDrive'),

	('ARCHIVING', 'archivingDataSourcesList'),

	('EBS', 'ebsApps'),

	('COMPLIANCE', 'ediscovery'),

	('CAPPS_ONEDRIVE', 'office365V2'),

	('EXCHANGE_ONLINE', 'office365V2'),

	('SHAREPOINT_ONLINE', 'office365V2'),

	('SALESFORCE','cappsClients'),

	('AMAZON_SQL','cappsClients'),

	('AZURE_SQL','cappsClients'),

	('GSUITE','gsuiteApps'),

	('OFFICE365','office365V2')

	--------gobal level settings----------------------------

	DECLARE @RestrictedNavItemsForMSPAdmin NVARCHAR(MAX) 

	DECLARE @RestrictedNavItemsForMSPUser NVARCHAR(MAX) 

	DECLARE @RestrictedNavItemsForRestrictedAdmin NVARCHAR(MAX)

	DECLARE @globalLevelCompletedSetups nvarchar(max) = ''

	DECLARE @TempNavItemTbl TABLE (navItem NVARCHAR(MAX))

	DECLARE @GlobalLevelCompletedSetupsTbl TABLE (navItem NVARCHAR(50) primary key, state NVARCHAR(10))	-- AEB navItem, state PK

	IF @isGlobalLevelNavItemsSet = 1

	BEGIN 

SELECT  @globalLevelCompletedSetups = value FROM GXGlobalParam WHERE name = 'completedSetups'

		--formating the string({"CAPPS":true,"EXCHANGE":true,"CORE_SETUP":true}) to a table(@GlobalLevelCompletedSetupsTbl)

		SET @globalLevelCompletedSetups = REPLACE(@globalLevelCompletedSetups, '{','')

		SET @globalLevelCompletedSetups = REPLACE(@globalLevelCompletedSetups, '}','')

		SET @globalLevelCompletedSetups = REPLACE(@globalLevelCompletedSetups, '"','')
		INSERT INTO @TempNavItemTbl


		SELECT _ID FROM dbo.SplitStringByDelimiter(@globalLevelCompletedSetups,',')
       INSERT INTO @GlobalLevelCompletedSetupsTbl


       SELECT   S._Name, s._Value  FROM @TempNavItemTbl AC

       CROSS APPLY dbo.SplitStringByDelimiterToTable(AC.navItem, ':') S

	   --converting to table is completed

       DECLARE @TempRestrictedNavItems table (navItem nvarchar(50) )
       INSERT INTO @TempRestrictedNavItems


       --GET NOT COMPLETED ONE

       SELECT c.state FROM @CompletedSetupsToState C

       LEFT JOIN @GlobalLevelCompletedSetupsTbl g ON g.navItem = c.setup

       WHERE (g.navItem is null or g.state= 'false') --and setup not in   ('VSA','ENDPOINT','ADMIN_CONSOLE', 'DBS','CAPPS')

       EXCEPT

       --GET COMPLETED ONES

       SELECT c.state FROM @CompletedSetupsToState C

       INNER join @GlobalLevelCompletedSetupsTbl g ON g.navItem = c.setup

       WHERE  g.state= 'true'

       DECLARE @RestrictedNavItemsInDB table (navItem nvarchar(50) )

IF EXISTS (SELECT 1 FROM GXGlobalParam WHERE NAME = 'Restricted Nav Items For MSP Admin' and modified=0)

       BEGIN
              INSERT INTO @RestrictedNavItemsInDB


              SELECT S._ID

              FROM GXGlobalParam 

              CROSS APPLY dbo.SplitStringByDelimiter(value,',') S

WHERE name = 'Restricted Nav Items For MSP Admin'
              INSERT INTO @RestrictedNavItemsInDB(navItem)


              SELECT T.navItem from @TempRestrictedNavItems T

              LEFT JOIN @RestrictedNavItemsInDB R ON T.navItem=R.navItem WHERE R.navItem IS NULL

              SELECT @RestrictedNavItemsForMSPAdmin=COALESCE(@RestrictedNavItemsForMSPAdmin + ',', '') + navItem FROM @RestrictedNavItemsInDB 

UPDATE GXGlobalParam SET value=@RestrictedNavItemsForMSPAdmin WHERE name = 'Restricted Nav Items For MSP Admin' AND modified = 0

			  IF(@@ROWCOUNT = 0)

              BEGIN                                                     
                     INSERT INTO GXGlobalParam(name, value, created, modified)                           


VALUES ('Restricted Nav Items For MSP Admin',@RestrictedNavItemsForMSPAdmin , @now, 0)

              END

       END

       ---------Restricted Nav Items For MSP User------------------

       DELETE @RestrictedNavItemsInDB

IF EXISTS (SELECT 1 FROM GXGlobalParam WHERE NAME = 'Restricted Nav Items For MSP User' AND modified=0)

       BEGIN
              INSERT INTO @RestrictedNavItemsInDB


              SELECT S._ID

              FROM GXGlobalParam 

              CROSS APPLY dbo.SplitStringByDelimiter(value,',') S

WHERE name = 'Restricted Nav Items For MSP User'
              INSERT INTO @RestrictedNavItemsInDB(navItem)


              SELECT T.navItem from @TempRestrictedNavItems T

              LEFT JOIN @RestrictedNavItemsInDB R ON T.navItem=R.navItem WHERE R.navItem IS NULL

              SELECT @RestrictedNavItemsForMSPUser=COALESCE(@RestrictedNavItemsForMSPUser + ',', '') + navItem FROM @RestrictedNavItemsInDB 

UPDATE GXGlobalParam SET value=@RestrictedNavItemsForMSPUser WHERE name = 'Restricted Nav Items For MSP User' AND modified = 0

			  IF(@@ROWCOUNT = 0)

              BEGIN                                                     
                     INSERT INTO GXGlobalParam(name, value, created, modified)                           


VALUES ('Restricted Nav Items For MSP User',@RestrictedNavItemsForMSPUser , @now, 0)

              END            

       END

       ---------Restricted Nav Items For Restricted Admin------------------

       DELETE @RestrictedNavItemsInDB

IF EXISTS (SELECT 1 FROM GXGlobalParam WHERE NAME = 'Restricted Nav Items For Restricted Admin' AND modified=0)

       BEGIN
              INSERT INTO @RestrictedNavItemsInDB


              SELECT S._ID

              FROM GXGlobalParam 

              CROSS APPLY dbo.SplitStringByDelimiter(value,',') S

WHERE name = 'Restricted Nav Items For Restricted Admin'
              INSERT INTO @RestrictedNavItemsInDB(navItem)


              SELECT T.navItem from @TempRestrictedNavItems T

              LEFT JOIN @RestrictedNavItemsInDB R ON T.navItem=R.navItem WHERE R.navItem IS NULL

              SELECT @RestrictedNavItemsForRestrictedAdmin=COALESCE(@RestrictedNavItemsForRestrictedAdmin + ',', '') + navItem FROM @RestrictedNavItemsInDB 

UPDATE GXGlobalParam SET value=@RestrictedNavItemsForRestrictedAdmin WHERE name = 'Restricted Nav Items For Restricted Admin' AND modified = 0

			  IF(@@ROWCOUNT = 0)

              BEGIN                                                     
                     INSERT INTO GXGlobalParam(name, value, created, modified)                           


VALUES ('Restricted Nav Items For Restricted Admin' ,@RestrictedNavItemsForRestrictedAdmin , @now, 0)

              END

       END

	END

	--------end gobal level----------------------------

	--------company level------------------------

	DECLARE @FinalRestrictedNavItemsForTenantAdminTbl table (companyId int, deniedNavItems nvarchar(max))

	DECLARE @FinalRestrictedNavItemsForTenantUserTbl table (companyId int, deniedNavItems nvarchar(max))

	DECLARE @CompanyLevelCompletedSetups table(companyId int, setup nvarchar(max))

	DECLARE @CompanyNavItemTempTbl TABLE (companyId int,navItem NVARCHAR(MAX))

	DECLARE @CompanyLevelCompletedSetupsInDb TABLE (companyId int,navItem NVARCHAR(50), state NVARCHAR(10))

	DECLARE @CompanyRestrictedNavItemsInDB table (companyId int, navItem nvarchar(50) )

	DECLARE @TempCompanyRestrictedNavItems table (companyId int, navItem nvarchar(50) )
	INSERT INTO @CompanyLevelCompletedSetups(companyId , setup )


SELECT componentNameId, REPLACE (REPLACE(REPLACE(attrVal, '{', ''), '}',''), '"', '')  FROM App_CompanyProp WHERE attrName = 'completedSetups' AND modified=0
	INSERT INTO @CompanyNavItemTempTbl


	SELECT C.companyId, S._ID FROM 

	@CompanyLevelCompletedSetups  C

	CROSS APPLY dbo.SplitStringByDelimiter(C.setup,',') S
	INSERT INTO @CompanyLevelCompletedSetupsInDb


	SELECT  AC.companyId, S._Name, s._Value  FROM @CompanyNavItemTempTbl AC

	CROSS APPLY dbo.SplitStringByDelimiterToTable(AC.navItem, ':') S
	INSERT INTO @TempCompanyRestrictedNavItems(companyId, navItem)


	--get the not completed ones

	SELECT c.companyId, c.state from ( 

	SELECT DISTINCT  A.companyId as companyId, B.state as state from @CompletedSetupsToState B

	INNER JOIN		-- INNER JOIN data set below with no input column from B

	(

	SELECT c.companyId, s.state FROM @CompletedSetupsToState s

	INNER join   @CompanyLevelCompletedSetupsInDb c on c.navItem = s.setup AND C.state = 'true'

	) A

	ON B.state <> A.state 

	UNION

	--For companies for which there is no nav settings

	SELECT DISTINCT A.id, B.state from @CompletedSetupsToState B

	CROSS APPLY	

	(

	SELECT u.id FROM UMDSProviders u

	LEFT JOIN @CompanyLevelCompletedSetupsInDb d ON u.id = d.companyId

	WHERE (serviceType=5) --and d.companyId is null

	) A

	) C

	EXCEPT

	--exclude the completed one's

	SELECT g.companyId, c.state FROM @CompletedSetupsToState C

	INNER join @CompanyLevelCompletedSetupsInDb g ON g.navItem = c.setup

	WHERE  g.state= 'true'

	--------------------------------------------

	DECLARE @RestrictedNavItemsCountForCompany INT = 0

	DELETE @CompanyRestrictedNavItemsInDB
	INSERT INTO @CompanyRestrictedNavItemsInDB


	SELECT componentNameId, S._ID

	FROM App_CompanyProp 

	CROSS APPLY dbo.SplitStringByDelimiter(attrVal,',') S

WHERE attrName = 'Restricted Nav Items For Tenant Admin'

	SET @RestrictedNavItemsCountForCompany = @@ROWCOUNT

	IF (@RestrictedNavItemsCountForCompany>0  OR @isGlobalLevelNavItemsSet=1)

	BEGIN 
		INSERT INTO @CompanyRestrictedNavItemsInDB(companyId, navItem)


		SELECT t.companyId, T.navItem from @TempCompanyRestrictedNavItems T

		LEFT JOIN @CompanyRestrictedNavItemsInDB R ON T.navItem=R.navItem and t.companyId=r.companyId and R.navItem IS NULL
		INSERT INTO @FinalRestrictedNavItemsForTenantAdminTbl


		SELECT B.companyId, STUFF(

		(SELECT ',' + A.navItem

		FROM @CompanyRestrictedNavItemsInDB A

		WHERE A.companyId = B.companyId

		FOR XML PATH('')),1,1,'') AS CSV

		FROM @CompanyRestrictedNavItemsInDB AS B

		GROUP BY B.companyId

		MERGE App_CompanyProp AS T

		USING @FinalRestrictedNavItemsForTenantAdminTbl AS S

ON  T.attrName = 'Restricted Nav Items For Tenant Admin' and t.componentNameId=S.companyId  AND modified=0	and cs_attrName = checksum('Restricted Nav Items For Tenant Admin')-- cs_attrName

		WHEN MATCHED THEN

		UPDATE SET T.attrVal=s.deniedNavItems

		WHEN NOT MATCHED THEN

		INSERT (componentNameId,  attrName, attrType, attrVal, created, modified)

VALUES (s.companyId, 'Restricted Nav Items For Tenant Admin', 1, s.deniedNavItems,  @now, 0);

	END

	--------------------------------------------

	DELETE @CompanyRestrictedNavItemsInDB
	INSERT INTO @CompanyRestrictedNavItemsInDB


	SELECT componentNameId, S._ID

	FROM App_CompanyProp 

	CROSS APPLY dbo.SplitStringByDelimiter(attrVal,',') S

WHERE attrName = 'Restricted Nav Items For Tenant User'

	SET @RestrictedNavItemsCountForCompany = @@ROWCOUNT

	IF (@RestrictedNavItemsCountForCompany> 0 OR @isGlobalLevelNavItemsSet=1)

	BEGIN 
		INSERT INTO @CompanyRestrictedNavItemsInDB(companyId, navItem)


		SELECT t.companyId, T.navItem from @TempCompanyRestrictedNavItems T

		LEFT JOIN @CompanyRestrictedNavItemsInDB R ON T.navItem=R.navItem and t.companyId=r.companyId and R.navItem IS NULL
		INSERT INTO @FinalRestrictedNavItemsForTenantUserTbl


		SELECT B.companyId, STUFF(

		(SELECT ',' + A.navItem

		FROM @CompanyRestrictedNavItemsInDB A

		WHERE A.companyId = B.companyId

		FOR XML PATH('')),1,1,'') AS CSV

		FROM @CompanyRestrictedNavItemsInDB AS B

		GROUP BY B.companyId

		MERGE App_CompanyProp AS T

		USING @FinalRestrictedNavItemsForTenantUserTbl AS S

ON  T.attrName = 'Restricted Nav Items For Tenant User' and t.componentNameId=S.companyId  AND modified=0 and cs_attrName = checksum('Restricted Nav Items For Tenant User')	--

		WHEN MATCHED THEN

		UPDATE SET T.attrVal=s.deniedNavItems

		WHEN NOT MATCHED THEN

		INSERT (componentNameId,  attrName, attrType, attrVal, created, modified)

VALUES (s.companyId, 'Restricted Nav Items For Tenant User', 1, s.deniedNavItems,  @now, 0);

	END
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


	VALUES('9047DC19-7D82-4809-A75D-2B01E2AEFFD3', 'Command Center Navigation items upgrade script', 

			'Script update the naviation items based on the completed solution', 

@nowTimeUTC, 16, 0 , (16 + 2))

END

IF NOT EXISTS(SELECT TOP 1 * FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = '6BF9EA7E-5196-4B4B-A7E3-9D40D1807513')	

BEGIN

-- Company attributes 'ClientOwnerAssignmentType' and 'ClientOwnerAssignmentValue' were introduced in sp18 for feature "automatic client owner assignment in command center",

	-- but because the feature was not ready to ship, most of the code were disabled in SP18.  However this two properties can still be written to App_CompanyProp table with default values, which could be incorrect values.

	-- To make things easier, will remove these attributes first and then populating them with correct values.

DELETE FROM App_CompanyProp WHERE attrName in ('ClientOwnerAssignmentType', 'ClientOwnerAssignmentValue')

	-- populate client owner assignment related company properties based on existing company additional settings.

	-- Retrieve GxGlobal settings

DECLARE @commcellAssignmentValue NVARCHAR(max) = ISNULL((SELECT value FROM GXGlobalParam WHERE name = 'ClientGroupForLaptop' AND modified = 0), '')

	DECLARE @commcellAssignmentType INT = (SELECT CASE WHEN @commcellAssignmentValue = '' THEN 0

WHEN @commcellAssignmentValue = 'EnumUserProfiles' THEN 1

WHEN @commcellAssignmentValue = 'SetLoggedInUserAsOwnersOnce' THEN 2

                                                       ELSE 3 END)

	-- Select additional settings 'enumuserprofiles' and 'nSetLoggedInUserAsOwnersOnce' that are enabled, not deleted and setting for client group entities into a temp table

	DECLARE @companyRegistryTable TABLE (companyId INT, keyName NVARCHAR(max), keyValue NVARCHAR(max))
	INSERT INTO @companyRegistryTable


	SELECT acp.componentNameId, aas.keyName, aas.value

FROM APP_AdvanceSettings aas INNER JOIN App_CompanyProp acp ON aas.keyName in ('enumuserprofiles', 'nSetLoggedInUserAsOwnersOnce')

AND aas.relativePath = 'iDataAgent'

                                                                   AND aas.enabled = 1 

                                                                   AND aas.deleted = 0 

AND aas.entityType = 28

AND acp.attrName = 'Associated Smart Client Group'

                                                                   AND acp.modified = 0

AND acp.cs_attrName = CHECKSUM('Associated Smart Client Group')

                                                                   AND acp.attrVal = CAST(aas.entityId AS NVARCHAR(12))

	-- Populate company property 'ClientOwnerAssignmentType' based on the additional settings
	INSERT INTO App_CompanyProp (componentNameId,  attrName, attrType, attrVal, created, modified)


SELECT companyId, 'ClientOwnerAssignmentType', 7, (CASE WHEN @commcellAssignmentType = 3 THEN '3' ELSE keyValue END), @nowTimeUTC, 0

FROM @companyRegistryTable WHERE keyName = 'enumuserprofiles'

	MERGE App_CompanyProp AS target

USING (SELECT * FROM @companyRegistryTable WHERE keyName = 'nSetLoggedInUserAsOwnersOnce') AS source

ON target.attrName = 'ClientOwnerAssignmentType' AND target.modified = 0 AND target.cs_attrName = CHECKSUM('ClientOwnerAssignmentType') AND target.componentNameId = source.companyId

	WHEN not matched THEN

		INSERT (componentNameId, attrName, attrType, attrVal, created, modified)

VALUES (source.companyId, 'ClientOwnerAssignmentType', 7, (CASE WHEN source.keyValue = '1' THEN '2'

                                                                                                                WHEN source.keyValue = '0' AND @commcellAssignmentType = 2 THEN '0' 

                                                                                                                WHEN source.keyValue = '0' AND @commcellAssignmentType <> 2 THEN @commcellAssignmentType 

                                                                                                                ELSE @commcellAssignmentType END),

				@nowTimeUTC, 0)

	WHEN matched AND source.keyValue = '1' THEN

		UPDATE SET target.attrVal = '2'

	;

	-- Populate property 'ClientOwnerAssignmentValue' based on property 'ClientOwnerAssignmentType'
	INSERT INTO App_CompanyProp (componentNameId,  attrName, attrType, attrVal, created, modified)


SELECT componentNameId, 'ClientOwnerAssignmentValue', 1,

(CASE WHEN attrVal = '0' THEN 'Administrators,admin,'

WHEN attrVal = '1' THEN 'EnumUserProfiles'

WHEN attrVal = '2' THEN 'SetLoggedInUserAsOwnersOnce'

				WHEN attrVal = '3' THEN @commcellAssignmentValue

				ELSE '' END),

		   @nowTimeUTC, 0

FROM App_CompanyProp WHERE attrName = 'ClientOwnerAssignmentType' AND modified = 0 AND cs_attrName = CHECKSUM('ClientOwnerAssignmentType')
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


	VALUES('6BF9EA7E-5196-4B4B-A7E3-9D40D1807513', 'Client owner assignment feature in AdminConsole support upgrade', 

			'Script to populate client owner assignment related company properties based on existing company additional settings', 

@nowTimeUTC, 16, 0 , (16 + 2))

END

IF NOT EXISTS(SELECT TOP 1 * FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = '76ee8649-1949-425b-995e-93591f122c38')

BEGIN

	UPDATE cp

SET attrtype = 7

    FROM APP_CompanyProp cp

    WHERE

        attrName in (

'Default Server Plan',

'Default Laptop Plan',

'Default Snap Plan',

'Default DB Plan',

'Default File System Plan',

'Default File System Plan',

'Default Virtual Server Backup Plan',

'Default Virtual Server Replication Plan',

'Associated Smart Client Group',

'ClientOwnerAssignmentType',

'Prefer Machine Centric Client',

'Enable Auth Code Generation',

'Use UPN For Email',

'EnableTwoFactorAuthentication',

'Allow Users To Enable Privacy',

'PremiseStorageType',

'API Quota Limit',

'API Quota Time Frame',

'Always activate with default plan',

'Allow to Manage Other Companies'

        )

        AND LEN(attrVal) <= 10      -- largest integer string possible

        AND ISNUMERIC(attrVal) = 1

	UPDATE cp

SET attrtype = 1

    FROM APP_CompanyProp cp

    WHERE

        attrName in (

'completedSetups',

'Authorization Code'

        )
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('76ee8649-1949-425b-995e-93591f122c38', 'Attrtype update for all company properties', 'Script to map correct attrtype values with correct attrname.', @nowTimeUTC, 16, 0 , (16 + 2))

END

IF NOT EXISTS(SELECT TOP 1 * FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = 'E8A928F0-FBC2-4F83-862D-6E4108279C18')

BEGIN

	;with cte

	AS

	(

	SELECT componentNameId, id, row_number() OVER ( partition by componentNameId, attrname order by id desc) as rn 

	FROM App_CompanyProp 

WHERE attrname IN  ('Default Server Plan','Default Laptop Plan','Default File System Plan' , 'Default DB Plan',  'Default Virtual Server Backup Plan','Default Virtual Server Replication Plan')

	AND modified =0

	)

	DELETE  FROM cte WHERE rn >1
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('E8A928F0-FBC2-4F83-862D-6E4108279C18', 'Delete duplicate default plans', 'Script to Delete duplicate default plans set.', @nowTimeUTC, 16, 0 , (16 + 2))

END

IF NOT EXISTS(SELECT TOP 1 * FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = '0D09102C-770A-4936-8037-9978ACBFAA83')

BEGIN

	UPDATE cp

        SET attrvalInt = attrVal

    FROM APP_CompanyProp cp

    WHERE

        attrName in (

'Default Server Plan',

'Default Laptop Plan',

'Default Snap Plan',

'Default DB Plan',

'Default File System Plan',

'Default File System Plan',

'Default Virtual Server Backup Plan',

'Default Virtual Server Replication Plan',

'Associated Smart Client Group',

'ClientOwnerAssignmentType',

'Prefer Machine Centric Client',

'Enable Auth Code Generation',

'Use UPN For Email',

'EnableTwoFactorAuthentication',

'Allow Users To Enable Privacy',

'PremiseStorageType',

'API Quota Limit',

'API Quota Time Frame',

'Always activate with default plan',

'Allow to Manage Other Companies',

'Operator User Group Id',

'Operator Role',

'AuthorizationType',

'Creation Time'

        )

        AND LEN(attrVal) <= 10      -- largest integer string possible

        AND ISNUMERIC(attrVal) = 1

		AND attrVal <> CAST(attrValInt AS NVARCHAR(10))
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('0D09102C-770A-4936-8037-9978ACBFAA83', 'attrvalInt update for all company properties', 'Script to map populate attrvalInt from attrVal values with correct attrname.', @nowTimeUTC, 16, 0 , (16 + 2))

END

