

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/APP_CommCellProp.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

GO

SET QUOTED_IDENTIFIER ON

GO

SET NOCOUNT ON

DECLARE @nowTime INT = DATEDIFF(second, '01/01/1970', GetUTCdate())

IF NOT EXISTS(SELECT * FROM   GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = '7E323B1B-BE14-4B2A-9478-E5345BAC62AC' )

BEGIN

	BEGIN TRY

        BEGIN TRANSACTION App_CommcellPropScript

		DECLARE @WebEndpointsXML XML 

		DECLARE @WebEndpoints TABLE (commcellId INT,webConsoleUrl nvarchar(max), webServerUrl nvarchar(max), WebEndPointXML XML,commcellType INT)

DECLARE @LocalCommCellType INT = 0
		INSERT INTO @WebEndpoints


		SELECT DISTINCT ACP1.componentId,NULL,ACP1.stringVal,NULL,

		CASE WHEN ACP2.longlongVal = 0

THEN 2

		WHEN ACP2.longlongVal = 1

THEN 8

				END

			FROM APP_ComponentProp AS ACP1

		INNER JOIN APP_ComponentProp ACP2 on ACP1.componentId = ACP2.componentId

WHERE ACP1.componentType=1 and ACP1.propertyTypeId = 17 and ACP2.componentType = 1048 and ACP2.propertyTypeId = 2  and ACP2.componentId <> 2

IF EXISTS (Select 1 from @WebEndpoints where commcellType = 8)

SET @LocalCommCellType = @LocalCommCellType | 4

IF EXISTS(Select 1 from @WebEndpoints where commcellType = 2)

SET @LocalCommCellType = @LocalCommCellType | 1

		-- start block for on-prim subscriber of cloud service

		-- If cloud service is registered then set LocalCommcellType

		DECLARE @cloudServiceCSID INT = 0

		SELECT TOP 1 @cloudServiceCSID =  AC.id FROM App_Commcell AC

			INNER JOIN APP_ClientProp ACP  ON ACP.componentNameId = AC.clientId

WHERE ACP.attrName = 'Commcell role' AND ACP.attrVal = 5

		IF(@cloudServiceCSID <> 0) --local CS is a on-prim subscriber of cloud service

SET @LocalCommCellType = @LocalCommCellType | 32

		-- insert subscribed cloud services in @WebEndPoints
		INSERT INTO @WebEndpoints (commcellId ,webConsoleUrl, webServerUrl, WebEndPointXML,commcellType)


SELECT DISTINCT AC.id, ACP.attrVal, NULL, NULL, 16

		FROM App_ClientProp ACP 

			INNER JOIN App_ClientProp ACP2 

ON ACP2.componentNameId = ACP.componentNameId AND ACP2.attrName = 'Commcell role' AND ACP2.attrVal = 5 AND ACP.attrName = 'Service commcell end point'

			INNER JOIN App_Commcell AC ON AC.clientId = ACP.componentNameId

		-- end block for on prim subscriber of cloud service

		-- start block for cloud service

		DECLARE @cloudServiceSubscriberExists INT = 0

		SELECT TOP 1 @cloudServiceSubscriberExists =  1 FROM App_ThirdpartyApp TP

			INNER JOIN App_ComponentProp ACP

ON ACP.componentType = 1034 AND ACP.componentId = TP.id AND ACP.propertyTypeId = 5

		IF(@cloudServiceSubscriberExists <> 0) --local CS is a cloud service

SET @LocalCommCellType = @LocalCommCellType | 16

		--end block for cloud service

		UPDATE @WebEndpoints SET webConsoleUrl = 

			PROPS.value('(/props/nameValues[@name="RedirectUrl"]/@value)[1]','nvarchar(max)') FROM APP_CommCell AC 

			INNER JOIN App_ThirdPartyApp ATP on AC.csGUID = ATP.appName 

			INNER JOIN APP_ComponentProp ACP on ACP.componentId = AC.id

			INNER JOIN @WebEndpoints WE on WE.commcellId = AC.id

WHERE componentType = 1048 and propertyTypeId = 2

		UPDATE WE1  SET WebEndPointXML =

			(SELECT

				(SELECT ST._ID as 'webserverUrls'FROM @WebEndpoints WE3 cross apply dbo.SplitStringByDelimiter(WE3.webServerUrl,',') ST 

					WHERE WE3.commcellId = WE2.commcellId  FOR XML PATH(''),TYPE),

				(SELECT WE2.webConsoleUrl as 'webconsoleUrls' FOR XML PATH(''),TYPE) FOR XML PATH(''),TYPE, ROOT('App_WebEndPoints'))

			FROM @WebEndpoints WE1

			INNER JOIN @WebEndpoints WE2 on WE1.commcellId  = WE2.commcellId 

		MERGE APP_CommCellProp AS TARGET

		USING @WebEndpoints AS SOURCE

		ON (TARGET.CommcellId = SOURCE.commcellId)

		WHEN MATCHED 

		THEN

		UPDATE SET TARGET.commcelltype = SOURCE.commcellType,TARGET.WebEndpoints = SOURCE.WebEndPointXML

		WHEN NOT MATCHED BY TARGET

		THEN

		INSERT  (CommCellId,LastEventID,LastEventUpdateTime,LastJobUpdateTime,LastCompletedJobUpdateTime,LastMaxChunkId,CommcellType,WebEndpoints) 

				VALUES(source.commcellId,0,NULL,NULL,NULL,0,source.commcellType,source.WebEndPointXML);

		--Checking if the commcell is a service commcell

		DECLARE @isIDPServiceCommcell INT = NULL

SELECT @isIDPServiceCommcell = longlongVal from APP_ComponentProp where componentType = 1048 and propertyTypeId = 2 and componentId = 2

		IF @isIDPServiceCommcell IS NOT NULL

		BEGIN

			--If commcell is a service commcell then it's either router service commcell or IDP service commcell.

			IF @isIDPServiceCommcell = 1

SET @LocalCommCellType  = @LocalCommCellType | 8

			ELSE IF @isIDPServiceCommcell = 0

SET @LocalCommCellType =@LocalCommCellType | 2

		END

IF(@LocalCommCellType > 0 AND EXISTS (SELECT 1 from APP_CommCellProp where CommCellId = 2))

		BEGIN

UPDATE APP_CommCellProp SET CommcellType = @LocalCommCellType WHERE CommCellId = 2

		END

		ELSE IF(@LocalCommCellType > 0)

		BEGIN
		INSERT INTO APP_CommCellProp (CommCellId,LastEventID,LastEventUpdateTime,LastJobUpdateTime,LastCompletedJobUpdateTime,LastMaxChunkId,CommcellType,WebEndpoints) 


VALUES(2,0,NULL,NULL,NULL,0,@LocalCommCellType,NULL)

		END

		-- insert/update GXGlobalParam: nMultiCommcellRole

IF(@LocalCommCellType > 0 AND EXISTS (SELECT 1 from GXGlobalParam where name = 'nMultiCommcellRole'))

		BEGIN

UPDATE GXGlobalParam SET value = @LocalCommCellType WHERE name = 'nMultiCommcellRole'

		END

		ELSE IF(@LocalCommCellType > 0)

		BEGIN
			INSERT INTO GXGlobalParam (name, value, created, modified) 


VALUES('nMultiCommcellRole', @LocalCommCellType, dbo.GetUnixTime(GetUTCdate()), 0)

		END
		INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


			VALUES('7E323B1B-BE14-4B2A-9478-E5345BAC62AC', 'Update CommcellType and WebEndpoints', 

'Updating CommcellType and WebEndpoints in already registered service commcells', @nowTime, 16, 0, (16 + 2))

		COMMIT TRANSACTION App_CommcellPropScript

    END TRY

    BEGIN CATCH

        PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

        ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

        PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '

        ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

        ERROR MESSAGE: ' + ERROR_MESSAGE() + '

        ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

        ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

        PRINT N'Rolling back Transactions App_CommcellPropScript.'

        ROLLBACK TRANSACTION App_CommcellPropScript

    END CATCH

END

