

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/APP_ClientProp.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/APP_ClientProp.script,v $ $Id: APP_ClientProp.script,v 1.3.12.62.8.3 2021/04/22 19:03:07 mmansano Exp $";

GO

SET QUOTED_IDENTIFIER ON

GO

SET NOCOUNT ON

-- USE GETUTCDATE() instead of GETDATE(). 

-- Re-syncing CS / Clients for CCS Enabled

DECLARE @syncCCSEnabled INT = NULL

SELECT

	@syncCCSEnabled = CAST(value AS INT)

FROM GXGlobalParam

WHERE name = 'SyncCCSEnabledClients'

IF (@syncCCSEnabled IS NULL OR @syncCCSEnabled = 0)

BEGIN

	DECLARE @currentTime INTEGER = (SELECT DATEDIFF(s, CONVERT(DATETIME, '1970-01-01'), GETUTCDATE()))

	-- script has never run, or value has been reset for force run it

	-- Update all clients with 'CCS Enabled' property enabled(1) that are not Laptops to be disabled(0)

	UPDATE cp

       set cp.attrVal = '0'

	FROM APP_Client c

		INNER JOIN APP_ClientProp cp ON

				cp.componentNameId = c.id

				AND cp.attrName = 'CCS Enabled'

				AND cp.attrVal = '1'

				AND (c.status & 4096) <> 4096

	IF (@syncCCSEnabled IS NULL)

	BEGIN
		INSERT INTO GXGlobalParam(name, value, created, modified)


			VALUES('SyncCCSEnabledClients', '1', @currentTime, 0)

	END

	ELSE

	BEGIN

		UPDATE GXGlobalParam

			SET value = '1'

		WHERE name = 'SyncCCSEnabledClients'

	END

END

GO

DECLARE @edgeDrivePriorityUpgrade INT = 0

-- Tbl script file should not have any function calls because they may not exist during upgrade

DECLARE @nowTimeUTC int = datediff(second, '01/01/1970', getUTCDate())

SELECT

	@edgeDrivePriorityUpgrade = 1

FROM

	GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

	gp.SqlScriptGUID = 'D2697685-F99D-41FE-9C9A-825FF468B8E3'

IF (@edgeDrivePriorityUpgrade = 0)		-- not done, do the db upgrade

BEGIN

	IF OBJECT_ID('tempdb.dbo.#edgeclients') IS NOT NULL 

		DROP TABLE #edgeclients

	CREATE TABLE #edgeclients (

		clientId					INT PRIMARY KEY

	)

	DECLARE @unixTime INTEGER = (SELECT DATEDIFF(s, CONVERT(DATETIME, '1970-01-01'), GETUTCDATE()))

	-- Get edge clients
	INSERT INTO #edgeclients


	SELECT CL.id

	FROM APP_Client CL

	WHERE CL.status & 0x10000000 = 0x10000000

	-- Remove existing pririty as a safety step.

	DELETE 

	FROM APP_ClientProp

	WHERE componentNameId IN (SELECT clientId FROM #edgeclients)

	AND attrName = 'JMPriority'

	-- Insert new priority
	INSERT INTO APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)


	SELECT clientId, 'JMPriority', 7, 3, @unixTime, 0, 0

	FROM #edgeclients
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('D2697685-F99D-41FE-9C9A-825FF468B8E3', 'EdgeDrivePriorityUpgrade', 'Create high priority for edge drive clients', @unixTime, 16, 0 , (16 + 1))

	IF OBJECT_ID('tempdb.dbo.#edgeclients') IS NOT NULL 

		DROP TABLE #edgeclients

END

	-- In 10.0 client description can be in HTML or non-HTML format, to differentiate that we have created flag for this in 11.0, if description in HTML format or not.

	-- So while upgrading below query will set this flag for all clients according to description format.

	DECLARE @nowTime INT = DATEDIFF(second, '01/01/1970', GetUTCdate())

	--Any entry guarantees that setup is already v11. 

	IF NOT EXISTS(SELECT 1 FROM App_ClientProp WHERE ATTRNAME = 'Is Client Description in HTML Format')

	BEGIN
	INSERT INTO App_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified,ccpId)


	SELECT id,  'Is Client Description in HTML Format',2 , 

      CASE WHEN clientDescription = '' OR ((TRY_CAST(clientDescription AS XML) IS NOT NULL 

		AND (CHARINDEX('<HTML>',clientDescription) > 0))) THEN 1

              ELSE 0 END, @nowTime, 0, 0 

	FROM APP_Client WHERE id > 1

	END

-- Update Script to update value of CacheAgingThreshold for Exchange MB Agent to 180 for existing agents if its not set by user 

-- first we will check if value is set by user then we wont change, we insert value only if its not set by user

DECLARE @SetCacheAgingThresholdGUID VARCHAR(512) = '93C8A548-5D47-46E1-BEA2-3B5868E45D1A'

IF NOT EXISTS (SELECT TOP 1 1 FROM GXUniqueSQLScriptExecTracking WITH (NOLOCK) WHERE SqlScriptGUID = @SetCacheAgingThresholdGUID)

BEGIN

	DECLARE @tmpClientIDAProp TABLE (agentId int, clientId int, attrName nvarchar(256), attrVal nvarchar(256))
	INSERT INTO @tmpClientIDAProp 


    SELECT A.id, C.id, PR.attrName, PR.attrVal FROM App_Client C 

INNER JOIN APP_IDANAME (NOLOCK) A ON A.appTypeId = 137  AND C.id = A.clientId

LEFT JOIN APP_ClientProp (NOLOCK) PR ON PR.componentNameId = A.clientId AND PR.attrName= 'AgingDays'

	DELETE FROM @tmpClientIDAProp WHERE attrName IS NOT NULL

	DECLARE @currentTime INTEGER = (SELECT DATEDIFF(s, CONVERT(DATETIME, '1970-01-01'), GETUTCDATE()))
	INSERT INTO APP_ClientProp (componentNameId,attrName,attrType,attrVal,created,modified,ccpId)


SELECT clientiD, 'AgingDays',7,180,@currentTime,0,0 FROM @tmpClientIDAProp
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@SetCacheAgingThresholdGUID, 'CacheAgingThresholdUpgrade', 'Setting Aging Threshold to 180', @currentTime, 16, 0 , (16 + 1))

END

-- Count the number of clients which needs to be associated with the array

IF NOT EXISTS(SELECT * FROM	GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE	gp.SqlScriptGUID = '1CCBAE59-7FC3-4846-AF0D-6B5D6D13BF01')

BEGIN

	DECLARE @azCurrentTime INTEGER = (SELECT DATEDIFF(s, CONVERT(DATETIME, '1970-01-01'), GETUTCDATE()))

	DECLARE @awsUpgradeRequiredCount INT = 

	(	SELECT	COUNT(DISTINCT A.clientId)

		FROM	APP_Application	A

				INNER JOIN APP_Client C

					ON A.clientId = C.id

				INNER JOIN APP_InstanceProp IP

					ON A.instance = IP.componentNameId AND IP.attrName = 'Virtual Server Instance Type' AND IP.attrVal = '301' AND IP.modified = 0

				LEFT OUTER JOIN APP_ClientProp CP

					ON CP.componentNameId = C.id AND CP.attrName = 'Snap Control Host ID' AND IP.modified = 0

		WHERE	A.appTypeId = 106

			AND	CP.attrVal IS NULL

	)

	IF (@awsUpgradeRequiredCount > 0)

	BEGIN

		IF EXISTS(SELECT 1 FROM GXGlobalParam WHERE name = 'AmazonClientsWithoutArrayAssoc' AND modified = 0)

		BEGIN

			UPDATE GXGlobalParam

			SET value = CAST(@awsUpgradeRequiredCount AS NVARCHAR(MAX))

			WHERE name = 'AmazonClientsWithoutArrayAssoc' AND modified = 0

		END

		ELSE

		BEGIN
			INSERT INTO GXGlobalParam(name, value, created, modified)


				VALUES('AmazonClientsWithoutArrayAssoc', @awsUpgradeRequiredCount, @azCurrentTime, 0)

		END

	END
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('1CCBAE59-7FC3-4846-AF0D-6B5D6D13BF01', 'AmazonClientArrayUpdate', 'Create and Associate Amazon Array for existing Amazon clients', @azCurrentTime, 16, 0 ,(16 + 2))

END

-- Set Client propert 'Arrays' with comma separated list of ControlHostIds from all snapshots on the client.

IF NOT EXISTS(SELECT * FROM	GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE	gp.SqlScriptGUID = '4FE37C04-2DE7-4DCB-9A9C-1DDFD18DB4AC')

BEGIN

	DECLARE @arrayListSetTime INTEGER = (SELECT DATEDIFF(s, CONVERT(DATETIME, '1970-01-01'), GETUTCDATE()))

	DECLARE @tblSnapClients TABLE (ClientId INT, ControlHostId INT)

	DECLARE @tblClientArrayList TABLE (ClientId INT, ArrayList NVARCHAR(MAX))
	INSERT INTO @tblSnapClients


	SELECT DISTINCT CLNT.id, SNAP.ControlHostId

		FROM SMVolume VOL (NOLOCK)

			INNER JOIN SMVolSnapMap MAP (NOLOCK) ON MAP.SMVolumeId = VOL.SMVolumeId

			INNER JOIN SMSnap SNAP (NOLOCK) ON MAP.SMSnapId = SNAP.SMSnapId

			INNER JOIN APP_Application APP (NOLOCK) ON APP.id = VOL.AppId

			INNER JOIN APP_Client CLNT (NOLOCK) ON APP.clientId = CLNT.id

		WHERE SNAP.ControlHostId > 0
	INSERT INTO @tblClientArrayList


		SELECT T2.Id, LEFT(T2.List,LEN(T2.List) - 1)

		FROM

		(

			SELECT ClientId AS Id, (SELECT CONVERT(NVARCHAR(20), ControlHostId) + ',' FROM @tblSnapClients  WHERE ClientId = T.ClientId ORDER By ControlHostId FOR XML PATH('')) AS List

			FROM @tblSnapClients T

			GROUP By ClientID

		) T2
	INSERT	INTO APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)


		SELECT	ClientId, 'Arrays', 1, ArrayList, @arrayListSetTime, 0, 0 FROM	@tblClientArrayList 
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


	VALUES('4FE37C04-2DE7-4DCB-9A9C-1DDFD18DB4AC', 'SetClientPropArrayList', 'Set the list of arrays associated with every client', @arrayListSetTime, 16, 0 ,(16 + 2))

END

IF NOT EXISTS(SELECT * FROM	GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE	gp.SqlScriptGUID = '35362936-A2B4-4680-B650-BF83CBD76407')

BEGIN

	IF OBJECT_ID('tempdb.dbo.#vmclientList') IS NOT NULL

		DROP TABLE #vmclientList

	CREATE TABLE #vmclientList

	(

		clientid INT,

		jobid INT,

		lastBackupStartTime INT

	)

	-- Get All VMs
	INSERT INTO #vmclientList(clientid)


	SELECT componentNameId 

	FROM APP_ClientProp 

	WHERE attrName = 'Virtual Server Discovered Clients' AND attrVal = '1' AND modified = 0

	-- Get latest successfull job. Consider backups, snap backups and synthetic full.

	UPDATE VM

	SET jobid = J.jobId

	FROM #vmclientList VM

	INNER  JOIN

	(

		SELECT VM.clientid, JM.jobId, ROW_NUMBER() OVER (PARTITION BY VM.clientId ORDER BY JM.servEndDate DESC) AS RowNumber

		FROM #vmclientList VM

		INNER JOIN APP_VMProp VMP ON VMP.VMclientId = VM.clientid AND VMP.attrName = N'vmStatus' AND VMP.attrVal IN (N'0', N'3') -- COMPLETED, PARTIAL_SUCCESS

		INNER JOIN JMBkpStats JM ON VMP.jobId = JM.jobId AND VMP.commCellId = JM.commCellId AND JM.status IN (1, 3, 14) AND JM.opType IN (4, 14, 59) -- (JMSUCCESS, PARTIALSUCCESS, COMPLETEDWITHWARNINGS) AND (BACKUP, SYNTHFULL, SNAPBACKUP)

	)J

	ON J.clientid = VM.clientid AND J.RowNumber = 1

	-- Remove VMs who dont even have a jobId

	DELETE #vmclientList WHERE jobid IS NULL

	-- Get latest successfull backup time. Consider backups and snap backups only.

	UPDATE VM

	SET lastBackupStartTime = LastBackedup

	FROM #vmclientList VM

	JOIN(

			SELECT VM.clientid, ISNULL(MAX(CAST(VMB.attrVal AS INT)), 0) LastBackedup

			FROM #vmclientList VM

			JOIN APP_VMProp VMS ON VMS.VMclientId = VM.clientid AND VMS.attrName = N'vmStatus' AND VMS.attrVal IN (N'0', N'3') -- COMPLETED, PARTIAL_SUCCESS

			INNER JOIN JMBkpStats JM ON VMS.jobId = JM.jobId AND VMS.commCellId = JM.commCellId AND JM.status IN (1, 3, 14) AND JM.opType IN (4, 59)-- (JMSUCCESS, PARTIALSUCCESS, COMPLETEDWITHWARNINGS) AND (BACKUP, SNAPBACKUP)

			JOIN APP_VMProp VMB ON VMB.VMclientId = VM.clientid AND VMB.attrName = N'vmBackupStartTime'  AND VMB.jobId = JM.jobId AND VMB.commCellId = JM.commCellId

			GROUP BY VM.clientId

		)T ON T.clientid = VM.clientid

	-- Remove VMs who dont even have a jobId

	DELETE #vmclientList WHERE lastBackupStartTime IS NULL

	-- Set backup job id

	UPDATE App_ClientProp

	SET attrVal = CAST(VM.jobid AS NVARCHAR(MAX)),

		created = @nowTimeUTC

	FROM App_ClientProp CP 

	INNER JOIN #vmclientList VM ON CP.componentNameId = VM.clientid AND CP.attrName = 'Last Backup JobID' AND CP.modified = 0
	INSERT INTO APP_ClientProp


	(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)

	SELECT VM.clientid, 'Last Backup JobID', 7, CAST(jobId AS NVARCHAR(MAX)), @nowTimeUTC, 0, 0

	FROM #vmclientList VM 

	LEFT OUTER JOIN App_ClientProp CP ON CP.componentNameId = VM.clientid AND CP.attrName = 'Last Backup JobID' AND CP.modified = 0

	WHERE CP.id IS NULL

	-- Set backup job start time

	UPDATE App_ClientProp

	SET attrVal = CAST(VM.lastBackupStartTime AS NVARCHAR(MAX)),

		created = @nowTimeUTC

	FROM App_ClientProp CP 

	INNER JOIN #vmclientList VM ON CP.componentNameId = VM.clientid AND CP.attrName = 'Last VM Backup Start Time' AND CP.modified = 0
	INSERT INTO APP_ClientProp


	(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)

	SELECT VM.clientid, 'Last VM Backup Start Time', 7, CAST(lastBackupStartTime AS NVARCHAR(MAX)), @nowTimeUTC, 0, 0

	FROM #vmclientList VM 

	LEFT OUTER JOIN App_ClientProp CP ON CP.componentNameId = VM.clientid AND CP.attrName = 'Last VM Backup Start Time' AND CP.modified = 0

	WHERE CP.id IS NULL

	IF OBJECT_ID('tempdb.dbo.#vmclientList') IS NOT NULL

		DROP TABLE #vmclientList
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('35362936-A2B4-4680-B650-BF83CBD76407', 'VmStatusReportingV2', 'Create client properties for VM reporting through admin console', @nowTimeUTC, 16, 0, (16 + 2))

END

-- Update geolocation property reference in DB

IF NOT EXISTS(SELECT * FROM	GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE	gp.SqlScriptGUID = 'A2095B86-C037-4774-B9FF-0A3FD196DCBE')

BEGIN

		-- Update correct string quotation

		UPDATE APP_ClientProp SET attrVal=REPLACE(attrVal, '"', '''') WHERE attrName='Client Geo Location'
		INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('A2095B86-C037-4774-B9FF-0A3FD196DCBE', 'Update geolocation with correct quotes', 'Update value for Client Geo Location Property to update double quotes to single quotes', dbo.getUnixTime(GetUTCDate()), 16, 0, (16 + 2))

END

-- Update Reference of Plan attrname in DB

IF NOT EXISTS(SELECT * FROM	GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE	gp.SqlScriptGUID = 'D5E01FA3-271E-409C-840D-A651BF911265')

BEGIN

UPDATE APP_ClientProp SET attrName='Associated Plan' WHERE attrName='Associated Plan Id'

		-- Get All SCG for Plans that are not Laptop

		DECLARE @scgGroupsID TABLE (cgid INT)
		INSERT INTO @scgGroupsID


		SELECT APP.attrVal FROM APP_PLANPROP APP WITH (NOLOCK)

		INNER JOIN APP_PLAN AP WITH (NOLOCK)

ON APP.componentNameId=AP.id AND APP.attrName='Assigned client group' AND AP.subType <> 33554439

        -- Remove Associated Schedules from SCG

		DELETE TAE

		FROM TM_AssocEntity TAE

		INNER JOIN @scgGroupsID SCG

			ON TAE.clientGroupId=SCG.cgid AND TAE.clientId = 0

		-- -- finally remove plan entity flag for SCG

        UPDATE ACG

SET ACG.flag = (ACG.flag & (~(536870912)))

            FROM APP_ClientGroup ACG

            INNER JOIN @scgGroupsID SCG

ON SCG.cgid=ACG.id AND (ACG.flag & 536870912 <> 0)

		-- Tbl script file should not have any function calls because they may not exist during upgrade
		INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('D5E01FA3-271E-409C-840D-A651BF911265', 'Associated Laptop Plan Property Update', 'Update References for Plan Property for Laptop Client and removal of unwanted SCG for Plan', @nowTimeUTC, 16, 0, (16 + 2))

END

-- Update the encryption settings

IF NOT EXISTS(SELECT * FROM   GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE        gp.SqlScriptGUID = '0C8B0131-2AA9-4A57-9C5B-D7F3058C9E18')

BEGIN

	        -- Insert new property name Encryption settings if and only if modified=0 and the new property is not already present

	        -- Update Encryption value to 2 when it is 0 i.e. off (Disable Client Side Encryption) and keep it as 1 when it is 1 i.e. Perform Client Side Encryption
	        INSERT INTO APP_CLIENTPROP (componentNameId,attrName,attrType,attrVal,created,modified,ccpId)


	                            SELECT A.componentNameId,'Encryption Settings',7,CASE 

	                                                                  WHEN A.attrVal = '1' THEN '1'

	                                                                  WHEN A.attrVal = '0' THEN '2'

	                                                                  END, @nowTimeUTC,0,0

	                            FROM APP_ClientProp A left outer join APP_ClientProp B on A.modified=0 and B.modified=0 and A.componentNameId=B.componentNameId and A.attrName='Encrypt: encryption' and B.attrName='Encryption Settings'  where A.attrName='Encrypt: encryption' and B.componentNameId is NULL and A.modified=0

	        -- Delete all the rows with attribute name as Encrypt: encryption and modified as 0

	           DELETE FROM APP_ClientProp where  attrname = 'Encrypt: encryption' and modified=0

	        -- Inserting new GUID for Updating Encryption Settings
	        INSERT INTO GXUniqueSQLScriptExecTracking VALUES('0C8B0131-2AA9-4A57-9C5B-D7F3058C9E18','Update App_ClientProp attribute Encrypt:Encryption','Update the Encrypt: encryption attribute name to Encryption settings as well as attribute value to 2 when it is originally 0',@nowTimeUTC,16,0,18)


END

DECLARE @UpdateSecurityGUID AS NVARCHAR(MAX) = 'E1207D09-F59E-4903-98F0-15F1356FE5A8'

-- Update the security settings

IF NOT EXISTS(SELECT * FROM   GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = @UpdateSecurityGUID)

BEGIN

            UPDATE APP_ClientProp 

            SET attrVal =  CASE  

WHEN (attrVal = '1') THEN 'a45fabb9712142ea42da80d2c0314cf1f871cea2571f6bda4152f645e2424b592f0ac7691aec175a'

WHEN (attrVal = '0') THEN 'd54e22dfae22260e76a0fa543b5d321facbd5489ac662ac4396c52b14e7c4511da3476935e6b832f'

	                       END 

,attrName = '7b70af7d447e975e31f8504a337c5458f5d51604cabfbfca348e98db02d459be18cdbd8233a5d807'

            WHERE attrName='Enable Data Security' and modified=0

            -- Inserting new GUID for Updating Encryption Settings
            INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


			VALUES(@UpdateSecurityGUID,'Encrypt Enable Data Security parameter name and values','Encrypt Enable Data Security parameter name and values',@nowTimeUTC,16,0,18)

END

DECLARE @analyticsRenameUpgrade INT = 0

DECLARE @analyticsRenameVersion varchar(36) = 'FA168AB1-F6F8-4653-807A-620AE520302F'	 

SELECT @analyticsRenameUpgrade = 1

FROM GXUniqueSQLScriptExecTracking GS WITH(NOLOCK)

WHERE GS.SqlScriptGUID = @analyticsRenameVersion

IF (@analyticsRenameUpgrade = 0)            -- not done, do the db upgrade

BEGIN   

	IF EXISTS (SELECT 1 FROM APP_ClientGroup (NOLOCK) WHERE NAME IN ('Solr Servers', 'Analytics Servers') )

		UPDATE APP_ClientGroup

SET name = 'Index Servers'

		WHERE NAME IN ('Solr Servers', 'Analytics Servers')

	--Do not create client group by default

	--Create client group only when needed

IF EXISTS (SELECT 1 from app_clientgroup (NOLOCK) where name IN ('Content Analyzer Cloud', 'Index Servers'))

	BEGIN

IF NOT EXISTS (SELECT 1 FROM simInstalledPackages (NOLOCK) WHERE simPackageID = 729 )

		BEGIN

			DELETE CGA 

			FROM APP_ClientGroupAssoc CGA 

			INNER JOIN APP_ClientGroup CG ON CGA.clientGroupId = CG.id

WHERE cg.name = 'Content Analyzer Cloud'

			DELETE FROM app_clientgroup 

WHERE name = 'Content Analyzer Cloud'

		END

IF NOT EXISTS (SELECT 1 FROM simInstalledPackages (NOLOCK) WHERE simPackageID = 55 )

		BEGIN

			DELETE CGA 

			FROM APP_ClientGroupAssoc CGA 

			INNER JOIN APP_ClientGroup CG ON CGA.clientGroupId = CG.id

WHERE cg.name = 'Index Servers'

			DELETE FROM app_clientgroup 

WHERE name = 'Index Servers'

		END	

	END
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@analyticsRenameVersion, 'SCPAnalyticsRenameUpgrade', 'Rename analytics server', datediff(second, '01/01/1970', GETDATE()), 16, 0 , (16 + 1))

END

--Create attribute 'Content store mail server role' on clients with pkg 171, only if this attr does not exist

--Tbl script file should not have any function calls because they may not exist during upgrade
INSERT INTO APP_ClientProp(componentNameId, attrName, attrType,  attrVal,  created,  modified, ccpId)		


	SELECT CL.id, 'Content Store Mail Server Role', 7, 2, @nowTimeUTC, 0, 0			

	FROM APP_Client CL (NOLOCK)

	JOIN APP_ClientProp CP (NOLOCK) ON CP.attrName = 'PackageStateForId 171' AND CP.attrVal = 1 AND CP.modified = 0 AND CP.componentNameId = CL.id

	WHERE CL.id NOT IN ( select componentNameId from APP_ClientProp (NOLOCK) where attrname = 'Content Store Mail Server Role' AND modified = 0)

--Update upgraded DAG Clients with property "Exchange Pseudo Client".

IF NOT EXISTS(SELECT * FROM	GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE	gp.SqlScriptGUID = '77D3A2F9-6994-4E96-9D01-2A14ED58A167')

BEGIN	
	INSERT INTO APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)


	SELECT cl.id, 'Exchange Pseudo Client', 2, 1, @nowTimeUTC, 0, 0

	FROM APP_Client cl WITH (NOLOCK)

	WHERE (cl.status & 2097152) = 2097152 AND cl.id NOT IN ( SELECT componentNameId FROM APP_ClientProp WHERE attrName = 'Exchange Pseudo Client')
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('77D3A2F9-6994-4E96-9D01-2A14ED58A167', 'Updating Exchange DAG Clients', 'Updating missing property Exchange Pseudo Client', @nowTimeUTC, 16, 0, (16 + 2))

END

GO

-- NAS clients, add client property "Sim OS Info", "NAS OS Type", and "NAS Capabilities"

-- MUST be before "Save Hardware and OS Info in client properties" below

-- * NAS OS Type was previously saved in the MMNdmpHostInfo table, but NAS clients do not always have NDMP properties

--   and looking up NDMP information when retrieving the client list is not efficient and causes problems in scale setups

-- * NAS Capabilities were also previously stored in MMNdmpHostInfo - and when there were no NDMP settings the default settings

--   would be calculated based on array management settings. Again inefficient causing problems in scale.

-- * Sim OS Info is also added for efficiency - and to be consistent with other client types.

IF NOT EXISTS(SELECT * FROM	GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE	gp.SqlScriptGUID = '44F52CA3-02E7-43F9-A934-73D285C009F1')

BEGIN

	DECLARE @nowTime integer = DATEDIFF(second, '01/01/1970', GETDATE())

	DECLARE @numNasUpdated integer = 0

	IF OBJECT_ID('tempdb.dbo.#nasClients') IS NOT NULL 

		DROP TABLE #nasClients

	CREATE TABLE #nasClients

	(

		id INT IDENTITY(1,1),	-- Useful when removing duplicate rows

		clientid INT,			-- Do not make primary key. May get dupliate clientIds if a client has more than 1 SMControlHost row

		simOperatingSystemId INT,

		ndmpOsVersion nvarchar (64),	-- FirmwareRevision length is 32 in MMNdmpHostInfo.tbl

		nasOSType INT,

		nasCapabilities BIGINT,

		simOsInfo nvarchar (512)

	)

	CREATE CLUSTERED INDEX nasClients_clientId_idx ON #nasClients (clientid) -- Use index instead of primary key since we may get dupliate clientIds
	INSERT into #nasClients


		SELECT DISTINCT -- DISTINCT: Eliminates rows where we have 2 SMControlHost entries (for different vendors) but we have MMNdmpHostInfo - without this DISTINCT we would get 2 identical rows

			c.id clientId,

			c.simOperatingSystemId simOperatingSystemId,

			ndmp.FirmwareRevision ndmpOsVersion,

			CASE

				WHEN (ndmp.OSType IS NOT NULL) THEN ndmp.OSType

WHEN (C.simOperatingSystemId = 17)        THEN 1

WHEN (C.simOperatingSystemId = 16)                THEN 2

WHEN (C.simOperatingSystemId = 29)      THEN 9

WHEN (C.simOperatingSystemId = 45) THEN 11

				WHEN (array.snapVendorName IS NULL) THEN 0

WHEN (array.snapVendorName = 'NetApp')            THEN 2

WHEN (array.snapVendorName = 'Huawei')            THEN 32

WHEN (array.snapVendorName = 'Dell EMC VNX / Celerra') THEN 1

WHEN (array.snapVendorName = 'Dell EMC Unity')         THEN 1

WHEN (array.snapVendorName = 'Dell EMC Isilon')        THEN 18

WHEN (array.snapVendorName = 'Hitachi NAS')       THEN 9

				ELSE 0

			END nasOsType,

			CASE

				WHEN (ndmp.CapabilityFlags IS NOT NULL) THEN ndmp.CapabilityFlags

WHEN (C.simOperatingSystemId = 16) THEN 0x088000CB

				WHEN (array.snapVendorName IS NULL) THEN 0

WHEN (array.SnapVendorName = 'NetApp')      THEN 0x088000CB

WHEN (array.SnapVendorName = 'Dell EMC Isilon')  THEN 0x00000008

				ELSE 0

			END nasCapabilities,

			NULL

		FROM

			APP_Client c WITH(READUNCOMMITTED)

			LEFT OUTER JOIN MMNdmpHostInfo ndmp WITH(READUNCOMMITTED) ON

				ndmp.ClientId = c.id

			LEFT OUTER JOIN (

				SELECT DISTINCT ClientId, snapVendorName	-- DISTINCT: Eliminate duplicate clientId/vendorName - still may have a client twice with a different vendor

				FROM SMControlHost WITH(READUNCOMMITTED)) array ON

				array.ClientId = c.id

		WHERE

C.simOperatingSystemId in (17, 16, 29, 45, 19)

	-- At this point a single clientId may occur more than once in #nasClients. It should be an extremely rare occurrence. To get this scenario the client needs to have:

	-- * No MMNdmpHostInfo row

	-- * More than one SMControlHost entry with a different snapVendorName.

	-- This can happen if a customer is using IntelliSnap and replaces a file server with a new file server from a different vendor - and instead of deconfiguring the first client

	-- and adding a new client for the new file server, they rename the clientname and hostname of the original file server ... and then add a new array management entry without

	-- deleting the existing array management entry.

	-- MUST delete duplicate rows or we end up with duplicate APP_ClientProp entries.

	DELETE FROM nc1

	FROM #nasClients as nc1

	INNER JOIN #nasClients as nc2 ON nc1.clientId = nc2.clientId

	AND nc1.id < nc2.id

	UPDATE #nasClients SET simOsInfo =

		CASE -- sOsName :- sVersion :- :- sOsName

WHEN (nasOSType = 1)    THEN N'DELLEMC Unity/VNX/Celerra' + N':-' + ISNULL(ndmpOsVersion, N'') + N':-:-' + N'DELLEMC Unity/VNX/Celerra'

WHEN (nasOSType = 2)    THEN N'NetApp' + N':-' + ISNULL(ndmpOsVersion, N'') + N':-:-' + N'NetApp'

WHEN (nasOSType = 9)   THEN N'Hitachi NAS' + N':-' + ISNULL(ndmpOsVersion, N'') + N':-:-' + N'Hitachi NAS'

WHEN (nasOSType = 11)   THEN N'Hitachi' + N':-' + ISNULL(ndmpOsVersion, N'') + N':-:-' + N'Hitachi'

WHEN (nasOSType = 15)    THEN N'ONStor' + N':-' + ISNULL(ndmpOsVersion, N'') + N':-:-' + N'ONStor'

WHEN (nasOSType = 18)    THEN N'Isilon' + N':-' + ISNULL(ndmpOsVersion, N'') + N':-:-' + N'Isilon'

WHEN (nasOSType = 24)       THEN N'Oracle' + N':-' + ISNULL(ndmpOsVersion, N'') + N':-:-' + N'Oracle'

WHEN (nasOSType = 26) THEN N'IBM' + N':-' + ISNULL(ndmpOsVersion, N'') + N':-:-' + 'IBM'

WHEN (nasOSType = 27)  THEN N'Hewlett-Packard Company' + N':-' + ISNULL(ndmpOsVersion, N'') + N':-:-' + N'Hewlett-Packard Company'

WHEN (nasOSType = 28)  THEN N'Dell Scalable File System' + N':-' + ISNULL(ndmpOsVersion, N'') + N':-:-' + N'Dell Scalable File System'

WHEN (nasOSType = 29)   THEN N'Stratus Technologies' + N':-' + ISNULL(ndmpOsVersion, N'') + N':-:-' + N'Stratus Technologies'

WHEN (nasOSType = 30)    THEN N'Nexsan' + N':-' + ISNULL(ndmpOsVersion, N'') + N':-:-' + N'Nexsan'

WHEN (nasOSType = 31)   THEN N'Nexenta' + N':-' + ISNULL(ndmpOsVersion, N'') + N':-:-' + N'Nexenta'

WHEN (nasOSType = 32)    THEN N'Huawei' + N':-' + ISNULL(ndmpOsVersion, N'') + N':-:-' + N'Huawei'

			ELSE N''

		END -- simOsInfo

	-- NAS OS Type --
	INSERT INTO APP_CLIENTPROP


	SELECT clientId,'NAS OS Type',8,nasOsType,@nowTime,0,0

	FROM #nasClients C

	LEFT OUTER JOIN

		APP_CLIENTPROP CP WITH (NOLOCK) ON

		CP.ATTRNAME = 'NAS OS Type'

		and CP.modified = 0

		and C.clientId = CP.componentNameId

	WHERE CP.componentNameId is null

	-- NAS Capabilities --

	UNION ALL 

	SELECT clientId,'NAS Capabilities',15,nasCapabilities,@nowTime,0,0

	FROM #nasClients C

	LEFT OUTER JOIN

		APP_CLIENTPROP CP WITH (NOLOCK) ON

		CP.ATTRNAME = 'NAS Capabilities'

		and CP.modified = 0

		and C.clientId = CP.componentNameId

	WHERE CP.componentNameId is null

	-- Sim OS Info --

	-- UNION ALL -- Cannot do a UNION ALL since simOsInfo is a nvarchar and the 2 properties above are numbers
	INSERT INTO APP_CLIENTPROP


	SELECT clientId,'Sim OS Info',1,simOsInfo,@nowTime,0,0

	FROM #nasClients C

	LEFT OUTER JOIN

		APP_CLIENTPROP CP WITH (NOLOCK) ON

		CP.ATTRNAME = 'Sim OS Info'

		and CP.modified = 0

		and C.clientId = CP.componentNameId

	WHERE CP.componentNameId is null

	SELECT @numNasUpdated = @@ROWCOUNT -- Number of rows we inserted. Actual count does not matter, just check greater than 0

	IF OBJECT_ID('tempdb.dbo.#nasClients') IS NOT NULL 

		DROP TABLE #nasClients

	-- If the Operating System Name and Hardware Info have already been inserted by script 3F3FA308-D517-4851-903F-78B8B4618C1A below, then we need to update

	-- these properties for NAS clients because the code above added "Sim OS Info" which is used to better calculate these properties.

	-- This code is an exact copy of the 3F3FA308-D517-4851-903F-78B8B4618C1A script ...

	-- * Except only for NAS clients.

	-- * AND this code deletes any previous 'Operating System Name' or 'Hardware Info' property

	IF (@numNasUpdated > 0) AND EXISTS(SELECT * FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = '3F3FA308-D517-4851-903F-78B8B4618C1A')

	BEGIN

		-- This code must match the 3F3FA308-D517-4851-903F-78B8B4618C1A code below

		-- Do NOT call stored procedures here!! Stored procedures may not available in the DB while the tbl script code runs

		DELETE FROM APP_CLIENTPROP

		WHERE attrName = 'Operating System Name' AND componentNameId in

		( 

			SELECT id FROM APP_CLIENT

WHERE simOperatingSystemId in (17, 16, 29, 45, 19)

		)
		INSERT INTO APP_CLIENTPROP


		SELECT T2.id,'Operating System Name',1,T3.osName,@nowTime,0,0

		FROM APP_CLIENT T2 

		JOIN -- Should match ClientOSNameView.view

		(

			SELECT 

			q.clientId,

			CASE

				-- First "WHEN": if we do not have the version from NDMP (osRel), but we know it is Isilon from array management, without this first WHEN we will incorrectly show "NAS Filer" instead of "Isilon"

				WHEN q.isNAS = 1 AND (q.osRel = N'') AND (q.simOSName = N'NAS Filer') AND (q.osName IS NOT NULL) AND (q.osName <> N'') THEN q.osName + N'' + ISNULL((SELECT FirmwareRevision from MMNDMPHostInfo with (nolock) where ClientId = q.clientId), '')

				WHEN q.isNAS = 1 AND ((q.osRel IS NULL) OR (q.osRel = N'')) THEN q.simOSName + N'' + ISNULL((SELECT FirmwareRevision from MMNDMPHostInfo with (nolock) where ClientId = q.clientId), '')

				WHEN q.isNAS = 1 AND (q.simOSName IS NOT NULL) AND (q.simOSName <> N'') AND (q.simOSName <> N'NAS Filer') THEN q.simOSName + q.osRel

				WHEN q.osName IS NULL OR q.osName = N'' THEN q.simOSName + q.osRel

				ELSE q.osName + q.osRel

			END osName

			FROM 

			(

				SELECT

					c.id clientId, 

					c.status,

					SUBSTRING(cp.attrVal, 0, CHARINDEX(N':-', cp.attrVal, 0)) osName,

					ISNULL((CASE (CHARINDEX(N'Windows', (CASE WHEN cp.attrVal IS NULL OR cp.attrVal = N'' THEN os.name ELSE cp.attrVal END))

									+ CHARINDEX(N'Any', (CASE WHEN cp.attrVal IS NULL OR cp.attrVal = N'' THEN os.name ELSE cp.attrVal END)))

							WHEN 0 THEN N' ' +

										SUBSTRING(

											SUBSTRING(cp.attrVal, CHARINDEX(N':-', cp.attrVal) + 2, LEN(cp.attrVal) - LEN(CHARINDEX(N':-',cp.attrVal))), 

											0,

											CHARINDEX(N':-', SUBSTRING(cp.attrVal, CHARINDEX(N':-', cp.attrVal) + 2, LEN(cp.attrVal) - LEN(CHARINDEX(N':-',cp.attrVal))), 0)

										)

							ELSE ''

						END), '') osRel,

					ISNULL(os.name, N'') simOSName,

					CASE

						WHEN os.SubType = N'NAS' THEN 1

						ELSE 0

					END isNAS

				FROM

					APP_Client c WITH(READUNCOMMITTED)

					LEFT OUTER JOIN APP_ClientProp cp WITH(READUNCOMMITTED) ON

						cp.componentNameId = c.id

						AND cp.attrName = N'Sim OS Info' 

						AND cp.modified = 0

						AND cp.attrVal <> N''

					LEFT OUTER JOIN simOperatingSystem os WITH(READUNCOMMITTED) ON

						os.id = c.simOperatingSystemId

				WHERE

c.simOperatingSystemId in (17, 16, 29, 45, 19)

			) q         

		) AS T3 ON T3.clientId = T2.id

		LEFT OUTER JOIN 

		(

			SELECT CP.componentNameId 

			FROM APP_CLIENTPROP CP WITH (NOLOCK) 				

			WHERE CP.ATTRNAME = 'Operating System Name'

			and CP.modified =0				

		) P

		ON T2.id = P.componentNameId

		WHERE P.componentNameId is null

		DELETE FROM APP_CLIENTPROP

		WHERE attrName = 'Hardware Info' AND componentNameId in

		( 

			SELECT id FROM APP_CLIENT

WHERE simOperatingSystemId in (17, 16, 29, 45, 19)

		)
		INSERT INTO APP_CLIENTPROP


		SELECT T2.id,'Hardware Info',1,T2.cHwName,@nowTime,0,0	

		FROM		

		(

				-- Should match AppUpdateStaticClientProperties.sp

				SELECT

					q.clientId as id,

					CASE

						WHEN q.hwPos IS NOT NULL AND q.hwPos > 0 THEN SUBSTRING(q.osInfo, q.osInfoLen - q.hwPos + 1, hwPos + 1)

						ELSE q.osName

					END as cHwName

					FROM 

					(

						SELECT

							c.id clientId,

							os.name osName,

							cp.attrVal osInfo,

							LEN(cp.attrVal) osInfoLen,

							(CHARINDEX('-:', REVERSE(cp.attrVal))-1) hwPos

						FROM APP_Client c

							LEFT OUTER JOIN simOperatingSystem os ON

								os.id = c.simOperatingSystemId							

							INNER JOIN APP_ClientProp cp ON		

								cp.componentNameId = c.id

								AND cp.attrname = N'Sim OS Info'

								AND cp.modified = 0

						WHERE

							c.id > 1

and c.simOperatingSystemId in (17, 16, 29, 45, 19)

					) q 

		) T2 			 

		LEFT OUTER JOIN 

		(

			SELECT CP.componentNameId 

			FROM APP_CLIENTPROP CP WITH (NOLOCK) 		

			WHERE CP.ATTRNAME = 'Hardware Info'

			and CP.modified = 0				

		) P

		ON  T2.id = P.componentNameId

		WHERE P.componentNameId is null	

	END
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('44F52CA3-02E7-43F9-A934-73D285C009F1', 'NAS OSInfo, OSType, Capabilities Update', 'Update NAS client OSInfo, OSType, and Capabilties', @nowTime, 16, 0, (16 + 2))

END

GO

-- Save Hardware and OS Info in client properties

-- * The above code adds the "Sim OS Info" client property for NAS clients - this property is used to calculate

--   the "Operating System Name" and "Hardware Info" properties calculated here.

IF NOT EXISTS(SELECT * FROM	GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE	gp.SqlScriptGUID = '3F3FA308-D517-4851-903F-78B8B4618C1A')

BEGIN   

			DECLARE @nowTime integer = DATEDIFF(second, '01/01/1970', GETDATE())
			INSERT INTO APP_CLIENTPROP


			SELECT T2.id,'Operating System Name',1,T3.osName,@nowTime,0,0

			FROM APP_CLIENT T2 

			JOIN -- Should match ClientOSNameView.view

			(

				SELECT 

		        q.clientId,

		        CASE

					WHEN q.isNAS = 1 AND (q.osRel = N'') AND (q.simOSName = N'NAS Filer') AND (q.osName IS NOT NULL) AND (q.osName <> N'') THEN q.osName + N'' + ISNULL((SELECT FirmwareRevision from MMNDMPHostInfo with (nolock) where ClientId = q.clientId), '')

		            WHEN q.isNAS = 1 AND ((q.osRel IS NULL) OR (q.osRel = N'')) THEN q.simOSName + N'' + ISNULL((SELECT FirmwareRevision from MMNDMPHostInfo with (nolock) where ClientId = q.clientId), '')

		            WHEN q.isNAS = 1 AND (q.simOSName IS NOT NULL) AND (q.simOSName <> N'') AND (q.simOSName <> N'NAS Filer') THEN q.simOSName + q.osRel

		            WHEN q.osName IS NULL OR q.osName = N'' THEN q.simOSName + q.osRel

		            ELSE q.osName + q.osRel

		        END osName

				FROM 

		        (

		            SELECT

		                c.id clientId, 

		                c.status,

		                SUBSTRING(cp.attrVal, 0, CHARINDEX(N':-', cp.attrVal, 0)) osName,

		                ISNULL((CASE (CHARINDEX(N'Windows', (CASE WHEN cp.attrVal IS NULL OR cp.attrVal = N'' THEN os.name ELSE cp.attrVal END))

		                                + CHARINDEX(N'Any', (CASE WHEN cp.attrVal IS NULL OR cp.attrVal = N'' THEN os.name ELSE cp.attrVal END)))

		                        WHEN 0 THEN N' ' +

		                                    SUBSTRING(

		                                        SUBSTRING(cp.attrVal, CHARINDEX(N':-', cp.attrVal) + 2, LEN(cp.attrVal) - LEN(CHARINDEX(N':-',cp.attrVal))), 

		                                        0,

		                                        CHARINDEX(N':-', SUBSTRING(cp.attrVal, CHARINDEX(N':-', cp.attrVal) + 2, LEN(cp.attrVal) - LEN(CHARINDEX(N':-',cp.attrVal))), 0)

		                                    )

		                        ELSE ''

		                    END), '') osRel,

		                ISNULL(os.name, N'') simOSName,

		                CASE

		                    -- Don't test os.Type = 'Any' - that is only true for NetApp

		                    -- Don't test (c.status & 2) <> 2 - that will miss deconfigured (CV_STATUS_UNINSTALLED) clients!

		                    WHEN os.SubType = N'NAS' THEN 1

		                    ELSE 0

		                END isNAS

		            FROM

		                APP_Client c WITH(READUNCOMMITTED)

		                LEFT OUTER JOIN APP_ClientProp cp WITH(READUNCOMMITTED) ON

		                    cp.componentNameId = c.id

		                    AND cp.attrName = N'Sim OS Info' 

		                    AND cp.modified = 0

		                    AND cp.attrVal <> N''

		                LEFT OUTER JOIN simOperatingSystem os WITH(READUNCOMMITTED) ON

		                    os.id = c.simOperatingSystemId

		        ) q         

			) AS T3 ON T3.clientId = T2.id

			LEFT OUTER JOIN 

			(

				SELECT CP.componentNameId 

				FROM APP_CLIENTPROP CP WITH (NOLOCK) 				

				WHERE CP.ATTRNAME = 'Operating System Name'

				and CP.modified =0				

			) P

			ON T2.id = P.componentNameId

			WHERE P.componentNameId is null
			INSERT INTO APP_CLIENTPROP


			SELECT T2.id,'Hardware Info',1,T2.cHwName,@nowTime,0,0	

			FROM		

			(

					-- Should match AppUpdateStaticClientProperties.sp

					SELECT

						q.clientId as id,

						CASE

							WHEN q.hwPos IS NOT NULL AND q.hwPos > 0 THEN SUBSTRING(q.osInfo, q.osInfoLen - q.hwPos + 1, hwPos + 1)

							ELSE q.osName

						END as cHwName

						FROM 

						(

							SELECT

								c.id clientId,

								os.name osName,

								cp.attrVal osInfo,

								LEN(cp.attrVal) osInfoLen,

								(CHARINDEX('-:', REVERSE(cp.attrVal))-1) hwPos

								FROM APP_Client c

								LEFT OUTER JOIN simOperatingSystem os ON

									os.id = c.simOperatingSystemId							

								INNER JOIN APP_ClientProp cp ON		

									cp.componentNameId = c.id

									AND cp.attrname = N'Sim OS Info'

									AND cp.modified = 0

							WHERE

								c.id > 1

						) q 

			)	

			T2 			 

			 LEFT OUTER JOIN 

			(

				SELECT CP.componentNameId 

				FROM APP_CLIENTPROP CP WITH (NOLOCK) 		

				WHERE CP.ATTRNAME = 'Hardware Info'

				and CP.modified = 0				

			) P

			ON  T2.id = P.componentNameId

			WHERE P.componentNameId is null	
			INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('3F3FA308-D517-4851-903F-78B8B4618C1A', 'Client OS Version and Hardware Info Update', 'Update client OS version information and other hardware related information', @nowTime, 16, 0, (16 + 2))

END

DECLARE @ccsCurrentTime INTEGER = (SELECT DATEDIFF(s, CONVERT(DATETIME, '1970-01-01'), GETUTCDATE()))

DECLARE @DeletePropForInvalidCCSCfgs VARCHAR(512) = 'A425AD57-97AA-4DDD-8314-BFE31B4FC100'

IF NOT EXISTS (SELECT TOP 1 1 FROM GXUniqueSQLScriptExecTracking WITH (NOLOCK) WHERE SqlScriptGUID = @DeletePropForInvalidCCSCfgs)

BEGIN

	IF OBJECT_ID('tempdb.dbo.#validCCSFSCoreLTClients') IS NOT NULL 

		DROP TABLE #validCCSFSCoreLTClients

	CREATE TABLE #validCCSFSCoreLTClients (

		--clientId	INT PRIMARY KEY,

		propId		INT PRIMARY KEY

	)
	INSERT INTO #validCCSFSCoreLTClients(propId)


		SELECT

			--c.id clientId,		-- clients with ONLY FS Core Laptop configurations

			cp.id propId

		FROM APP_Client c WITH(NOLOCK)

			INNER JOIN APP_ClientProp cp WITH(NOLOCK) ON

				cp.componentNameId = c.id

				AND cp.attrName = N'CCS Enabled'

				AND cp.modified = 0

			INNER JOIN simInstalledPackages ip WITH(NOLOCK) ON

				ip.ClientId = c.id

		WHERE

			(c.status & 4096) = 4096		-- Laptop Configuration

		GROUP BY 

			--c.id,

			cp.id

		HAVING 

			SUM(CASE WHEN simPackageID = 1 THEN 1 ELSE 0 END) = 1		-- Filesystem Core installed

			AND COUNT(DISTINCT simPackageID) = 1	

	BEGIN TRY

		BEGIN TRAN CCS_ICFG_SP12_TRAN

		-- Delete CCS Client Property rows not in this list - Client not configured properly to use CCS which is ONLY FS Core Package with Laptop configured.

		DELETE cp

		FROM APP_ClientProp cp 

			LEFT OUTER JOIN #validCCSFSCoreLTClients c ON

				c.propId = cp.id

		WHERE

			c.propId IS NULL		-- not a valid configured CCS Client, remove CCS Enabled Property

			AND cp.attrName = N'CCS Enabled' 

			AND cp.modified = 0

		COMMIT TRAN CCS_ICFG_SP12_TRAN

	END TRY

	BEGIN CATCH

		PRINT  'CCS Invalid Client Configuration: INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

			ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

			PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '

			ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

			ERROR MESSAGE: ' + ERROR_MESSAGE() + '

			ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

			ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		ROLLBACK TRAN CCS_ICFG_SP12_TRAN

		RAISERROR ('Failed to delete invalid configured CCS Enabled Clients', 16, 1)

	END CATCH
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@DeletePropForInvalidCCSCfgs, 'Delete Invalid Configured Clients CCS Enabled property', 'Delete Invalid Configured Clients CCS Enabled property', @ccsCurrentTime, 16, 0, (16 + 2))

END

DECLARE @CleanupCCS_SP12_Clients VARCHAR(512) = '4A02757B-F250-411A-AEEF-74582F5B19C1'

IF NOT EXISTS (SELECT TOP 1 1 FROM GXUniqueSQLScriptExecTracking WITH (NOLOCK) WHERE SqlScriptGUID = @CleanupCCS_SP12_Clients)

BEGIN

	-- Identify existing clients with CCS Enabled property and who are NOT running the V11 SP12[+] CCS Software updates

	IF OBJECT_ID('tempdb.dbo.#ccsSP12Clients') IS NOT NULL 

		DROP TABLE #ccsSP12Clients

	CREATE TABLE #ccsSP12Clients (

		clientId				INT PRIMARY KEY,

		newCCSEnabledSetting	NVARCHAR(4)

	)
	INSERT INTO #ccsSP12Clients(clientId, newCCSEnabledSetting)


		SELECT

			q.clientId,

			--q.ccsEnabled,

			--q.spVersion,

			CASE

				WHEN q.spVersion IS NULL THEN N'0'

				WHEN TRY_CAST(q.spVersion AS INT) >= 12 THEN N'1'

				ELSE N'0'

			END newCCSEnabledSetting

		FROM (

				SELECT

					c.id clientId,

					ccs.attrVal ccsEnabled,

					ip.HighestSP spVersion

				FROM APP_Client c WITH(NOLOCK)

					INNER JOIN APP_ClientProp ccs WITH(NOLOCK) ON

						ccs.componentNameId = c.id

						AND ccs.attrName = N'CCS Enabled'

						AND ccs.modified = 0

					INNER JOIN simInstalledPackages ip WITH(NOLOCK) ON

						ip.ClientId = c.id

				--WHERE

				--	(c.status & (2|4)) = 0	-- uninstalled / deleted	-- Disable in this state as well

			) q

	BEGIN TRY

		BEGIN TRAN CCS_SP12_TRAN

		-- Delete client property rows that do not have the new CCS Software Release starting with V11 SP12

		DELETE FROM cp

		FROM APP_ClientProp cp

			INNER JOIN #ccsSP12Clients c ON

				c.clientId = cp.componentNameId

				AND cp.attrName = N'CCS Enabled'

				AND cp.modified = 0

				AND c.newCCSEnabledSetting = '0'

		COMMIT TRAN CCS_SP12_TRAN

	END TRY

	BEGIN CATCH

		PRINT  'CCS pre-SP12: INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

			ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

			PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '

			ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

			ERROR MESSAGE: ' + ERROR_MESSAGE() + '

			ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

			ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		ROLLBACK TRAN CCS_SP12_TRAN

		RAISERROR ('Failed to cleanup CCS Enabled Client pre SP12 Release', 16, 1)

	END CATCH
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@CleanupCCS_SP12_Clients, 'Cleanup CCS Clients for SP12 Release', 'Any pre SP12 CCS Clients should be disabled', @ccsCurrentTime, 16, 0, (16 + 2))

END

GO

SET NOCOUNT OFF

GO

SET QUOTED_IDENTIFIER ON

GO

-- Update geolocation property reference in DB

IF NOT EXISTS(SELECT 1 FROM	GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE	gp.SqlScriptGUID = '89e27160-08ca-4331-8064-a4b61ecbc6d6')

BEGIN

		DECLARE @tempTable TABLE (acpID INT Primary KEY, clientID INT, attrval NVARCHAR(1024), ipAddress NVARCHAR(1024), latitude NVARCHAR(1024), longitude NVARCHAR(1024), finalXML NVARCHAR(1024))
		INSERT INTO @tempTable (acpID, clientID, attrval)


		select id, componentNameId, attrVal from APP_ClientProp WHERE attrName='client geo location' AND TRY_CAST(attrVal as xml) IS NULL AND attrVal like '%SUCCESS%' AND modified=0

		UPDATE TT

		SET 

			TT.ipAddress = right(attrVal, len(attrVal) - len(substring(attrVal, 1, charindex('ip_address', attrVal, 1))) - len('ip_address=')),

			TT.latitude = right(attrVal, len(attrVal) - len(substring(attrVal, 1, charindex('latitude', attrVal, 1))) - len('latitude=')),

			TT.longitude = right(attrVal, len(attrVal) - len(substring(attrVal, 1, charindex('longitude', attrVal, 1))) - len('longitude='))

		FROM @tempTable TT

		UPDATE TT

		SET 

			TT.ipAddress = substring (TT.ipAddress, 1 , charindex( '''', TT.ipAddress, 1) -1),

			TT.latitude = substring (TT.latitude, 1 , charindex( '''', TT.latitude, 1) -1),

			TT.longitude = substring (TT.longitude, 1 , charindex( '''', TT.longitude, 1) -1)

		FROM @tempTable TT

		UPDATE TT 

		SET TT.finalXML = '<App_GeoLocation ip_address=''' + TT.ipAddress + ''' latitude=''' + TT.latitude + ''' longitude=''' + TT.longitude + ''' status_code=''SUCCESS'' status_description=''''/>'

		FROM @tempTable TT

		UPDATE ACP

		 SET ACP.attrval=TT.finalXML

		FROM APP_ClientProp ACP

		INNER JOIN @tempTable TT

			ON TT.acpID=ACP.id AND TT.clientID=ACP.componentNameId
		INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('89e27160-08ca-4331-8064-a4b61ecbc6d6', 'Update geolocation to remove unwanted quotes for malformed XML', 'Update geolocation to remove unwanted quotes for malformed XML', dbo.getUnixTime(GetUTCDate()), 16, 0, (16 + 2))

END

-- Remove Index Server dependency from CA cloud configurations

IF NOT EXISTS(SELECT 1 FROM	GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE	gp.SqlScriptGUID = '198EDEFC-F85E-424A-AC63-FF370317AC47')

BEGIN	

	IF EXISTS (SELECT 1 FROM APP_ClientProp WITH (NOLOCK) WHERE attrName ='Analytics CACloudId' AND modified = 0)

	BEGIN

		DELETE FROM APP_ClientProp WHERE attrName ='Analytics CACloudId' AND modified = 0

		-- Deleting the 'Analytics CACloudID' for the content analyzer cloud as the index server dependency is removed from the CA Cloud.

	END
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('198EDEFC-F85E-424A-AC63-FF370317AC47', 'RemoveIS_CACloudUpgrade', 'Rename Index Server dependency from Content Analyzer', datediff(second, '01/01/1970', GETDATE()), 16, 0 , (16 + 1))

END

-- Add IsInfrastructure property

IF NOT EXISTS(SELECT 1 FROM	GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE	gp.SqlScriptGUID = '37353368-3BA4-40A9-895A-EF5150482C62')

BEGIN

	DECLARE @currentTime INT = (SELECT dbo.GetUnixTime(GETUTCDATE()) )

	IF object_id('tempdb.dbo.#proxyClientList') IS NOT NULL

					  DROP TABLE #proxyClientList

	CREATE TABLE  #proxyClientList ( cId  int  PRIMARY KEY )
	INSERT INTO #proxyClientList


	--20 commserve

	--55  Index Store

	--252 Web Server

	--259 Content Extractor

	--713 VirtualServer Agent

	--726 Web Console

	--729 Content Analyzer

	--1136      VirtualServer Agent on UNIX

	--151 Exchange

	--730 Cloud Apps

	SELECT DISTINCT ClientId FROM simInstalledPackages

	WHERE simPackageID in (713,1136,259,55,729,726,252,730,20)

	UNION

	SELECT ClientId FROM MMHost WITH(NOLOCK) 

	WHERE clientid NOT IN (SELECT PMClientId FROM APP_VMToPMMap WITH(NOLOCK) WHERE VMClientId = 2) 

	MERGE App_clientProp as p

	USING (SELECT p.cId FROM #proxyClientList p) S

ON S.cId = p .componentNameId AND p.modified=0 AND p.attrName = 'IsInfrastructure'

	WHEN NOT MATCHED THEN

	INSERT (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)

VALUES (S.cId,'IsInfrastructure', 2, 1, @currentTime, 0 , 0);
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('37353368-3BA4-40A9-895A-EF5150482C62', 'Add_IsInfrastructure', 'Add IsInfrastructure for servers', datediff(second, '01/01/1970', GETDATE()), 16, 0 , (16 + 1))

END

-- VSA Subclient security expansion to VM clients

-- Populate the new property for existing clients during upgrade. 

DECLARE @VSASubclientVMClientPropertyGUID VARCHAR(128) = 'C5998CFF-D6E5-422A-B1FD-5864024626D1'

IF NOT EXISTS(SELECT 1 FROM	GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE	gp.SqlScriptGUID = @VSASubclientVMClientPropertyGUID)

BEGIN

	DECLARE @scriptRunTime INT = DATEDIFF(second, '01/01/1970', GETDATE())

	MERGE INTO APP_ClientProp AS target

	USING (

			SELECT componentNameId AS clientId, JM.appId AS subclientId

			FROM APP_ClientProp CP

				INNER JOIN JMBkpStats JM

					ON CAST(CP.attrVal AS INT) = JM.jobId 

			WHERE 

				CP.attrName = 'Last Backup JobID'

				AND CP.modified = 0) AS source

ON (target.componentnameid = source.clientid AND target.attrname = 'Last Backup Subclient')

	WHEN MATCHED THEN

		UPDATE SET attrVal = Source.subclientId, created = @scriptRunTime 

	WHEN NOT MATCHED THEN

		INSERT (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)

VALUES (source.clientid, 'Last Backup Subclient', 7, CAST(source.subclientId AS VARCHAR(10)), @scriptRunTime, 0, 0);
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@VSASubclientVMClientPropertyGUID, 'VSASubclientVMClientPropertyGUID', 'Populate VSA Subclient for VM clients property', @scriptRunTime, 16, 0 , (16 + 1))

END

DECLARE @IsInfrastructurePropertyGUID VARCHAR(128) = 'AE2F7FA6-CE38-437F-9314-22D2768A73C9'

IF NOT EXISTS(SELECT 1 FROM	GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE	gp.SqlScriptGUID = @IsInfrastructurePropertyGUID)

BEGIN

	DECLARE @IsInfrastructurePropertyGUIDRunTime INT = DATEDIFF(second, '01/01/1970', GETDATE())

	UPDATE p

	SET p.attrVal=N'0'

	FROM APP_Clientprop p

	INNER JOIN APP_CLIENT c ON c.id = p.componentNameId AND attrName in ('IsInfrastructure', 'IsInfrastructureMachine') AND attrVal = N'1'  AND p.modified=0

	WHERE STATUS & 4096 <> 0 -- laptop clients
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@IsInfrastructurePropertyGUID, 'IsInfrastructurePropertyGUID', 'Fix the IsInfrastructure and IsInfrastructureMachine for laptop clients', @IsInfrastructurePropertyGUIDRunTime, 16, 0 , (16 + 1))

END

-- To assign default global webconsole based on globalparam webConsoleURL

DECLARE @globalWebconsoleGUID VARCHAR(128) = '6D749838-1CDE-4691-A25D-C17EB8FBD563'

IF NOT EXISTS(SELECT 1 FROM	GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE	gp.SqlScriptGUID = @globalWebconsoleGUID)

BEGIN

	DECLARE @globalWebconsoleSetTime INT = DATEDIFF(second, '01/01/1970', GETUTCDATE())	

	DECLARE @webConsoleURL NVARCHAR(MAX) = ''

	DECLARE @defaultWebconsoleHostname nvarchar(510); 

	DECLARE @defaultWebconsoleClientId INT

	SELECT @webConsoleURL = value FROM GXGlobalParam(nolock) WHERE name = N'WebConsoleURL'

	IF @webConsoleURL IS NOT NULL AND LTRIM(RTRIM(@webConsoleURL)) <> ''

	BEGIN

		--DBO.GetHostnameFromUrl(@webConsoleURL) definition

		DECLARE @pos1 INT = CHARINDEX('//', @webConsoleURL)

           DECLARE @pos2 INT = CASE WHEN @pos1 = 0 THEN 1 ELSE @pos1 + 2 END

           SET @defaultWebconsoleHostname =  SUBSTRING(@webConsoleURL,

               @pos2,

               CASE

                   WHEN CHARINDEX(':', @webConsoleURL, @pos2) > 0 THEN CHARINDEX(':', @webConsoleURL, @pos2) - @pos2

                   WHEN CHARINDEX('/', @webConsoleURL, @pos2) > 0 THEN CHARINDEX('/', @webConsoleURL, @pos2) - @pos2

                   WHEN CHARINDEX('?', @webConsoleURL, @pos2) > 0 THEN CHARINDEX('?', @webConsoleURL, @pos2) - @pos2

                   ELSE LEN(@webConsoleURL)

               END

               )

		--order by not needed.Ideally there should be only one match for this criteria.

		SET @defaultWebconsoleClientId = (SELECT TOP 1 CL.id 

											FROM 

												APP_Client CL(NOLOCK) 		

											INNER JOIN simInstalledPackages SP(NOLOCK) ON CL.ID = SP.ClientId		

											WHERE (net_hostname = @defaultWebconsoleHostname OR name = @defaultWebconsoleHostname) 

											AND SP.simPackageID in (726,1135)

										  )

	END

	IF (@defaultWebconsoleClientId IS NOT NULL AND @defaultWebconsoleClientId>0)	

	BEGIN

		-- enable the defaultwebconsole client

		MERGE App_ClientProp t USING (VALUES(@defaultWebconsoleClientId)) AS s (defaultWebconsoleClientId) 

		ON (t.componentNameId = s.defaultWebconsoleClientId AND t.attrName = N'Side by Side Loading of Multiple SP Instance Enabled'  AND t.modified=0)

		WHEN MATCHED AND attrVal <>  N'1' THEN

			UPDATE SET attrVal =  N'1'

		WHEN NOT MATCHED THEN

			INSERT (componentNameId, attrName, attrType, attrVal, created, modified , ccpId)

			Values( s.defaultWebconsoleClientId, N'Side by Side Loading of Multiple SP Instance Enabled', 1,  N'1', @globalWebconsoleSetTime, 0, 0);

	END
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@globalWebconsoleGUID, 'AutoEnableGlobalWebconsole', 'AutoEnable Global Webconsole for dynamic app creation.', @globalWebconsoleSetTime, 16, 0 , (16 + 1))

END

DECLARE @SIMOSVersionFixGUID VARCHAR(128) = '2DDBB97F-01C5-43A9-A223-C014F4F1B550'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WITH(NOLOCK) WHERE SqlScriptGUID = @SIMOSVersionFixGUID)

BEGIN

	DECLARE @ClientsWithOSToFix TABLE (t_id INT, t_clientID INT, t_oldOS VARCHAR(MAX), t_OSVer VARCHAR(MAX), t_newOS VARCHAR(MAX))
	INSERT INTO @ClientsWithOSToFix


	SELECT	id, componentNameId, attrVal, dbo.getClientOSVersion(componentNameId, attrVal), '' 

	FROM	APP_CLientProp 

	WHERE	attrName = 'SIM OS INFO' AND attrVal like '%:-New:-%:-%' AND componentNameID in (select C.id from APP_Client C JOIN SimOperatingSystem O ON SimOperatingSystemID = O.id and O.type = 'Windows')

	UPDATE @ClientsWithOSToFix SET t_newOS = REPLACE(t_oldOS, ':-New:-', ':-'+t_OSVer+':-') WHERE ISNUMERIC(t_OSVer) = 1

	UPDATE APP_CLientProp SET attrVal = t_newOS FROM @ClientsWithOSToFix WHERE id= t_id AND LEN(t_newOS) > 0
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@SIMOSVersionFixGUID, 'SIMOSVersionFix', 'Fix cached OS version for windows clients', datediff(second, '01/01/1970', GETDATE()), 16, 0 , (16 + 1))

END

DECLARE @populateLastVMBackupJobInfoGUID uniqueidentifier = '2D6A0CA8-EB1C-47AE-8B0B-C3BC9F1366D8'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WITH (NOLOCK) WHERE SqlScriptGUID = @populateLastVMBackupJobInfoGUID)

BEGIN

	IF OBJECT_ID('tempdb.dbo.#lastBackupInfoTmp') IS NOT NULL 

		DROP TABLE dbo.#lastBackupInfoTmp

	CREATE TABLE #lastBackupInfoTmp(vmClientId INTEGER PRIMARY KEY, jobId INT, commcellId INT, jobEndTime INT, lastBackupInfo XML);

	-- Get All VMs
	INSERT INTO #lastBackupInfoTmp(vmClientId)


	SELECT componentNameId 

	FROM APP_ClientProp (NOLOCK)

	WHERE attrName = 'Virtual Server Discovered Clients' AND attrVal = '1' AND modified = 0

	-- Get latest job information. Consider backups and snap backups only

	UPDATE L

	SET jobId = J.jobId,

		commcellId = J.commCellId,

		jobEndTime = J.servEndDate,

		lastBackupInfo = (

							SELECT	J.jobId AS '@jobID',

									J.commCellId AS '@commCellID',

									J.status AS '@status',

									CASE 

										WHEN LEN(J.failureReasonMsg) > 512 -- Limiting to 512 in the failure reason to ensure it doesnt overflow attrVal column after xml encoding.

											THEN SUBSTRING(J.failureReasonMsg, 1, 500) + '<Truncated>'

										ELSE J.failureReasonMsg

									END AS '@failureReasonMessageEnglish',

									J.servEndDate AS 'endTime/@time',

									J.servStartDate AS 'startTime/@time'

							FOR XML PATH('lastBackupJobInfo'), TYPE

						 )

	FROM #lastBackupInfoTmp L

	INNER  JOIN

	(

		SELECT VM.vmclientid, JM.jobId, JM.commCellId, JM.servStartDate, JM.servEndDate, 

			   CASE VMP.attrVal 

				   WHEN '0' THEN 1 -- VMClientBkupStatus::COMPLETED, CVJobStatus::JMSUCCESS

				   WHEN '1' THEN 2 -- VMClientBkupStatus::FAILED, CVJobStatus::FAIL

				   WHEN '3' THEN 3 -- VMClientBkupStatus::PARTIAL_SUCCESS, CVJobStatus::PARTIALSUCCESS

				   WHEN '6' THEN 4 -- VMClientBkupStatus::KILLED, CVJobStatus::KILLED

				   ELSE 9 -- VMClientBkupStatus::SKIPPED_BY_USER or VMClientBkupStatus::SKIPPED, CVJobStatus::DROPPED		

			   END AS status,

			   JPR.attrVal AS failureReasonMsg, ROW_NUMBER() OVER (PARTITION BY VM.vmClientId ORDER BY JM.servEndDate DESC) AS RowNumber

		FROM #lastBackupInfoTmp VM

		INNER JOIN APP_VMProp VMP (NOLOCK) ON VMP.VMclientId = VM.vmclientid AND VMP.attrName = N'vmStatus'

		INNER JOIN JMBkpStats JM (NOLOCK) ON VMP.jobId = JM.jobId AND VMP.commCellId = JM.commCellId AND JM.opType IN (4, 59) --  BACKUP, SNAPBACKUP)

		LEFT OUTER JOIN APP_VMProp JPR (NOLOCK) ON JPR.jobId = JM.jobId AND JPR.commCellId = JM.commCellId AND JPR.vmClientId = VMP.vmClientId AND JPR.attrName = N'vmFailureReason' AND JPR.attrVal <> ''

	)J

	ON J.vmclientid = L.vmclientid AND J.RowNumber = 1

	--Save in VM client prop level

	--If Prop already exists, update. Else insert below.

	UPDATE CP

	SET CP.attrVal = CAST(T.lastBackupInfo AS NVARCHAR(MAX)),

		CP.created = T.jobEndTime

	FROM #lastBackupInfoTmp T

	INNER JOIN APP_ClientProp CP ON CP.componentNameId = T.vmClientId AND CP.attrName = 'Last VM Backup Job Info' AND CP.modified = 0

	WHERE jobId IS NOT NULL -- Have a valid job
	INSERT INTO APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)


	SELECT vmClientId, 'Last VM Backup Job Info', 15, CAST(lastBackupInfo AS NVARCHAR(MAX)), jobEndTime, 0, 0 

	FROM #lastBackupInfoTmp T

	LEFT OUTER JOIN APP_ClientProp CP (NOLOCK) ON CP.componentNameId = T.vmClientId AND CP.attrName = 'Last VM Backup Job Info' AND CP.modified = 0

	WHERE jobId IS NOT NULL -- Have a valid job

	AND CP.id IS NULL -- Prop not already exists, so insert.
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@populateLastVMBackupJobInfoGUID, 'PopulateLastVMBackupInfo', 'Update script to populate last backup info for VMs', DATEDIFF(second, '01/01/1970', GETUTCDATE()), 16, 0, (16 + 2))

	IF OBJECT_ID('tempdb.dbo.#lastBackupInfoTmp') IS NOT NULL 

		DROP TABLE dbo.#lastBackupInfoTmp

END

DECLARE @IndexingV2EnabledMaskGUID VARCHAR(128) = 'CDD14170-B1C4-4980-80EC-565681CA5BE2'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WITH(NOLOCK) WHERE SqlScriptGUID = @IndexingV2EnabledMaskGUID)

BEGIN

	-- Update all IndexingV2_EnabledBitmask properties

	EXEC dbo.UpdateIdxV2AppTypesBitmask
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@IndexingV2EnabledMaskGUID, 'InsertOrUpdateIndexingV2EnabledMask', 'Insert or update the Indexing V2 enabled bitmask', datediff(second, '01/01/1970', GETDATE()), 16, 0 , (16 + 1))

END

DECLARE @removeClientPropertyCloudModeGUID VARCHAR(128) = 'C59FA0FD-DFB2-40CC-99F2-55FE3848094B'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WITH(NOLOCK) WHERE SqlScriptGUID = @removeClientPropertyCloudModeGUID)

BEGIN

	-- delete property 'Cloud Mode Enabled' since it is not needed

delete from APP_ClientProp where attrName = 'Cloud Mode Enabled'
    INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@removeClientPropertyCloudModeGUID, 'RemoveClientPropertyCloudModeFix', 'Remove property cloud mode enabled for clients', datediff(second, '01/01/1970', GETDATE()), 16, 0 , (16 + 1))

END

DECLARE @removeExtraLastOfflineTimeProp VARCHAR(128) = '09CD6617-FA6C-48DE-B6BE-366843388A3A'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WITH(NOLOCK) WHERE SqlScriptGUID = @removeExtraLastOfflineTimeProp)

BEGIN

	DELETE CP

	FROM APP_ClientProp CP

	LEFT JOIN

	(

SELECT componentNameId, 'Last offline time' attrName, MAX(CAST(attrVal AS INTEGER)) lastOfflineTime

		FROM APP_ClientProp

WHERE attrName = 'Last offline time' AND modified = 0

		GROUP BY componentNameId

	) CP1 

ON CP.componentNameId = CP1.componentNameId AND CP.attrName = CP1.attrName AND CP.attrVal = CAST(CP1.lastOfflineTime AS NVARCHAR(1024))

WHERE CP.attrName = 'Last offline time' AND CP.modified = 0 AND CP1.componentNameId IS NULL
    INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@removeExtraLastOfflineTimeProp, 'removeExtraLastOfflineTimePropFix', 'Remove extra client property of last offline time', datediff(second, '01/01/1970', GETDATE()), 16, 0 , (16 + 1))

END

GO

