

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/APP_CCSLaptopReload.script] ---------- 


SET QUOTED_IDENTIFIER ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

------------------------------------------------------------------------

-- rcsid[]='@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/APP_CCSLaptopReload.script,v $ $Id: APP_CCSLaptopReload.script,v 1.1.2.3 2020/03/12 01:31:42 abilbrey Exp $';

--TABLENAME APP_CCSLaptopReload

SET NOCOUNT ON

-- SP15

DECLARE @ccsReloadGUID	VARCHAR(40) = '55D22E34-2AAF-43C5-AF20-5B1B73CBD31C'

DECLARE @currentTime	INT =  DATEDIFF(second, '01/01/1970', GETUTCDATE())

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @ccsReloadGUID)

BEGIN

	--=================================================================================================

	-- This a CCS Laptop script that is setup to force a reload of all active CCS Laptop Clients

	-- when necessary in an Update or Service Pack database upgrade.

	--=================================================================================================

	-- Is CCS Functionality enabled on the CommServer?

    DECLARE @ccsEnabled INT = 0

    SELECT @ccsEnabled = CAST(value AS INT) FROM GXGlobalParam WITH(NOLOCK) WHERE name = 'CommServCCSEnabled'

	IF (@ccsEnabled = 1)

	BEGIN

		-- CCS Commserver Enabled

		-- Get List of CCS Laptop Clients that are Enabled

		IF OBJECT_ID('tempdb.dbo.#ccsClients') IS NOT NULL 

			DROP TABLE #ccsClients

		CREATE TABLE #ccsClients (

			clientId	INT PRIMARY KEY,

			ccsEnabled	INT,

			asEnabled	INT,

			wq49Rows	INT		-- true or false there are work queue rows

		)
		INSERT INTO #ccsClients (clientId, ccsEnabled, asEnabled, wq49Rows)


			SELECT 

				c.id, 

				CASE 

					WHEN cp.attrVal = N'1' THEN 1 

					ELSE 0 

				END, 

				CASE 

					WHEN CAST(s.value AS NVARCHAR(32)) = N'ONLINE' THEN 1

					ELSE 0 

				END,

				CASE

					WHEN wq.clientId IS NULL THEN 0

					ELSE 1

				END				

			FROM APP_Client c WITH(NOLOCK) 

				INNER JOIN APP_ClientProp cp WITH(NOLOCK) ON

					cp.componentNameId = c.id

					AND cp.attrName = N'CCS Enabled'

					AND cp.modified = 0

				INNER JOIN APP_AdvanceSettings s WITH(NOLOCK) ON

					s.entityId = cp.componentNameId

					AND s.entityType = 3

					AND s.keyName = N'sCCSDbStatus'

				LEFT OUTER JOIN (

					SELECT

						clientId

					FROM APP_WorkQueueRequest WITH(NOLOCK)

					WHERE

						workToken = 49		-- WORK_TOKEN_CCS_DB_CHANGE_STATE

					GROUP BY clientId

				) wq ON

					wq.clientId = c.id

			WHERE

				(c.status & (2|4)) = 0  -- client is not uninstalled

		-- Delete existing work queue rows for token 49

		DELETE FROM wq

		FROM APP_WorkQueueRequest wq

			INNER JOIN #ccsClients c ON

				c.clientId = wq.clientId

				AND wq.workToken = 49		-- WORK_TOKEN_CCS_DB_CHANGE_STATE

				AND wq.workTokenParams NOT IN ('DISABLED', 'LOAD')		-- do not delete DISABLED or LOAD rows already configured

		-- Insert new work queue rows to force reload CCS Laptop Clients
		INSERT INTO APP_WorkQueueRequest(clientId, remoteClient, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag)


			SELECT                          -- need to update the client's advance setting cache file else it may overwrite the sCCSDbStatus regkey with an out-of-date setting stored in the cache file

				c.clientId, 

				-1, 

				6,		-- WORK_TOKEN_REGISTRY

				'',

				@currentTime, 

				0,

				0, 

				0

			FROM #ccsClients c

			WHERE

				c.asEnabled = 1

				AND c.ccsEnabled = 1

				AND c.clientId NOT IN (	-- existing WQ Row exist, new row not needed

					SELECT DISTINCT

						clientId 

					FROM APP_WorkQueueRequest wq WITH(NOLOCK)

					WHERE

						(

							wq.workToken = 49		-- WORK_TOKEN_CCS_DB_CHANGE_STATE

							AND wq.workTokenParams IN ('DISABLED', 'LOAD')

						)

						OR (

							wq.workToken = 6		-- WORK_TOKEN_REGISTRY

						)

				)

			UNION ALL

			SELECT

				c.clientId, 

				-1, 

				49,			-- WORK_TOKEN_CCS_DB_CHANGE_STATE

				N'LOAD',

				@currentTime, 

				0,

				0, 

				0

			FROM #ccsClients c

			WHERE

				c.asEnabled = 1

				AND c.ccsEnabled = 1

				AND c.clientId NOT IN (	-- existing WQ Row exist, new row not needed

					SELECT DISTINCT

						clientId 

					FROM APP_WorkQueueRequest wq WITH(NOLOCK)

					WHERE

						wq.workToken = 49		-- WORK_TOKEN_CCS_DB_CHANGE_STATE

						AND wq.workTokenParams IN ('DISABLED', 'LOAD')

				)

		-- Clear this table of existing data since all clients will reload and reset serial to start at 1

		TRUNCATE TABLE APP_CCSTriggerRows

	END

	ELSE

	BEGIN

		-- Not enabled so delete any captured data

		TRUNCATE TABLE APP_CCSTriggerRows

	END
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@ccsReloadGUID, 'CCS Laptops Clients Reloaded', 'CC Laptop force reload script', @currentTime, 16, 0, (16 + 2))

END

ELSE

BEGIN

	-- SP20

	DECLARE @ccsReloadGUIDSP20	VARCHAR(40) = '01F7C49E-FC0F-4035-AAF1-0E35A4329345C'

	IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @ccsReloadGUIDSP20)

	BEGIN

		EXEC AppCCSSetLoadState 0		-- All Clients
		INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@ccsReloadGUIDSP20, 'CCS Laptops Clients Reloaded for Client Group Content', 'CCS Laptop force reload script  for Client Group Content', @currentTime, 16, 0, (16 + 2))

	END

END

GO 

SET  NOCOUNT OFF

