

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/APP_BackupSetProp.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

SET NOCOUNT ON

SET QUOTED_IDENTIFIER ON

GO

DECLARE @curTime INT = datediff(second, '01/01/1970', GETUTCDATE())

--Update File System Quota Usage property name to Application Size

DECLARE @fsQuotaPropertyUpdateGUID varchar(36) = 'FCBB729B-E9C1-477E-9187-AA6595119692'

IF NOT EXISTS(SELECT 1 FROM	GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE	gp.SqlScriptGUID = @fsQuotaPropertyUpdateGUID)

BEGIN

UPDATE APP_BackupSetProp SET attrName = N'Application Size' WHERE attrname = N'File System Quota Usage'
INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@fsQuotaPropertyUpdateGUID, 'FSQuotaPropNameUpdate', 'Update File System Quota Usage property name to Application Size', @curTime, 16, 0, (16 + 2))

END

DECLARE @populateLastBackupJobInfoBkpSetGUID uniqueidentifier = 'D6054D14-4125-4551-991D-663B68172FE2'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WITH (NOLOCK) WHERE SqlScriptGUID = @populateLastBackupJobInfoBkpSetGUID)

BEGIN

	IF OBJECT_ID('tempdb.dbo.#lastBackupInfoTmp_bsProp') IS NOT NULL 

		DROP TABLE dbo.#lastBackupInfoTmp_bsProp

	CREATE TABLE #lastBackupInfoTmp_bsProp(subclientId INTEGER PRIMARY KEY, backupSetId INT, jobId INT, commcellId INT, jobEndTime INT, lastBackupInfo XML);

	-- find all valid subclients 
	INSERT INTO #lastBackupInfoTmp_bsProp(subclientId, backupSetId)


	SELECT SC.id, SC.backupSet

	FROM APP_Application AS SC WITH(NOLOCK)

	INNER JOIN APP_Client AS CL WITH(NOLOCK) ON 

                        SC.clientId = CL.id

                        AND (CL.status & 4) = 0				-- deleted/agentless client

                        AND (SC.subclientStatus & 536) != 536           -- not an indexing subclient

                        AND (SC.subclientStatus & (16|32)) = 0          -- do not backup flags are no set

                        AND (SC.subclientStatus & 4) = 0		-- subclient is not deleted

                        AND dbo.IsSubClientValid(SC.appTypeId, SC.subclientStatus, 0) = 1   -- subclient is valid

                    INNER JOIN APP_BackupSetName AS BS WITH(NOLOCK) ON 

                        BS.id = SC.backupSet

                        AND BS.name <> N'defaultDummyBackupSet'

                    INNER JOIN APP_InstanceName AS INST WITH(NOLOCK) ON 

                        INST.id = SC.instance

                        AND INST.name NOT IN (N'DefaultDummyInstanceForOracle', N'defaultDummyInstanceForSAP')

                    INNER JOIN APP_IDAName AS IDA WITH(NOLOCK) ON 

                        IDA.clientId = SC.clientId

						AND IDA.appTypeId = SC.appTypeId

                WHERE 

                    IDA.appTypeId = 78 -- CV_APPTYPE_MS_SHAREPOINTV2_DOC

	-- Populate the jobIds

	UPDATE  L

	SET jobId = J.jobId,

		commcellId = J.commCellId,

		jobEndTime = J.servEndDate,

		lastBackupInfo = (

							SELECT	J.jobId AS '@jobID',

									J.commCellId AS '@commCellID',

									J.displayStatus AS '@status', -- Use display status always so that committed jobs show correctly

									J.failureReason AS '@failureReasonIds',

									J.failureReasonMsg AS '@failureReasonMessageEnglish',

									J.servEndDate AS 'endTime/@time',

									J.servStartDate AS 'startTime/@time'

							FOR XML PATH('lastBackupJobInfo'), TYPE

						 )

	FROM #lastBackupInfoTmp_bsProp L 

	CROSS APPLY

	(

		SELECT TOP 1 jobId, commCellId, servStartDate, servEndDate, displayStatus, failureReason, dbo.JMGetLocalizedMessageFunc(0, failureReason) AS failureReasonMsg

		FROM JMBkpStats AS BKP(NOLOCK) 

		WHERE BKP.appId = L.subclientId

		AND optype IN (4, 18, 59, 65, 30, 43) -- JMShouldUpdateLastBackupTime

		ORDER BY servEndDate DESC

	)J

	-- Save in subclient level

	-- If Prop already exists, update. Else insert below.

	UPDATE SP

	SET SP.attrVal = CAST(T.lastBackupInfo AS NVARCHAR(MAX)),

		SP.created = T.jobEndTime

	FROM #lastBackupInfoTmp_bsProp T

	INNER JOIN APP_SubClientProp SP ON SP.componentNameId = T.subclientId AND SP.attrName = 'Last Backup Job Info' AND SP.modified = 0 ANd SP.cs_attrName = CHECKSUM(N'Last Backup Job Info')

	WHERE jobId IS NOT NULL -- Have a valid job
	INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)


	SELECT subclientId, 'Last Backup Job Info', 15, CAST(lastBackupInfo AS NVARCHAR(MAX)), jobEndTime, 0, 0 

	FROM #lastBackupInfoTmp_bsProp T

	LEFT OUTER JOIN APP_SubClientProp SP ON SP.componentNameId = T.subclientId AND SP.attrName = 'Last Backup Job Info' AND SP.modified = 0 ANd SP.cs_attrName = CHECKSUM(N'Last Backup Job Info')

	WHERE jobId IS NOT NULL -- Have a valid job

	AND SP.id IS NULL -- Prop not already exists, so insert.

	-- For Sharepoint in command center, remove all except 1 latest row per backupset

	DELETE L1

	FROM #lastBackupInfoTmp_bsProp L1

	CROSS APPLY

	(

		SELECT TOP 1 jobId, commcellId 

		FROM #lastBackupInfoTmp_bsProp L2

		WHERE L2.backupSetId = L1.backupSetId

		ORDER BY L2.jobEndTime DESC

	)AL

	WHERE (L1.jobId <> AL.jobId OR L1.jobId IS NULL)

	-- Also save in backupset level

	-- If Prop already exists, update. Else insert below.

	UPDATE IP

	SET IP.attrVal = CAST(T.lastBackupInfo AS NVARCHAR(MAX)),

		IP.created = T.jobEndTime

	FROM #lastBackupInfoTmp_bsProp T

	INNER JOIN APP_BackupSetProp IP ON IP.componentNameId = T.backupSetId AND IP.attrName = 'Last Backup Job Info' AND IP.modified = 0 

	WHERE jobId IS NOT NULL  -- Have a valid job
	INSERT INTO APP_BackupSetProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)


	SELECT backupSetId, 'Last Backup Job Info', 15, CAST(lastBackupInfo AS NVARCHAR(MAX)), jobEndTime, 0, 0 

	FROM #lastBackupInfoTmp_bsProp T

	LEFT OUTER JOIN APP_BackupSetProp IP ON IP.componentNameId = T.backupSetId AND IP.attrName = 'Last Backup Job Info' AND IP.modified = 0 

	WHERE jobId IS NOT NULL -- Have a valid job

	AND IP.id IS NULL -- Prop not already exists, so insert.
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@populateLastBackupJobInfoBkpSetGUID, 'PopulateLastBackupInfoSharepoint', 'Update script to populate last backup info for Sharepoint.', DATEDIFF(second, '01/01/1970', GETUTCDATE()), 16, 0, (16 + 2))

END

--Remove unwanted plan association from backupset level

DECLARE @planPropertyRemoveGUID varchar(36) = '5F81E616-C1DC-4019-BD2D-F20BDEA588B5'

IF NOT EXISTS(SELECT 1 FROM	GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE	gp.SqlScriptGUID = @planPropertyRemoveGUID)

BEGIN

	DELETE ABP

		FROM APP_BackupsetProp ABP

	INNER JOIN APP_APPlication AAP

ON AAP.backupset=ABP.componentNameId AND ABP.attrName='Associated Plan' AND ABP.modified=0

	LEFT OUTER JOIN APP_AppTypeGroupAssoc AAT

		ON AAT.appTypeId=AAP.appTypeId AND AAT.appGroupId=35	-- FS Apptype Group ID

	WHERE (AAT.appTypeId IS NULL) AND AAP.appTypeId NOT IN (1030,37,62,103,135)		

	-- Don't delete anything for subclient policy level and for below IDAs

	--CV_APPTYPE_DB2                          37

	--CV_APPTYPE_UNIX_DB2                     62

	--CV_APPTYPE_DB2_DPF                      103

	--CV_APPTYPE_SAP_HANA                     135
INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@planPropertyRemoveGUID, 'PlanPropertyRemoveGUID', 'Remove Plan property for no FS IDA apptypes', @curTime, 16, 0, (16 + 2))

END

--Reset the indexing dataSourceId property.

DECLARE @resetIndexingDataSourceId varchar(36) = '5A8A0BD1-1300-47C2-95DC-459BF2F561A7'

IF NOT EXISTS(SELECT 1 FROM	GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE	gp.SqlScriptGUID = @resetIndexingDataSourceId)

BEGIN

	IF object_id('tempdb.dbo.#dataSourceIndexingProp') IS NOT NULL

		DROP TABLE #dataSourceIndexingProp

	CREATE TABLE #dataSourceIndexingProp

	(

		id					int,

		componentNameId		int,

		created				int,

		modified			int

	)
	INSERT INTO #dataSourceIndexingProp


	SELECT id, componentNameId, created, modified

	FROM APP_BackupSetProp(NOLOCK) WHERE attrName = 'Indexing datasource id' and componentNameId NOT IN(

	SELECT componentNameId FROM APP_BackupSetProp(NOLOCK) WHERE attrName = 'Indexing datasource id' AND modified = 0)

	-- Exclude other than Exchange backupsets	

	DELETE #dataSourceIndexingProp

	FROM #dataSourceIndexingProp A, App_Application(NOLOCK) B

	WHERE A.componentNameId = B.backupSet AND B.appTypeId NOT IN(137)

	-- CTE to remove the duplicate and keep the latest row.

	;With dataSourcePropCTE As

	(

		SELECT componentNameId, ROW_NUMBER() OVER(PARTITION BY componentNameId ORDER BY created DESC) AS RowNum

		FROM #dataSourceIndexingProp

	)

	DELETE FROM dataSourcePropCTE WHERE RowNum > 1;

	UPDATE prop

	SET prop.modified = 0

	FROM 

	APP_BackupSetProp prop, #dataSourceIndexingProp T

	WHERE prop.id = T.id 

	DROP TABLE #dataSourceIndexingProp
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@resetIndexingDataSourceId, 'IndexingDatasourceIdReset', 'Resets the last indexing dataSourceId property modified time if there is no valid record', @curTime, 16, 0, (16 + 2))

END

SET  NOCOUNT OFF
