

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/APP_AdvanceSettings.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/APP_AdvanceSettings.script,v $ $Id: APP_AdvanceSettings.script,v 1.6.12.37 2020/12/29 07:57:54 njain Exp $";

--TABLENAME APP_AdvanceSettings

/******************************************************************************************************************

NEVER REMOVE KEYS DIRECTLY FROM DB (APP_AdvanceSettings table). THIS WILL CAUSE ISSUES IN CLIENT SIDE CACHE 

						AND REGISTRY KEYS CHANGES WILL BE OVER WRITTEN.

*******************************************************************************************************************/

GO

SET QUOTED_IDENTIFIER ON

GO

IF EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeFromRelease' AND CAST(Status AS INTEGER) IN (14) )

BEGIN

    IF (EXISTS (SELECT * FROM sys.objects WHERE type = 'U' AND name LIKE 'CvRegistryKeys'))

    BEGIN
       INSERT INTO APP_AdvanceSettings 


		(entityId,keyName,type,relativePath,value, enabled,deleted,entityType,sourceId,sourceEntityType)

			SELECT clientId,keyName,type,relativePath,value, enabled,deleted,3,0,0 

				FROM CvRegistryKeys

    END

END

IF EXISTS (SELECT 1 FROM APP_AdvanceSettings WHERE keyName = 'ExcludedExtentionsForEdgeDriveUpload' OR keyName = 'ExcludedExtentionsForUpload')

BEGIN

	UPDATE APP_AdvanceSettings SET keyName = 'ExcludedExtensionsForEdgeDriveUpload' WHERE keyName = 'ExcludedExtentionsForEdgeDriveUpload'

	UPDATE APP_AdvanceSettings SET keyName = 'ExcludedExtensionsForUpload' WHERE keyName = 'ExcludedExtentionsForUpload'

END

IF EXISTS (SELECT 1 FROM GXGlobalParam WHERE name = 'ExcludedExtentionsForEdgeDriveUpload' OR name = 'ExcludedExtentionsForUpload')

BEGIN

	UPDATE GXGlobalParam SET name = 'ExcludedExtensionsForEdgeDriveUpload' WHERE name = 'ExcludedExtentionsForEdgeDriveUpload'

	UPDATE GXGlobalParam SET name = 'ExcludedExtensionsForUpload' WHERE name = 'ExcludedExtentionsForUpload'

END

DECLARE @guid uniqueidentifier = 'F1E2C526-57D2-4170-B961-3CC6DA96885F'

DECLARE @curUtcDateTime BIGINT = datediff(second, '01/01/1970', GetUTCdate())    

DECLARE @globalParamPlanUpdateExec INT = 0

SELECT @globalParamPlanUpdateExec = 1

FROM

    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

    gp.SqlScriptGUID = @guid

IF @globalParamPlanUpdateExec = 0

BEGIN

	/**************************** Remove From CS DB and Lookup ********************************/

	DELETE FROM APP_AdvanceSettings 

		WHERE keyName = 'sExchangeServerName' AND relativePath = 'iDataAgent' AND sourceId = 0 AND sourceEntityType = 0

				AND entityType = 3

	DELETE FROM APP_AdvanceSettings 

		WHERE keyName = 'nPreferredIPFamily' AND relativePath = 'Session' AND sourceId = 0 AND sourceEntityType = 0

				AND entityType = 3 AND value LIKE N'1'

	DELETE FROM APP_AdvanceSettings 

		WHERE keyName = 'nSQL' AND relativePath = 'Cvd' AND sourceId = 0 AND sourceEntityType = 0

				AND entityType = 3

	DELETE FROM APP_AdvanceSettings 

		WHERE keyName = 'nDISABLE_CVFWD' AND relativePath = 'Firewall' AND sourceId = 0 AND sourceEntityType = 0

				AND entityType = 3 AND value LIKE N'*0*'

	DELETE FROM APP_AdvanceSettings 

		WHERE keyName = 'bGetClientPropOriginalMethod' AND relativePath = 'CommServe' AND sourceId = 0 AND sourceEntityType = 0

				AND entityType = 3

	--TODO: delete from GxGlobalParam

	/***************************** Remove From Dictionary ***************************************/

	DELETE FROM APP_AdvanceKeyInfo 

		WHERE keyName = 'nSQL' AND relativePath = 'Cvd'

	DELETE FROM APP_AdvanceKeyInfo 

		WHERE keyName = 'sExchangeServerName' AND relativePath = 'iDataAgent' 

	/****************************** Remove UnConditionally ***************************************/

	DELETE FROM APP_AdvanceSettings 

		WHERE keyName = 'nFAILFORPROXY' AND relativePath = 'FileSystemAgent' 
	  INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@guid, 'CleanUpAppAdvanceSettingsTable', 'Fix App_AdvanceSettings Entries', @curUtcDateTime, 16, 0 , (16 + 2))

END

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = '6910DBEA-B20B-4676-8AC2-E0DD3BC18202')

BEGIN

	DELETE FROM APP_AdvanceSettings

	WHERE keyName = 'bAllowAddDataPathforSnapCopies'

	DELETE FROM APP_AdvanceKeyInfo 

	WHERE keyName = 'bAllowAddDataPathforSnapCopies'
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


	    VALUES('6910DBEA-B20B-4676-8AC2-E0DD3BC18202', 'RemoveSnapMultiDataPathAdvancedSetting', 

'Remove advanced setting to allow addition of multiple data paths on a snap copy', @curUtcDateTime, 16, 0 , (16 + 2))

END

--Enable new RM on all CommServers

DELETE FROM APP_AdvanceKeyInfo 

WHERE keyName = 'bUseResourceManagerThread' AND relativePath = 'ResourceManager'

DELETE FROM	APP_AdvanceSettings 

WHERE 	entityId = 2 AND entityType = 3

AND keyName = 'bUseResourceManagerThread' AND relativePath = 'ResourceManager'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = '26A2A09D-4E71-458F-8B40-55B73BCF6F45')

BEGIN

	DECLARE @now INTEGER = dbo.GetUnixTime(GetUTCDate())

	DECLARE @entityType INTEGER = 3 --Client Entity

	DECLARE @keyName VARCHAR(64) = 'NrOfClientsServedByProxy'

	DECLARE @keyType VARCHAR(64) = 'INTEGER'

	DECLARE @relativePath VARCHAR(64) = 'WINFSDataMigrator/Config'

	DECLARE @hidden VARCHAR(64) = 1

	DECLARE @outTable TABLE (keyId INTEGER)

	IF OBJECT_ID('tempdb.dbo.#ProxyReferenceCount') IS NOT NULL 

		DROP TABLE #ProxyReferenceCount

	CREATE TABLE #ProxyReferenceCount (

							clientId INT PRIMARY KEY,                      

							clientCount INT DEFAULT 0

	)

	--Identify the primary and secondary proxy.

	INSERT #ProxyReferenceCount

	SELECT CAST(agentProp.attrVal AS INT), count(*) from APP_IDAName agent

	INNER JOIN APP_IDAProp agentProp ON agent.id = agentProp.componentNameId

				AND agentProp.attrName IN('FPOLICY PRIMARY CLIENT', 'FPOLICY SECONDARY CLIENT')

				AND agentProp.modified = 0

				WHERE agentProp.attrVal != '0'

				GROUP BY agentProp.attrVal

	--Push the registry key to proxy client.

	IF EXISTS(SELECT 1 FROM #ProxyReferenceCount)

	BEGIN
		INSERT INTO @outTable


		SELECT id FROM 

		(

			MERGE APP_AdvanceSettings as addSet

			USING (SELECT clientId as entityID , clientCount as cliCount FROM #ProxyReferenceCount) S

			ON addSet.entityId = S.entityID AND addSet.entityType = @entityType AND addSet.KeyName = @keyName AND addSet.type = @keyType AND addSet.relativePath = @relativePath

			WHEN MATCHED THEN UPDATE SET addSet.value = CAST(S.cliCount AS VARCHAR(16))

			WHEN NOT MATCHED THEN 

			INSERT VALUES(S.entityID, @keyName, @keyType, @relativePath, CAST(S.cliCount AS VARCHAR(16)), 1, 0, @entityType, 0, 0)

			OUTPUT $action,Inserted.id

		) AS Temp(MergeAction, id)

		MERGE APP_AdvanceSettingsEx addSetEx

		USING (SELECT keyId FROM @outTable) AS temp

		ON temp.keyId = addSetEx.keyId

		WHEN MATCHED THEN UPDATE SET addSetEx.hidden = @hidden

		WHEN NOT MATCHED THEN INSERT VALUES(temp.keyId,'',@hidden);

		--WORK_TOKEN_REGISTRY
		INSERT INTO APP_WorkQueueRequest(clientId,remoteClient,workToken,workTokenParams,createTime,lastUpdateTime,retryCount,flag)


		SELECT DISTINCT proxy.clientId, -1,6,'',@now,0,0,0 

		FROM #ProxyReferenceCount proxy

		INNER JOIN APP_Client client ON client.id = proxy.clientId

	END   

	--The registry key may be out of sync. Example, physical client may have the key NrOfClientsServedByProxy, but NetApp client removed the physical client as a proxy client and the client registry is not updated.

	--Following code will push the registry key with value 0 to physical client.

	UPDATE clientRegistry

	SET value = '0'

	FROM APP_AdvanceSettings clientRegistry

	LEFT OUTER JOIN #ProxyReferenceCount proxyClient ON clientRegistry.entityId = proxyClient.clientId

	WHERE clientRegistry.keyName = @keyName AND clientRegistry.relativePath = @relativePath AND clientRegistry.type = @keyType AND clientRegistry.entityType = @entityType

	AND proxyClient.clientId IS NULL
	INSERT INTO APP_WorkQueueRequest(clientId,remoteClient,workToken,workTokenParams,createTime,lastUpdateTime,retryCount,flag)


	SELECT clientRegistry.entityId, -1,6,'',@now,0,0,0 --WORK_TOKEN_REGISTRY

	FROM APP_AdvanceSettings clientRegistry

	LEFT OUTER JOIN #ProxyReferenceCount proxyClient ON clientRegistry.entityId = proxyClient.clientId

	WHERE clientRegistry.keyName = @keyName AND clientRegistry.relativePath = @relativePath AND clientRegistry.type = @keyType AND clientRegistry.entityType = @entityType

	AND proxyClient.clientId IS NULL
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


	    VALUES('26A2A09D-4E71-458F-8B40-55B73BCF6F45', 'PushProxyCountKey', 

'NetApp client has primary and secondary client, push a reference key to these clients.', @curUtcDateTime, 16, 0 , (16 + 2))

END

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = 'AAFFA903-69F1-4573-AC2B-C13FE0DA61F0')

BEGIN

	IF EXISTS ( SELECT 1 FROM APP_Plan WHERE flag = 0)

	BEGIN

		IF EXISTS (SELECT 1 FROM APP_AdvanceSettings WHERE keyName = 'showAssociatedSchedules')

		BEGIN

			UPDATE APP_AdvanceSettings SET value = 'true' WHERE keyName = 'showAssociatedSchedules'

		END

		ELSE

		BEGIN
			INSERT INTO APP_AdvanceSettings (entityId,keyName,type,relativePath,value, enabled,deleted,entityType,sourceId,sourceEntityType)


VALUES(2 /*CommCell*/, 'showAssociatedSchedules', N'BOOLEAN','CommServDB.AdminConsole','true', 1, 0, 3, 0, 0 )

		END

	END
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


			VALUES('AAFFA903-69F1-4573-AC2B-C13FE0DA61F0', 'showAssociatedSchedules', 

'Adding setting to show associated schedules at plan level', @curUtcDateTime, 16, 0 , (16 + 2))

END

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = '6157AC8D-8D11-493D-9D66-C63B17A47A6C')

BEGIN

	IF EXISTS (SELECT 1 FROM APP_AdvanceSettings WHERE keyName = 'showAssociatedSchedules' AND entityId = 0)

	BEGIN

		IF EXISTS (SELECT 1 FROM APP_AdvanceSettings WHERE keyName = 'showAssociatedSchedules' AND entityId = 2)

		BEGIN

			DELETE FROM APP_AdvanceSettings WHERE keyName = 'showAssociatedSchedules' AND entityId = 0

		END

		ELSE

		BEGIN

			UPDATE APP_AdvanceSettings SET entityId = 2 WHERE keyName = 'showAssociatedSchedules' AND entityId = 0

		END

	END
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


			VALUES('6157AC8D-8D11-493D-9D66-C63B17A47A6C', 'showAssociatedSchedulesCleanup', 

'cleanup if there are multiple values for the setting showAssociatedSchedules', @curUtcDateTime, 16, 0 , (16 + 2))

END

--

--

-- SET REGION PROPERTY FOR LAPTOP CLIENTS ------------------------------------------------------------------------------------------------------------------------------------

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = '8D67ADAF-1EA7-4D19-96F3-37DB83FF0420')

BEGIN

	BEGIN TRY

	BEGIN TRAN

		DECLARE	@clientId	INT, 

				@regionId	INT,

				@cLat		float,

				@cLong		float,

				@cLocation	XML,

				@cCountry	NVARCHAR(255),

				@cState		NVARCHAR(255),

				@regionStr	NVARCHAR(24)

		DECLARE @clientZones	TABLE(zoneId INT PRIMARY KEY, lat float, long float, distance float default 0)

		DECLARE clients_cursor CURSOR FOR   

		SELECT C.id

		FROM APP_Client C WITH(NOLOCK)

WHERE (C.status & 0x1000) = 0x1000 /*CV_STATUS_PERSONAL_WKSTN*/

		AND id NOT IN (

						SELECT entityId 

						FROM APP_AdvanceSettings WITH(NOLOCK) 

WHERE entityType = 3/*CLIENT_ENTITY*/ AND keyName = 'Region Id' AND enabled = 1 AND deleted = 0

					 )

		OPEN clients_cursor  

		FETCH NEXT FROM clients_cursor   

		INTO @clientId

		WHILE @@FETCH_STATUS = 0  

		BEGIN

			DELETE @clientZones

 			----- Region BEGIN ------------------------------------------------------------------------------------------------------------------

 			IF EXISTS (SELECT 1 FROM APP_ClientProp WITH(READUNCOMMITTED) WHERE attrName = 'Client Geo Location' AND componentNameId = @clientId AND modified = 0)

			BEGIN

				-- GET CLIENT'S GEO LOCATION

 				SELECT

 					@cLocation = attrVal

 				FROM APP_ClientProp WITH(READUNCOMMITTED)

 				WHERE attrName = 'Client Geo Location' AND componentNameId = @clientId AND modified = 0

 					AND modified = 0

 				SET @cLat =		@cLocation.value('(.//@latitude)[1]', 'float')

 				SET @cLong =	@cLocation.value('(.//@longitude)[1]', 'float')

				SET @cCountry =	@cLocation.value('(.//@country)[1]', 'NVARCHAR(255)')

				SET @cState =	@cLocation.value('(/App_GeoLocation/detailedlocationInfo/state/@name)[1]', 'NVARCHAR(255)')

 				-- FILTER BY COUTRY AND CONTINENT
				INSERT INTO @clientZones (zoneId, lat, long)


				SELECT id, latitude, longitude

					FROM App_Zone WITH(READUNCOMMITTED) WHERE country = @cCountry

				IF EXISTS (SELECT 1 FROM @clientZones)

				BEGIN

					-- FILTER BY STATE

					IF EXISTS (SELECT 1 FROM App_Zone WITH(READUNCOMMITTED) WHERE state = @cState AND country = @cCountry)

						DELETE cz

						FROM @clientZones cz

							JOIN App_Zone z ON z.id = cz.zoneId

							WHERE z.state <> @cState

					-- REMOVE ZONES WHICH ARE NOT PART OF ANY REGION

					DELETE

					FROM @clientZones

						WHERE zoneId NOT IN (SELECT zoneRegionId FROM App_RegionZoneAssoc WITH(READUNCOMMITTED) WHERE isRegion = 0)

					IF EXISTS (SELECT 1 FROM @clientZones)

					BEGIN

						-- CALCULATE CLOSEST REGION BASED ON GEO LOCATION

						UPDATE @clientZones

							SET distance = dbo.APPComputeGeoDistance(@cLat, @cLong, lat, long, default)

						-- GET THE ID OF THE CLOSEST REGION

 						SET @regionId = (SELECT TOP 1 rz.regionId

											FROM APP_RegionZoneAssoc rz WITH(READUNCOMMITTED)

												JOIN App_Region r WITH(READUNCOMMITTED) ON r.id = rz.regionId

												JOIN @clientZones z ON z.zoneId = rz.zoneRegionId AND rz.isRegion = 0

											WHERE z.distance = (SELECT MIN(distance) FROM @clientZones)

										)

					-- TAG THE REGION TO THE CLIENT

					IF @regionId > 0 AND @regionId IS NOT NULL

					BEGIN

						SET @regionStr = CAST(@regionId AS NVARCHAR(16))

EXEC AppSetAdditionalSettingsForEntity @clientId, 3, 'Region Id', 'CommServDB.Client', 'INTEGER',

							@regionStr, 1 /*hidden*/, '<App_AdvanceSettingProps comment="Added as part of upgrade script"/>'

					END

					END

				END

			END

			FETCH NEXT FROM clients_cursor INTO @clientId

		END

		CLOSE clients_cursor;  

		DEALLOCATE clients_cursor;	
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


			VALUES('8D67ADAF-1EA7-4D19-96F3-37DB83FF0420', 'Set region property for clients', 

'Sets region property for laptop clients if not already present.', @curUtcDateTime, 16, 0 , (16))

	COMMIT TRAN

	END TRY

	BEGIN CATCH

		PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

			ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

			PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '

			ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

			ERROR MESSAGE: ' + ERROR_MESSAGE() + '

			ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

			ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		--Close cursor

		IF ( CURSOR_STATUS('global', 'clients_cursor') >= 0  /* cursor is open */ 

			OR CURSOR_STATUS('local', 'clients_cursor') >= 0 ) 

		CLOSE clients_cursor 

		IF ( CURSOR_STATUS('global','clients_cursor') = -1  /* cursor is closed */ 

			OR CURSOR_STATUS('local','clients_cursor') = -1 ) 

		DEALLOCATE clients_cursor 

		-- Rollback any active or uncommittable transactions before

		-- inserting information in the ErrorLog

		IF XACT_STATE() <> 0

		BEGIN

			ROLLBACK TRANSACTION;

		END

	END CATCH;

END

--

-- ADD ADDITIONAL SETTINGS AND HIDE THE SETTING IF NOT PRESENT

MERGE APP_AdvanceSettingsEx addSetEx

USING (SELECT Adv.id from APP_AdvanceSettings Adv WITH(NOLOCK)

		LEFT JOIN APP_AdvanceSettingsEx AvEx WITH(NOLOCK) ON Adv.id = AvEx.keyId

WHERE Adv.Keyname='Region Id' AND Adv.deleted = 0 AND Adv.enabled = 1 AND AvEx.keyId IS NULL

	  ) AS dest

ON dest.id = addSetEx.keyId

WHEN NOT MATCHED THEN INSERT VALUES(dest.id,'<App_AdvanceSettingProps comment="Added as part of upgrade script"/>', 1/*hidden*/);

-- SET REGION PROPERTY FOR LAPTOP CLIENTS ------------------------------------------------------------------------------------------------------------------------------------

SET @guid = 'E8A30ED8-60D6-4839-8CDB-AB15F8CD8E72'

SET @globalParamPlanUpdateExec = 0

SELECT @globalParamPlanUpdateExec = 1

FROM

    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

    gp.SqlScriptGUID = @guid

IF @globalParamPlanUpdateExec = 0

BEGIN

	--Request from Arun, Remove all solr* keys from DB

	DELETE FROM APP_AdvanceSettings 

	WHERE keyname like 'solr.%' AND keyName NOT IN ('solr.extract.ifGeneratePreview','solr.extract.DQConfigForContentChain')
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@guid, 'CleanUpSolrKeys', 'Fix App_AdvanceSettings Entries', @curUtcDateTime, 16, 0 , (16 + 2))

END

SET @guid = 'B33B88F1-31F5-4CF3-8973-DF8FFEC24C58'

SET @globalParamPlanUpdateExec = 0

SELECT @globalParamPlanUpdateExec = 1

FROM

    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

    gp.SqlScriptGUID = @guid

IF @globalParamPlanUpdateExec = 0

BEGIN

	--Request from Parag

	DELETE FROM APP_AdvanceSettings 

	WHERE keyName = 'nKeepAliveInterval' AND relativePath = 'CVD' AND value like '30'

	DELETE FROM APP_AdvanceSettings 

	WHERE keyName = 'nKeep_Alive' AND relativePath = 'Firewall' AND value like '*%*' -- any value inside * *
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@guid, 'CleanUpSolrKeys', 'Fix App_AdvanceSettings additional Entries', @curUtcDateTime, 16, 0 , (16 + 2))

END

-- Delete all rows for pre SP12 configured CCS Clients, CCS is only valid on SP12+ configurations.

DECLARE @ccsCurrentTime INTEGER = (SELECT DATEDIFF(s, CONVERT(DATETIME, '1970-01-01'), GETUTCDATE()))

DECLARE @CleanupCCS_SP12_Clients VARCHAR(512) = 'B2C1D6CB-5525-4D98-89EA-9421871B3411'

IF NOT EXISTS (SELECT TOP 1 1 FROM GXUniqueSQLScriptExecTracking WITH (NOLOCK) WHERE SqlScriptGUID = @CleanupCCS_SP12_Clients)

BEGIN

	-- Note this works for pre SP12 Configured CCS Clients since it runs after APP_ClientProp.script

	-- that delete pre SP12 'CCS Enabled' property rows for clients configured.

	DELETE s

	FROM APP_AdvanceSettings s

		LEFT OUTER JOIN APP_ClientProp cp WITH(NOLOCK) ON

			cp.componentNameId = s.entityId

			AND s.entityType = 3

			AND cp.modified = 0

			AND cp.attrName = N'CCS Enabled'

	WHERE

		cp.id IS NULL

		AND s.keyName = N'sCCSDbStatus'
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@CleanupCCS_SP12_Clients, 'Delete CCS Clients pres SP12 Release APP_AdvanceSettings', 'Delete pre SP12 CCS Clients', @ccsCurrentTime, 16, 0, (16 + 2))

END

DELETE 	FROM APP_AdvanceSettings

WHERE  	entityId = 2 AND entityType = 3

		AND keyName IN ('DefaultEncryptionForNewCopies', 'DefaultKeyProviderForNewCopies') AND relativePath = 'CommServDB.GxGlobalParam' 

DELETE FROM APP_AdvanceKeyInfo 

WHERE keyName IN ('DefaultEncryptionForNewCopies', 'DefaultKeyProviderForNewCopies') AND relativePath = 'CommServDB.GxGlobalParam' 

/* 

                When originally implemented, the setting name has spell mistake 

                If any customer or setup already has it, correct it from here..

				Do rename only if setting with new name not already exist, otherwise we will end up having duplicate rows in customer like BAE

*/

IF EXISTS (SELECT TOP 1 Id FROM APP_AdvanceSettings (NOLOCK) WHERE keyname = 'EnableSecurityFilterOptmization') AND NOT EXISTS (SELECT TOP 1 Id FROM APP_AdvanceSettings (NOLOCK) WHERE keyname = 'EnableSecurityFilterOptimization')

BEGIN

                UPDATE APP_AdvanceSettings

                SET keyname = 'EnableSecurityFilterOptimization'

                WHERE keyname = 'EnableSecurityFilterOptmization'

END

IF EXISTS (SELECT TOP 1 Id FROM APP_AdvanceSettings (NOLOCK) WHERE keyname = 'EnableNegatedSecurityFilterOptmization') AND NOT EXISTS (SELECT TOP 1 Id FROM APP_AdvanceSettings (NOLOCK) WHERE keyname = 'EnableNegatedSecurityFilterOptimization')

BEGIN

                UPDATE APP_AdvanceSettings

                SET keyname = 'EnableNegatedSecurityFilterOptimization'

                WHERE keyname = 'EnableNegatedSecurityFilterOptmization'

END

DECLARE @sp16guid uniqueidentifier = '0C8B4E96-F383-49A8-B71C-AFE6F63A6BBA'

DECLARE @sp16curUtcDateTime BIGINT = datediff(second, '01/01/1970', GetUTCdate())   

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @sp16guid)

BEGIN

	DECLARE @createTime INTEGER = dbo.GetUnixTime(GetUTCDate())

	DECLARE @clientIdTable TABLE (id INTEGER)

	-- Pick clientid for WORK_TOKEN_REGISTRY_OPERATION
	INSERT INTO @clientIdTable


	SELECT entityId FROM APP_AdvanceSettings WITH(NOLOCK) WHERE entityType = 3 AND keyName = 'nnumPipelinebuffers'COLLATE Latin1_General_CS_AS 

	-- Marking delete = 1 at clients and clientgroup level for misspelled registry key "nnumPipelinebuffers" instead of "nNumPipelineBuffers" 

	UPDATE APP_AdvanceSettings

                SET deleted = 1

                WHERE keyname = 'nnumPipelinebuffers' COLLATE Latin1_General_CS_AS 

	--WORK_TOKEN_REGISTRY_OPERATION, Pushing work-queue tokens for clientId from @clientIdTable table.
	INSERT INTO APP_WorkQueueRequest(clientId,remoteClient,workToken,workTokenParams,createTime,lastUpdateTime,retryCount,flag)


	SELECT DISTINCT C.id, -1,6,'',@createTime,0,0,0 

	FROM @clientIdTable C

	INNER JOIN APP_Client client WITH(NOLOCK) ON client.id = C.id
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@sp16guid, 'SP16 registry cleanup', 'SP16 registry cleanup', @sp16curUtcDateTime, 16, 0, (16 + 2))

END

/**

-- As per Amey's feedbacks, commenting below block of registry clean up codes.

-- As removing keys directly from DB may cause issues in client side cache and changes will be over written.  

-- SP16: Registry clean up exercise based on survey report and Parag/Amey's feedbacks

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @sp16guid)

BEGIN

		Delete FROM APP_AdvanceSettings where keyName IN ('EnableFSQuotaManagement','bEnableFSQuotaManagementGUI','NKEEPALIVEINTERVAL','nAllowOlderClients','sCASServerName',

															'MOVE_MEDIUM','RESERVE','REWIND','SPACE','dEVLOGDIR'

															)

		Delete FROM APP_AdvanceSettings where keyName IN ('nnumPipelinebuffers') AND relativePath NOT IN ('Cvd')

		Delete from APP_AdvanceSettings Where keyname IN ('nDISABLE_CVFWD') and value LIKE N'0'

		Delete from APP_AdvanceSettings Where keyname IN ('nIgnoreNonExistentDB') and value LIKE N'1'

		Delete from APP_AdvanceSettings Where keyname IN ('DataMoverUseLookAheadLinkReader') and value LIKE N'1'
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@sp16guid, 'SP16 registry cleanup', 'SP16 registry cleanup', @sp16curUtcDateTime, 16, 0, (16 + 2))

END

**/

/**

-- As per Amey's feedbacks, commenting below block of registry clean up codes.

-- As removing keys directly from DB may cause issues in client side cache and changes will be over written.  

SET @sp16guid = '1D39134F-4CA2-4F8C-9D69-CC830832ACE9'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @sp16guid)

BEGIN

-- Pavan Bedadala confirmed that these can be deleted

		Delete FROM APP_AdvanceSettings where keyName IN ('bEnableVSASnapSynthFull','bJMAllowIncrWithSynthFull')
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@sp16guid, 'SP16 registry cleanup 2', 'SP16 registry cleanup 2', @sp16curUtcDateTime, 16, 0, (16 + 2))

END

**/

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = '719d67a6-1ecc-4084-9fb3-8e1847cc3f72')

BEGIN

	IF EXISTS ( SELECT TOP 1 Id FROM APP_AdvanceSettings (NOLOCK) WHERE keyname = 'EnableOrphanChunkListing')

	BEGIN

		UPDATE APP_AdvanceSettings 

		SET value = '6' 

		WHERE keyName = 'EnableOrphanChunkListing'

	END
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


			VALUES('719d67a6-1ecc-4084-9fb3-8e1847cc3f72', 'EnableOrphanChunkListing', 

'Enable orphan chunk list pruning by default', @curUtcDateTime, 16, 0 , (16 + 2))

END

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = 'b3f8e8e8-4e1b-4f17-b649-32b31fc6e612')

BEGIN

	IF EXISTS ( SELECT TOP 1 Id FROM APP_AdvanceSettings (NOLOCK) WHERE keyname = 'MMPruneProcessIntervalMin')

	BEGIN

		DECLARE @value INT = 0

		SELECT @value = CONVERT(INT, CONVERT(NVARCHAR(20), value)) 

		FROM APP_AdvanceSettings WHERE keyname = 'MMPruneProcessIntervalMin'

		UPDATE MMConfigs

SET value = (CASE WHEN @value >= 10 THEN @value ELSE 10 END)

		WHERE name = 'MM_CONFIG_PRUNE_PROCESS_INTERVAL_MINS'

		DELETE FROM APP_AdvanceSettings WHERE keyname = 'MMPruneProcessIntervalMin'

	END
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


			VALUES('b3f8e8e8-4e1b-4f17-b649-32b31fc6e612', 'MigratePruneProcessIntervalMin', 

'Migrate PruneProcessInterval to MMConfigs', @curUtcDateTime, 16, 0 , (16 + 2))

END

/***************************** Remove MMPruneProcessIntervalMin From Dictionary ***************************************/

DELETE FROM APP_AdvanceKeyInfo 

WHERE keyName = 'MMPruneProcessIntervalMin' AND relativePath = 'MediaManager'

DECLARE @CCSDbGUID UNIQUEIDENTIFIER  = '1B500941-04BA-4664-91EE-5DFA8C0DEE92'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @CCSDbGUID)

BEGIN

	-- Hide the sCCSDbStatus key name
	INSERT INTO APP_AdvanceSettingsEx (keyId, details, hidden)


		SELECT

			 a.id keyId,

			 N'' details,

			 1 hidden

		FROM APP_AdvanceSettings a

			LEFT OUTER JOIN APP_AdvanceSettingsEx x on

				a.id = x.keyId

		WHERE

			a.keyName = N'sCCSDbStatus'

			AND x.keyId IS NULL
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@CCSDbGUID, 'HidesCCSDbStatusKeyname', 'Hide sCCSDbStatus Keyname from being displayed in GUI', @curUtcDateTime, 16, 0 , (16 + 2))

END

DECLARE @sp17guid uniqueidentifier = '83643EAD-89EE-4B0F-9D40-A58BE887D429'

DECLARE @sp17curUtcDateTime BIGINT = datediff(second, '01/01/1970', GetUTCdate())  

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @sp17guid)

BEGIN

	-- Pavan Bedadala confirmed that below keys needs to be deleted.

	-- Marking delete = 1 at clients and clientgroup level for registry keys in ('bEnableFSSnapSyntheticFull', 'bEnableFSQuotaManagementGUI', 'EnableFSQuotaManagement', 'EnableFSEndUserErase', 'nINDEXCACHE_MIN', 'nINDEXCACHE_MAX') for eventual sync between CS DB and client's registry.

	UPDATE APP_AdvanceSettings

                SET deleted = 1

                WHERE keyname IN ('bEnableFSSnapSyntheticFull', 'bEnableFSQuotaManagementGUI', 'EnableFSQuotaManagement', 'EnableFSEndUserErase', 'nINDEXCACHE_MIN', 'nINDEXCACHE_MAX')
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@sp17guid, 'SP17 registry cleanup', 'SP17 registry cleanup', @sp17curUtcDateTime, 16, 0, (16 + 2))

END

DELETE FROM APP_AdvanceKeyInfo 

WHERE keyName = 'EnableStoragePool' AND relativePath = 'CommServDB.GxGlobalParam'

DELETE FROM APP_AdvanceSettings 

WHERE keyName = 'EnableStoragePool' AND relativePath = 'CommServDB.GxGlobalParam'

update APP_AdvanceSettings set deleted=1,enabled=0 where keyName='customreportengineurl_UNTIL'

--Automatically enable Run Analytics job option only if there were analytics job ran previously

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = '0E15A6F0-3336-4A3E-968E-982E25C59DAB')

BEGIN

	IF EXISTS (SELECT TOP 1 1 FROM archFLAIndexingInfo (NOLOCK))

	BEGIN

		IF NOT EXISTS (SELECT 1 FROM APP_AdvanceSettings WHERE keyName = 'bEnableDataAnalyticsForClient' AND entityId =2)

		BEGIN
			INSERT INTO APP_AdvanceSettings (entityId,keyName,type,relativePath,value, enabled,deleted,entityType,sourceId,sourceEntityType)


VALUES(2 /*CommCell*/, 'bEnableDataAnalyticsForClient', N'BOOLEAN','CommServDB.Console','true', 1, 0, 3, 0, 0 )
			INSERT INTO APP_AdvanceSettingsEx (keyId, details, hidden)


			SELECT

				 a.id keyId,

				 N'' details,

				 1 hidden

			FROM APP_AdvanceSettings a

				LEFT OUTER JOIN APP_AdvanceSettingsEx x on

					a.id = x.keyId

			WHERE

				a.keyName = N'bEnableDataAnalyticsForClient'

				AND x.keyId IS NULL

		END

	END
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


			VALUES('0E15A6F0-3336-4A3E-968E-982E25C59DAB', 'AutoEnableAnalyticsJobOption', 

'Auto Enable analytics job option at client or client group level', @curUtcDateTime, 16, 0 , (16 + 2))

END
