SET NOCOUNT ON
GO
SET QUOTED_IDENTIFIER ON 
GO

---------------------------------
--------------------------------------------------------
-- upgrade of APP_Application table for oracle sap client (apptypeId = 61)
-- There will be two command line subclients subclientStatus 64 and 4096
--------------------------------------------------------
DECLARE @clientId int , @appTypeId int ,@instance int,@backupSet int,@appNumber int,@dataArchGrpID smallint,@logArchGrpID smallint,@refTime int,@modified int,
			@LogsubclientName nvarchar(128),@LogsubclientStatus int,@ccpId int,@ccpTime int,@created   integer
SET @LogsubclientName = '(Logcommand line)'
SET @LogsubclientStatus = 4096
DECLARE AppApplicationCursor CURSOR STATIC FOR
   SELECT clientId,appTypeId,instance,backupSet,appNumber,dataArchGrpID,
		logArchGrpID,refTime,modified,ccpId,ccpTime
   FROM APP_Application where appTypeId = 61 and (subclientStatus & 64) > 0 order by id -- get all commandLine subclient
BEGIN TRY
	OPEN AppApplicationCursor
	FETCH NEXT FROM AppApplicationCursor INTO @clientId,@appTypeId,@instance,@backupSet,@appNumber,@dataArchGrpID,
		@logArchGrpID,@refTime,@modified,@ccpId,@ccpTime
    WHILE @@FETCH_STATUS = 0
	BEGIN
		-- subclient id is a serial to APP_Application - insert a logcommandline for commanline subclient
	    INSERT APP_Application(clientId,appTypeId,instance,backupSet,appNumber,dataArchGrpID,logArchGrpID,refTime,modified,subclientName,subclientStatus,ccpId,ccpTime)
			VALUES(@clientId,@appTypeId,@instance,@backupSet,@appNumber,@dataArchGrpID,@logArchGrpID,@refTime,@modified,@LogsubclientName,@LogsubclientStatus,@ccpId,@ccpTime)
		FETCH NEXT FROM AppApplicationCursor INTO @clientId,@appTypeId,@instance,@backupSet,@appNumber,@dataArchGrpID,
		@logArchGrpID,@refTime,@modified,@ccpId,@ccpTime
	END
    CLOSE       AppApplicationCursor
    DEALLOCATE  AppApplicationCursor
END TRY
BEGIN CATCH
      select 'Cannot Process APP_Application for adding a new log subclient' +ERROR_MESSAGE()
END CATCH
---------------------------------------------------------
-- Get commandline log subclient Id generated in APP_Application
---------------------------------------------------------
-- We can have many combinations for 
DECLARE cmdLogSubClientIdCursor CURSOR STATIC FOR SELECT id from APP_Application where appTypeId = 61 and (subclientStatus & 4096) > 0 and subclientName = '(Logcommand line)' order by id
DECLARE cmdSubClientIdCursor CURSOR STATIC FOR SELECT id from APP_Application where appTypeId = 61 and (subclientStatus & 64) > 0 and subclientName = '(command line)' order by id
DECLARE @CmdLogSubClientId int, @CmdflagSubClientId int
DECLARE @cur_status int
BEGIN TRY
	OPEN cmdLogSubClientIdCursor -- all logcommanline subclient
	OPEN cmdSubClientIdCursor	-- all commandline subclient
	FETCH NEXT FROM cmdSubClientIdCursor INTO @CmdflagSubClientId 
	set @cur_status = @@FETCH_STATUS	-- status for logcommandline cursor
	FETCH NEXT FROM cmdLogSubClientIdCursor INTO @CmdLogSubClientId
	set @cur_status = @cur_status + @@FETCH_STATUS -- status for commandline cursor
	WHILE @cur_status = 0 -- status should be zero
	BEGIN 
		-- push properties in APP_ScFilterFile,APP_SubClientProp,
		-- archpipeconfig tables for logcommandline corresponding commandline
		------------------------------------------------------------------
		-- Upgrade APP_ScFilterFile for command line subclients
		------------------------------------------------------------------
		DECLARE @type int,@fileName nvarchar(1024)
		DECLARE ScFilterFileCursor CURSOR STATIC FOR
		SELECT type,fileName,created,modified,ccpId from APP_ScFilterFile 
		where componentNameId = @CmdflagSubClientId -- get property for commanline 
		BEGIN TRY
			OPEN ScFilterFileCursor
			FETCH NEXT FROM ScFilterFileCursor INTO @type,@fileName,@created,@modified,@ccpId
			WHILE @@FETCH_STATUS = 0
			BEGIN -- insert for logcommandline subclient
				INSERT APP_ScFilterFile(componentNameId,type,fileName,created,modified,ccpId)
				VALUES(@CmdLogSubClientId,@type,@fileName,@created,@modified,@ccpId)
				FETCH NEXT FROM ScFilterFileCursor INTO @type,@fileName,@created,@modified,@ccpId
			END
			CLOSE       ScFilterFileCursor
			DEALLOCATE  ScFilterFileCursor
		END TRY
		BEGIN CATCH
			select 'Cannot Process APP_ScFilterFile for adding a new log command line subclient' +ERROR_MESSAGE()
		END CATCH
		------------------------------------------------------------------
		-- Upgrade APP_SubClientProp for command line subclients
		------------------------------------------------------------------
		DECLARE @attrName nvarchar(1024),@attrType int,@attrVal nvarchar(MAX)
		DECLARE SubClientPropCursor CURSOR STATIC FOR
		SELECT attrName,attrType,attrVal,created,modified,ccpId from APP_SubClientProp 
		where componentNameId = @CmdflagSubClientId --get property for commandline
		BEGIN TRY
			open SubClientPropCursor
			FETCH NEXT FROM SubClientPropCursor INTO @attrName,@attrType,@attrVal,@created,@modified,@ccpId
			WHILE @@FETCH_STATUS = 0
			BEGIN -- insert property for logcommandline subclient
				INSERT APP_SubClientProp(componentNameId,attrName,attrType,attrVal,created,modified,ccpId)
				VALUES(@CmdLogSubClientId,@attrName,@attrType,@attrVal,@created,@modified,@ccpId)
		
				FETCH NEXT FROM SubClientPropCursor INTO @attrName,@attrType,@attrVal,@created,@modified,@ccpId	
			END
			CLOSE       SubClientPropCursor
			DEALLOCATE  SubClientPropCursor
		END TRY
		BEGIN CATCH
			select 'Cannot Process APP_SubClientProp for adding a new log command line subclient' +ERROR_MESSAGE()
		END CATCH
		------------------------------------------------------------------
		-- Upgrade archpipeconfig for command line subclients
		------------------------------------------------------------------
		DECLARE @compressWhere tinyint,@numNWAgents tinyint,@NWWriteSpeed int
	
		DECLARE archpipeconfigCursor CURSOR STATIC FOR
		SELECT compressWhere,numNWAgents,NWWriteSpeed from archpipeconfig 
		where appNumber = @CmdflagSubClientId -- get property for commanline subclient
	
		BEGIN TRY
			open archpipeconfigCursor
			FETCH NEXT FROM archpipeconfigCursor INTO @compressWhere,@numNWAgents,@NWWriteSpeed
			WHILE @@FETCH_STATUS = 0
			BEGIN -- insert property for logcommandline subclient
				INSERT archpipeconfig(appNumber,compressWhere,numNWAgents,NWWriteSpeed) 
				VALUES(@CmdLogSubClientId,@compressWhere,@numNWAgents,@NWWriteSpeed)
			
				FETCH NEXT FROM archpipeconfigCursor INTO @compressWhere,@numNWAgents,@NWWriteSpeed	
			END
			CLOSE       archpipeconfigCursor
			DEALLOCATE  archpipeconfigCursor
		END TRY
		BEGIN CATCH
			select 'Cannot Process archpipeconfig for adding a new log command line subclient' +ERROR_MESSAGE()
		END CATCH
	
		FETCH NEXT FROM cmdSubClientIdCursor INTO @CmdflagSubClientId 
		set @cur_status = @@FETCH_STATUS
		FETCH NEXT FROM cmdLogSubClientIdCursor INTO @CmdLogSubClientId
		set @cur_status = @cur_status + @@FETCH_STATUS
	END
	CLOSE cmdLogSubClientIdCursor
	DEALLOCATE cmdLogSubClientIdCursor
	CLOSE cmdSubClientIdCursor
	DEALLOCATE cmdSubClientIdCursor
END TRY
BEGIN CATCH
		SELECT 'Can not process Upgrade for subclient id [LogCmdSubclientId:' + @CmdLogSubClientId + ' CmdSubClientId:'+ @CmdflagSubClientId + ']' + ERROR_MESSAGE()
END CATCH

