




--------------------------------------------------------------
-- DEFECT 96545 "FAN-IN FOR CDR" (7.0 via update form 2073) --
--------------------------------------------------------------
set nocount off

DECLARE @CDR int
DECLARE @DEFAULT_BIT int

set @CDR         = 84
set @DEFAULT_BIT = 8

Update app_application
SET subClientStatus = subClientStatus | @DEFAULT_BIT
where appTypeId=@CDR and subClientName = 'default'

UPDATE app_backupSetName
SET status = status | @DEFAULT_BIT
where  name = 'defaultBackupSet'
  AND id in (select DISTINCT backupSet from app_application where appTypeId=@CDR)

GO


-------------------------------------------
-- SysStateForSysStateSubClient 		---
-- 17-Aug-2007  -Skatz					---
-- Set "System State" prop for "System  ---
-- State Subclients (upgraded)          ---
--                                      ---
-- Can be run multiple times w/o issue  ---
--                                      ---
-- Defect 98276							---
-------------------------------------------
  
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO

set nocount on
DECLARE @subClientId int
DECLARE @nowTime   integer
DECLARE @created   integer
SET    @nowTime     =   dbo.GetUnixTime (GetUTCdate())

DECLARE @SystemStateSubclient  nvarchar(80)
DECLARE @SystemState           nvarchar(80)
SET     @systemStateSubClient = 'System State SubClient'
SET     @SystemState          = 'System State'



----------------------------------------------------------------------------------------   
--  THIS MAKES SURE "SYSTEM STATE" IS SET FOR EVERY SYSTEM STATE SUBCLIENT (FROM 6.1) --
----------------------------------------------------------------------------------------
-- "SYSTEM STATE" DOESN'T EXIST, HAVE TO ADD IT --
--------------------------------------------------

DECLARE subClientsForSystemStateCursor CURSOR STATIC FOR
   SELECT Distinct componentNameID, created
   FROM app_subClientProp
   WHERE attrName = @SystemStateSubClient AND modified=0
BEGIN TRY
	OPEN subClientsForSystemStateCursor
	FETCH NEXT FROM subClientsForSystemStateCursor INTO @subClientId , @created
    WHILE @@FETCH_STATUS = 0
	BEGIN
	    IF NOT exists (Select * from app_subClientprop where componentNameId = @subClientId and attrName = @SystemState AND modified = 0)
			INSERT app_subClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
				VALUES(@subClientId, @SystemState, 2, '1', @created, 0)
		
		FETCH NEXT FROM subClientsForSystemStateCursor INTO @subClientId, @created
	END
    CLOSE       subClientsForSystemStateCursor
    DEALLOCATE  subClientsForSystemStateCursor
END TRY
BEGIN CATCH
      select 'Cannot Process Set System State Prop for System State SubClient' +ERROR_MESSAGE()
END CATCH

------------------------------- END SysStateForSysStateSubClient  ----------------------------------



-------------------------------------------
-- SetMSSqlVDItimeout			        ---
-- 20-Aug-2007  -Skatz                  ---
-- Set VDI Timeout for MSSQL Instances  ---
-- .. if not already set. Default = 300 ---
--                                      ---
-- Defect: 98284                        ---
--                                      ---
-- Can be run multiple times w/o issue  ---
-------------------------------------------


--use commserv

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO

--SET QUOTED_IDENTIFIER OFF

DECLARE @instanceId            int
DECLARE @created			   int
DECLARE @CV_MSSQL_VDI_TIMEOUT  nvarchar(80)
DECLARE @SC_STATUS_BITS        int

SET  @CV_MSSQL_VDI_TIMEOUT        = 'MSSQL VDI Timeout'
SET  @SC_STATUS_BITS              =  4					-- CV_STATUS_DELETED
SET  @created = 0

DECLARE instanceForSQLCursor CURSOR STATIC FOR
  select distinct instance from app_application where appTypeId = 81 AND (subClientStatus & @SC_STATUS_BITS) = 0

BEGIN TRY
    OPEN instanceForSQLCursor
    FETCH NEXT FROM instanceForSQLCursor INTO @instanceId
    WHILE @@FETCH_STATUS = 0
    BEGIN
	-- DO THE WORK --
	    IF NOT EXISTS (SELECT * FROM App_InstanceProp Where  componentNameId = @instanceId AND attrName = @CV_MSSQL_VDI_TIMEOUT AND modified = 0)
		BEGIN
			SET @created = (select min(refTime)  FROM app_application where appTypeId = 81 AND instance = @instanceId AND (subClientStatus & @SC_STATUS_BITS) = 0)
			INSERT App_InstanceProp(componentNameId, attrName, attrType, attrVal, created, modified)
					VALUES(@instanceId, @CV_MSSQL_VDI_TIMEOUT, 2, '300', @created, 0)
		END

       FETCH NEXT FROM instanceForSQLCursor INTO @instanceId
    END
    CLOSE       instanceForSQLCursor
    DEALLOCATE  instanceForSQLCursor
END TRY
BEGIN CATCH
      select 'Cannot Process Set VDI Timeout for SQL Instances' +ERROR_MESSAGE()
END CATCH

--	   select * from app_instanceProp where attrName like '%VDI%'

------------------------------- END SetMSSqlVDItimeout ----------------------------------

---------- Drop the ExportHistory table during the upgrade. Missed during upgrade from 6.1 to 7.0 ------------
---------- MR# 101530, TR# TR 1-251240 -----------------------------------------------------------------------

IF EXISTS (select * from sysobjects WHERE type = 'u' AND name = 'ExportHistory')
	drop table ExportHistory


--NAS ACL OPTIONS



declare @defBkpValue int
declare @defRstValue int
set @defBkpValue = 6
set @defRstValue = 191


--insert the default nas option for schedule coming from generic schedule policy 

insert into SchedBackupTaskOptions select id ,'NasOptions',@defBkpValue  
from schedbackuptask
where scheduleId in (
select id from schedule where schedTemplateInstanceId
in ( select id from schedTemplateInstance where schedTemplateId in ( select id from schedTemplate where type & 8 = 8 )))


--Insert the default nas option for backup schedule for apptype NAS(13)
insert into SchedBackupTaskOptions select id ,'NasOptions',@defBkpValue from schedbackuptask where schedbackuptask.apptypeId = 13 and NOT EXISTS( select * from schedbackuptaskoptions where name = 'nasOptions' and 
schedbackuptask.id = schedbackuptaskoptions.backuptaskid)


--Insert the default nas option for restore schedule for apptype NAS(13)
insert into SchedRestoreTaskOptions select id ,'NAS_RESTORE_OPTIONS',@defRstValue from schedrestoretask where schedrestoretask.apptypeId = 13 and NOT EXISTS( select * from SchedRestoreTaskOptions where name = 'NAS_RESTORE_OPTIONS' and 
schedrestoretask.id = SchedRestoreTaskOptions.restoretaskid)





-- OBSOLETE QSNAP Option (for 7.0 and later clients only!  --

DECLARE @errCode int
DECLARE @errString nvarchar(2048)

exec appIdaUpgrade_NoUseQSnap 0, 12, @errCode, @errString


--delete Celerra from patchInfo during upgrade: Proxy File Share Archiver (appType 1081)
--any agents without packages SHOULD NOT create rows in the patchInfo table
DELETE patchInfo WHERE apptypeId = 1081

-- Set manualRetentionEndTime to infinite if manual retention flag is set and manualRetentionEndTime is not set
UPDATE JMJobDataStats 
SET manualRetentionEndTime = -1 
WHERE disabled & 2 = 2 
AND manualRetentionEndTime = 0

--upgrade the datalink entries
exec JMDataLinkUpgrade


-- Update version of SQL IDA it is installed on the CS itself.
UPDATE LICUSAGE SET ReleaseId = (SELECT ReleaseId FROM app_client where id=2)
WHERE cid=2 AND lictype=9


-- Update patch related entries to disable use of unix share and corresponding clients
UPDATE GXGlobalParam SET value='0' WHERE name='Patch Unix Share Flag'
UPDATE App_ClientProp SET attrVal='1' WHERE attrName='Patch Location flag'

--Update app manager thread
update gxglobalparam set value = '15' where name = 'AppMgrMaxThreadCount'
update gxglobalparam set value = '10' where name = 'AppMgrInitThreadCount'
update gxglobalparam set value = '5' where name = 'AppMgrMinThreadCount'


-- Update GxCounter table for the MPID -- See MR 20527 for details.
IF EXISTS (SELECT * FROM GXCounter WHERE name = 'MPID_Counter')
BEGIN
	UPDATE GXCounter
	SET next_l = (SELECT MAX(mountpathId) FROM MMMountPath) + 1
	WHERE name = 'MPID_Counter'
END
ELSE
BEGIN
	INSERT INTO GXCounter VALUES ('MPID_Counter', 0, (SELECT MAX(mountpathId) FROM MMMountPath) + 1)
END

-- For SDR
IF EXISTS (SELECT * FROM MMLibrary where (ExtendedAttributes & 65536) > 0)
BEGIN
	declare  @tblDevIds TABLE (devId int)
	declare  @srcClientIds TABLE (clientId int)
	declare  @bkSetIds TABLE (bkSet int)

	insert into @tblDevIds
	SELECT DISTINCT MPDS.DeviceId
	FROM MMMountPathToStorageDevice MPDS WITH (READUNCOMMITTED), MMMountPath MP WITH (READUNCOMMITTED), MMLibrary L WITH (READUNCOMMITTED)
	WHERE (L.ExtendedAttributes & 65536) > 0 AND MP.LibraryId = L.Libraryid
	AND MPDS.MountPathId = MP.MountPathId

	insert into @srcClientIds
	SELECT DISTINCT ClientId
	FROM MMDeviceController DEVC WITH (READUNCOMMITTED), @tblDevIds D
	WHERE DEVC.DeviceId = D.devId AND (DeviceAccessType & 2) > 0

	insert into @bkSetIds
	SELECT DISTINCT APP.backupSet
	FROM APP_Application APP WITH (READUNCOMMITTED), @srcClientIds SRC
	WHERE APP.clientId = SRC.clientId AND appTypeId = 84
	
	DECLARE @bsetId INT
DECLARE GetBset CURSOR FOR 
SELECT bkSet FROM @bkSetIds 
OPEN GetBset

FETCH GetBset INTO @bsetId 
WHILE @@FETCH_STATUS = 0
 BEGIN
	if exists (select * from app_backupsetprop where attrName = 'Flr Replication Options' and modified = 0 and componentnameId = @bsetId) 
	update app_backupsetprop
	SET attrVal = attrVal | 8192 | 65536
	WHERE componentNameId = @bsetId
	AND attrName = 'Flr Replication Options' and modified = 0
	ELSE
	insert into app_backupsetprop (componentNameId,attrName,attrType,attrVal,created,modified)
			values (@bsetId, 'Flr Replication Options', 7,  8192 | 65536 , dbo.getunixtime(GETUTCDATE()), 0)
	FETCH GetBset INTO @bsetId 
 END
CLOSE GetBset
DEALLOCATE GetBset	
END


--UPDATE schedule for new timezone

-- Update rows in [dbo].[schedule]
UPDATE [dbo].[schedule] SET [tz_name]='(GMT+04:00) Caucasus Standard Time' WHERE [tz_name]='(GMT+04:00) Yerevan'
UPDATE [dbo].[schedule] SET [tz_name]='(GMT) Monrovia, Reykjavik' WHERE [tz_name]='(GMT) Casablanca, Monrovia, Reykjavik'
UPDATE [dbo].[schedule] SET [tz_name]='(GMT-03:00) Georgetown' WHERE [tz_name]='(GMT-03:00) Buenos Aires, Georgetown'
UPDATE [dbo].[schedule] SET [tz_name]='(GMT-04:00) La Paz' WHERE [tz_name]='(GMT-04:00) Caracas, La Paz'
UPDATE [dbo].[schedule] SET [tz_name]='(GMT+05:00) Tashkent' WHERE [tz_name]='(GMT+05:00) Islamabad, Karachi, Tashkent'


-- SET WBA FULL BACKUP EXTENDED BIT OPTION

DECLARE @taskId INT
DECLARE @count INT
DECLARE @len INT
DECLARE @SET_POS INT
DECLARE @extendOpt VARCHAR(1024)
DECLARE @newExtendOpt VARCHAR(1024)
DECLARE GetIncrementalCur CURSOR
FOR SELECT id FROM SchedBackupTask WHERE type&1=1 AND appTypeId = 0 AND 
	scheduleId IN (SELECT id FROM schedule WHERE schedTemplateInstanceId <> 1)

SET @SET_POS = 46+1

OPEN GetIncrementalCur
FETCH NEXT FROM GetIncrementalCur INTO @taskId

WHILE @@FETCH_STATUS = 0
BEGIN
	SET @count = 0
	SET @newExtendOpt = ''
	SET @extendOpt = (SELECT value FROM SchedBackupTaskOptions WHERE backupTaskId=@taskId AND name='ExtendedOptions')

	SET @len = LEN(@extendOpt)

	IF (@len < @SET_POS) SET @len = @SET_POS

	WHILE (@count <= @len)
	BEGIN
		IF @count = @SET_POS
		BEGIN
			SET @newExtendOpt = @newExtendOpt + '1'
		END
		ELSE
		BEGIN
			IF @count <= LEN(@extendOpt)
				SET @newExtendOpt = @newExtendOpt + SUBSTRING(@extendOpt, @count, 1)
			ELSE
				SET @newExtendOpt = @newExtendOpt + '0'
		END

		SET @count = @count + 1
	END

	UPDATE SchedBackupTaskOptions SET value=@newExtendOpt WHERE backupTaskId=@taskId AND name='ExtendedOptions'

	FETCH NEXT FROM GetIncrementalCur INTO @taskId
END
CLOSE GetIncrementalCur
DEALLOCATE GetIncrementalCur


-- DEFECT 22048 -----------------
--  In 7.0, some upgrade of this table set gxdbversions but did NOT alter column definition, so fix here (for 8.0 & beyond).

DECLARE @intVal int
SET @intVal = ISNULL((
SELECT character_maximum_length from information_schema.columns
 where table_name = 'app_subClientProp' and column_name = 'attrVal'), 0)
 IF @intVal > 0
 	alter table app_subClientProp alter column attrVal nvarchar(MAX) not NulL
