-- Create a custom calendar with custom year start
SET QUOTED_IDENTIFIER OFF
SET NOCOUNT ON
GO

BEGIN
	BEGIN TRANSACTION
		DECLARE @CustomYearStartCopyTbl	TABLE
		(
			copyId			INTEGER,
			calendarId	INTEGER,
			yearStart		INTEGER
		)
		
		DECLARE	@errorCode	INTEGER
		SET 		@errorCode	= 0
		
		--Get all copies with custom yearStart
		INSERT INTO @CustomYearStartCopyTbl
		SELECT DISTINCT AGC.id, AGC.calendarId, AAR.yearStart
		FROM archGroupCopy AGC WITH (NOLOCK), archAgingRule AAR WITH (NOLOCK)
		WHERE	AGC.id = AAR.copyId
		AND		AAR.yearStart > 0
	
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT	
		
		--Reset custom yearStart if custom calendar is already set for those copies
		--Since we DO NOT allow custom calendar with custom yearStart 
		UPDATE 	@CustomYearStartCopyTbl
		SET yearStart = 0
		WHERE yearStart > 0
		AND		calendarId > 1

		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT	
		
		--Set custom calendar if it already exists for the custom yearStart
		--Reset custom yearStart if custom calendar is already available
		UPDATE 	@CustomYearStartCopyTbl
		SET T.calendarId = CC.id, T.yearStart = 0
		FROM @CustomYearStartCopyTbl T, APP_CustomCalendar CC WITH (NOLOCK)
		WHERE T.yearStart > 0
		AND		T.calendarId = 1
		AND		CC.beginMonth = T.yearStart + 1
		AND		CC.calType = 2
		
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT	
			
		INSERT INTO APP_CustomCalendar (name, beginYear, beginMonth, beginDate, noOfyears, isDefault, calType, createdTime, modifiedTime, origCCId)
		SELECT DISTINCT 'SYSTEM-CREATED-CUSTOM-YEAR-START-' + UPPER(DATENAME(MONTH, DATEADD(MONTH, (T.yearStart + 1), 0) - 1)), 1970, (T.yearStart + 1), 10382400, 0, 0, 2, dbo.getUnixTime(GETUTCDATE()), dbo.getUnixTime(GETUTCDATE()), 2
		FROM @CustomYearStartCopyTbl T
		WHERE T.yearStart > 0

		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT			

		--Set newly created custom calendar 
		--Reset custom yearStart 
		UPDATE 	@CustomYearStartCopyTbl
		SET T.calendarId = CC.id, T.yearStart = 0
		FROM @CustomYearStartCopyTbl T, APP_CustomCalendar CC WITH (NOLOCK)
		WHERE T.yearStart > 0
		AND		T.calendarId = 1
		AND		CC.beginMonth = T.yearStart + 1
		AND		CC.calType = 2
		
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT	
		
		UPDATE archGroupCopy
		SET calendarId = T.calendarId
		FROM archGroupCopy AGC, @CustomYearStartCopyTbl T
		WHERE AGC.id = T.copyId

		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT	

		UPDATE archAgingRule
		SET yearStart = T.yearStart
		FROM archAgingRule AAR, @CustomYearStartCopyTbl T
		WHERE AAR.copyId = T.copyId

		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT				
	END

CX_EXIT:	
	IF @errorCode <> 0
		ROLLBACK TRANSACTION
	ELSE
		COMMIT TRANSACTION
		
	RETURN
	
GO
