SET QUOTED_IDENTIFIER ON

IF EXISTS (SELECT name FROM WF_Definition WHERE name = 'apsscollection')
	UPDATE CloudMonitoringService SET isEnabled = 1 WHERE name = 'ProactiveSupport'

--Step 1 : Remove obsolete workflows:
DECLARE @ObsoleteWFs TABLE(wfId int, wfName NVARCHAR(512))
INSERT INTO @ObsoleteWFs
	SELECT WorkflowId, Name FROM WF_Definition WHERE Name IN 
	('apss_104_enableSCActivity',
	'apss_106_httpLogUploadChange',
	'apss_79_addSYSADMIN',
	'apss_advanced_data_collector',
	'apss_CreateMPLabel',
	'apss_ExcludeClientSLA',
	'apss_health_csdb',
	'apss_health_ddbrecon',
	'apss_health_maglib',
	'apss_HTTPValidator',
	'apss_setup',
	'apsscollection',
	'apss_ResubmitSQLJobsThatFailed')

UPDATE T SET T.deleted = 1
FROM TM_Task T
INNER JOIN TM_AssocEntity AE
	ON T.taskId = AE.taskId
INNER JOIN @ObsoleteWFs OW
	ON AE.workflowId = OW.wfId
	
DELETE FROM WF_Activity WHERE ActivityId IN (SELECT ActivityId FROM WF_Definition WF INNER JOIN @ObsoleteWFs OW ON WF.WorkflowId = OW.wfId)

DELETE FROM App_MessageHandler WHERE workflowname IN (SELECT wfName FROM @ObsoleteWFs)

DELETE FROM WF_Definition WHERE WorkflowId IN (SELECT wfId FROM @ObsoleteWFs)

DELETE FROM UMUserandGroupEntityAssociation WHERE entityType = 14033 AND objectId IN (SELECT wfId FROM @ObsoleteWFs)

DECLARE @workflowId INT
DECLARE cur CURSOR FOR
SELECT wfId FROM @ObsoleteWFs
OPEN cur
FETCH NEXT FROM cur INTO @workflowId
WHILE (@@FETCH_STATUS = 0)
BEGIN
	
	EXEC sec_deleteSecurityAssociationsForEntity 83, @workFlowId --WORKFLOW_ENTITY
	
    FETCH NEXT FROM cur INTO @workflowId
END 
CLOSE cur    
DEALLOCATE cur	

--Step 2: Update or delete client groups "CVProactive - Critical Group"
DECLARE @cgId INT = 0
SELECT @cgId = id FROM APP_ClientGroup WHERE name = 'CVProactive - Critical Group'
IF @cgId > 0
BEGIN
	IF NOT EXISTS (SELECT * FROM APP_ClientGroup WHERE flag = 0x200000)
		UPDATE APP_ClientGroup SET name = 'APSS - Critical Group', description = 'Critical clients monitored by Proactive Support', flag = 0x200000 WHERE id = @cgId
	ELSE
	BEGIN
		DELETE FROM APP_ClientGroupAssoc WHERE clientGroupId = @cgId
		DELETE FROM APP_ClientGroup WHERE id = @cgId
	END
END

--Step 4: Delete "CVProactive - Unix Media Agents" and CVProactive - Windows Media Agents"	
SET @cgId = 0
SELECT @cgId = id FROM APP_ClientGroup WHERE name = 'CVProactive - Unix Media Agents'
IF @cgId > 0
BEGIN
	DELETE FROM APP_ClientGroupAssoc WHERE clientGroupId = @cgId
	DELETE FROM APP_ClientGroup WHERE id = @cgId
END

SET @cgId =	0	
SELECT @cgId = id FROM APP_ClientGroup WHERE name = 'CVProactive - Windows Media Agents'
IF @cgId > 0
BEGIN
	DELETE FROM APP_ClientGroupAssoc WHERE clientGroupId = @cgId
	DELETE FROM APP_ClientGroup WHERE id = @cgId
END	


