

IF  EXISTS (select * from LicUsage where AppType=1082 and CId=2 and LicType=153 and OpType = 'Install')
BEGIN
-- Create the analytics policy

DECLARE	@l_archGroupId	INT
DECLARE	@l_copyId		INT
DECLARE	@l_mediaGroupId	INT

INSERT 	INTO archGroup
		(defaultCopy, name, description, maxStreams, type, 
		incrSP, origCCcommCellID, origCCarchGroupId, defaultSnapCopy, SIBlockSizeKB, 
		AuxCopyAlertGB, AuxCopyAlertDays, flags, mediaPassword, TimeZoneType, TimeZone) 
VALUES (0, 'Analytics Policy', 'Automatically created Storage Policy', 1, 4, 
		0, 0, 0, 0, 0, 
		0, 0, 0, '', 0, '')
		
SET		@l_archGroupId = SCOPE_IDENTITY()
		
INSERT	INTO archGroupCopy
		(archGroupId, copy, name, flags, 
		maxMultiplex, isActive, type, startTime, waitForIfOffline, 
		waitForIfBusy, archCheckStartTime, origCCcommCellID, origCCarchCopyId, sourceCopyId, 
		delayedDays, maxStreamNum, archCheckValidMonths, calendarId, SIDBStoreId, 
		encType, encKeyLen, isSnapCopy, isMirrorCopy, NWWriteSpeed, 
		SIDBSnapIntervalHours, siloAppId, nDataInstance, description, dedupeFlags, 
		blockCacheValidDays, nSiloStreams, silosInCache, siloRestoreMAClientId, siloRestoreClientId, 
		sealStoreTaskId)
VALUES (@l_archGroupId, 1, 'Primary', 8, 
		0, 1, 1, -dbo.getUnixTime(GETUTCDATE()), 600, 
		18000, -1, 0, 0, 0, 
		0, 1, 0, 1, 0, 
		0, 0, 0, 0, 0, 
		0, 0, 0, '', 0, 
		0, 0, 0, 0, 0, 
		0)

SET		@l_copyId = SCOPE_IDENTITY()

UPDATE	archGroup 
SET		defaultCopy = @l_copyId 
WHERE	id = @l_archGroupId

INSERT	INTO MMMediaGroup
		(MediaGroupName, 
		DrivePoolId, SpareGroupId, DesiredMediaTypeId, RecordingFormatId, DataPathId)
VALUES ('AG[' + CAST(@l_archGroupId AS varchar(8)) + ']_AGC[' + CAST(@l_copyId AS varchar(8)) + ']_stream[1]',
		0, 0, 0, 0, 0)

SET		@l_mediaGroupId = SCOPE_IDENTITY()

INSERT	INTO archStream
		(archGroupId, archGroupCopyId, stream, mediaGroupId, isActive, lastUsedTime, physicalDataSizeInGB, flags)
VALUES (@l_archGroupId, @l_copyId, 1, @l_mediaGroupId, 1, 0, 0, 0)
		
INSERT	INTO archAgingRule

		(copyId, retentionDays, fullCycles, flags, weekStart, monthStart, yearStart, archiverRetDays, retentionJobs,minutesSinceDayStarts)
VALUES (@l_copyId, 15, -1, 0, 5, 1, 0, 0, 0,0)


INSERT	INTO MMDataPath
		(CopyId, DrivePoolId, HostClientId, Flag, SpareGroupId,
		ReadinessFlag, Priority, IsHardwareCompressed, ChunkSizeMB, FlushBlockSizeKB, UseHardwareEncryption)
VALUES (@l_copyId, 0, 2, 1, 0,
		0, 0, 0, 0, 0, 0)

UPDATE	APP_Application
SET		dataArchGrpID = @l_archGroupId
WHERE	appTypeId IN (600, 603)

DECLARE @analyticsPolicy INTEGER
DECLARE @ERRCode INTEGER
DECLARE @loc INTEGER
DECLARE @errString INTEGER
	SET @analyticsPolicy = NULL
	SELECT @analyticsPolicy = id FROM archGroup WITH (READUNCOMMITTED) WHERE (type = 4 AND name LIKE 'Analytics Policy');
	IF (@analyticsPolicy = NULL)
	BEGIN
		SET @errCode = -1
		SET @loc = @loc + 1
		SET @errString = 'ANALYTICS POLICY not found in archGroup table'
		--GOTO ERROR_EXIT
	END
	ELSE
		UPDATE APP_Application SET dataArchGrpID = @analyticsPolicy WHERE (clientId = 2 AND appTypeId = 600);
	

END