-- Copy the global flag to each app type in ida_appType table

SET QUOTED_IDENTIFIER OFF
SET NOCOUNT ON
GO

BEGIN
	BEGIN TRANSACTION
		
		DECLARE	@errorCode	INTEGER
		SET 		@errorCode	= 0
			
		DECLARE @isCWEjobValid	INTEGER
		SET			@isCWEjobValid	= 1
		
		-- Get the configured value for DA_CONFIG_CONSIDER_PARTIAL_SUCCESSFUL_FULL_AS_VALID_FULL
		IF EXISTS (SELECT name FROM MMConfigs WHERE name = 'DA_CONFIG_CONSIDER_PARTIAL_SUCCESSFUL_FULL_AS_VALID_FULL')
		BEGIN
			SELECT @isCWEjobValid = isnull(value, 1) 
			FROM MMConfigs
			WHERE name = 'DA_CONFIG_CONSIDER_PARTIAL_SUCCESSFUL_FULL_AS_VALID_FULL'
			
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT	
				
			--Copy the global flag to each appType during upgrade	
			UPDATE APP_iDAType
			SET isCWEjobValid = @isCWEjobValid
		
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT	
					
			--Remove the config parameter	
			DELETE FROM MMConfigs
			WHERE name IN ('DA_CONFIG_CONSIDER_PARTIAL_SUCCESSFUL_FULL_AS_VALID_FULL')
			
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT	
		END							
	END

CX_EXIT:	
	IF @errorCode <> 0
		ROLLBACK TRANSACTION
	ELSE
		COMMIT TRANSACTION
		
	RETURN
	
GO
