DECLARE @errCode INT = 0
			
--Update ClientId in SMControlHost and SMArray Tables based on SMHostAlias
UPDATE SMControlHost 
SET ClientId = client.id
FROM SMControlHost AS ctrlHost
	INNER JOIN SMHostAlias AS alias
		ON ctrlHost.ClientId = 1
		AND alias.RefType = 5 
		AND ctrlHost.ControlHostId = alias.RefId
	INNER JOIN APP_Client AS client
		ON (alias.AliasName = client.name OR alias.AliasName = client.net_hostname)

SET	@errCode	= @@ERROR
IF	@errCode != 0 GOTO CX_EXIT 

UPDATE SMArray 
SET ClientId = ctrlHost.ClientId
FROM SMControlHost AS ctrlHost
	INNER JOIN SMArray AS array
		ON array.ClientId = 1 
		AND array.ArrayName = ctrlHost.SMArrayId
		
SET	@errCode	= @@ERROR
IF	@errCode != 0 GOTO CX_EXIT 

CX_EXIT:

IF @errCode != 0
	SELECT 2
ELSE
	SELECT 0

RETURN

