

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/cvsp_getPermissionsOnUsers.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcxtools/DatabaseUpgrade/CommServer/MainUpgrade/GetDBPermission/CreateSPcvsp_getpermissionsOnUsers.sql,v $ $Id: CreateSPcvsp_getpermissionsOnUsers.sql,v 1.1.2.2 2018/10/08 12:47:09 chandru Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: cvsp_getPermissionsOnUsers <<<'

IF EXISTS (select * from sysobjects where name='cvsp_getPermissionsOnUsers')
    drop procedure cvsp_getPermissionsOnUsers
IF EXISTS (select * from GxQscripts where name='cvsp_getPermissionsOnUsers')
    delete from GxQscripts where name = 'cvsp_getPermissionsOnUsers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvsp_getPermissionsOnUsers')
    delete from GXDBVersions where aliasname = 'cvsp_getPermissionsOnUsers'
GO
print '... Creating Procedure: cvsp_getPermissionsOnUsers'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure cvsp_getPermissionsOnUsers
  @i_UserId INT = NULL,
  @i_ObjectType nvarchar(16),
  @errorCode INT OUTPUT,
  @errorMessage NVARCHAR(MAX) OUTPUT
AS
SET NOCOUNT ON
BEGIN TRY
SET @errorCode = 0
SET @errorMessage = ''
Create table #temp
(
    objectId         INT             NOT NULL,
    columnId         INT             NOT NULL,
    userName         NVARCHAR(1024)  NOT NULL,
    permissionType   NVARCHAR(256)   NOT NULL,
    permissionState  NVARCHAR(256)   NOT NULL,
    objectName       NVARCHAR(1024)  NOT NULL,
    objectType       NVARCHAR(16)    NOT NULL,
    columnName       NVARCHAR(256)   NULL,
    flags            INT             NOT NULL default 0
)
INSERT INTO #temp (objectId ,columnId ,UserName,permissionType,permissionState ,objectName,objectType,columnName)
    (SELECT  pe.major_id,pe.minor_id ,pr.name, pe.state_desc,pe.permission_name, s.name + '.' + o.name AS ObjectName,o.type AS ObjectType,NULL
            FROM sys.database_principals AS pr WITH (NOLOCK)
            JOIN sys.database_permissions AS pe  WITH (NOLOCK) ON pe.grantee_principal_id = pr.principal_id
            JOIN sys.objects AS o  WITH (NOLOCK) ON pe.major_id = o.object_id
            JOIN sys.schemas AS s  WITH (NOLOCK) ON o.schema_id = s.schema_id
                where o.type IN ('U','P','FS','FT','AF','FN','TF','V') and pe.class = 1 and pr.type IN ('S','U')
                AND ISNULL(O.is_ms_shipped, 0) = 0  --Excluding System Database Objects
                AND o.object_id NOT IN (select ep.major_id from sys.extended_properties ep
                                            where ep.major_id = o.object_id and ep.class = 1 and ep.name = N'microsoft_database_tools_support'))
UPDATE a
    SET columnName = c.name
 FROM sys.columns as c
 JOIN #temp as a ON a.objectType in ('U') AND  c.object_id = a.objectId and c.column_id=a.columnId
DECLARE @no_days INT
SET @no_days = ISNULL((select CAST(CAST(Value AS NVARCHAR(8)) AS INT) from GXGlobalParam where Name like 'RetentionDaysForPermissions'),90)
DELETE from CSDBPermissionsOnUsers where lastActivity < (GETUTCDATE()-@no_days) and flags = 1 -- 1 = 1 Permissions Successfully Executed
DELETE FROM CSDBPermissionsOnUsers where flags = 0 -- 0 = 0 Permissions Not Executed
INSERT INTO CSDBPermissionsOnUsers (UserName,permissionType,permissionState ,objectName,objectType,columnName)
    (select UserName,permissionType,permissionState ,objectName,objectType,columnName from #temp)
DROP TABLE #temp
END TRY
BEGIN CATCH

    PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
    ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
    PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
    ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
    ERROR MESSAGE: ' + ERROR_MESSAGE() + '
    ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
    ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

SET @errorCode = ERROR_NUMBER()
SET @errorMessage = 'Error : Procedure [cvsp_getPermissionsOnUsers] Failed to Execute ' + ERROR_MESSAGE()
END CATCH
return @errorCode
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'cvsp_getPermissionsOnUsers')
    delete from GxQscripts where name = 'cvsp_getPermissionsOnUsers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvsp_getPermissionsOnUsers')
    delete from GXDBVersions where aliasname = 'cvsp_getPermissionsOnUsers'
GO

insert into GXDBVersions values(2, 'cvsp_getPermissionsOnUsers',  '00010001000200020000', 'cvsp_getPermissionsOnUsers', '00010001000200020000')
GO