

--  ------------  Generated from [../../../Source/CommServer/Db/CSView/RunningRestores.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: RunningRestores"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[RunningRestores]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[RunningRestores]
GO

delete from GXDBVersions where name = 'RunningRestores' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'RunningRestores', '1.39.14.15', 'RunningRestores', '')
GO
  ---  Copyright (c) 1998  CommVault Systems, Inc.
  ---  Display all the currently running backups
CREATE VIEW dbo.RunningRestores
AS
	SELECT jobID = JMJobInfo.jobId,
		opType = CASE WHEN JMJobInfo.subOpType > 0 THEN JMJobInfo.subOpType ELSE JMJobInfo.opType END,
		userId,
		JMJobInfo.commCellId,
		srcClientId,
		destClientId,
		JMRstJobInfo.appType,
		JMRstJobInfo.instanceID,
		JMRstJobInfo.bkpSetID,
		state,
		displayState,
		clientPriority,
		opPriority,
		appPriority,
		combPriority,
		currentPhase,
		jobStartTime,
		attemptStartTime,
		elapsedTime = CASE WHEN attemptStartTime > 0 THEN dbo.GetUnixTime(GETUTCDATE()) - attemptStartTime + elapsedTime ELSE elapsedTime END,
		jobElapsedTime = CASE WHEN attemptStartTime > 0 THEN dbo.GetUnixTime(GETUTCDATE()) - attemptStartTime + jobElapsedTime ELSE jobElapsedTime END,
		startAttempts,
		runAttempts,
		CASE WHEN state = 1 THEN preemptable
		WHEN state = 2 OR state = 3 OR state = 15 OR state = 16 THEN 1
		ELSE 0
		END AS isPreemptable,
		totCompBytes,
		totUnCompBytes,
		totSuccess,
		totFailures,
		totSkipped,
		totFiles2Xfer,
		totBytes2Xfer,
		initFrom,
		pendingCause,
		errorType,
		guiAlertColorLevel,
		timeToComplete,
		percentcomplete,
		lastUpdateFromClient,
		lastStateChangeTime,
		noOfGUIMonitors,
		isScheduledAlert,
		jobBasedAlertId,
		maxRestarts,
		restartInterval,
		rstTaskID,
		rstattributes,
		taskId = (ISNULL(T.taskId, 0)),
		totReadBytes,
		totReadTime,
		totPhysicalWriteBytes,
		totPhysicalWriteTime,
		totNwTransBytes,
		totNwTransTime,
		totSidbLookups,
		totSidbLookupTime,
		readCurrentThroughput,
		readAverageThroughput,
		writeCurrentThroughput,
		writeAverageThroughput,
		networkCurrentThroughput,
		networkAverageThroughput,
		sidbCurrentLookups,
		sidbAverageLookups,
		subTaskName = (ISNULL(ST.subTaskName, '')),
		taskName = (ISNULL(T.taskName, '')),
		[UserName] = CASE WHEN dmUserName IS NOT NULL AND LEN(CAST(dmUserName AS VARCHAR)) <> 0 THEN dmUserName
				ELSE ISNULL(US.login,'') END,
		alertName,
		srcClientName = ISNULL(SRC.name, ''),
		destClientName = ISNULL(DSTC.name, ''),
		appTypeName = ISNULL(IDA.name, ''),
		instanceName = ISNULL(INS.name, ''),
		backupSetName = ISNULL(BS.name, ''),
		ISNULL(libraryList,'') AS libraryList,
		ISNULL(driveList,'') AS driveList,
		failureReason,
		FR.localisedMessage AS DelayReason,
		--dbo.JMGetLocalizedMessageFunc(0,failureReason) AS [DelayReason],
		foreignToken,
		currentPhaseName,
		ISNULL(curDatabase,'') AS curDatabase,
		ISNULL(mediaAgent,'') AS mediaAgent,
		ISNULL(shortMediaAgent,'') AS shortMediaAgent,
		activeFile,
		dbo.JMGetKBArticlesForFailures( failureReason, 0 ) AS failureKBArticle,
		jobDescription,
		xmlJobInfo,
		CAST(currentThroughput AS FLOAT) AS currentThroughput,
		CAST(( SELECT
								CASE WHEN J.writeTime > 0 then J.unCompBytes/J.writeTime
								ELSE 0 END
								FROM
								(
									SELECT ISNULL(JMRstJobInfo.totUnCompBytes, 0) as unCompBytes,
									CASE WHEN state = 1/*Running*/ THEN ISNULL((dbo.GetUnixTime(GETUTCDATE()) - JMJobInfo.attemptStartTime), 0)
									ELSE 0 END
									+ ISNULL((JMJobInfo.jobElapsedTime), 0) AS writeTime
								) J
							)*0.00000335276126861572265625 AS FLOAT) AS averageThroughput, -- VALUE IS 60*60/(1024*1024*1024)
        srcClientDisplayName = ISNULL(SRC.displayName, ''),
        destClientDisplayName = ISNULL(DSTC.displayName, ''),
		JMRstJobInfo.destInstanceId,
		destInstanceName = ISNULL(DESTINS.name, '')
	FROM JMJobInfo WITH (READUNCOMMITTED)
	INNER JOIN JMRstJobInfo WITH (READUNCOMMITTED) ON
	JMRstJobInfo.jobId = JMJobInfo.jobId
	LEFT OUTER JOIN TM_SubTask ST WITH (READUNCOMMITTED) ON
	JMRstJobInfo.rstTaskID = ST.subTaskId
	LEFT OUTER JOIN TM_Task T WITH (READUNCOMMITTED) ON
	ST.taskId = T.taskId
	LEFT OUTER JOIN UMUsers US (READUNCOMMITTED) ON US.id = userId
	LEFT OUTER JOIN APP_Client SRC (READUNCOMMITTED) ON SRC.id = srcClientId
	LEFT OUTER JOIN APP_Client DSTC (READUNCOMMITTED) ON DSTC.id = destClientId
	LEFT OUTER JOIN APP_iDAType IDA (READUNCOMMITTED) ON IDA.type = JMRstJobInfo.appType
	LEFT OUTER JOIN APP_InstanceName INS (READUNCOMMITTED) ON INS.id = JMRstJobInfo.instanceID
	LEFT OUTER JOIN APP_InstanceName DESTINS (READUNCOMMITTED) ON DESTINS.id = JMRstJobInfo.destInstanceId
	LEFT OUTER JOIN APP_BackupSetName BS (READUNCOMMITTED) ON BS.id = JMRstJobInfo.bkpSetID
	LEFT OUTER JOIN JMFailureReasonLocaleMsgCache FR (READUNCOMMITTED) ON FR.jobID = JMJobInfo.jobID AND FR.commCellId = JMJobInfo.commCellId AND FR.reasonCode = failureReason
	WHERE JMJobInfo.opType <> 29 /*QUICKDMRST*/ OR ISNULL((SELECT CAST(value AS INT) FROM GXGlobalParam WITH (NOLOCK) WHERE name = N'showPersistentRecoveryJobs'), 0) = 1 --Hide persistent restore jobs from UI
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [RunningRestores]'
END
GO

